/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermophysics.h"

void GIST::Thermophysics::SaveGrid(std::string filename)
{
    std::ofstream outfile;
	gctl::open_outfile(outfile, filename, ".rg", std::ios::out | std::ios::binary);

	size_t info_size = name_.size();
	outfile.write((char*)&info_size, sizeof(size_t));
	outfile.write((char*)name_.c_str(), info_size);
	
	info_size = unit_.size();
	outfile.write((char*)&info_size, sizeof(size_t));
	outfile.write((char*)unit_.c_str(), info_size);

	outfile.write((char*)&t_min_, sizeof(double));
	outfile.write((char*)&t_max_, sizeof(double));
	outfile.write((char*)&dt_, sizeof(double));
	outfile.write((char*)&rel_dt_, sizeof(double));
	outfile.write((char*)&p_min_, sizeof(double));
	outfile.write((char*)&p_max_, sizeof(double));
	outfile.write((char*)&dp_, sizeof(double));
	outfile.write((char*)&rel_dp_, sizeof(double));
	outfile.write((char*)&c_min_, sizeof(double));
	outfile.write((char*)&c_max_, sizeof(double));
	outfile.write((char*)&dc_, sizeof(double));
	outfile.write((char*)&rel_dc_, sizeof(double));
	outfile.write((char*)&d_min_, sizeof(double));
	outfile.write((char*)&d_max_, sizeof(double));
	outfile.write((char*)&t_size_, sizeof(size_t));
	outfile.write((char*)&p_size_, sizeof(size_t));
	outfile.write((char*)&c_size_, sizeof(size_t));
	outfile.write((char*)&d_size_, sizeof(size_t));

	// 注意我们保存的是归一化后参考网络的计算结果
	outfile.write((char*)data_.get(), sizeof(double)*d_size_);
	outfile.write((char*)data_gt_.get(), sizeof(double)*d_size_);
	outfile.write((char*)data_gp_.get(), sizeof(double)*d_size_);
	outfile.write((char*)data_gc_.get(), sizeof(double)*d_size_);

	outfile.close();
	return;
}