/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermophysics.h"

void GIST::Thermophysics::LoadGrid(std::string filename)
{
    std::ifstream infile;
	gctl::open_infile(infile, filename, ".rg", std::ios::in | std::ios::binary);

	size_t info_size;

	infile.read((char*)&info_size, sizeof(size_t));
	name_.resize(info_size);
	infile.read((char*)name_.c_str(), info_size);

	infile.read((char*)&info_size, sizeof(size_t));
	unit_.resize(info_size);
	infile.read((char*)unit_.c_str(), info_size);

	infile.read((char*)&t_min_, sizeof(double));
	infile.read((char*)&t_max_, sizeof(double));
	infile.read((char*)&dt_, sizeof(double));
	infile.read((char*)&rel_dt_, sizeof(double));
	infile.read((char*)&p_min_, sizeof(double));
	infile.read((char*)&p_max_, sizeof(double));
	infile.read((char*)&dp_, sizeof(double));
	infile.read((char*)&rel_dp_, sizeof(double));
	infile.read((char*)&c_min_, sizeof(double));
	infile.read((char*)&c_max_, sizeof(double));
	infile.read((char*)&dc_, sizeof(double));
	infile.read((char*)&rel_dc_, sizeof(double));
	infile.read((char*)&d_min_, sizeof(double));
	infile.read((char*)&d_max_, sizeof(double));
	infile.read((char*)&t_size_, sizeof(size_t));
	infile.read((char*)&p_size_, sizeof(size_t));
	infile.read((char*)&c_size_, sizeof(size_t));
	infile.read((char*)&d_size_, sizeof(size_t));

	data_.resize(d_size_);
	data_gt_.resize(d_size_);
	data_gp_.resize(d_size_);
	data_gc_.resize(d_size_);

	infile.read((char*)data_.get(), sizeof(double)*d_size_);
	infile.read((char*)data_gt_.get(), sizeof(double)*d_size_);
	infile.read((char*)data_gp_.get(), sizeof(double)*d_size_);
	infile.read((char*)data_gc_.get(), sizeof(double)*d_size_);

	infile.close();
    return;
}