/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermophysics.h"

void GIST::Thermophysics::ImportArray(std::string name, std::string unit, double tmin, double tmax, double dt, 
    double pmin, double pmax, double dp, double cmin, double cmax, double dc, const array<double> &data)
{
    name_ =  name;
    unit_ = unit;
	t_min_ = tmin; t_max_ = tmax; dt_ = dt;
	p_min_ = pmin; p_max_ = pmax; dp_ = dp;
	c_min_ = cmin; c_max_ = cmax; dc_ = dc;

	t_size_ = round((t_max_ - t_min_)/dt_) + 1;
	p_size_ = round((p_max_ - p_min_)/dp_) + 1;
	c_size_ = round((c_max_ - c_min_)/dc_) + 1;

	rel_dt_ = 1.0/(t_size_ - 1);
	rel_dp_ = 1.0/(p_size_ - 1);
	rel_dc_ = 1.0/(c_size_ - 1);

	d_size_ = t_size_ * p_size_ * c_size_;
	data_.resize(d_size_);

	// 注意这个我们将参考网络进行了归一化，同时记录原参考网络中的极值以便获取原始值
	for (size_t i = 0; i < d_size_; i++)
	{
		data_[i] = data[i];
		d_min_ = std::min(d_min_, data_[i]);
		d_max_ = std::max(d_max_, data_[i]);
	}

    // Build the reference grid.
	BuildGrid();
	return;
}