/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermophysics.h"

void GIST::Thermophysics::ExportCustomProfile(std::string out_name, const std::vector<double> &t, const std::vector<double> &p, const std::vector<double> &c)
{
    std::ofstream ofile;
    open_outfile(ofile, out_name, ".txt");

    ofile << "# Temperature(K) Pressure(GPa) Mg# " << name_ << "(" << unit_ << ")\n";

    double rel_t, rel_p, rel_c, out_val;
    for (size_t i = 0; i < t.size(); i++)
    {
        if (t[i] >= t_max_) rel_t = 1.0;
        else if (t[i] <= t_min_) rel_t = 0.0;
        else rel_t = (t[i] - t_min_)/(t_max_ - t_min_);

        if (p[i] >= p_max_) rel_p = 1.0;
        else if (p[i] <= p_min_) rel_p = 0.0;
        else rel_p = (p[i] - p_min_)/(p_max_ - p_min_);

        if (c[i] >= c_max_) rel_c = 1.0;
        else if (c[i] <= c_min_) rel_c = 0.0;
        else rel_c = (c[i] - c_min_)/(c_max_ - c_min_);

        GetValue(rel_t, rel_p, rel_c, out_val);
        ofile << t[i] << " " << p[i] << " " << c[i] << " " << out_val << "\n";
    }
    
    ofile.close();
    return;
}