/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermophysics.h"

void GIST::Thermophysics::Convert2AbsoluteModel(const array<double> &in_model, array<double> &ret_model, thermophysics_type_e p_type)
{
    double tmp_val;

    if (p_type == TempVal)
    {
        ret_model.resize(in_model.size());
        for (size_t i = 0; i < in_model.size(); i++)
        {
            tmp_val = in_model[i];

            if (tmp_val > 1.0) tmp_val = 1.0;
            if (tmp_val < 0.0) tmp_val = 0.0;

            ret_model[i] = tmp_val*(t_max_ - t_min_) + t_min_;
        }
        return;
    }
    
    if (p_type == PressVal)
    {
        ret_model.resize(in_model.size());
        for (size_t i = 0; i < in_model.size(); i++)
        {
            tmp_val = in_model[i];

            if (tmp_val > 1.0) tmp_val = 1.0;
            if (tmp_val < 0.0) tmp_val = 0.0;

            ret_model[i] = tmp_val*(p_max_ - p_min_) + p_min_;
        }
        return;
    }
    
    if (p_type == CompVal)
    {
        ret_model.resize(in_model.size());
        for (size_t i = 0; i < in_model.size(); i++)
        {
            tmp_val = in_model[i];

            if (tmp_val > 1.0) tmp_val = 1.0;
            if (tmp_val < 0.0) tmp_val = 0.0;

            ret_model[i] = tmp_val*(c_max_ - c_min_) + c_min_;
        }
        return;
    }
    return;
}