/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermal_conductivity_Science99.h"

#define a0 0.3034e-4
#define a1 0.7422e-8
#define a2 -0.5381
#define k0 5.2
#define a  0.45
#define gamma 1.25
#define Kt 127.9
#define Kp 4.0

double thermal_expansion(double K)
{
    // alpha(T) = a_0 + a_1*T + a_2*T^-2
    // integral(alpha(T)) = C + a_0*T + 0.5*a_1*T^2 - a_2*T^-1
    double t1 = a0*298.0 + 0.5*a1*298.0*298.0 - a2/298.0;
    double t2 = a0*K + 0.5*a1*K*K - a2/K;
    return t2 - t1;
}

double radiation_conductivity(double T)
{
    return 0.01753 - 0.00010365*T + 2.2451e-7*T*T - 3.407e-11*T*T*T;
}

double thermal_conductivity(double T, double P)
{
    return k0*pow(298.0/T, a)*exp(-(4*gamma + 1.0/3.0)*thermal_expansion(T))*(1.0 + P*Kp/Kt)
        + radiation_conductivity(T);
}