/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermal_conductivity_JGR2022.h"
#include "cmath"

double upper_crust_thermal_conductivity(double k0, double d, double t)
{
    return k0*(1.0 + 1.5e-3*d)/(1.0 + 1.0e-3*(t - 293.15));
}

double middle_crust_thermal_conductivity(double k0, double d, double t)
{
    return k0*(1.0 + 1.5e-3*d)/(1.0 + 5.0e-4*(t - 293.15));
}

double lower_crust_thermal_conductivity(double k0, double d, double t)
{
    return k0*(1.0 + 1.5e-3*d)/(1.0 + 1.5e-4*(t - 293.15));
}

double mantle_thermal_conductivity(double k0, double d, double t)
{
    return k0*(1.23e-10*t*t*t + 1.0/(0.518 + 7.89e-4*t));
}

double heat_production(double rho, double d, double d0, double d1, double Cu, double Cth, double Ck)
{
    double q0 = 0.01*rho*(9.52*Cu + 2.56*Cth + 3.48*Ck);
    if (d <= d0) return q0;
    return q0*exp(-1.0*(d - d0)/d1);
}