/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermal.h"

void GIST::Thermal::ResetHeatProductivity()
{
    if (!system_ready_)
    {
        throw gctl::runtime_error("[GIST::Thermal::ResetHeatProductivity] System not initialized.");
    }

    pdt_cndt_.resize(node_num_, 0.0); // 产热边界条件数组
    return;
}

void GIST::Thermal::SetHeatProductivity(const array<size_t> &ele_idx, double hp_val)
{
    array<gctl::tetrahedron> &elem = m_space_->get_element();

    thermal_FEM_setup tt;
    tt.i_type = HeatProduct;

    vertex3dc *vt[4];
    for (size_t i = 0; i < ele_idx.size(); i++)
    {
        for (size_t j = 0; j < 4; j++)
        {
            vt[j] = elem[ele_idx[i]].vert[j];
        }

        for (size_t j = 0; j < 4; j++)
        {
            tt.uv_id[0] = j;
            // 热产率(热源密度)的单位为 W/m^3
            pdt_cndt_[vt[j]->id] += hp_val*tetrahedron::integral(vt[0]->x, vt[1]->x, vt[2]->x, vt[3]->x, 
                vt[0]->y, vt[1]->y, vt[2]->y, vt[3]->y, vt[0]->z, vt[1]->z, vt[2]->z, vt[3]->z, &tt);
        }
    }
    return;
}