/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermal.h"
/*
void GIST::Thermal::ResetBoundaryTransfer()
{
    if (!system_ready_)
    {
        throw gctl::runtime_error("The thermal system is not initialized.");
    }

    has_trn_cndt_.resize(face_num_, false);
    trn_cndt_.resize(node_num_, 0.0); // 热传导边界条件数组
    trans_list_.resize(face_num_ * 9);

    array<gctl::triangle> &face = m_space_->get_face();

    vertex3dc *vt[4];
    mat_node<double> tmp_entry;
    thermal_FEM_setup tt;

    tt.i_type = TransferKernel;

    size_t cr_id;
    double x1 = 0.0, x2, x3, y1 = 0.0, y2 = 0.0, y3;
    for (size_t i = 0; i < face_num_; i++)
    {
        face[i].local_coordinates(x2, x3, y3, cr_id);

        for (size_t j = 0; j < 3; j++)
        {
            vt[j] = face[i].vert[j];
        }

        for (size_t j = 0; j < 3; j++)
		{
            tmp_entry.r_id = vt[(cr_id+j)%3]->id;
            tt.uv_id[0] = (cr_id+j)%3;

			for (size_t f = 0; f < 3; f++)
			{                
                tmp_entry.c_id = vt[(cr_id+f)%3]->id;
                tt.uv_id[1] = (cr_id+f)%3;

                tmp_entry.val = triangle::integral(x1, x2, x3, y1, y2, y3, &tt);

                trans_list_[9*i + 3*j + f] = tmp_entry;
			}
		}
    }
    return;
}

void GIST::Thermal::SetBoundaryTransfer(const array<size_t> &fac_idx, double hf_val, double temper_val)
{
    array<gctl::triangle> &faces = m_space_->get_face();

    size_t c_id;
    double x1 = 0.0, x2, x3, y1 = 0.0, y2 = 0.0, y3;

    thermal_FEM_setup tt;
    tt.i_type = TransferForce;

    int v_id;
    double ambt_val = temper_val - 1e-3*hf_val;
    for (size_t i = 0; i < fac_idx.size(); i++)
    {
        faces[fac_idx[i]].local_coordinates(x2, x3, y3, c_id);

        for (size_t k = 0; k < 3; k++)
        {
            tt.uv_id[0] = k;
            v_id = faces[fac_idx[i]].vert[(c_id+k)%3]->id;
            //trn_cndt_[faces[i].vert[(c_id+k)%3]->id] += ht_val*ambt_val*triangle::integral(x1, x2, x3, y1, y2, y3, &tt);
            trn_cndt_[v_id] += ambt_val*triangle::integral(x1, x2, x3, y1, y2, y3, &tt);
        }

        has_trn_cndt_[fac_idx[i]] = true;
    }
    return;
}
*/