/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermal.h"

void GIST::Thermal::ObsHeatFlow(const array<double> &cndt, const array<double> &t)
{
    hf_kernel_.set_all(0.0);

    size_t v_id = 0;
    double vol_cndt;
    for (size_t i = 0; i < obs_num_; i++)
    {
        for (size_t j = 0; j < obs_hosts_[i].size(); j++)
        {
            vol_cndt = cndt[obs_hosts_[i][j]->id];

            for (size_t k = 0; k < 4; k++)
            {
                hf_kernel_.add_scalar(i, obs_hosts_[i][j]->vert[k]->id, vol_cndt*hf_coeff_[v_id]);
                v_id++;
            }
        }
    }

    hf_kernel_.multiply_vector(t, pre_hf_);
    return;
}