/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

double GIST::ModelSpace::SmoothModelConstraint(double wgt, const array<double> &model, array<double> &out_grad, array<double> *bkg_model)
{
    // swgt*||Ws*D*(m - m_bkg)||^2
    if (!swgt_ready_)
    {
        throw std::runtime_error("Smoothness model weights are not initialized. From GIST::ModelSpace::SmoothModelConstraint(...).");
    }

    out_grad = model;
    if (bkg_model != nullptr)
    {
        for (size_t i = 0; i < elem_num_; i++)
        {
            out_grad[i] -= bkg_model->at(i);
        }
    }

    smooth_mat_.multiply_vector(out_grad, face_diff_);
    for (size_t i = 0; i < cmn_face_num_; i++)
    {
        face_diff_[i] *= smth_wgts_[i];
    }
    
    double sum = 0.0;
    for (size_t i = 0; i < cmn_face_num_; i++)
    {
        sum += face_diff_[i]*face_diff_[i];
    }
    sum *= wgt;

    for (size_t i = 0; i < cmn_face_num_; i++)
    {
        face_diff_[i] *= smth_wgts_[i];
    }

    smooth_mat_.multiply_vector(face_diff_, grad_dm_, gctl::Trans);
    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] = 2.0*wgt*grad_dm_[i];
    }
/*
    double mini_grad = 1e+30, maxi_grad = -1e+30;
    for (size_t i = 0; i < elem_num_; i++)
    {
        mini_grad = std::min(mini_grad, out_grad[i]);
        maxi_grad = std::max(maxi_grad, out_grad[i]);
    }

    if (fabs(maxi_grad - mini_grad) > 1e-10)
    {
        for (size_t i = 0; i < elem_num_; i++)
        {
            out_grad[i] = out_grad[i]/(maxi_grad - mini_grad);
        }
    }
*/
    //out_grad.normalize(1.0, gctl::L1);
    return sum;
}
