/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

double GIST::ModelSpace::SimilarModelConstraint(const array<double> &model, array<double> &out_grad)
{
    if (!rwgt_ready_)
    {
        throw std::runtime_error("Similar model weights are not initialized. From GIST::ModelSpace::SimilarModelConstraint(...).");
    }

    double sum = 0.0;
    out_grad.resize(elem_num_);

    ref1_mat_.multiply_vector(model, ref_diff_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        sum += ref_diff_[i]*ref_diff_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    ref1_mat_.multiply_vector(ref_diff_, grad_dm_, gctl::Trans);
    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] = 2.0*rwgt_*grad_dm_[i];
    }


    ref2_mat_.multiply_vector(model, ref_diff_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        sum += ref_diff_[i]*ref_diff_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    ref2_mat_.multiply_vector(ref_diff_, grad_dm_, gctl::Trans);
    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] += 2.0*rwgt_*grad_dm_[i];
    }


    ref3_mat_.multiply_vector(model, ref_diff_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        sum += ref_diff_[i]*ref_diff_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    ref3_mat_.multiply_vector(ref_diff_, grad_dm_, gctl::Trans);
    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] += 2.0*rwgt_*grad_dm_[i];
    }


    ref4_mat_.multiply_vector(model, ref_diff_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        sum += ref_diff_[i]*ref_diff_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    ref4_mat_.multiply_vector(ref_diff_, grad_dm_, gctl::Trans);
    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] += 2.0*rwgt_*grad_dm_[i];
    }


    ref5_mat_.multiply_vector(model, ref_diff_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        sum += ref_diff_[i]*ref_diff_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    ref5_mat_.multiply_vector(ref_diff_, grad_dm_, gctl::Trans);
    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] += 2.0*rwgt_*grad_dm_[i];
    }


    ref6_mat_.multiply_vector(model, ref_diff_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        sum += ref_diff_[i]*ref_diff_[i];
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        ref_diff_[i] *= refm_wgts_[i];
    }

    ref6_mat_.multiply_vector(ref_diff_, grad_dm_, gctl::Trans);
    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] += 2.0*rwgt_*grad_dm_[i];
    }

    sum *= rwgt_;
    return sum;
}