/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::SetReferModelWeight(double wgt, array<double> *ele_wgts)
{
    if (wgt < 0.0)
    {
        throw std::runtime_error("Invalid reference model weight. From GIST::ModelSpace::SetReferModelWeight(...).");
    }

    rwgt_ = wgt;

    refm_wgts_.resize(elem_num_, 1.0);
    if (ele_wgts != nullptr)
    {
        if (ele_wgts->size() != elem_num_)
        {
            throw std::runtime_error("Wrong reference weights' size. From GIST::ModelSpace::SetReferModelWeight(...).");
        }

        for (size_t i = 0; i < elem_num_; i++)
        {
            if (ele_wgts->at(i) <= 0.0)
            {
                throw std::runtime_error("Invalid element weight of the reference model constraint. From GIST::ModelSpace::SetReferModelWeight(...).");
            }

            refm_wgts_[i] = ele_wgts->at(i) * refm_wgts_[i];
        }        
    }

    rwgt_ready_ = true;
    return;
}