/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::SetMinimalModelWeight(array<double> *ele_wgts)
{
    double max_vol = 0.0;
    mini_wgts_.resize(elem_num_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        mini_wgts_[i] = sqrt(elem_vols_[i]);
        max_vol = std::max(max_vol, mini_wgts_[i]);
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        mini_wgts_[i] /= max_vol;
    }
    
    if (ele_wgts != nullptr)
    {
        if (ele_wgts->size() != elem_num_)
        {
            throw std::runtime_error("Wrong minimal weights' size. From GIST::ModelSpace::SetMinimalModelWeight(...).");
        }

        for (size_t i = 0; i < elem_num_; i++)
        {
            if (ele_wgts->at(i) <= 0.0)
            {
                throw std::runtime_error("Invalid element weight of the minimal model constraint. From GIST::ModelSpace::SetMinimalModelWeight(...).");
            }

            mini_wgts_[i] = ele_wgts->at(i) * mini_wgts_[i];
        }        
    }

    mwgt_ready_ = true;
    return;
}