/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::SaveMesh(std::string filename, index_packed_e filemode, array<size_t> *fdata_idx, array<size_t> *edata_idx)
{
    if (in_ready_ == false)
    {
        throw gctl::runtime_error("Model space not initialized. From GIST::ModelSpace::SaveMesh(...)");
    }
    
    fio_.reset_file(filename, Output);
    fio_.set_packed(filemode, Output);

    if (!out_ready_)
    {
        if (node_tag_ready_)
        {
            if (!enodes_.empty()) fio_.element_register(enodes_, &ntags_);
        }
        else
        {
            if (!enodes_.empty()) fio_.element_register(enodes_);
        }

        if (face_tag_ready_)
        {
            if (!faces_.empty() && fdata_idx != nullptr) fio_.element_register(faces_, &ftags_, fdata_idx);
            else if (!faces_.empty()) fio_.element_register(faces_, &ftags_);
        }
        else
        {
            if (!faces_.empty() && fdata_idx != nullptr) fio_.element_register(faces_, nullptr, fdata_idx);
            else if (!faces_.empty()) fio_.element_register(faces_);
        }
        
        if (elem_tag_ready_)
        {
            if (edata_idx != nullptr) fio_.element_register(elems_, &etags_, edata_idx);
            else fio_.element_register(elems_, &etags_);
        }
        else
        {
            if (edata_idx != nullptr) fio_.element_register(elems_, nullptr, edata_idx);
            else fio_.element_register(elems_);
        }

        if (phys_ready_) fio_.save_registered_mesh(nodes_, &phys_);
        else fio_.save_registered_mesh(nodes_);

        out_ready_ = true;
    }
    return;
}