/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::SaveData(std::string dataname, mesh_data_type_e d_type, const array<double> &data, array<size_t> *data_index)
{
    if (out_ready_ == false)
    {
        throw gctl::runtime_error("Output file not initialized. From GIST::ModelSpace::SaveData(...)");
    }

    if (d_type == gctl::NodeData)
    {
        if (data_index != nullptr) fio_.save_data(dataname, data, NodeData, data_index);
        else fio_.save_data(dataname, data, NodeData);
        return;
    }

    if (d_type == gctl::ElemData || d_type == gctl::ElemData2D || d_type == gctl::ElemData3D)
    {
        if (data_index == nullptr)
        {
            if (face_ready_ && d_type == gctl::ElemData3D)
            {
                array<size_t> idx(data.size());
                for (size_t i = 0; i < idx.size(); i++)
                {
                    idx[i] = i + face_num_;
                }

                fio_.save_data(dataname, data, ElemData, &idx);
                return;
            }
            
            fio_.save_data(dataname, data, ElemData);
            return;
        }
        
        if (face_ready_ && d_type == gctl::ElemData3D)
        {
            for (size_t i = 0; i < data_index->size(); i++)
            {
                data_index->at(i) += face_num_;
            }
        }

        fio_.save_data(dataname, data, ElemData, data_index);
        return;
    }    
	return;
}