/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::ReadMeshFaces(msh_tag_e with_tags)
{
    if (in_ready_ == false)
    {
        throw gctl::runtime_error("Input file not initialized. From GIST::ModelSpace::ReadMeshFaces(...)");
    }

    if (with_tags)
    {
        _2i_vector ftags;
        fio_.read_element(faces_, nodes_, &ftags);

        face_num_ = faces_.size();

        ftags_.resize(face_num_, ftags[0].size()); // all tags, including both physical tags, geometric tags and others.
        face_tags_.resize(face_num_, 0); // only physical tags.
        for (size_t i = 0; i < face_num_; i++)
        {
            face_tags_[i] = ftags[i][0];

            for (size_t j = 0; j < ftags[i].size(); j++)
            {
                ftags_[i][j] = ftags[i][j];
            }
        }
        destroy_vector(ftags);

        node_ftags_.resize(node_num_, 0); // face associated physical tag for nodes.
        for (size_t i = 0; i < face_num_; i++)
        {
            for (size_t j = 0; j < 3; j++)
            {
                node_ftags_[faces_[i].vert[j]->id] = face_tags_[i];
            }
        }

        face_tag_ready_ = true;
    }
    else
    {
        fio_.read_element(faces_, nodes_);

        face_num_ = faces_.size();
    }

    face_ready_ = true;
    return;
}