/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

double GIST::ModelSpace::MinimalModelConstraint(double wgt, const array<double> &model, const array<double> &bkg_model, array<double> &out_grad)
{
    if (!mwgt_ready_)
    {
        throw std::runtime_error("Minimal model weights are not initialized. From GIST::ModelSpace::MinimalModelConstraint(...).");
    }
    
    double sum = 0.0;
    out_grad.resize(elem_num_);

    for (int i = 0; i < elem_num_; i++)
    {
        out_grad[i] = 2.0*wgt*mini_wgts_[i]*mini_wgts_[i]*(model[i] - bkg_model[i]);
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        sum += mini_wgts_[i]*mini_wgts_[i]*(model[i] - bkg_model[i])*(model[i] - bkg_model[i]);
    }
    sum *= wgt;

    return sum;
}