/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::InitDepthWeight_DepthApproach(const array<point3ds> &obsp, double beta)
{
    // cal mean observation radius
    double avg_r = 0.0;
    for (size_t i = 0; i < obsp.size(); i++)
    {
        avg_r += obsp[i].rad;
    }
    avg_r /= obsp.size();

    double max_wgt = -1e+30;
    point3ds cen_s;
    dep_wgts_.resize(elem_num_);
    for (size_t i = 0; i < elem_num_; i++)
    {
        cen_s = elems_[i].center().c2s();
        dep_wgts_[i] = avg_r - cen_s.rad;
        max_wgt = std::max(max_wgt, dep_wgts_[i]);
    }

    for (size_t i = 0; i < elem_num_; i++)
    {
        dep_wgts_[i] = pow(dep_wgts_[i]/max_wgt, -1.0*beta);
    }

    dwgt_ready_ = true;
    return;
}

void GIST::ModelSpace::InitDepthWeight_DistanceApproach(const array<point3ds> &obsp, double beta)
{
    // cal mean observation radius
    throw std::runtime_error("Not ready yet. From GIST::ModelSpace::InitDepthWeight_DistanceApproach(...)");
    return;
}