/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::ExportFaceIndex(std::string fac_name, array<size_t> &fac_idx)
{
    if (!face_ready_ || !face_tag_ready_)
    {
        throw gctl::runtime_error("Faces (tags) are not initialized. From GIST::ModelSpace::ExportFaceIndex(...)");
    }

    if (!phys_ready_)
    {
        throw gctl::runtime_error("Physics are not initialized. From GIST::ModelSpace::ExportFaceIndex(...)");
    }

    int tar_tag = -9999;
    bool ok_tag = false;
    for (size_t i = 0; i < phys_.size(); i++)
    {
        if (phys_[i].name == fac_name)
        {
            tar_tag = phys_[i].phys_tag;
            ok_tag = true;
            break;
        }
    }
    
    if (!ok_tag)
    {
        throw gctl::runtime_error("Fail to find the face: " + fac_name + ". From GIST::ModelSpace::ExportFaceIndex(...)");
    }

    array<bool> bn(face_num_, false);
    for (size_t i = 0; i < face_num_; i++)
    {
        if (face_tags_[i] == tar_tag)
        {
            bn[i] = true;
        }
    }

    size_t bn_num = 0;
    for (size_t i = 0; i < face_num_; i++)
    {
        if (bn[i]) bn_num++;
    }
    
    fac_idx.resize(bn_num);

    size_t c = 0;
    for (size_t i = 0; i < face_num_; i++)
    {
        if (bn[i])
        {
            fac_idx[c] = i;
            c++;
        }
    }
    return;
}