/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "model_space.h"

void GIST::ModelSpace::CrtElemData(std::string tag_str, array<double> &data)
{
    if (!elem_tag_ready_)
    {
        throw std::runtime_error("Element tags are not initialized. From GIST::ModelSpace::CrtElemData(...)");
    }

    if (!phys_ready_)
    {
        throw std::runtime_error("Physical groups are not initialized. From GIST::ModelSpace::CrtElemData(...)");
    }
    
    std::vector<std::string> str_vec;
    gctl::parse_string_to_vector(tag_str, ',', str_vec);

    size_t v_num = str_vec.size();
    std::string sig_str;
    double sig_val;
    int tar_tag;
    bool ok_tag;

    data.resize(elem_num_, 0.0);

    for (size_t i = 0; i < v_num; i++)
    {
        gctl::parse_string_to_value(str_vec[i], '/', true, sig_str, sig_val);

        ok_tag = false;
        for (size_t i = 0; i < phys_.size(); i++)
        {
            if (phys_[i].name == sig_str)
            {
                tar_tag = phys_[i].phys_tag;
                ok_tag = true;
                break;
            }
        }
        
        if (!ok_tag)
        {
            throw gctl::runtime_error("Fail to find the elements: " + sig_str + ". From GIST::ModelSpace::CrtElemData(...)");
        }

        for (size_t i = 0; i < elem_num_; i++)
        {
            if (elem_tags_[i] == tar_tag)
            {
                data[i] = sig_val;
            }
        }
    }
    return;
}