/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "gravity.h"

void GIST::Gravity::LoadGravityKernel(std::string filename)
{
    if (!obs_ready_)
    {
        throw gctl::runtime_error("Gravity observations are not ready. From GIST::Gravity::LoadGravityKernel(...)");
    }

    std::string size_str;
    read_binary2matrix(filename, gravity_kernel_, &size_str);

    size_t in, im;
    parse_string_to_value(size_str, '/', true, in, im);

    if (in != obsp_num_ || im != elem_num_)
    {
        throw gctl::runtime_error("Size of the input kernel matrix is incompatible with the current setup. From GIST::Gravity::LoadGravityKernel(...)");
    }

    kernel_ready_ = true;
    return;
}