/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "geophysic_model.h"

void GIST::GeophysicalModel::InitTargetModel(const array<double> &in_mod, array<size_t> *in_idx)
{
    if (!sys_ready_) throw std::runtime_error("The geophysical model is not initialized. From GIST::GeophysicalModel::InitTargetModel(...)");

    if (in_idx == nullptr)
    {
        if (in_mod.size() != elem_num_) throw std::runtime_error("Invalid input model size. From GIST::GeophysicalModel::InitTargetModel(...)");
        
        tar_num_ = elem_num_;
    }
    else
    {
        if (in_mod.size() != in_idx->size()) throw std::runtime_error("Invalid input model and/or index sizes. From GIST::GeophysicalModel::InitTargetModel(...)");

        tar_num_ = in_mod.size();
        tar_idx_.resize(tar_num_);
        for (size_t i = 0; i < tar_num_; i++)
        {
            tar_idx_[i] = in_idx->at(i);
        }

        partial_model_ = true;
    }

    tar_model_.resize(tar_num_);
    for (size_t i = 0; i < tar_num_; i++)
    {
        tar_model_[i] = in_mod[i];
    }

    tar_ready_ = true;
    return;
}