/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "geophysic_model.h"

GIST::GeophysicalModel::GeophysicalModel()
{
    sys_ready_ = err_ready_ = tar_ready_ = false;
    partial_model_ = false;
}

GIST::GeophysicalModel::~GeophysicalModel(){}

void GIST::GeophysicalModel::set_geophysical_model_error(double err)
{
    if (!tar_ready_) throw std::runtime_error("Target model not ready. From GIST::GeophysicalModel::set_geophysical_model_error(...)"); 
    if (err <= 0.0) throw std::runtime_error("Invalid error value. From GIST::GeophysicalModel::set_geophysical_model_error(...)");
    
    mod_err_ = err;
    err_ready_ = true;
    return;
}

void GIST::GeophysicalModel::set_geophysical_model_error(const array<double> &errs)
{
    if (!tar_ready_) throw std::runtime_error("Target model not ready. From GIST::GeophysicalModel::set_geophysical_model_error(...)"); 
    if (tar_num_ != errs.size()) throw std::runtime_error("Invalid error size. From GIST::GeophysicalModel::set_geophysical_model_error(...)");

    mod_errs_.resize(tar_num_);
    for (size_t i = 0; i < tar_num_; i++)
    {
        mod_errs_[i] = errs[i];
    }

    err_ready_ = true;
    return;
}