/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "geoid.h"

void GIST::Geoid::CalGeoidKernel()
{
    if (!sys_ready_)
    {
        throw std::runtime_error("The geoid system is not initialized. From GIST::Geoid::CalGeoidKernel().");
    }

    if (!obs_ready_)
    {
        throw gctl::runtime_error("Geoid observations not ready. From GIST::Geoid::CalGeoidKernel().");
    }
 
    // create an alias
    array<tetrahedron> &ele = m_space_->get_element();

    geoid_kernel_.resize(obsp_num_, elem_num_);
    geoid_ele_.resize(elem_num_);
    geoid_para_.resize(elem_num_);

    for (size_t i = 0; i < elem_num_; i++)
    {
        // Always use set() function to initiate a tetrahedron element
        geoid_ele_[i].set(ele[i].vert[0], ele[i].vert[1], ele[i].vert[2], ele[i].vert[3], ele[i].id);
    }
 
    callink_gravity_para(geoid_ele_, geoid_para_);
    gkernel(geoid_kernel_, geoid_ele_, geoid_obsp_, GravPot);

    for (size_t i = 0; i < obsp_num_; i++)
    {
        for (size_t j = 0; j < elem_num_; j++)
        {
            geoid_kernel_[i][j] /= (1e+5*earth_1d_->get_normal_gravity(geoid_obsp_[i].lat));
        }
    }

    kernel_ready_ = true;
    return;
}