/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "earth_1d.h"

void GIST::Earth1D::ShowStatistics(std::ostream &ss)
{
	ss << "----------------------------\n";
	ss << "1-D Earth Model: " << name_ << ", Layer Num. = " << layer_num_ << std::endl;
	ss << "Polar radius = " << ref_r_ << ", Equatorial radius = " << ref_R_ << std::endl;
	
	double mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, depth_[i]);
		maxi = std::max(maxi, depth_[i]);
	}
	ss << "Depth: " << mini << " - " << maxi;

	mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, den_[i]);
		maxi = std::max(maxi, den_[i]);
	}
	ss << ", Density: " << mini << " - " << maxi;

	mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, press_[i]);
		maxi = std::max(maxi, press_[i]);
	}
	ss << ", Pressure: " << mini << " - " << maxi << std::endl;

	mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, vp_[i]);
		maxi = std::max(maxi, vp_[i]);
	}
	ss << "Vp: " << mini << " - " << maxi;

	mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, vs_[i]);
		maxi = std::max(maxi, vs_[i]);
	}
	ss << ", Vs: " << mini << " - " << maxi;

	mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, t_cndt_[i]);
		maxi = std::max(maxi, t_cndt_[i]);
	}
	ss << ", Thermal Conductivity: " << mini << " - " << maxi  << std::endl;

	mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, tep_[i]);
		maxi = std::max(maxi, tep_[i]);
	}
	ss << ", Temperature: " << mini << " - " << maxi;

	mini = 1e+30, maxi = -1e+30;
	for (size_t i = 0; i < layer_num_; i++)
	{
		mini = std::min(mini, mg_[i]);
		maxi = std::max(maxi, mg_[i]);
	}
	ss << ", Magnesium: " << mini << " - " << maxi << std::endl;
	ss << "----------------------------\n";
	return;
}

void GIST::Earth1D::ShowWholeProfile(std::ostream &ss)
{
    ss << "# Reference Ellipsoid\n" << ref_r_ << " " << ref_R_ << "\n";
    ss << "# Model Layers\n" << layer_num_ << "\n";
	ss << "# Depth(m) Density(g/cm^3) Vp(km/s) Vs(km/s) ThermalConductivity(W/m.K) Temperature(K) Magnesium(#) Pressure(Gpa)\n";
    for (size_t i = 0; i < layer_num_; i++)
    {
        ss << depth_[i] << " " << den_[i] << " " << vp_[i] << " " << vs_[i] << " " << t_cndt_[i] 
			<< " " << tep_[i] << " " << mg_[i] << " " << press_[i] << "\n";
    }
    return;
}