#!/bin/bash

if [[ $# == 0 || ${1} == "help" ]]; then
	echo "Compiles library and executable(s)."
	echo "Usage: ./config_gist.sh [option]"
	echo "Options:"
	echo "(1)  configure: Configure Cmake project(s)."
	echo "(2)      build: Build executable(s)."
	echo "(3)      clean: Clean build/ folder(s)."
	echo "(4)     update: Run options (2) and (3) in sequent."
	echo "(5)       help: Show help information."
	exit 0
fi

if [[ ${1} == "configure" && ! -d "build/" ]]; then
	mkdir build && cd build && cmake .. -DCMAKE_BUILD_TYPE=Release
elif [[ ${1} == "configure" ]]; then
	cd build && rm -rf * && cmake ..  -DCMAKE_BUILD_TYPE=Release
elif [[ ${1} == "update" ]]; then
	cd build && make && cd .. && rm -rf build/
elif [[ ${1} == "build" ]]; then
	cd build && make
elif [[ ${1} == "clean" ]]; then
	rm -rf build/
fi
