/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

/**
 * @brief 运行定义的流程
 * 
 * @param argc 运行时参数个数
 * @param argv 运行时参数列表 第一个参数为选项文件名 第二个参数为默认参数文件名（可选）
 */
void GIST::Assembler::Run(int argc, char *argv[])
{
    if (argc >= 1) Display_Logo();
    if (argc == 1)
    {
        Display_Help();
        return;
    }

    // Load the default setups
    if (argc == 2) InitDefaultSetups("null");
    else if (argc >= 3) InitDefaultSetups(argv[2]);

    AddOptions();

    gopt_.read_options(argv[1]);
    gopt_.check_mandatory();
    gopt_.check_groups();
    gopt_.show_options(std::cout);

    Routine();
    return;
}