/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

void GIST::Assembler::ParseTagPairs(std::string opt_str, std::vector<std::string> &tag_vec, 
    std::vector<std::string> &val_vec, char str_separator, char tag_separator)
{
    std::vector<std::string> opt_strs;
    parse_string_to_vector(opt_str, str_separator, opt_strs);

    if (!tag_vec.empty()) tag_vec.clear();
    if (!val_vec.empty()) val_vec.clear();
    tag_vec.resize(opt_strs.size());
    val_vec.resize(opt_strs.size());

    for (size_t i = 0; i < opt_strs.size(); i++)
    {
        parse_string_to_value(opt_strs[i], tag_separator, true, tag_vec[i], val_vec[i]);
    }

    opt_strs.clear();
    return;
}