/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

bool GIST::Assembler::InitModelData(std::string opt_str, array<double> &data, array<size_t> *data_idx)
{
    if (gopt_.has_value(opt_str+"-value")) // First try the value option
    {
        data.resize(m_space_.get_element_number(), atof(gopt_.get_value(opt_str+"-value").c_str()));
        return true;
    }
    else if (gopt_.has_value(opt_str+"-model")) // Try read data from model file
    {
        if (data_idx == nullptr) m_space_.ReadData(gopt_.get_value(opt_str+"-model"), data);
        else m_space_.ReadData(gopt_.get_value(opt_str+"-model"), gctl::ElemData3D, *data_idx, data);
        return true;
    }
    else if (gopt_.has_value(opt_str+"-tag")) // Try assign data values using tags
    {
        m_space_.CrtElemData(gopt_.get_value(opt_str+"-tag"), data);
        return true;
    }
    else if (gopt_.has_value(opt_str+"-linear")) // Try assign data values using tags
    {
        double t_dep, b_dep, t_val, b_val;
        parse_string_to_value(gopt_.get_value(opt_str+"-linear"), '/', true, t_dep, b_dep, t_val, b_val);
        m_space_.CrtElemData1DLinear(data, earth1d_obj_, t_dep, b_dep, t_val, b_val);
        return true;
    }
    else if (gopt_.has_value(opt_str+"-profile")) // Try assign data values using tags
    {
        GIST:model_type_e m_type;
        if (gopt_.get_value(opt_str+"-profile") == "Density") m_type = Density;
        else if (gopt_.get_value(opt_str+"-profile") == "Lithostatic_Pressure") m_type = Lithostatic_Pressure;
        else if (gopt_.get_value(opt_str+"-profile") == "Vs") m_type = Vs;
        else if (gopt_.get_value(opt_str+"-profile") == "Vp") m_type = Vp;
        else if (gopt_.get_value(opt_str+"-profile") == "Temperature") m_type = Temperature;
        else if (gopt_.get_value(opt_str+"-profile") == "Thermal_Conductivity") m_type = Thermal_Conductivity;
        else if (gopt_.get_value(opt_str+"-profile") == "Magnesium") m_type = Magnesium;
        else throw std::runtime_error("Invalid data type of the 1D-Earth model.");

        m_space_.CrtElemData1DEarth(data, earth1d_obj_, m_type);
        return true;
    }
    return false;
}