/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

void GIST::Assembler::InitLGDSetups(lgd_para &in_para)
{
    /**
     * Start the configuration of the default LGD options
     */
    getoption deft_opt;
    deft_opt.add_options(
        {"flight_times", "batch", "epsilon", "stddev_v", "beta", "alpha", "sigma", "lambda"}, 
        {false, false, false, false, false, false, false, false});

    if (lgd_dfts_ != "null" && !access(lgd_dfts_.c_str(), 2)) deft_opt.read_options(lgd_dfts_);
    else if (!access("lgd.default", 2)) deft_opt.read_options("lgd.default");
    else throw std::runtime_error("The option file for LGD Algorithm is not found.");

    if (deft_opt.has_value("flight_times"))   in_para.flight_times  = std::atoi(deft_opt.get_value("flight_times").c_str());
    if (deft_opt.has_value("batch"))          in_para.batch         = std::atoi(deft_opt.get_value("batch").c_str());
    if (deft_opt.has_value("epsilon"))        in_para.epsilon       = std::atof(deft_opt.get_value("epsilon").c_str());
    if (deft_opt.has_value("stddev_v"))       in_para.stddev_v      = std::atof(deft_opt.get_value("stddev_v").c_str());
    if (deft_opt.has_value("beta"))           in_para.beta          = std::atof(deft_opt.get_value("beta").c_str());
    if (deft_opt.has_value("alpha"))          in_para.alpha         = std::atof(deft_opt.get_value("alpha").c_str());
    if (deft_opt.has_value("sigma"))          in_para.sigma         = std::atof(deft_opt.get_value("sigma").c_str());
    if (deft_opt.has_value("lambda"))         in_para.lambda        = std::atof(deft_opt.get_value("lambda").c_str());
    
    /**
     * End the configuration of the default LGD options
     */
    return;
}