/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

void GIST::Assembler::InitLCGSetups(lcg_para &in_para)
{
    /**
     * Start the configuration of the default LCG options
     */

    getoption deft_opt;
    deft_opt.add_options(
        {"max_iterations", "epsilon", "abs_diff", "restart_epsilon", "step", "sigma", "beta", "maxi_m"}, 
        {false, false, false, false, false, false, false, false});

    if (lcg_dfts_ != "null" && !access(lcg_dfts_.c_str(), 2)) deft_opt.read_options(lcg_dfts_); // Read LCG options from file specified by the gist.default file
    else if (!access("lcg.default", 2)) deft_opt.read_options("lcg.default"); // Read LCG options from the default file
    else throw std::runtime_error("The option file for LCG algorithm is not found.");

    if (deft_opt.has_value("max_iterations"))  in_para.max_iterations  = std::atoi(deft_opt.get_value("max_iterations").c_str());
    if (deft_opt.has_value("epsilon"))         in_para.epsilon         = std::atof(deft_opt.get_value("epsilon").c_str());
    if (deft_opt.has_value("abs_diff"))        in_para.abs_diff        = std::atoi(deft_opt.get_value("abs_diff").c_str());
    if (deft_opt.has_value("restart_epsilon")) in_para.restart_epsilon = std::atof(deft_opt.get_value("restart_epsilon").c_str());
    if (deft_opt.has_value("step"))            in_para.step            = std::atof(deft_opt.get_value("step").c_str());
    if (deft_opt.has_value("sigma"))           in_para.sigma           = std::atof(deft_opt.get_value("sigma").c_str());
    if (deft_opt.has_value("beta"))            in_para.beta            = std::atof(deft_opt.get_value("beta").c_str());
    if (deft_opt.has_value("maxi_m"))          in_para.maxi_m          = std::atoi(deft_opt.get_value("maxi_m").c_str());

    /**
     * End the configuration of the default LCG options
     */
    return;
}