/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

void GIST::Assembler::InitLBFGSSetups(lbfgs_para &in_para)
{
    /**
     * Start the configuration of the default LBFGS options
     */
    getoption deft_opt;
    deft_opt.add_options(
        {"m", "epsilon", "past", "delta", "max_iterations", "max_linesearch", "min_step", "max_step", 
        "ftol", "wolfe", "gtol", "xtol", "orthantwise_c", "orthantwise_start", "orthantwise_end", "linesearch"}, 
        {false, false, false, false, false, false, false, false, 
        false, false, false, false, false, false, false, false});

    if (lbfgs_dfts_ != "null" && !access(lbfgs_dfts_.c_str(), 2)) deft_opt.read_options(lbfgs_dfts_);
    else if (!access("lbfgs.default", 2)) deft_opt.read_options("lbfgs.default");
    else throw std::runtime_error("The option file for LBFGS Algorithm is not found.");

    if (deft_opt.has_value("m"))                 in_para.m                 = std::atoi(deft_opt.get_value("m").c_str());
    if (deft_opt.has_value("epsilon"))           in_para.epsilon           = std::atof(deft_opt.get_value("epsilon").c_str());
    if (deft_opt.has_value("past"))              in_para.past              = std::atoi(deft_opt.get_value("past").c_str());
    if (deft_opt.has_value("delta"))             in_para.delta             = std::atof(deft_opt.get_value("delta").c_str());
    if (deft_opt.has_value("max_iterations"))    in_para.max_iterations    = std::atoi(deft_opt.get_value("max_iterations").c_str());
    if (deft_opt.has_value("max_linesearch"))    in_para.max_linesearch    = std::atoi(deft_opt.get_value("max_linesearch").c_str());
    if (deft_opt.has_value("min_step"))          in_para.min_step          = std::atof(deft_opt.get_value("min_step").c_str());
    if (deft_opt.has_value("max_step"))          in_para.max_step          = std::atof(deft_opt.get_value("max_step").c_str());
    if (deft_opt.has_value("ftol"))              in_para.ftol              = std::atof(deft_opt.get_value("ftol").c_str());
    if (deft_opt.has_value("wolfe"))             in_para.wolfe             = std::atof(deft_opt.get_value("wolfe").c_str());
    if (deft_opt.has_value("gtol"))              in_para.gtol              = std::atof(deft_opt.get_value("gtol").c_str());
    if (deft_opt.has_value("xtol"))              in_para.xtol              = std::atof(deft_opt.get_value("xtol").c_str());
    if (deft_opt.has_value("orthantwise_c"))     in_para.orthantwise_c     = std::atof(deft_opt.get_value("orthantwise_c").c_str());
    if (deft_opt.has_value("orthantwise_start")) in_para.orthantwise_start = std::atoi(deft_opt.get_value("orthantwise_start").c_str());
    if (deft_opt.has_value("orthantwise_end"))   in_para.orthantwise_end   = std::atoi(deft_opt.get_value("orthantwise_end").c_str());
    
    if (deft_opt.has_value("linesearch"))
    {
        std::string search_str = deft_opt.get_value("linesearch");
        if (search_str == "LBFGS_LINESEARCH_DEFAULT")                   in_para.linesearch = LBFGS_LINESEARCH_DEFAULT;
        if (search_str == "LBFGS_LINESEARCH_MORETHUENTE")               in_para.linesearch = LBFGS_LINESEARCH_MORETHUENTE;
        if (search_str == "LBFGS_LINESEARCH_BACKTRACKING_ARMIJO")       in_para.linesearch = LBFGS_LINESEARCH_BACKTRACKING_ARMIJO;
        if (search_str == "LBFGS_LINESEARCH_BACKTRACKING")              in_para.linesearch = LBFGS_LINESEARCH_BACKTRACKING;
        if (search_str == "LBFGS_LINESEARCH_BACKTRACKING_WOLFE")        in_para.linesearch = LBFGS_LINESEARCH_BACKTRACKING_WOLFE;
        if (search_str == "LBFGS_LINESEARCH_BACKTRACKING_STRONG_WOLFE") in_para.linesearch = LBFGS_LINESEARCH_BACKTRACKING_STRONG_WOLFE;
        if (search_str == "LBFGS_LINESEARCH_BACKTRACKING_ARMIJO_QUAD")  in_para.linesearch = LBFGS_LINESEARCH_BACKTRACKING_ARMIJO_QUAD;
    }

    /**
     * End the configuration of the default LBFGS options
     */
    return;
}