/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

void GIST::Assembler::InitDefaultSetups(std::string gist_dfts)
{
    getoption deft_opt;
    deft_opt.add_options({GIST_LCG_OPTS, GIST_LBFGS_OPTS, GIST_LGD_OPTS, GIST_GMSH_PACKED}, {true, true, true, true});

    /**
     * Start the configuration of the default GIST options
     */

    // looking for gist.default at the current directory or the given directory
    if (gist_dfts != "null" && !access(gist_dfts.c_str(), 2)) deft_opt.read_options(gist_dfts); // read the given file
    else if (!access("gist.default", 2)) deft_opt.read_options("gist.default"); // read the default file
    else throw std::runtime_error("Default options for GIST are not found. A gist.default file must be exist at the current directory or a given directory.");

    deft_opt.check_mandatory();

    // setup deafults options
    lcg_dfts_ = deft_opt.get_value(GIST_LCG_OPTS);
    lbfgs_dfts_ = deft_opt.get_value(GIST_LBFGS_OPTS);
    lgd_dfts_ = deft_opt.get_value(GIST_LGD_OPTS);

    if (deft_opt.get_value(GIST_GMSH_PACKED) == "yes") node_packed_ = gctl::Packed;
    else if (deft_opt.get_value(GIST_GMSH_PACKED) == "no") node_packed_ = gctl::NotPacked;
    else throw std::runtime_error("Invalid Gmsh node indexing type.");

    /**
     * End the configuration of the default GIST options
     */
    return;
}