/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "assembler.h"

void GIST::Assembler::AddGroupOption(std::string opt_str, int gp_tag)
{
    std::string tag_str = opt_str, mod_str = opt_str, val_str = opt_str, lin_str = opt_str, pro_str = opt_str;
    tag_str += "-tag"; mod_str += "-model"; val_str += "-value"; lin_str += "-linear"; pro_str += "-profile";

    gopt_.add_options({opt_str, tag_str, mod_str, val_str, lin_str, pro_str}, {true, true, true, true, true, true});
    gopt_.set_group(gp_tag, {opt_str, tag_str, mod_str, val_str, lin_str, pro_str});
    return;
}