# Dataset Metadata README

## Dataset Structure
The dataset is organized into the following files:
1) The file Inversions_CO2_v2022.csv includes the NEE CO2 flux from managed lands for the nine CO2 inverse models. 
It includes 8 fields: years (from 1960 to 2021), country, value (unit: TgC/yr), sector ("land": without the adjustment of lateral C flux; "land_cor": with later C flux adjustment), source, gas, observation ("in-situ": in-situ-based; "satellite": satellite-based), version ("CO2_ML_v2022" only).
2) The file Inversions_CH4_v2022.csv includes CH4 flux from anthropogenic sources for the six CH4 inverse models. 
It includes 8 fields: years (from 2000 to 2020), country, value (unit: TgCH4/yr), sector ("agrw": agriculture and waste; "fos": fossil fuel; "ant": anthropogenic=agrw+fos), source, gas, observation ("in-situ": in-situ-based; "satellite": satellite-based), version ("CH4_2022_V1": use EDGAR as priors; "CH4_2022_V2": use GAINS as priors).
3) The file Inversions_N2O_v2022.csv includes the anthropogenic N2O flux from managed lands for the four N2O inverse models. 
It includes 8 fields: years (from 1995 to 2020), country, value (unit: TgN2O/yr), sector ("ant" only, for anthropogenic), source, gas, observation ("in-situ" only, for in-situ-based), version ("N2O_ML_v2022" only).
4) The file lateral_CO2_v2022.csv includes the national lateral C flux from river and trade.
5) The file NGHGIs_v2022.csv includes the national inventory data collected from UNFCCC NGHGIs (unit: Gg/yr)

## Sector
- CO2:
	- "land": without the adjustment of lateral C flux
	- "land_cor": with later C flux adjustment
- CH4:
	- "agrw": agriculture and waste
	- "fos": fossil fuel
	- "ant": anthropogenic=agrw+fos
- N2O:
	- "ant": anthropogenic

## Unit
- Inversion:
	- CO2: Tg C / yr
	- CH4: Tg CH4 / yr
	- N2O: Tg N2O / yr
- Inventory:
	- CO2: Gg CO2 / yr
	- CH4: Gg CH4 / yr
	- N2O: Gg N2O / yr

