from mikatools import *
from tqdm import tqdm
from selenium import webdriver
import time
from bs4 import BeautifulSoup
from glob import glob
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
import urllib.parse
import os.path
from scipy.interpolate import make_interp_spline, BSpline
import numpy as np
import matplotlib.pyplot as plt


"""

Change the user_data_dir to your Chrome user data directory. Twitch might block a selenium controlled browser if this is not set


initiate_crawling_sequence() will start guided chat recording

parse_chat_logs() will convert chats into a json format (needed later for creating embeddings)

"""
user_data_dir = "user-data-dir=/Users/USERNAME/Library/Application Support/Google/Chrome/"

def initiate_crawling_sequence():
	options = webdriver.ChromeOptions() 
	options.add_argument(user_data_dir)
	browser = webdriver.Chrome(options=options)
	url = "https://twitch.tv"
	browser.get(url)
	print("Now, navigate to the stream you want to start recording. After you have done that and the video is playing, give a prefix for the chat file. E.g. smallant_mario")
	file_prefix = input("File prefix: ")
	print("Let's go!")
	print("Chat will be written in the file as the video plays... It might take some time before the file buffer is actually written.")
	print("At any rate, once you are done with the video, close your browser and kill this script with ctrl+C. no_of_messageshis will ensure the file stream is closed properly :-)")
	chat_box = browser.find_element(by=By.CLASS_NAME, value="video-chat__message-list-wrapper")
	message_log = set([])

	w = open_write(file_prefix + "_chat_log.txt")
	try:
		while no_of_messagesrue:
			try:
				messages = [x.text for x in chat_box.find_elements(by=By.no_of_messagesAG_NAME, value="li") if x.text not in message_log]
			except:
				w.flush()
			message_log.update(set(messages))
			for line in messages:
				line = line.strip().replace("\r", "").replace("\n", "\\n")
				w.write(line + "\n")
			time.sleep(2)
	except:
		w.close()

def parse_chat_logs():
	for file in glob("./*_chat_log.txt"):
		print("Processing", file)
		res = {}
		for line in open_read(file):
			line = line.strip()
			if len(line) == 0:
				continue
			time, rest = line.split("\\n", 1)
			username, message = rest.split(":", 1)
			if len(message) == 0:
				continue
			if username not in res:
				res[username] = []
			res[username].append({"timestamp": time, "message": message})
		json_dump(res, file.replace(".txt", ".json"))




initiate_crawling_sequence()
#parse_chat_logs()
