# -*- coding: utf-8 -*-
"""
/***************************************************************************
 jpdata
                                 A QGIS plugin
 Download and load various data of Japan
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-04-28
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Yoshihiko Baba
        email                : babayoshihiko@mac.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt, QUrl
from qgis.PyQt.QtGui import QIcon, QDesktopServices
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .jpdata_dockwidget import jpdataDockWidget
import os.path

# User defined
import os, tempfile
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QListWidgetItem
from qgis.PyQt.QtWidgets import QAbstractItemView
from qgis.core import QgsProject, QgsSettings, QgsVectorLayer, QgsRasterLayer
from . import jpDataUtils
from . import jpDataDownloader
from . import jpDataMuni
from . import jpDataCensus
from . import jpDataLNI
from .jpdata_mesh import jpdataMeshWidget


class jpdata:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value("locale/userLocale")[0:2]
        locale_path = os.path.join(
            self.plugin_dir, "i18n", "jpdata_{}.qm".format(locale)
        )

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr("&jpdata")
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar("jpdata")
        self.toolbar.setObjectName("jpdata")

        # print "** INITIALIZING jpdata"

        self.pluginIsActive = False
        self.dockwidget = None

        # User defined
        self._folderPath = QSettings().value("jpdata/FolderPath", "~")
        self._proxyServer = QSettings().value("jpdata/ProxyServer", "http://")
        self._LandNumInfo = jpDataUtils.getMapsFromCsv()
        self._GSI = jpDataUtils.getTilesFromCsv()
        # Create an action that triggers the folder chooser
        self.action = QAction("Choose Folder", self.iface.mainWindow())
        self.action.triggered.connect(self.chooseFolder)

        self.meshWindow = jpdataMeshWidget()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate("jpdata", message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        self.add_action(
            os.path.join(self.plugin_dir, "icon.png"),
            text=self.tr("jpdata"),
            callback=self.run,
            add_to_toolbar=False,
            parent=self.iface.mainWindow(),
        )

    # --------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        # print "** CLOSING jpdata"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        # print "** UNLOAD jpdata"

        for action in self.actions:
            self.iface.removePluginMenu(self.tr("&jpdata"), action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    # --------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            # print "** STARTING jpdata"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = jpdataDockWidget()

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # User defined
            self._downloader = jpDataDownloader.DownloadThread()
            self._downloader.progress.connect(self.dockwidget.progressBar.setValue)
            self._downloader.finished.connect(self.download_finished)

            self.dockwidget.myPushButton2.setText(self.tr("Choose Folder"))
            self.dockwidget.myPushButton2.setToolTip(self.tr("Choose Folder"))
            self.dockwidget.myPushButton2.clicked.connect(self.chooseFolder)

            self.dockwidget.myLabelStatus.setText("")

            # Set Tab 1
            self.dockwidget.myTabWidget.setTabText(0, self.tr("LandNumInfo"))
            self.dockwidget.myPushButton11.setText(self.tr("Download"))
            self.dockwidget.myPushButton11.setToolTip(
                self.tr("Download Land Numerical Information data")
            )
            self.dockwidget.myPushButton11.clicked.connect(self.tab1DownloadAll)
            self.dockwidget.myPushButton14.setText(self.tr("Add to Map"))
            self.dockwidget.myPushButton14.setToolTip(
                self.tr("Add Shapefile as a Layer to Map on QGIS")
            )
            self.dockwidget.myPushButton14.clicked.connect(self.tab1AddMap)
            self.dockwidget.myPushButton15.setText(self.tr("Web"))
            self.dockwidget.myPushButton15.setToolTip(
                self.tr("Open the webpage with the standard browser")
            )
            self.dockwidget.myPushButton15.clicked.connect(self.tab1Web)
            for row in self._LandNumInfo:
                item = QListWidgetItem(row["name_j"])
                if row["availability"] != "yes":
                    item.setFlags(item.flags() & ~Qt.ItemIsSelectable)
                    item.setForeground(Qt.gray)
                self.dockwidget.myListWidget11.addItem(item)
            self.tab1CheckPrefsOrRegions()
            # Users cannot choose multiple maps
            # self.dockwidget.myListWidget11.setSelectionMode(
            #    QAbstractItemView.ExtendedSelection
            # )
            self.dockwidget.myListWidget11.clicked.connect(self.tab1CheckPrefsOrRegions)
            self.dockwidget.myListWidget12.clicked.connect(self.tab1CheckYear)
            self.myListWidget12_is_all_prefs = False
            # Users cannot choose multiple prefctures
            self.dockwidget.myListWidget12.setSelectionMode(
                QAbstractItemView.ExtendedSelection
            )

            # Set Tab 2
            self.dockwidget.myTabWidget.setTabText(1, self.tr("GSI Tiles"))
            self.dockwidget.myPushButton25.setText(self.tr("Add to Map"))
            self.dockwidget.myPushButton25.setToolTip(
                self.tr("Add GSI xyz tile server to Map on QGIS")
            )
            self.dockwidget.myPushButton25.clicked.connect(self.addTile)
            for row in self._GSI:
                self.dockwidget.myListWidget23.addItem(row["name_j"])

            # Set Tab 3
            self.dockwidget.myTabWidget.setTabText(2, self.tr("Census"))
            self.dockwidget.myLabel31.setText(self.tr("Year"))
            self.dockwidget.myComboBox31.addItem("2020")
            self.dockwidget.myComboBox31.addItem("2015")
            self.dockwidget.myComboBox31.addItem("2010")
            self.dockwidget.myComboBox31.addItem("2005")
            self.dockwidget.myComboBox31.addItem("2000")
            self.dockwidget.myPushButton31.setText(self.tr("Download"))
            self.dockwidget.myPushButton31.setToolTip(
                self.tr("Download census data by city")
            )
            self.dockwidget.myPushButton31.clicked.connect(self.tab3DownloadAll)
            self.dockwidget.myPushButton32.setText(self.tr("Add to Map"))
            self.dockwidget.myPushButton32.setToolTip(
                self.tr("Add Shapefile as a Layer to Map on QGIS")
            )
            self.dockwidget.myPushButton32.clicked.connect(self.tab3AddMap)
            self.dockwidget.myListWidget31.itemClicked.connect(self.tab3SelectPref)
            self.dockwidget.myListWidget32.setSelectionMode(
                QAbstractItemView.ExtendedSelection
            )

            for code in range(1, 48):
                self.dockwidget.myListWidget31.addItem(
                    jpDataUtils.getPrefNameByCode(code)
                )

            # Tab Setting
            self.dockwidget.myTabWidget.setTabText(3, self.tr("Setting"))
            self.dockwidget.myLineEditSetting1.textEdited.connect(self.setProxyServer)
            self.dockwidget.myLineEditSetting2.textEdited.connect(self.setProxyServer)
            self.dockwidget.myLineEditSetting3.textEdited.connect(self.setProxyServer)
            if self._folderPath:
                self.dockwidget.myLabel1.setText(self._folderPath)
            else:
                self.dockwidget.myLabel1.setText(
                    self.tr("Choose folder for zip/shp files")
                )
                self.dockwidget.myTabWidget.setCurrentIndex(3)
            if self._proxyServer:
                self.dockwidget.myLineEditSetting1.setText(self._proxyServer)
            self.dockwidget.myLineEditSetting2.setToolTip(
                self.tr("User/Password are not stored")
            )
            self.dockwidget.myLineEditSetting3.setToolTip(
                self.tr("User/Password are not stored")
            )

            # self.dockwidget.myPushButtonTest.hide()
            self.dockwidget.myPushButtonTest.setText(self.tr("Test"))
            self.dockwidget.myPushButtonTest.clicked.connect(self.showMeshWindow)

            # Mesh Window
            self.meshWindow.meshLabel1.setText(self.tr("Prefecture"))
            self.meshWindow.meshLabel2.setText(self.tr("Municipality"))
            for code in range(1, 48):
                self.meshWindow.meshListWidget1.addItem(
                    jpDataUtils.getPrefNameByCode(code)
                )
            self.meshWindow.meshListWidget1.clicked.connect(self.meshPref)
            self.meshWindow.meshListWidget2.clicked.connect(self.meshMuni)
            self.meshWindow.setWindowFlags(Qt.WindowStaysOnTopHint)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

    def addTile(self):
        selected_items = self.dockwidget.myListWidget23.selectedItems()

        for current_gsi in self._GSI:
            if current_gsi["name_j"] == str(selected_items[0].text()):
                tile_name = current_gsi["name_j"]
                tile_url = current_gsi["url"]
                zoom_min = current_gsi["zoom_min"]
                zoom_max = current_gsi["zoom_max"]
                break

        tile_url = (
            "type=xyz&url="
            + tile_url
            + "&zmax="
            + zoom_max
            + "&zmin="
            + zoom_min
            + "&crs=EPSG3857"
        )
        layer = QgsRasterLayer(tile_url, tile_name, "wms")
        if not layer.isValid():
            return
        QgsProject.instance().addMapLayer(layer)

    def tab1CheckPrefsOrRegions(self):
        self.tab1CheckYear()
        items = self.dockwidget.myListWidget11.selectedItems()
        for i in range(len(items)):
            for item in self._LandNumInfo:
                if (
                    str(self.dockwidget.myListWidget11.selectedItems()[i].text())
                    == item["name_j"]
                ):
                    if item["type_muni"].lower() == "regional":
                        if not self.myListWidget12_is_all_prefs:
                            self.dockwidget.myListWidget12.clear()
                        self.myListWidget12_is_all_prefs = True
                        names_pref = jpDataLNI.getPrefsOrRegionsByMapCode(
                            item["code_map"]
                        )
                        for name_pref in names_pref:
                            self.dockwidget.myListWidget12.addItem(name_pref)
                    elif item["type_muni"].lower() == "single":
                        self.myListWidget12_is_all_prefs = False
                        self.dockwidget.myListWidget12.clear()
                        self.dockwidget.myListWidget12.addItem(self.tr("Nation-wide"))
                    else:
                        self.myListWidget12_is_all_prefs = False
                        self.dockwidget.myListWidget12.clear()
                        for code_pref in range(1, 48):
                            self.dockwidget.myListWidget12.addItem(
                                jpDataUtils.getPrefNameByCode(code_pref)
                            )

    def tab1CheckYear(self):
        items = self.dockwidget.myListWidget11.selectedItems()
        for i in range(len(items)):
            for item in self._LandNumInfo:
                if (
                    str(self.dockwidget.myListWidget11.selectedItems()[i].text())
                    == item["name_j"]
                ):
                    self.dockwidget.myComboBox11.clear()
                    if item["year"].lower() != "csv":
                        self.dockwidget.myListWidget12.setSelectionMode(
                            QAbstractItemView.ExtendedSelection
                        )
                        self.dockwidget.myComboBox11.addItem(item["year"])
                    else:
                        if len(self.dockwidget.myListWidget12.selectedItems()) > 0:
                            name_pref = self.dockwidget.myListWidget12.selectedItems()[
                                0
                            ].text()
                        else:
                            name_pref = None
                        self.dockwidget.myListWidget12.setSelectionMode(
                            QAbstractItemView.SingleSelection
                        )
                        years = jpDataLNI.getYearsByMapCode(item["code_map"], name_pref)
                        for year in years:
                            self.dockwidget.myComboBox11.addItem(year)

    def tab1DownloadAll(self):
        self.dockwidget.progressBar.setValue(0)
        if self.dockwidget.myPushButton11.text() == self.tr("Cancel"):
            self.dockwidget.myPushButton11.setText(self.tr("Download"))
            self.cancel_download()
            return

        self.dockwidget.myPushButton11.setText(self.tr("Cancel"))
        self.dockwidget.myPushButton14.setEnabled(False)

        items = self.dockwidget.myListWidget11.selectedItems()
        pref_name = self.dockwidget.myListWidget12.selectedItems()
        pref_code = []
        for i in range(len(pref_name)):
            pref_code.append(
                jpDataUtils.getPrefCodeByName(
                    str(self.dockwidget.myListWidget12.selectedItems()[i].text())
                )
            )

        for i in range(len(items)):
            for item in self._LandNumInfo:
                if (
                    str(self.dockwidget.myListWidget11.selectedItems()[i].text())
                    == item["name_j"]
                ):
                    if item["type_muni"] != "single":
                        for x in range(len(pref_code)):
                            if self.dockwidget.myPushButton11.text() == self.tr(
                                "Cancel"
                            ):
                                if item["type_muni"].lower() == "regional":
                                    year = str(
                                        self.dockwidget.myComboBox11.currentText()
                                    )
                                    y = jpDataLNI.getUrlCodeZipByPrefName(
                                        item["code_map"], str(pref_name[x].text()), year
                                    )
                                    tempUrl = y["url"]
                                    tempZipFileName = y["zip"]
                                else:
                                    tempUrl = item["url"].replace(
                                        "code_pref", pref_code[x]
                                    )
                                    tempZipFileName = item["zip"].replace(
                                        "code_pref", pref_code[x]
                                    )
                                self.start_download(
                                    tempUrl, item["code_map"], tempZipFileName
                                )
                            else:
                                break
                        break
                    else:
                        # The single .shp file covers the whole nation
                        # So, download only once.
                        if self.dockwidget.myPushButton11.text() == self.tr("Cancel"):
                            tempUrl = item["url"]
                            tempZipFileName = item["zip"]
                            self.start_download(
                                tempUrl, item["code_map"], tempZipFileName
                            )
                        else:
                            break

    def tab1Web(self):
        items = self.dockwidget.myListWidget11.selectedItems()
        for i in range(len(items)):
            for item in self._LandNumInfo:
                if (
                    str(self.dockwidget.myListWidget11.selectedItems()[i].text())
                    == item["name_j"]
                ):
                    url = QUrl(item["source"])
                    QDesktopServices.openUrl(url)

    def tab1AddMap(self):
        items = self.dockwidget.myListWidget11.selectedItems()
        pref_name = self.dockwidget.myListWidget12.selectedItems()
        pref_code = []
        for i in range(len(pref_name)):
            pref_code.append(
                jpDataUtils.getPrefCodeByName(
                    str(self.dockwidget.myListWidget12.selectedItems()[i].text())
                )
            )

        for i in range(len(items)):
            for item in self._LandNumInfo:
                if (
                    str(self.dockwidget.myListWidget11.selectedItems()[i].text())
                    == item["name_j"]
                ):
                    if item["type_muni"] == "single":
                        seleted_prefs = [0]
                    else:
                        seleted_prefs = range(len(pref_code))

                    for x in seleted_prefs:
                        if item["type_muni"].lower() == "regional":
                            year = self.dockwidget.myComboBox11.currentText()
                            y = jpDataLNI.getUrlCodeZipByPrefName(
                                item["code_map"], str(pref_name[x].text()), year
                            )
                            tempShpFileName = jpDataUtils.unzipAndGetShp(
                                os.path.join(self._folderPath, item["code_map"]),
                                y["zip"],
                                y["shp"],
                                y["altdir"],
                                pref_code[x],
                                epsg=item["epsg"],
                            )
                        elif item["type_muni"].lower() == "single":
                            # The single .shp file covers the whole nation
                            tempShpFileName = jpDataUtils.unzipAndGetShp(
                                os.path.join(self._folderPath, item["code_map"]),
                                item["zip"],
                                item["shp"],
                                item["altdir"],
                                "",
                                epsg=item["epsg"],
                            )
                        else:
                            tempShpFileName = jpDataUtils.unzipAndGetShp(
                                os.path.join(self._folderPath, item["code_map"]),
                                item["zip"],
                                item["shp"],
                                item["altdir"],
                                pref_code[x],
                                epsg=item["epsg"],
                            )

                        if tempShpFileName is None:
                            if item["type_muni"] == "single":
                                self.dockwidget.myLabelStatus.setText(
                                    self.tr("Cannot find the .shp file: ") + item["shp"]
                                )
                                self.iface.messageBar().pushMessage(
                                    "Error",
                                    "Cannot find the .shp file: " + item["shp"],
                                    1,
                                    duration=10,
                                )
                                tempShpFileName, ok = QFileDialog.getOpenFileName(
                                    self.iface.mainWindow(),
                                    "Select a File",
                                    self._folderPath + "/" + item["code_map"],
                                    "ESRI Shapefile (*.shp)",
                                )
                            else:
                                self.dockwidget.myLabelStatus.setText(
                                    self.tr("Cannot find the .shp file: ")
                                    + item["shp"].replace("code_pref", pref_code[x])
                                )
                                self.iface.messageBar().pushMessage(
                                    "Error",
                                    "Cannot find the .shp file: "
                                    + item["shp"].replace("code_pref", pref_code[x]),
                                    1,
                                    duration=10,
                                )
                                tempShpFileName, ok = QFileDialog.getOpenFileName(
                                    self.iface.mainWindow(),
                                    "Select a File",
                                    self._folderPath + "/" + item["code_map"],
                                    "ESRI Shapefile (*.shp)",
                                )

                        if tempShpFileName != "":
                            if item["type_muni"] == "single":
                                tempLayer = QgsVectorLayer(
                                    tempShpFileName, item["name_j"], "ogr"
                                )
                            else:
                                tempLayer = QgsVectorLayer(
                                    tempShpFileName,
                                    item["name_j"]
                                    + " ("
                                    + str(pref_name[x].text())
                                    + ")",
                                    "ogr",
                                )

                            tempLayer.setProviderEncoding(item["encoding"])
                            if not os.path.exists(tempShpFileName[:-4] + ".qix"):
                                tempLayer.dataProvider().createSpatialIndex()

                            if os.path.isfile(
                                os.path.join(self.plugin_dir, "qml", item["qml"])
                            ):
                                # For the qml files that use SVG images in the plugin folder
                                with tempfile.TemporaryDirectory() as temp_dir:
                                    with open(
                                        os.path.join(
                                            self.plugin_dir, "qml", item["qml"]
                                        ),
                                        "r",
                                    ) as file:
                                        file_contents = file.read()
                                    new_contents = file_contents.replace(
                                        "PLUGIN_DIR", self.plugin_dir
                                    )
                                    with open(
                                        os.path.join(temp_dir, item["qml"]), "w"
                                    ) as file:
                                        file.write(new_contents)
                                    if tempLayer.loadNamedStyle(
                                        os.path.join(temp_dir, item["qml"])
                                    ):
                                        tempLayer.triggerRepaint()
                            QgsProject.instance().addMapLayer(tempLayer)
                    break

    def start_download(self, url, subFolder, zipFileName):
        if not os.path.exists(os.path.join(self._folderPath, subFolder)):
            os.mkdir(os.path.join(self._folderPath, subFolder))

        if not os.path.exists(os.path.join(self._folderPath, subFolder, zipFileName)):
            self.setProxyServer()
            self.dockwidget.myLabelStatus.setText(
                self.tr("Downloading: ") + zipFileName
            )
            self._downloader.setUrl(url)
            self._downloader.setFilePath(
                os.path.join(self._folderPath, subFolder, zipFileName)
            )
            self._downloader.start()
        else:
            self.dockwidget.myLabelStatus.setText(
                self.tr("The zip file exists: ") + zipFileName
            )
            self.dockwidget.myPushButton11.setText(self.tr("Download"))
            self.dockwidget.myPushButton31.setText(self.tr("Download"))
            self.dockwidget.myPushButton14.setEnabled(True)
            self.dockwidget.myPushButton32.setEnabled(True)

    def download_finished(self, success):
        current_text = self.dockwidget.myLabelStatus.text()
        self.dockwidget.myLabelStatus.setText(current_text + self.tr("...Done"))
        # self.dockwidget.myLabelStatus.setText(self._downloader.getStatus())
        self.dockwidget.myPushButton11.setText(self.tr("Download"))
        self.dockwidget.myPushButton31.setText(self.tr("Download"))
        self.dockwidget.progressBar.setValue(100)
        self.dockwidget.myPushButton14.setEnabled(True)
        self.dockwidget.myPushButton32.setEnabled(True)

    def cancel_download(self):
        if self._downloader is not None:
            current_text = self.dockwidget.myLabelStatus.text()
            self.dockwidget.myLabelStatus.setText(
                current_text + self.tr("...Cancelled")
            )
            self._downloader.stop()
        else:
            self._downloader = jpDataDownloader.DownloadThread()
        self.dockwidget.myPushButton14.setEnabled(True)
        self.dockwidget.myPushButton32.setEnabled(True)

    def tab3SelectPref(self):
        selectedItems = self.dockwidget.myListWidget31.selectedItems()
        for item in selectedItems:
            rows = jpDataMuni.getMuniFromPrefName(str(item.text()))
            self.dockwidget.myListWidget32.clear()
            for row in rows:
                self.dockwidget.myListWidget32.addItem(row["name_muni"])

    def tab3DownloadAll(self):
        self.dockwidget.progressBar.setValue(0)
        if self.dockwidget.myPushButton31.text() == self.tr("Cancel"):
            self.dockwidget.myPushButton31.setText(self.tr("Download"))
            self.cancel_download()
            return

        self.dockwidget.myPushButton31.setText(self.tr("Cancel"))
        self.dockwidget.myPushButton32.setEnabled(False)

        year = str(self.dockwidget.myComboBox31.currentText())
        pref_name = str(self.dockwidget.myListWidget31.selectedItems()[0].text())
        muni_names = self.dockwidget.myListWidget32.selectedItems()

        for muni_name in muni_names:
            row = jpDataMuni.getRowFromNames(pref_name, str(muni_name.text()))
            tempUrl = jpDataCensus.getUrl(year, row["code_pref"], row["code_muni"])
            tempZipFileName = jpDataCensus.getZipFileName(
                year, row["code_pref"], row["code_muni"]
            )
            if self.dockwidget.myPushButton31.text() == self.tr("Cancel"):
                self.start_download(tempUrl, "Census", tempZipFileName)
            else:
                break

    def tab3AddMap(self):
        year = str(self.dockwidget.myComboBox31.currentText())
        pref_name = str(self.dockwidget.myListWidget31.selectedItems()[0].text())
        muni_names = self.dockwidget.myListWidget32.selectedItems()

        for muni_name in muni_names:
            row = jpDataMuni.getRowFromNames(pref_name, str(muni_name.text()))
            tempZipFileName = jpDataCensus.getZipFileName(
                year, row["code_pref"], row["code_muni"]
            )
            tempShpFileName = jpDataCensus.getShpFileName(
                year, row["code_pref"], row["code_muni"]
            )
            tempShpFileName = jpDataUtils.unzipAndGetShp(
                os.path.join(self._folderPath, "Census"),
                tempZipFileName,
                tempShpFileName,
            )

            if tempShpFileName is None:
                tempShpFileName, ok = QFileDialog.getOpenFileName(
                    self.iface.mainWindow(),
                    self.tr("Select a shp file"),
                    os.path.join(self._folderPath, "Census"),
                    "ESRI Shapefile (*.shp)",
                )

            if tempShpFileName != "":
                tempLayer = QgsVectorLayer(
                    tempShpFileName, row["name_muni"] + " (" + year + ")", "ogr"
                )
                tempLayer.setProviderEncoding("CP932")
                if not os.path.exists(tempShpFileName[:-4] + ".qix"):
                    tempLayer.dataProvider().createSpatialIndex()

                if os.path.exists(os.path.join(self.plugin_dir, "qml", "Census.qml")):
                    if tempLayer.loadNamedStyle(
                        os.path.join(self.plugin_dir, "qml", "Census.qml")
                    ):
                        tempLayer.triggerRepaint()
                QgsProject.instance().addMapLayer(tempLayer)

    def chooseFolder(self):
        # Open a folder dialog to choose a folder
        self._folderPath = QFileDialog.getExistingDirectory(
            self.iface.mainWindow(), self.tr("Choose Folder")
        )
        if not os.access(self._folderPath, os.W_OK):
            self.dockwidget.myLabelStatus.setText(
                self.tr("The folder is not writable.")
            )

        if self._folderPath:
            self.dockwidget.myLabel1.setText(self._folderPath)
            s = QgsSettings()
            s.setValue("jpdata/FolderPath", self._folderPath)

    def setProxyServer(self):
        _proxyServer = self.dockwidget.myLineEditSetting1.text()
        if len(_proxyServer) > 10:
            self._proxyServer = _proxyServer
            QgsSettings().setValue("jpdata/ProxyServer", self._proxyServer)
            self._downloader.setProxyServer(self._proxyServer)
            self._downloader.setProxyUser(self.dockwidget.myLineEditSetting2.text())
            self._downloader.setProxyPassword(self.dockwidget.myLineEditSetting3.text())
        else:
            QgsSettings().setValue("jpdata/ProxyServer", "http://")

    def showMeshWindow(self):
        self.meshWindow.show()

    def meshPref(self):
        selectedItems = self.meshWindow.meshListWidget1.selectedItems()
        for item in selectedItems:
            rows = jpDataMuni.getMuniFromPrefName(str(item.text()))
            self.meshWindow.meshListWidget2.clear()
            for row in rows:
                self.meshWindow.meshListWidget2.addItem(row["name_muni"])

    def meshMuni(self):
        selectedItems = self.meshWindow.meshListWidget2.selectedItems()
        for item in selectedItems:
            rows = jpDataMuni.getMesh3FromPrefName(str(item.text()))
            self.meshWindow.meshListWidget3.clear()
            for row in rows:
                self.meshWindow.meshListWidget3.addItem(row["code_mesh3"])
