# Programming in Python
[![DOI](https://zenodo.org/badge/429098563.svg)](https://zenodo.org/doi/10.5281/zenodo.10604607)


The entry level course 'Programming in Python', by the [Utrecht Centre for Digital Humanities](https://cdh.uu.nl/) aims to teach the basics of the Python programming language. Special attention is given to best practices in coding, e.g.: writing clean code and documentation.

The course was first taught 15-16 November, 2021.

This repository contains all teaching materials, exercises, solutions and extra resources relevant to the course. All files are provided as IPython Notebooks.

## Running locally

It is also possible to run this course locally. This is possible by installing the following:

* [Python](https://www.python.org/downloads/)
* [Git](https://git-scm.com/downloads)
* [Visual Studio Code](https://code.visualstudio.com/Download)

Steps:

1. Install Python, Git and Visual Studio Code
2. Open Visual Studio Code
3. Choose "Source Control" on the left
4. Choose "Clone Git Repository..."
5. Use the URL of this repository (https://github.com/UUDigitalHumanitieslab/programming-in-python.git)
6. Decide on a convenient location for storing this repository e.g. create a folder "Sources" for storing this and all your future code!
7. The repository will now be opened, choose "Yes, I trust the authors"
8. Open the introduction lesson using the file explorer on the left
9. Try to run the first code using the 'play icon' next to it
10. It will recommend extensions: Python + Jupyter, let it install those
11. You will see "Python environments..." when running code, just pick the recommended
12. On Windows you might get a firewall notification, you can ignore/disallow it
13. Installation of ipykernel package will be asked, let it install this
14. It should just work now

Consult the [official documentation](https://docs.jupyter.org/en/latest/start/index.html#id4) if you want to deviate from this or need more information.
