library(jsonify)
library(Hmsc)

load("models/unfitted_models.RData")
nChains = 4
samples = 250
m = m.pa
transient = round(0.5*thin*samples)
for(thin in c(1,10)){
  importFromHPC = from_json(readRDS(file = paste0("models/post_file_pa_",as.character(thin),".rds"))[[1]])
  postList = importFromHPC[1:nChains]
  m = importPosteriorFromHPC(m, postList, samples, thin, transient)
  save(m,file=paste0("models/m.pa_thin_",as.character(thin),".Rdata"))
}

samples = 250
nChains = 4
for(thin in c(1,10)){
  load(paste0("models/m.pa_thin_",as.character(thin),".Rdata"))
  m.pa = m
  load(paste0("models/m.facets_thin_",as.character(thin),".RData"))
  models = list(m.pa,m.facets)
  names(models) = c("pa","facets")
  save(models,file = paste0("models/models_thin_", as.character(thin),
                            "_samples_", as.character(samples),
                            "_chains_",as.character(nChains),
                            ".Rdata",sep = ""))
}
