load("data_meta_otu.Rdata")

library(vegan)
library(dplyr)
library(ggplot2)

otu.table = otu.table.plausible
taxonomy = taxonomy.plausible
read.counts = read.counts.plausible

# Processing community and meta data ####
sel = read.counts$filt_nread>=10000  # selecting sampling units with read count >=10000
otu.table = otu.table[sel,]
meta = meta[sel,]

sel = rowSums(otu.table>0)>=5  # selecting sampling units with >= OTUs
otu.table = otu.table[sel,]
meta = meta[sel,]

inocs = c("Antrodia_piceata",  # removing OTUs assigned to inoculated target species
          "Antrodiella_citrinella",
          "Fomitopsis_rosea",
          "Perenniporia_subacida",
          "Physisporinus_crocatus",
          "Postia_guttulata",
          "Skeletocutis_odora",
          "Skeletocutis_stellae",
          "Steccherinum_collabens")
spp = c("Antrodia_piceata_813073",
        "Flaviporus_citrinellus_106139",
        "Rhodofomes_roseus_127496",
        "Perenniporia_subacida_335816",
        "Rigidoporus_crocatus_107233",
        "Postia_guttulata_110917",
        "Skeletocutis_odora_106476",
        "Skeletocutis_stellae_323595",
        "Junghuhnia_collabens_315979")
ni = length(inocs)
inoc.indices = rep(NA,ni)
for(i in 1:ni) inoc.indices[i] = which(taxonomy$species==spp[i])
otu.table = otu.table[,-inoc.indices]

sel = colSums(otu.table)!=0  # removing OTUs with 0 occurrences
otu.table = otu.table[,sel]

com.hel = decostand(otu.table, method = "hellinger") # Hellinger transformation of the community data

meta$LogType = recode(meta$LogType,  # Renaming log type in the meta data
                       B = "broken",
                       U = "uprooted",
                       R = "felled")
meta$LogTypeMain = recode(meta$LogType,  # Grouping broken and uprooted mortality factors under natural log type
                           broken = "natural",
                           uprooted = "natural",
                           felled = "felled")
                       
# NMDS ####
set.seed(1)
nmds = metaMDS(com.hel, k = 4, distance = "euclidean",
               trymax = 100000,
               maxit = 999)

scores = as.data.frame(scores(nmds, display = "sites"))
scores$SampleID = rownames(scores)
scores = left_join(scores, meta, by = "SampleID")

scores %>% 
  ggplot(aes(x = NMDS1, y = NMDS2)) +
  geom_point(aes(color = LogTypeMain), size = 0.75, alpha = 0.4) +
  scale_color_manual(values = c("natural" = "#74ADD1",
                                "felled" = "#F46D43")) +
  stat_ellipse(aes(color = LogTypeMain),
               level = 0.95, show.legend = FALSE, alpha = 0.8) +
  facet_wrap(~SamplingYear) +
  xlim(-0.7,0.7) +
  ylim(-0.7,0.7) +
  theme_light() +
  theme(strip.text = element_text(face = "bold", color = "black"),
        strip.background = element_blank(),
        aspect.ratio = 1,
        legend.margin = margin(0,0,0,0),
        legend.position = "bottom") +
  guides(color = guide_legend(override.aes = list(size = 2, alpha = 0.9))) +
  labs(color = "Log Type")