###### Reading and plotting results

# Plot root traits mycorrhiza experiment
library(ggplot2)
library(data.table)
library(ggpubr)
library(Rmisc)
library(cowplot)
library(plyr)
library(gtools)

root_dir <- "File location"

field_dir = root_dir
field_dir_ntd = root_dir

#Reading field data
field_data = read.table(paste(field_dir, "Field_Ref_2101.csv", sep="") , sep="," , na.strings= c("?", " ", "!"), header=T, fill=TRUE, blank.lines.skip=TRUE, dec=".")
field_ci_data = read.table(paste(field_dir, "Field_Ref_ci.csv", sep="") , sep="," , na.strings= c("?", " ", "!"), header=T, fill=TRUE, blank.lines.skip=TRUE, dec=".")
field_data$Site = as.factor(c(1000,2000,3000))
field_ci_data$Site = as.factor(c(1000,2000,3000))
field_sd_data = read.table(paste(field_dir, "Field_Ref_sd.csv", sep="") , sep="," , na.strings= c("?", " ", "!"), header=T, fill=TRUE, blank.lines.skip=TRUE, dec=".")
field_inv = read.table(paste(field_dir, "field_inv.csv", sep="") , sep="," , na.strings= c("?", " ", "!"), header=T, fill=TRUE, blank.lines.skip=TRUE, dec=".")
field_inv_roots = read.table(paste(field_dir_ntd, "Root_traits.csv", sep="") , sep="," , na.strings= c("?", " ", "!"), header=T, fill=TRUE, blank.lines.skip=TRUE, dec=".")
field_inv$CtoN = field_inv$CN_ratio
field_inv$CtoP = field_inv$CP_ratio
field_inv$BA = field_inv$Tree_dbh * pi

violab = xlab("Elevation (meters a.s.l.)")
timelab = xlab("Year")
viotext = theme(axis.title.x = element_text(size=15), axis.text.x = element_text(size=15), axis.title.y = element_text(size=15), axis.text.y = element_text(size=15))
wsglab = ylab("WSG (g/cm³)")
slalab = ylab("SLA (cm²/g)")
wsgxlab = xlab("WSG (g/cm³)")
slaxlab = xlab("SLA (cm²/g)")
wsglab1 = xlab("WSG (g/cm³)")
slalab1 = xlab("SLA (cm²/g)")
cnlab = ylab("Leaf C:N ratio (-)")
cplab = ylab("Leaf C:P ratio (-)")
clab  = ylab("Above + Belowground MgC/ha")
lailab  = ylab("Leaf Area Index (m²/m²)")
npplab  = ylab("NPP (MgC/ha)")
hlab  = ylab("Average Tree Height (m)")
ltorlab  = ylab("Leaf:Fine Root biomass ratio (-)")
aetlab  = ylab("Average Annual Evapotranspiration (mm/y)")

amfon = "AMF-on"
amfoff = "AMF-off"

results_sum_inv_run = fread(paste(root_dir,"results_sum_inv_run_all.csv"))
results_sum_inv_run$Site = as.factor(results_sum_inv_run$Site)
results_sum_inv_run$model = as.factor(results_sum_inv_run$model)
levels(results_sum_inv_run$model)[levels(results_sum_inv_run$model)=="Myco"] <- amfon
levels(results_sum_inv_run$model)[levels(results_sum_inv_run$model)=="No_Myco"] <- amfoff

results_sim_general_run = fread(paste(root_dir,"results_sim_general_run_all.csv"))
results_sim_general_run$Site = as.factor(results_sim_general_run$Site)
results_sim_general_run$model = as.factor(results_sim_general_run$model)
levels(results_sim_general_run$model)[levels(results_sim_general_run$model)=="Myco"] <- amfon
levels(results_sim_general_run$model)[levels(results_sim_general_run$model)=="No_Myco"] <- amfoff

sim_inv_2100 = fread(paste(root_dir,"sim_inv_2100_all.csv"))
sim_inv_2100$Site = as.factor(sim_inv_2100$Site)
sim_inv_2100$model = as.factor(sim_inv_2100$model)
levels(sim_inv_2100$model)[levels(sim_inv_2100$model)=="Myco"] <- amfon
levels(sim_inv_2100$model)[levels(sim_inv_2100$model)=="No_Myco"] <- amfoff

results_sim_avg = fread(paste(root_dir,"results_sim_avg.csv"))
results_sim_avg$Site = as.factor(results_sim_avg$Site)

results_sum_inv_avg = fread(paste(root_dir,"results_sum_inv_avg.csv"))
results_sum_inv_avg$Site = as.factor(results_sum_inv_avg$Site)




# Figure 3

cbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = cmass*10))

cmassplot = cbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
  ) +
  geom_point(
    aes(color= Site, shape = Site),

  ) +
  geom_errorbar(
    aes(ymin=cmass*10-cmass_sd*10, ymax=cmass*10+cmass_sd*10, color = Site, linetype = Site)
  ) +

  ylab(expression("Biomass (Mg C ha"^-1*")")) +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

cmass = cmassplot
cmass

anppbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = anpp*10))

anppplot = anppbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
  ) +
  geom_point(
    aes(color= Site, shape = Site),
  ) +
  geom_errorbar(
    aes(ymin=anpp*10-anpp_sd*10, ymax=anpp*10+anpp_sd*10, color = Site, linetype = Site)
  ) +
  ylab(expression("NPP (Mg C ha"^-1*"y"^-1*")")) +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")


anpp = anppplot
anpp

mycolbaseplot = ggplot(results_sum_inv_avg, aes(x = Mycoac, y = mycol))

mycolplot = mycolbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_errorbar(
    aes(ymin=mycol-mycol_sd, ymax=mycol+mycol_sd, color = Site, linetype = Site)
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  #timelab +
  ylab("AMF colonization rate") +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

mycol = mycolplot
mycol


cfluxbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = cflux_myco_npp))

cfluxplot = cfluxbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_errorbar(
    aes(ymin=cflux_myco_npp-cflux_myco_npp_sd, ymax=cflux_myco_npp+cflux_myco_npp_sd, color = Site, linetype = Site)
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  #timelab +
  ylab("Rate of NPP transfered to AMF") +
  viotext +
  #theme(legend.position = "none")+
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")"))


cflux = cfluxplot
cflux



graphics.off()
png( file=paste(root_dir, "Figure_3.png", sep=""), width=1200, height=600)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(cmass, anpp, mycol, cflux, nrow = 2, labels = c('a', 'b', 'c', 'd'), label_size = 20)
graphics.off()


graphics.off()
pdf( file=paste(root_dir, "Figure_3.pdf", sep=""), width=15, height=10)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(cmass, anpp, mycol, cflux, nrow = 2, labels = c('a', 'b', 'c', 'd'), label_size = 20)
graphics.off()


# Figure 4

# Cmass
cbaseplot = ggplot(results_sim_general_run, aes(x = Site, y = cmass*10))

fieldc = field_data$Ag_C_matrix
fieldc_ci = field_ci_data$Ag_C_matrix

cmassplot = cbaseplot + 
  geom_boxplot(
    aes(fill= model),
    position = position_dodge(0.9),
  ) +
  scale_fill_manual(values = c("#027FBF", "#FF7F00")) +
  violab +
  ylab(expression("Biomass (Mg C ha"^-1*")")) +
  viotext +
  theme(legend.position = "none") +
  geom_errorbar(aes(x=1.0, ymin=fieldc[1]+fieldc_ci[1]+crtfield[1], ymax=fieldc[1]-fieldc_ci[1]+crtfield[1]), color = "grey") +
  geom_point(aes(x=1.0, y=fieldc[1]+crtfield[1]), color = "grey") +
  geom_errorbar(aes(x=2.0, ymin=fieldc[2]+fieldc_ci[2]+crtfield[2], ymax=fieldc[2]-fieldc_ci[2]+crtfield[2]), color = "grey") +
  geom_point(aes(x=2.0, y=fieldc[2]+crtfield[2]), color = "grey") +
  geom_errorbar(aes(x=3.0, ymin=fieldc[3]+fieldc_ci[3]+crtfield[3], ymax=fieldc[3]-fieldc_ci[3]+crtfield[3]), color = "grey") +
  geom_point(aes(x=3.0, y=fieldc[3]+crtfield[3]), color = "grey")

cmass = cmassplot


#ANPP
cbaseplot = ggplot(results_sim_general_run, aes(x = Site, y = anpp*10))

fieldnpp = field_data$Wallis_NPP
fieldnpp_ci = field_ci_data$Wallis_NPP

cmassplot = cbaseplot + 
  geom_boxplot(
    aes(fill= model),
    position = position_dodge(0.9),
  ) +
  scale_fill_manual(values = c("#027FBF", "#FF7F00")) +
  violab +
  ylab(expression("NPP (Mg C ha"^-1*"y"^-1*")")) +
  viotext +
  theme(legend.position = "none") +
  geom_errorbar(aes(x=1.0, ymin=fieldnpp[1]+fieldnpp_ci[1], ymax=fieldnpp[1]-fieldnpp_ci[1]), color = "grey") +
  geom_point(aes(x=1.0, y=fieldnpp[1]), color = "grey") +
  geom_errorbar(aes(x=2.0, ymin=fieldnpp[2]+fieldnpp_ci[2], ymax=fieldnpp[2]-fieldnpp_ci[2]), color = "grey") +
  geom_point(aes(x=2.0, y=fieldnpp[2]), color = "grey") +
  geom_errorbar(aes(x=3.0, ymin=fieldnpp[3]+fieldnpp_ci[3], ymax=fieldnpp[3]-fieldnpp_ci[3]), color = "grey") +
  geom_point(aes(x=3.0, y=fieldnpp[3]), color = "grey")

anpp = cmassplot


# SRL
cbaseplot = ggplot(results_sum_inv_run, aes(x = Site, y = srl/20))

field_dt = data.table(field_inv_roots)
field_srl = field_dt[, .(srl = mean(SRL/20), srl_sd = sd(SRL/20)), by = "Site"]
field_srl$Site = as.factor(field_srl$Site)

cmassplot = cbaseplot + 
  geom_boxplot(
    aes(fill= model),
    position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  scale_fill_manual(values = c("#027FBF", "#FF7F00")) +
  violab +
  ylab(expression("SRL (cm g"^-1*")")) +
  viotext +
  theme(legend.position = "none") +
  geom_errorbar(data = field_srl, aes(x=Site, ymin=srl+srl_sd, ymax=srl-srl_sd), color = "grey") +
  geom_point(data = field_srl, aes(x=Site, y=srl), color = "grey")
#ylim(0, 100)

#srlplot = cmassplot + facet_wrap(~model)  + stat_compare_means(label = "p.signif", method = "t.test", ref.group = "1000")
srlplot = cmassplot


# Mycorrhiza Colonization
cbaseplot = ggplot(results_sum_inv_run, aes(x = Site, y = mycol))

field = c(0.216009052,	0.471781173,	0.493119281)
field_ci = c(0.055337544,	0.074245899,	0.034216584)

cmassplot = cbaseplot + 
  geom_boxplot(
    aes(fill= model),
    position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  scale_fill_manual(values = c("#027FBF", "#FF7F00")) +
  violab +
  ylab("AMF Colonization rate") +
  viotext +
  labs(fill=NULL) +
  geom_errorbar(aes(x=1.0, ymin=field[1]+field_ci[1], ymax=field[1]-field_ci[1]), color = "grey") +
  geom_point(aes(x=1.0, y=field[1]), color = "grey") +
  geom_errorbar(aes(x=2.0, ymin=field[2]+field_ci[2], ymax=field[2]-field_ci[2]), color = "grey") +
  geom_point(aes(x=2.0, y=field[2]), color = "grey") +
  geom_errorbar(aes(x=3.0, ymin=field[3]+field_ci[3], ymax=field[3]-field_ci[3]), color = "grey") +
  geom_point(aes(x=3.0, y=field[3]), color = "grey")
#ylim(0, 100)

#cmassplot + facet_wrap(~model)  + stat_compare_means(label = "p.signif", method = "t.test", ref.group = "1000")
mycocolplot = cmassplot



graphics.off()
png( file=paste(root_dir, "Figure_4.png", sep=""), width=1200, height=800)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(srlplot, mycocolplot, cmass, anpp,  nrow = 2, labels = c('a', 'b','c', 'd'), label_size = 20)
graphics.off()

graphics.off()
pdf( file=paste(root_dir, "Figure_4.pdf", sep=""), width=15, height=12)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(srlplot, mycocolplot, cmass, anpp,  nrow = 2, labels = c('a', 'b','c', 'd'), label_size = 20)
graphics.off()



#################### TRAIT DISTRIBUTION PLOTS


sim_inv_2100$WSG <- sim_inv_2100$WSG /500

sim_inv_obs_2100 = data.table(smartbind(sim_inv_2100, field_inv, field_inv_roots))

mua <- ddply(sim_inv_obs_2100, c("Site","model"), summarise, grp.mean=mean(SLA, na.rm = T))
mub <- ddply(sim_inv_obs_2100, c("Site","model"), summarise, grp.mean=mean(WSG, na.rm = T))
muc <- ddply(sim_inv_obs_2100, c("Site","model"), summarise, grp.mean=mean(SRL/20, na.rm = T))


a = ggplot(data = sim_inv_obs_2100, aes(x = SLA))
#b = ggplot(data = results_sim_inv_2015, aes(x = WSG/500))

sla_dens = a + geom_density(aes(fill = model), alpha=0.4) +
  geom_vline(data=mua, aes(xintercept=grp.mean, color=model),
             linetype="dashed") +
  viotext +
  theme_light(base_size = 20, base_family = "Times") +
  xlab(expression("SLA (cm² g"^-1*")")) +
  labs(fill = "Scenario", color = "Mean") +
  theme(panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  scale_fill_manual(values = c("#FF7F00", "#027FBF", "darkgray")) +
  scale_color_manual(values = c("#FF7F00", "#027FBF", "darkgray")) +
  theme(legend.position = "none") +
  # scale_color_manual(values=c("blue", "red", "darkgreen")) + 
  # scale_fill_manual(values=c("blue", "red", "darkgreen")) + 
  facet_wrap(~Site)
#sla_dens


b = ggplot(data = sim_inv_obs_2100, aes(x = SRL/20))

srl_dens = b + geom_density(aes(fill = model), alpha=0.4) +
  geom_vline(data=muc, aes(xintercept=grp.mean, color=model),
             linetype="dashed") +
  viotext +
  theme_light(base_size = 20, base_family = "Times") +
  xlab(expression("SRL (cm g"^-1*")")) +
  labs(fill = "Scenario", color = "Mean") +
  theme(panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  scale_fill_manual(values = c("#FF7F00", "#027FBF", "darkgray")) +
  scale_color_manual(values = c("#FF7F00", "#027FBF", "darkgray")) +
  #theme(legend.position = "none") +
  # scale_color_manual(values=c("blue", "red", "darkgreen")) + 
  # scale_fill_manual(values=c("blue", "red", "darkgreen")) + 
  facet_wrap(~Site)
#srl_dens



graphics.off()
png( file=paste(root_dir, "Figure_5.png", sep=""), width=1200, height=600)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(srl_dens, sla_dens, nrow = 2, labels = c('a', 'b'), label_size = 20)
graphics.off()

graphics.off()
pdf( file=paste(root_dir, "Figure_5.pdf", sep=""), width=15, height=10)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(srl_dens, sla_dens, nrow = 2, labels = c('a', 'b'), label_size = 20)
graphics.off()



# Figure A1

rmax = c(0, 0.2, 0.5, 1)
AMF_col = seq(0,1,0.05)
field_col = c(0.216009052,	0.471781173,	0.493119281)

graphics.off()
pdf( file=paste(root_dir, "Figure_A1.pdf", sep=""), width=10, height=8)
plot(AMF_col, AMF_col * rmax[1], type = "l", ylim = c(0,1), 
     ylab = "NPP transfer to AMF", 
     xlab = "AMF colonization rate")

lines(AMF_col, AMF_col * rmax[2], type = "l")
lines(AMF_col, AMF_col * rmax[3], type = "l")
lines(AMF_col, AMF_col * rmax[4], type = "l")
text(0.9, 0.05, "rmax = 0")
text(0.9, 0.25, "rmax = 0.2")
text(0.9, 0.51, "rmax = 0.5")
text(0.9, 1, "rmax = 1")
abline(v = field_col[1],lty = 2, col = "red")
abline(v = field_col[2],lty = 3, col = "darkgreen")
abline(v = field_col[3],lty = 4, col = "blue")
legend(-0.02, 0.9, legend=c("1000 m", "2000 m", "3000 m"),
       col=c("red", "darkgreen", "blue"), lty=c(2, 3, 4), cex=0.8, box.lty=0, title = "Field obs.")
graphics.off()



#Figure A3


cbaseplot = ggplot(results_sum_inv_avg, aes(x = Mycoac, y = srl/20))

cmassplot = cbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    
  ) +
  geom_errorbar(
    aes(ymin=srl/20-srl_sd/20, ymax=srl/20+srl_sd/20, color = Site, linetype = Site)
  ) +
  
  ylab(expression("SRL (cm g"^-1*")")) +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

srlsens = cmassplot
srlsens

amfmassbaseplot = ggplot(results_sum_inv_avg, aes(x = Mycoac, y = cmyco/1000))

amfmassplot = amfmassbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
  ) +
  geom_point(
    aes(color= Site, shape = Site),
  ) +
  geom_errorbar(
    aes(ymin=cmyco/1000-cmyco_sd/1000, ymax=cmyco/1000+cmyco_sd/1000, color = Site, linetype = Site)
  ) +
  ylab(expression("AMF biomass (Mg C ha"^-1*")")) +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

amfmass = amfmassplot
amfmass


myconcostbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = myconcost))

myconcostplot = myconcostbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_errorbar(
    aes(ymin=myconcost-myconcost_sd, ymax=myconcost+myconcost_sd, color = Site, linetype = Site)
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  #timelab +
  ylab("C cost per myco N uptake") +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

myconcost = myconcostplot
myconcost


mycopcostbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = mycopcost))

mycopcostplot = mycopcostbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_errorbar(
    aes(ymin=mycopcost-mycopcost_sd, ymax=mycopcost+mycopcost_sd, color = Site, linetype = Site)
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  #timelab +
  ylab("C cost per myco P uptake") +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

mycopcost = mycopcostplot
mycopcost


vmaxnlimbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = vmaxnlim))

vmaxnlimplot = vmaxnlimbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_errorbar(
    aes(ymin=vmaxnlim-vmaxnlim_sd, ymax=vmaxnlim+vmaxnlim_sd, color = Site, linetype = Site)
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  #timelab +
  ylab(expression("Vc"["max"]*" N limitation")) +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

vmaxnlim = vmaxnlimplot
vmaxnlim

vmaxplimbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = vmaxplim))

vmaxplimplot = vmaxplimbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_errorbar(
    aes(ymin=vmaxplim-vmaxplim_sd, ymax=vmaxplim+vmaxplim_sd, color = Site, linetype = Site)
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  #timelab +
  ylab(expression("Vc"["max"]*" P limitation")) +
  viotext +
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")")) +
  theme(legend.position = "none")

vmaxplim = vmaxplimplot
vmaxplim


cfluxgppbaseplot = ggplot(results_sim_avg, aes(x = Mycoac, y = cflux_myco))

cfluxgppplot = cfluxgppbaseplot + 
  geom_line(
    aes(color= Site, linetype = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_point(
    aes(color= Site, shape = Site),
    #position = position_dodge(0.9),
    #fill = c("#00AFBB", "#E7B800", "#FC4E07")
  ) +
  geom_errorbar(
    aes(ymin=cflux_myco-cflux_myco_sd, ymax=cflux_myco+cflux_myco_sd, color = Site, linetype = Site)
  ) +
  #scale_fill_manual(values = c("#00AFBB", "#E7B800", "#FC4E07")) +
  #timelab +
  ylab("Rate of GPP transfered to AMF") +
  viotext +
  #theme(legend.position = "none")+
  xlab(expression("Max. rate of C transfer to AMF (r"["max"]*")"))


cfluxgpp = cfluxgppplot
cfluxgpp



graphics.off()
png( file=paste(root_dir, "Figure_A3.png", sep=""), width=1200, height=1600)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(srlsens, amfmass, myconcost, mycopcost, vmaxnlim, vmaxplim, cfluxgpp, nrow = 4, labels = "auto", label_size = 20)
graphics.off()


graphics.off()
pdf( file=paste(root_dir, "Figure_A3.pdf", sep=""), width=15, height=18)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(srlsens, amfmass, myconcost, mycopcost, vmaxnlim, vmaxplim, cfluxgpp, nrow = 4, labels = "auto", label_size = 20)
graphics.off()


# Figure A4


amfcmassbaseplot = ggplot(results_sum_inv_run[model == "AMF-on",], aes(x = Site, y = (cmyco/1000)/cmass))

amfcmassplot = amfcmassbaseplot + 
  geom_boxplot(fill = "lightgray") +
  violab +
  ylab("AMF biomass / Total biomass") +
  theme_pubr() +
  viotext +
  theme(legend.position = "none")


amfcmassplot


graphics.off()
png( file=paste(root_dir, "Figure_A4.png", sep=""), width=800, height=600)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(amfcmassplot, nrow = 1)
graphics.off()


graphics.off()
pdf( file=paste(root_dir, "Figure_A4.pdf", sep=""), width=10, height=8)
theme_set(theme_cowplot(font_family = "Times"))
plot_grid(amfcmassplot, nrow = 1)
graphics.off()
