(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1751195,      32457]
NotebookOptionsPosition[   1737022,      32232]
NotebookOutlinePosition[   1737417,      32248]
CellTagsIndexPosition[   1737374,      32245]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Coral halo geometric and consumer-resource models", "Title",
 CellChangeTimes->{{3.903168690693034*^9, 3.9031687157018003`*^9}, {
  3.903398331488291*^9, 
  3.903398338120206*^9}},ExpressionUUID->"92b4f769-0c1c-43ae-ba7f-\
3b87d631d1b7"],

Cell[TextData[StyleBox["The following document lists code for panels in \
Figures in the paper \[OpenCurlyDoubleQuote]Seeing halos: Spatial and \
consumer-resource constraints to landscape of fear patterns\
\[CloseCurlyDoubleQuote]", "Subtitle"]], "Text",
 CellChangeTimes->{{3.903168604936709*^9, 3.903168677584402*^9}, {
   3.903168737275311*^9, 3.903168749053843*^9}, {3.903168780685112*^9, 
   3.903168786815713*^9}, {3.903168824842626*^9, 3.903168855137381*^9}, {
   3.922527832171254*^9, 3.922527846540674*^9}, 
   3.922527905721143*^9},ExpressionUUID->"a7d3feaf-c2db-4008-bdf1-\
4ece4d30d786"],

Cell["Figure 2c", "Text",
 CellChangeTimes->{{3.903129521014813*^9, 
  3.903129523086384*^9}},ExpressionUUID->"d6b3f14e-ebb8-44b0-843e-\
5d82ece179c7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FracionalAreaOfNonCircles", "[", 
    RowBox[{"f_", ",", "\[CapitalDelta]_", ",", "\[Alpha]_"}], "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          FractionBox["\[CapitalDelta]", "\[Alpha]"], "\[LessEqual]", 
          FractionBox[
           SqrtBox["3"], "2"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{
           SuperscriptBox["\[Alpha]", "2"], "f"}]}], " ", ",", 
         RowBox[{
          FractionBox["\[CapitalDelta]", "\[Alpha]"], "\[GreaterEqual]", 
          "1"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["\[Alpha]", "2"], "f"}], " ", "+", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[Alpha]", "2"], "f"}], "\[Pi]"], " ", "6", 
       RowBox[{"(", " ", 
        RowBox[{
         RowBox[{"ArcCos", "[", 
          FractionBox["\[CapitalDelta]", "\[Alpha]"], "]"}], "-", 
         RowBox[{
          FractionBox["\[CapitalDelta]", "\[Alpha]"], 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox[
             RowBox[{"(", 
              FractionBox["\[CapitalDelta]", "\[Alpha]"], ")"}], "2"]}]]}]}], 
        ")"}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AreaOfAlgeaLeastPacking", "[", 
    RowBox[{"n_", ",", "P_", ",", " ", "\[Alpha]_"}], "]"}], ":=", 
   RowBox[{"FracionalAreaOfNonCircles", "[", 
    RowBox[{
     RowBox[{"n", " ", "P"}], ",", 
     RowBox[{
      FractionBox["1", 
       SqrtBox[
        RowBox[{"n", " ", "P", " "}]]], 
      SqrtBox[
       FractionBox[
        RowBox[{"\[Pi]", 
         SqrtBox["3"]}], "6"]]}], ",", "\[Alpha]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AreaOfAlgeaMostPacking", "[", 
    RowBox[{"n_", ",", "P_", ",", "\[Alpha]_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    FractionBox[
     RowBox[{"2", 
      SqrtBox["3"], "n", " ", "P", " "}], "\[Pi]"], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"2", 
       SqrtBox["3"], "n", " ", "P", " "}], "\[Pi]"], 
     RowBox[{"FracionalAreaOfNonCircles", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"\[Pi]", 
         SqrtBox["3"]}], "6"], ",", " ", "1", ",", " ", "\[Alpha]"}], "]"}]}],
     "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", 
        SqrtBox[
         FractionBox[
          RowBox[{"2", 
           SqrtBox["3"], "n"}], "\[Pi]"]]}], "+", "\[Alpha]", "-", "1"}], 
      ")"}], 
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "-", "1"}], ")"}], " ", "P"}]}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.903129641607223*^9, 3.9031296648836193`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"aff0f5d2-2dfa-422b-a543-4153d2570f5a"],

Cell["\<\
(rc + h)/rc = \[Alpha]
h = rc(\[Alpha]-1)\
\>", "Text",
 CellChangeTimes->{{3.903131650457198*^9, 3.9031316711434107`*^9}, 
   3.903131864099657*^9, {3.90313212486353*^9, 
   3.903132195206662*^9}},ExpressionUUID->"2d1c87fa-6651-406a-bb8f-\
1705ceeee88a"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "500"}], ",", 
     RowBox[{"L", "=", "1000"}], ",", " ", 
     RowBox[{"P", "=", "0.0002"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rc", "=", 
       SqrtBox[
        FractionBox[
         RowBox[{"P", " ", 
          SuperscriptBox["L", "2"]}], "\[Pi]"]]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"count", "=", "0"}], "}"}], ",", 
       RowBox[{
        RowBox[{"SetSharedVariable", "[", "count", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "=", 
            RowBox[{"ParallelTable", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"count", "++"}], ";", "\[IndentingNewLine]", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"conditionList", ",", "myregion", ",", "areas"}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"areas", "=", 
                   RowBox[{"Table", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"conditionList", "=", "\[IndentingNewLine]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x0", "=", 
                    RowBox[{"vals", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"y0", "=", 
                    RowBox[{"vals", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"x", "-", "x0"}], ")"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"y", "-", "y0"}], ")"}], "^", "2"}]}], "<", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"rc", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "h"}], ")"}]}], ")"}], "2"]}]}], "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"vals", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "L"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"n", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], 
                    "]"}]}], ";", "\[IndentingNewLine]", 
                    RowBox[{"myregion", "=", 
                    RowBox[{"Or", "@@", "conditionList"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"1", "-", 
                    FractionBox[
                    RowBox[{"Area", "[", 
                    RowBox[{"ImplicitRegion", "[", 
                    RowBox[{"myregion", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "0", ",", "L"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "0", ",", "L"}], "}"}]}], "}"}]}], 
                    "]"}], "]"}], 
                    SuperscriptBox["L", "2"]]}]}], ",", 
                    RowBox[{"{", "10", "}"}]}], "]"}]}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"h", " ", ",", 
                    RowBox[{"Mean", "@", "areas"}], ",", 
                    RowBox[{"2", 
                    RowBox[{"StandardDeviation", "@", "areas"}]}]}], 
                   "}"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"h", ",", "0.", ",", "3.", ",", 
                RowBox[{"3", "/", "7"}]}], "}"}]}], "]"}]}], ";"}], 
          "\[IndentingNewLine]", ",", "count"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.7599328114709015`*^9, 3.75993292991162*^9}, {
   3.7599329696813807`*^9, 3.7599329915539165`*^9}, {3.759933141750102*^9, 
   3.7599332096489887`*^9}, {3.75993332452325*^9, 3.759933374421837*^9}, {
   3.7985550903751383`*^9, 3.798555121645775*^9}, {3.798555156354596*^9, 
   3.7985553094784813`*^9}, {3.798555385717477*^9, 3.798555526639209*^9}, {
   3.79855567023029*^9, 3.798555680196661*^9}, 3.798555795135437*^9, 
   3.7985558539332047`*^9, {3.798555890057579*^9, 3.79855589448657*^9}, 
   3.798556783847658*^9, {3.798556992738634*^9, 3.798557014991941*^9}, {
   3.798557045100697*^9, 3.798557073772705*^9}, {3.798557494472698*^9, 
   3.798557666338517*^9}, 3.827584014529056*^9, {3.827586742803679*^9, 
   3.8275867429873323`*^9}},
 CellLabel->
  "In[205]:=",ExpressionUUID->"ecf81f63-1b4b-4722-a433-6da3cd71b408"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "-", 
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], "&"}], "/@", "data"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "+", 
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], "&"}], "/@", "data"}]}],
     "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".1"}], ",", "1"}], "}"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", "Gray", ",", 
      RowBox[{"Thickness", "[", "0.5", "]"}]}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{
     StyleBox["{",
      FontSlant->"Italic"], 
     RowBox[{
      StyleBox["\"\<h\>\"",
       FontSlant->"Italic"], ",", "\"\<Fraction algae\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.903133030986739*^9, 3.903133079536509*^9}},
 CellLabel->
  "In[206]:=",ExpressionUUID->"41eafb7c-57a4-4df7-8d2e-d3ef3d688d4d"],

Cell[BoxData[
 GraphicsBox[{{}, GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQDQO/XZ1ENd+8sb+9LReE7B//evUui/EVlP/aXkBh
Y+6h7mf2Kp6TgOiLvfgRJu7VRx9B5X/bZzTuVElvumcPllZhdJiek5j5Kuy6
vSpYgMXBduGCiay8F+0htnE41L43D7q15pg9zP5Wg5tLmRnfwu3ndd/mFuKL
sH/X3GAbkYcI+1NNPosXNT2G29+iwsAXvvU+3P5Y/jU//M7ehNvvfGd/8qYp
l+H2Zz45aP5K75z9SPc/AJ7a3Cw=
    "], {{{}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.5], Opacity[0.2], EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{1, 2, 3, 4, 5, 6, 7, 8, 16, 15, 14, 13, 12, 11, 10, 
         9}}]]}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, 
      {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6], LineBox[{9, 10, 11, 12, 13, 14, 15, 16}]}}}], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Fraction algae\"", TraditionalForm], None}, {
     FormBox["\"h\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Large,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 3.}, {-0.1, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.903136789694717*^9},
 CellLabel->"Out[206]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>", "ImageResolution" -> \
144.],ExpressionUUID->"0944365c-241d-4b8b-917d-5f5045b104b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rc", "=", "1"}], ",", 
     RowBox[{"n", "=", "500"}], ",", 
     RowBox[{"P", "=", "0.0002"}]}], "}"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AreaOfAlgeaLeastPacking", "[", 
          RowBox[{"n", ",", "P", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"rc", "+", "h"}], ")"}], "/", "rc"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"AreaOfAlgeaMostPacking", "[", 
          RowBox[{"n", ",", "P", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"rc", "+", "h"}], ")"}], "/", "rc"}]}], "]"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "0", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Thick", ",", 
            RowBox[{"ColorData", "[", 
             RowBox[{"97", ",", "2"}], "]"}], ",", 
            RowBox[{"Dashing", "[", ".02", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", 
            RowBox[{"ColorData", "[", 
             RowBox[{"97", ",", "3"}], "]"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "->", "True"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".1"}], ",", "1"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<h\>\"", ",", "\"\<Fraction Algae\>\""}], "}"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     GraphicsBox[{{}, GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQDQO/XZ1ENd+8sb+9LReE7B//evUui/EVlP/aXkBh
Y+6h7mf2Kp6TgOiLvfgRJu7VRx9B5X/bZzTuVElvumcPllZhdJiek5j5Kuy6
vSpYgMXBduGCiay8F+0htnE41L43D7q15pg9zP5Wg5tLmRnfwu3ndd/mFuKL
sH/X3GAbkYcI+1NNPosXNT2G29+iwsAXvvU+3P5Y/jU//M7ehNvvfGd/8qYp
l+H2Zz45aP5K75z9SPc/AJ7a3Cw=
        "], {{{}, {}, {}, {}, {}, {}, 
          {GrayLevel[0.5], Opacity[0.2], EdgeForm[None], 
           GraphicsGroupBox[
            PolygonBox[{{1, 2, 3, 4, 5, 6, 7, 8, 16, 15, 14, 13, 12, 11, 10, 
             9}}]]}, {}, {}, {}}, {{}, {}, {}, 
          {GrayLevel[0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, 
          {GrayLevel[0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], 
           LineBox[{9, 10, 11, 12, 13, 14, 15, 16}]}}}], {{}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{
         FormBox["\"Fraction algae\"", TraditionalForm], None}, {
         FormBox["\"h\"", TraditionalForm], None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->Large,
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 3.}, {-0.1, 1.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.902002352950274*^9, 3.902002354734316*^9}, {
   3.9020024955271883`*^9, 3.902002534435807*^9}, {3.902002569323975*^9, 
   3.902002607235958*^9}, {3.90200333750952*^9, 3.902003338951982*^9}, {
   3.902003560811944*^9, 3.9020036069366493`*^9}, {3.902003667213232*^9, 
   3.9020036785017853`*^9}, {3.90200372732825*^9, 3.902003737001769*^9}, {
   3.9020037672969313`*^9, 3.9020037719506197`*^9}, {3.902003841287292*^9, 
   3.902003858667405*^9}, {3.9020043726757593`*^9, 3.9020043878550873`*^9}, 
   3.9031315878518133`*^9, {3.903131710556486*^9, 3.903131714392515*^9}, {
   3.903131746309079*^9, 3.903131747091378*^9}, {3.903131830911192*^9, 
   3.9031318312170973`*^9}, {3.903131936229455*^9, 3.9031320343337803`*^9}, {
   3.9031333089739933`*^9, 3.903133329138698*^9}, 3.9031367971084623`*^9, 
   3.9031707995246487`*^9, {3.903438604714423*^9, 3.9034386399625893`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"8e94be34-2ce9-49ac-b49c-425f810d8908"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
       Dashing[0.02], 
       LineBox[{{6.122448979591837*^-8, 0.8999999877551017}, {
        0.0009201537616788803, 0.8998158845793697}, {0.0018402462988679647`, 
        0.8996316120895823}, {0.0036804313732461333`, 0.8992625591678415}, {
        0.007360801522002471, 0.8985224215556948}, {0.014721541819515146`, 
        0.8970340192567425}, {0.029443022414540495`, 0.8940247063602016}, {
        0.05888598360459119, 0.8878760473725738}, {0.12272507125637595`, 
        0.8739488414372365}, {0.15374390572615498`, 0.8668874999999757}}], 
       LineBox[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAAclp8/ZLswz/WK3o67LnrP7d5Zd2l
0c4/8slSx9MS6z/ZWmsvcnfTP5qs+nGqjuo/EUeNZsFA1z90UQFvYg3qPxDU
ZbI3W9s/V7vn+s166T8jIGyphWLfP2Cmh5NY5Og/ON1ty0GS4T9B/5vNJVLo
P8H6gEzUm+M/FlRmpTut5z9ov8jIvoLlP15r1S5IDec/mWOnGhVg5z8GrV7l
22rmPy1Y4fb+Zek/rCFPQla05T/e80/OQEnrP/TcgFUfBOU/8t8ZMBZV7T88
Pt4drD7kP5CremdXV+8/jCgJ8lB24z8mDwhNeJvwP3jAs9KkteI/tnCAq46f
8T+YSDR3Ut7hP9QlkwdRkvI/BAHit2IP4T8kg9MoXZnzPwTit3qoKOA/OVDf
NJ+b9D9SaOeSHX/eP91whT6NjPU/XlZ6OnPA3D+yOVkNxZH2PzJb0cdcz9o/
FlbH2aiF9z+SgH0eOPPYPz/iAJHCdPg/yDVpCyYV1z+ZFmgNJnj5P6jHQrPi
AdU/gp5phzVq+j9QFEBhQgbTP53OmMaOcPs/yH+u5inT0D99bpPwHXL8PyyE
LbuKOs0/62EoGFli/T8QPmp1iwPJP4v96gTeZv4/AA7BoPFXxD+67EfvDlr/
PyDy2Cnix78/No6cishd/z/gUEXHmaS/P7Iv8SWCYf8/AIRAnk6Bvz+pcppc
9Wj/PzBn4/ivOr8/mPjsydt3/z9wIdtgUa2+P3YEkqSolf8/yGWS+w6SvT8z
HNxZQtH/P8gtIFx1Wbs/rr0w9fvU/z8gF2cr1DW7PypfhZC12P8/yNQ8NDAS
uz8ioi7HKOD/PwDNlPLfyro/EiiBNA/v/z9wsfYhHjy6P/gZkwduBgBAQEqC
SxUeuT9laOD4ixUAQIDCnzot+7c/Z3ZSqQ==
        "]], LineBox[CompressedData["
1:eJwV0Hk8VOsfB/BzDvXDvcJQKI21Qouicon5PmT7lSJLi2osSSUpWwvpIiSk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        "]], LineBox[CompressedData["
1:eJxFx2kogwEAxvGX4a1FbnIbIzlaVkQiIUlKhLma3NKQhJwhR2Q52r7ItQ9C
5oPR5Gwx8yakHGkhFnIVZjlaGkp7nvr39GPkVSQXGhIEwf7t7xstMm4Eh7RI
4n+yQOmE0QksZCYFWZ3CpfZPcjclHEHvSgk4g2+fV6viLuFlFYeWpoL7jtWD
+ddwyIqPpPkO7u4UvCy8wNw6VsuGGmbzdswPNLAyiWA9fsL+LrwyhoGR3vvz
0Q98S7gtfOFmwBoO3mZeCW3hUaXx6YgDXGZAbc0yYNPEBNFeIBz/kJJulgxv
uRcpegfh9sVU0RXdWO9sjzNuFh/WSllOfqSJ3o20+11hM2zHDM31Iki9a8vT
NPQ62Dm4gPJugGXflcNRTTCdz4+pb4VHZ+SC+25YcccOooZgm3zzmo5VeMnX
JV60DnPVvq5rMniqNVahkcNh4012BXtw3vmjNOoCJie+eriXsJhH5tSr4Het
Bym5hXscMzmMZ5ilKvYLf4WPpqt16W+wa+jAZP8HvEmMNYi/4BJKnEhpYdP+
Zc/rb3iOQ33odPAPekGoqw==
        "]]},
      Annotation[#, "Charting`Private`Tag$18933#1"]& ], 
     TagBox[
      {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV0n0w1HkABvAdUS5JY7DXyxCmX2hOum6oLp47L2FL3NElHL0pGa+d12rp
BYm1FYeusORli8MaG7EbdreOzab31pXrZW1J921PxJmR3Pf+eOaZz3/PH4/1
3vgfI/VYLJYXzf89vTWuPCA+we1l6d+3VCqCnP2r7e4y22FfPK/Wr5/gjk4b
XcCEo3TMvfaFkmCs1YMXw8RhihshsOklOGkxsSKMycDO4WSPORlBfy/ndSDD
B8fbp7D+OkFTqmlAmP45lDa3bChsJ0jNz2zkT57DRn5qEreNwLB1V9SEuhDu
p8vdw8UEDnqLn0vLSrDpeq5ii4ggvjJF6c9UIEcSYVZzhWCDeJg5yRZgkZI1
KBESsPbbuYfoV2KQZ8Q8qSNQphYLeJOVmHB22WRaSxAiiA/5oL6M+cYfvIVV
BMd0tvc6y+owINRtdLtEsDvt6edAcyH4d3XKIxcJPPXOf/W+QAjX9t7Yjt8I
jC0+51llXsG/Q83PNl8gqHAd9MraU4/qhClFaDGBjMeT+DFNePVo95PJswRd
7/5UGV1tgmjZgMiDWuqz+rlyTTO2nzGpL+IThOrtYVV/KUJk8O8jGwsIdnTN
2FhZtqBUJF4uyCPgOK+LYtu3QlIzvUyZTeDzWp2QEt0Ko/oBYxdq718z0h83
tOLF0RFtXRbdO96fV+QoxiWryfW8UwRuTQcaTb65huTpOIPYEwTrmbLxBWiH
Rep+22wuwdeP3WcOHG+HVlNguoTaKWt03h+ydtit5kvLjhE4apzNszyvY8e9
oA2SowR2FfddWJwOZIy8LFp0hIDxS/suIr8Dh6rDLWvTCVZ9svTtUnXAycU+
ENQ2ITEhx/w70eJkIE5LI1hhsYA7HSSBNXet1VwKwbJbjdk7SySoPeTUV0O9
NCmI36aWQPGFvvE2aosHVYKkECkqfojdJ0gmWMLfLB+LuAGe2zXzXUkEi12H
b/tX3cC+2dx4I2pjcuZhk+YGKucig7t/IVjIUWtjIrswX7fl/hpqg/mHF4xG
d+NOtKUL+zDBW99MkwlhN7atnLV7mkhwu4DHntV2o2fpu5gK6t68h0W5a3uw
MLH0jQN1vqmuuuxqD/oty08FJtD/iD8Krft6wPtr3duV1HE/zTTUvelByQtu
yT/xBAEXDcUiWxkuOPqpzlGb2djevFkug6Fm9IQmju65ad/nK5VBLvVY2kk9
FemkGngqw858xXgh9eBV10eDbDlmzaqifKiVWz0Hf3aWIzH023mrqDvfc4Y0
QXK0FycN6VGXrwvWkvNyVDYHe8tjCfgPw98miuToMgxSV1MfT44kUwNyPFt/
9nIO9d6Owx9ZixSYfpw54k8dGJo+ne2ggPLghQhnas/ZzE8LfRXw0rWZWFIz
3xfom+coYMvRmn2IIWAPFxlerFHgecPBqCHqsAc5oa8aFXBfXhf2hPo/EwUu
LQ==
        "]], LineBox[CompressedData["
1:eJwBkQJu/SFib1JlAgAAACgAAAACAAAAbF98/ZLswz8i0gXLr2zsP69QwiQ9
esQ/UIH8EFps7D84YPdEZW7FP2bo7UfGa+w/SX9hhbVWxz8eOwySnmrsPzKP
wUahdMc/pbLwcYxq7D8cnyEIjZLHP81Tp1F6auw/8L7himTOxz8BE4sQVmrs
P5b+YZATRsg/9oQsjA1q7D/kfWKbcTXJPxk313p8aew/gHxjsS0Uyz881Ms1
WmjsP7d5Zd2l0c4//PExIhVm7D/ZWmsvcnfTP1juUQQmYew/EUeNZsFA1z/a
1UUniFzsPxDUZbI3W9s/PyjTBoRX7D8jIGyphWLfPzdW2vaTUuw/ON1ty0GS
4T+dV5rc9U3sP8H6gEzUm+M/xDkgxfBI7D9ov8jIvoLlPwEvkP89ROw/mWOn
GhVg5z8if9wCoD/sPy1Y4fb+Zek/ZqazU5o67D/e80/OQEnrP8gBmKbnNew/
8t8ZMBZV7T8v0BCyzDDsP5CremdXV+8/6O5/TcYr7D8mDwhNeJvwP/XBYZ8T
J+w/tnCAq46f8T/WeYfw9yHsP9QlkwdRkvI/gVkPVDAd7D8kg9MoXZnzPzN3
OCH/F+w/OVDfNJ+b9D+vRTvE4hLsP91whT6NjPU/E+LTLhsO7D+yOVkNxZH2
P3w+6UjpCOw/FlbH2aiF9z+/Uu6GDATsPz/iAJHCdPg/ruuAU0X/6z+ZFmgN
Jnj5PyNHBBoT+us/gp5phzVq+j9SOem0NvXrP53OmMaOcPs/tL2GtO7v6z99
bpPwHXL8P0masgm86us/62EoGFli/T+lS/Tn3+XrP4v96gTeZv4/Iw1NcZfg
6z+67EfvDlr/PyfB09+l2+s/ZWjg+IsVAEDYLrWwY9frPyL1RqI=
        "]], 
       LineBox[{{2.0124341472911973`, 0.8700231441247589}, {2.080847139562298,
         0.8693245917993165}, {2.1397733342408576`, 0.8687214066748866}, {
        2.2036526941911005`, 0.8680659506077036}, {2.263301545943639, 
        0.8674524294566768}, {2.321781113988269, 0.8668495534100149}, {
        2.3852138473045827`, 0.8661940676742569}, {2.444416072423192, 
        0.8655808460816392}, {2.4763980748166055`, 0.8652489905787295}}], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQXS0Q+XTKZWaHMM/0v1/Wv7Y/qpB2rGcSi0NTfeQ1
phWv7Vu2hy58yMXqUGF/POLvotf2MUp34qJ7WR3CPmibd8x9bf97m760Njub
Q/J/85M5M17b1zC/PDO1js2BPXCnbsbk1/ZiKpaJqgzsDkrzrlt87n1tX54X
9oWrkt1BqO7e8hsdr+1lzFJOqFWzO7xlVbt+EMg/8LdwjlMtu0OUqzHbaiCf
q7fXpaqR3eH1q3nJtUD+vNVHprzsZHd4fmGXtBKQf+yFkemJWewOrhysjdnt
r+1FkvnLWvewO8xVeSz/r/W1/U4tWa+F+9gd9s576P4cyI/7pCW39wC7Q/6F
pfkXgPwVjW7Hvhxhd+iMqt+3CMi3XlArlnKW3WE6Z3mkO5CfdPf1Nqd77A6S
lytaJrS8tmdf+rMr7gG7Q/SxSysqgfw1OezxVY/YHfQLP51JAvK//VZi3/SM
3aHvbZOIKZDfJRUVrvie3UG18cWCm82v7fUfpWvbfmR3+GFQcPgQkH9lZen/
iM/sDrEz9j5dDeTLWU5cPuE7u8O93pWadUD+YYb51Wt+sjv8kvbwTgfyM06s
8T/xm91heeKanAAgn2fCLuUnf4HhEXet1xLI3xh+4vv//+wOO4WPrVMC8gEQ
Z+ie
        "]]},
      Annotation[#, "Charting`Private`Tag$18933#2"]& ], {}}, {}}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQDQO/XZ1ENd+8sb+9LReE7B//evUui/EVlP/aXkBh
Y+6h7mf2Kp6TgOiLvfgRJu7VRx9B5X/bZzTuVElvumcPllZhdJiek5j5Kuy6
vSpYgMXBduGCiay8F+0htnE41L43D7q15pg9zP5Wg5tLmRnfwu3ndd/mFuKL
sH/X3GAbkYcI+1NNPosXNT2G29+iwsAXvvU+3P5Y/jU//M7ehNvvfGd/8qYp
l+H2Zz45aP5K75z9SPc/AJ7a3Cw=
     "], {{{}, {}, {}, {}, {}, {}, 
       {GrayLevel[0.5], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{1, 2, 3, 4, 5, 6, 7, 8, 16, 15, 14, 13, 12, 11, 10, 
          9}}]]}, {}, {}, {}}, {{}, {}, {}, 
       {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, 
       {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
        1.6], LineBox[{9, 10, 11, 12, 13, 14, 15, 16}]}}}], {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Fraction Algae\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"h\"", HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 2.99999993877551}, {-0.1, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.903131579212557*^9, 3.903131588521646*^9}, {
   3.9031317311211233`*^9, 3.9031317475132313`*^9}, 3.903131831659822*^9, {
   3.903132007007092*^9, 3.90313203475948*^9}, 3.90313679841852*^9, 
   3.9031708049473124`*^9, 3.903431271571653*^9, 3.903438640537521*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"8fb4ffd1-0616-4b68-a1b1-f1263d74f177"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rc", "=", "1"}], ",", 
     RowBox[{"n", "=", "500"}], ",", 
     RowBox[{"P", "=", "0.0002"}]}], "}"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AreaOfAlgeaLeastPacking", "[", 
          RowBox[{"n", ",", "P", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"rc", "+", "h"}], ")"}], "/", "rc"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"AreaOfAlgeaMostPacking", "[", 
          RowBox[{"n", ",", "P", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"rc", "+", "h"}], ")"}], "/", "rc"}]}], "]"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "0", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Thick", ",", 
            RowBox[{"ColorData", "[", 
             RowBox[{"97", ",", "2"}], "]"}], ",", 
            RowBox[{"Dashing", "[", ".02", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", 
            RowBox[{"ColorData", "[", 
             RowBox[{"97", ",", "3"}], "]"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "->", "True"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".1"}], ",", "1"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<h\>\"", ",", "\"\<Fraction Algae\>\""}], "}"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     GraphicsBox[{{}, GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQDQO/XZ1ENd+8sb+9LReE7B//evUui/EVlP/aXkBh
Y+6h7mf2Kp6TgOiLvfgRJu7VRx9B5X/bZzTuVElvumcPllZhdJiek5j5Kuy6
vSpYgMXBduGCiay8F+0htnE41L43D7q15pg9zP5Wg5tLmRnfwu3ndd/mFuKL
sH/X3GAbkYcI+1NNPosXNT2G29+iwsAXvvU+3P5Y/jU//M7ehNvvfGd/8qYp
l+H2Zz45aP5K75z9SPc/AJ7a3Cw=
        "], {{{}, {}, {}, {}, {}, {}, 
          {GrayLevel[0.5], Opacity[0.2], EdgeForm[None], 
           GraphicsGroupBox[
            PolygonBox[{{1, 2, 3, 4, 5, 6, 7, 8, 16, 15, 14, 13, 12, 11, 10, 
             9}}]]}, {}, {}, {}}, {{}, {}, {}, 
          {GrayLevel[0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, 
          {GrayLevel[0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], 
           LineBox[{9, 10, 11, 12, 13, 14, 15, 16}]}}}], {{}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{
         FormBox["\"Fraction algae\"", TraditionalForm], None}, {
         FormBox["\"h\"", TraditionalForm], None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->Large,
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 3.}, {-0.1, 1.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztXQm4XEWxHu7M3CU3ZAdMWHITlhAIBAgQAYELhD3sCSDvITchTEggEDDK
osCoEVQEQ0II4MOguJCwGlwAhZuHCKgR5CHIpgEkCiKLiAuy3NfVXX1Onz7V
3dUzE198znzfOcnt6em/qrq6urpPV53Dps079ZQ50+bNOnla14FnT5t76qyT
P9p1wJlni6LieoVCqVootLzWVSiJ//cVCqHb/ELh3/6rk+TfxZ9WKpU+cY2f
OXNmoajKRkyfPh3KVovL+MUmjiZ+hk3seOqpp+omNhb/h7Ln/02b2Amq19fE
PkYTm2FZZBOfMTp1L/F/KHuc1USHbuJdcZ0krpZqtTr0tNNOuwebuf2UU06J
aOZF/Pdv4nrPaHo/oDDYTLtu5oMzZsw4T/zk++L/j4jrRnHtcfLJJ6c/2JTT
t+m3o/9Pqp8hql4q2Bie7Ytc9XXEVDS/+hf/6hh5Lw4RI2VnoXabzp49uzCA
KLuaKFtflsHEWgArtKvQ8C3E98uIqsv4VW+kq16NxX19fV2iaHdhZDaYM2cO
RetAxdpR6iuo/aD46n0YUS190nQ+JO7bgpmCT4uqdygO1FehRon520X1Y/yn
+N0aUa/P+O1T4n4A/A8+S1S92VjnS8ZvM+0VmbRw2+PSd4Wqdzaaf1mjTd7L
22GdmmS7MLLdIpPeK1W9Y0UdPffoejAD7t0IveivVPBIee/YUFT/AzbzE/Gz
z4lq2rsCEuB7DTcZXYLXUpZ4v1/YGKyPGOK+TVyfEn/fi3+/I679YVpGFTod
yxdAWYlosyWCJm6bMXQq1SztjeoA11/E1fqK1KKxYCzEp06RRzXfEkG9Mi4d
U7EclO1mqCvg7kFIKDs0bbd27ckq7GVI3nfEVcZxA/9+D38GTWjIQT09PXuI
JnZNXWPe7xfWiaXKSsWpU6e+inXPFZcioXQJFv1KXCXhoV7lVi+iVR5VHpWt
g1JU2pVY/IC4+omrrU5xL/I1255pFnCiaIUlwMv41TxBjKrdPh+LXsbaUGgC
xZCfUdDiC/iTHeArNPw7ou7LtWk7s95CZj0lptJOSNKfYZgLEaFY2oQn8hJ+
BZ4JpWwdTCRKqTqi0FWnlDcRK6IXsPh+UQxrNBRjmIpFnjb61UBNaXvRkrZM
5VShQC1ew9oTZs2a1cakD9XhCNXKBtOmTYOv/iR+Bo4jNg7O4pvYOFi51qja
C6JqI+H9hdEfjjqsbcEPsNo06EpKNdqjkKgW+jHRlbqXwaH+NYr4aXHB37pb
mVQsCrYUpgY9R7Ae4LhL76msyn6F9Y6AenH91mmqRnEXnCl/CYRg449XjDV5
K7PeAmY9XJE8hGUnAlPuTg+3R/12MIGBHQIS+Al2CMz6E6HdDibWlZ42BhGY
uCiDTv8Hlo9LxlkYLttT+6KFeMCo/iBS0S2+0z0VrLeAWQ+H7MGCzFmiDNaQ
WqfGGRztKP7v6cAgjGe8cqCxT2Cu/jYWg7Z/qJLOckESFofb4JCimmkdKf47
TBRNEj/R47RX/L+NSQ3d7Q8Z1X+Mre6fjv5wvQXMeorMfs9h2WPiOkpQv7n4
d4r4/nksB3ccrAyj651Q7q5nw2PXgT/2TRxPMF+OMhSYSYavjUhyWvVaRV83
iAs8Oy5FWRWYiF89bFR/GMtgD1erQLDeAmY9JPN2Y+FWKMm7NFBSMAV/3wcx
PMOeiVsCP+m/sd6t4vdtTOgl3p8H0bGPYSMFdtHfwro3id+Bu8alItvHW6IF
eNmo/nusvhXMJa3MeguY9XBhU8Wyy8V1kbhuEdf14jpNXO1CY5HZu8Sfx4if
gTNhdlk7E22Rv5l+PGKuUR03HtFgMwEkzhXN1b6fc8HhmdRqrPqRVGuC4Jnu
livCP+FPNk6WeqWNhI69r0nr7u5ujaq9IKo2En4kErkMiLxWddPrWAaPrC7G
ltLe5gIs8jfWj8DHxR08RoUh9xtDmNqFHS1WQYU4uVwR1WqWItQZUICzRNlV
FfVAD9dcn8aqV1fSNTCTKNQHXLDfhg2dMzN97ngull1XSd2QYL2Fce114aLx
WShTvS83yeydX2me9aeNiXElsz2KFrTRMKfqzTlYLaMwt0Ub/feKWltzKVoY
1WorQZfxnOW32MKkpIXitdjvn4/psuzeItADz3nfFheYSFgwfKyinvm+L77b
KW2aV3dhRF1cCIH3835F79hdLnsMzGDSY7iYGijKlhpbtcZmDA9vsaedTiYt
yup1fB5/C70Czy62ECtmWB0/i+Vfi5Xbouh2w7QqS9RxISoatHmYqAve5FzE
B7omgKsRQyuqED7SO1MUv2sNOGjio5qUDma9RXHt9RKe049M9lV3F5dgPdPn
C2IsIX7bycRFnwjG9G1WPZiVBuq67XFyCbbXxqQPJyhYgCzX9YrqDuvLRIW4
/YbqcLS8l7cRJJ1fUXMXODmw1YhV6O+u8nyHIofjJCeIshMkS/Je3M+06djV
sNu5CEcO/pZu9xpn/TAW7trtKeqBkV0sfvsJUesgqOPjc4nnd/2Y2GgJ4cgR
OI2LxXfniHakP+HDVttg68oxh9q+OkgWyOkxe9utK/F7CgcqQfYIoYDbDFdh
6OpEw5OykURZF7NePb/9/1JvXaJlXao3JC3r1iv49QzVbIEhOUwpKVRKRvbI
5NtRrm8LRfBaevSpBizrwhWi/Ksrrh5MFQmZWA/+7tW/9dSD9pdq24T1oP0u
fGYZV8/Pufy2q35+qXpcfql6tfNL14vQiCHJt+p5dlO9fPWa6uXhvKlecWJs
qhddr6leTfVqCL90vbWsXkooSVkXURZZLyPQBrRHlVGCahgG1mvKqkZZRarh
MkIUywjSlzf4t/9vyEyaNJoFy5R0FJbB34kFW97g33rIpDY3JjarN6s3q/8L
Vy8UoSTZAWpRO0CJKSPakbft5DetUG+18XsweTQC1JTWSD0iJJocD7cSfLtu
S6xZvVm9WX2dr76NvFNRptmyfnHNbq2aqClKkxtV2RZH0hh5rz1aLyayrjbS
6ozL4v2+JtK40TrMenz4reSdG4dQjqqNZ3H0xC4nczlVU5SNlRon68jNkSrK
Vz/4UYSGD+CXmfUM4pKFVCvc3cTJOj7igsfEy8x6rbV0YviIcplZrzb44OnZ
MrNebfDB05xlZr2a4LlHCMtRtSNJQVsSPL3GPXpXm5VlnX5qi60bPTUGT9xw
Tw5Fwktb4T2JQ3/XEQezTjk5zerN6v921ZXzAO6AdAxalHuQbGsS7cib3LIo
qcrgedi+hNW29IhalF+UVPW2rdwY+IW+Vlfy2yHrlCib1ZvVm9Wb1dex6taW
cYtry3gHuNFbxvS+dq/5rMtjyDn72uuUxJrVm9Wb1ZvV/7WrNx9GNqs3q3uq
43HB7mq1uhSvwtC4JjZTTXRV1Wc1NFHsg7zLce1snLbTI65eaKe1T7bWg/nZ
5GdQXLMfyDYrOWxTza5GkmWNyINKG6bNQpN9KbWlNeJ+zUUXXVQR/w4///zz
h8W1PJSQJ8oBWl4hror8a8IFF1xQKAJCIptIJga5Ra6hpHxa64da390NWl4S
pL1+qM6sAPssrnTXFDrrh2rPQlEClFADOFDUA+YRXviyv/9W6f4bzIGPexBd
zjyIFp+zZfi5qq9T4MpPyctCS1gvJkujxGEh/sF1OfPgWnxkhl1kGx7evIJX
oSTvRZ04lcEaQwU3jOCq3lykK7HeAxWVXLO/i/h3s8Q7lXo4n3juU3E6p2On
i9K3s8rTayiP1n1J48YcSuMeoCO9vhSD2vV0Pi5/PSW/26f7mxHkS5k04Cm7
smDezHzawXU+WX81qzDOGWuUk4/6H8grWj1Z5Cj9+ROhP9T8twVff8LP5JV2
eBKeUZS+RlBqqEqi6VtFUMpMkkWn6qKI/GNKpOUTZa3e2Agigw/5VZw/nVeK
IvLllEivso6LsBlRRwaYqZAo2n9HaAGlr+MjLHPw7ACme4pJ20PR/tss7U4H
cMeIKTHmgAIrlYxTtZ/Pao1TtXeO8LR45xUYmU6cMv9NlmrnTD6RQzXjOASZ
zMN5HOKZrEY4vdfd6/LTnwzrnZxkP1QXyhNM/di7LpTHmP25b10ovyD6hfKq
JtWF8vMUpdvXLwfWhfKzrMSc1v6QulAeCveL1OTD6kL5sbtfMj7AEXWh/Eih
6D6hNFn2y9F1oaxk9stUhbKbuANFkSj3EBKj+mUKoLRItkrA4CpkHMji72Ld
nUVzznDHKJ4mI/oKg6ouzSN8+Btdd6bIXsfr6JTPosmnuSGWiHkwG/67zM48
mmC8I7sVJ9H5G2Yr/B2cTCEGsua70J4iL8Xfq81CFvJt4c6Wcj7Sz/NSzfPG
bORbstJ2dvaRTp5LJs/QzmZs8OVZcOcMdAST7dFs5G8RXU3NSofz2Ab0LUnw
+NNgX0lJ6/bpwmFMoUi6Gn+w7L+yfeccphaZPgkqT7bmY2pLw9oEn8JkSVHJ
FBx8307Ibge2QhnisBUqM50e6hdHryGOCWxwzPaq1cU5yx6S53yVg3P+k58l
TEU4JMx5FdF3Z4NfSYid6vODU84rbs6hicJebPArsuDOKfogPuf7sMG/lIJ7
Z+kD+Zzvzwb/IrPPD+RzfhAb/PPMPj8gy7m23xTnk9ngl/g5T/p8f8I6S+QW
+ZOiZls2dzgbfj6hclSvT+Lzfgwb/NNu3jOT5n4xvE9lw6v6WStXJqzcvnze
T2CDX+Dv94T3fZhe6Yls5E+E2ZZd3s1wxxPGp7Hhz2UyvjeT8Rls5I+nyBTj
iZHZK4bxU9nwH80ybpuZhPE9mYyfxkY+i8n4nk7nNMvzmWzkM5g878H0Pc9m
I5/O5HkPnkMO7XyMDT4rBe8h2E6M+m5Mts9jI89ksr0bj21A/yQbfAaT7Yl8
h7nKBp+eVTUn5xP5DvNn2OAnMTnfhc/5JWzwE5mc78Ln/Ats8BOYnE/gLxUu
J8EZh+SnMgUxge9FXgYtNurI/RFMWe3Id7HVkqHmA/zHMCW2I19iV7NV50im
OHZgTkv/xUY+nMn2DgTbbTTbS9ngh4bZnmyBQ1mfUS/D9g1s5IPrYNtA1iwX
vslGPiCe5xUWhRkTsYyNPCnL82qC5yqTZ9nSTWzkfRrM861s5L0bzPPtbOQP
NZjnO9jIuxM8U2vJ8YQxoXj+Lht5YpbnpfXyfCcbeZcG83w3G3mCQtb82pYk
mud72Mg7uHnOrCi4PPeykbdXyN0enk3rqWduJ8/3sZG3rY3nNS6e72cjj02R
G8Lzg2zkrbI825aEy3OP5vknbOQt/Dzbs2SQ51Vs5FEN5vlhNvJIJs/jszPG
Cgs54flRNvImKXIPwXPiBHJ5foyNPKLBPD/BRt6owTw/yUbeoDE8VzXPz7CR
hzSY51+zkY0wkmoEz06v9zk2shVVUjfPL9jIeCAS3jB1nlgBwlXolHd5SLKg
PzhdU+tVX7ShEcDREMmpY4qhxSoydenM9KV/hf5w3yXlwhvRWKpf7L2m2OXZ
0NwegEXmT+Tz8G/Kuz6m/D9AelmVfd2Uc/ok1iK9NSW9XolDG4U/ODRGU31S
Jc3TqF+6eyFQuoeLwmJKYUOE+8eGU7heg2X4eiMpfC8svskWccni33AuEhG+
2Uji3mmw5N5qJHF/b4zklmrJ/a2RxP01K7nV9Uru7QjiIM4A3jYtw9oo4t7y
d2u05N51EPfBWbNmzRbEyMCHfQhC3kwJSbyPUlZK1RgpvW8TQs3EbyjQbtQZ
GzSae9loi42Mh+E/KVj/hSiFq9Am78VHcjOxRaERoJRottU/krbtmWJJJ0GC
wiXmtNqeTKsWSa/49ZkiySW07oSkNpqkVlBciKqDOIkvVNRb4CE2ojROzvDb
hGZOK2bG1m/4SDK3i5FfB01s8RaUHbyTt7AnQc3v3dRoM2BTExZdfwc1Om50
Ogw5ipo1KTWuIScNU5RsBjio+awoeVJcR0OPUdRglI3WcudYjJJN7iSwoqYE
IWxabeAd7RhoCv/dVyjWcYJIiOfclaDzuVRq3hE5jrmBKhvNHdVWwY2tewlC
wGNcjnZiM/Hvr6BWGuZ7hB4COxPEWmE0zrE6LkaoG9JC7f+B2bNn61iy+5Gq
G1EJIf7qafz/7yoqDJgi+Fn3CMmM121jpJs7G40EV5EgeHMwhF9C98OLkyHS
GmLZITjuTmQIovkogp8mCKYGkSFh746QbDR3pFoR3AZq8FckFAp06OBieY5W
UTIHy+TLwCmKjbAiaqABdXKgRYl4UwfFDwtqXjQmuSlIHXw0xZ/BWLjOE088
kaT48ZRi15CzKQ7LuIumuHOVKHlHXIMhnlF89EvXP4jHqAfMmTPn+QpGyVLz
oxXq5Bxz28TIN3faHKm9HlUYouwg8vU+Id/3kNopaDzgbzAkOqFIME3Do4RO
U4Nwmxh5546s48QAGxTva6ejTdm1X5huEb4TqqbXDCDG11HrplYcMdWPuDle
VTUm5rHMJwey0TE2x5hz42BBMaQ+eFRyouLbH0fD/mtx/VlLQ+3I1f42A+Re
x2ofm0TNW9wbAW1eRyCqv7exuce9NrD8++s5S/Vt7QkiuBxiMJ22Hk7nIqp/
x9kcqvj41vWnT58O0ftHCapg3EHUNGw84NZuMKEEbvR8UtRbKOoslPXkvayn
0DvxO2eyeCOuz2UybYUOd+l4h0JDtPg3ROnbQA2G+YIZ3VNHnqhujnvDQ1GH
N5uGYX/T3y+penrnkkpW0ZuKwWuLt47pd6nZngQWaJr7C/P6S6T/PXR/VlZU
0gLtJr2LZlsbOe6rJW7GsltSqZRXYtnF4i8oGZwE5PsTYRihhl5rPyaVkX6u
RT7rkI3KPHSe5Bjoh89FmmEdDOHYqBHgCXwGRfFEJXktIPPdFiVQopcqKnvB
GDH40HIErcR9bklklmdjstrifJYqG03XENl57y5kXeZdwW76PpbJ3DFDs0z7
35RRaD8U51GYIUpIgckxxfDKlGGX4ZdmcYzfVcl2/W4Ohh8VxLyk1QAZ1p0M
eq8ZDib3QNfyqkr6eMBmluxeKqaWciPHEDaReuQiG0031bLcwtT1juiK0cLm
aW5/iBSDvdTcBrOEILf90EEA1xSmviC3P8hy6zR9W4WVOe3bXLwSjuOzkGKw
2VPScQybNNdpz0UQjPMAM+kIroFhIQOrsqfEdXtAoe9KmabsfWLLtoxR6Fyc
FDINq7D7kaDfJN+WwcL9HZn+o7bb+HA1mLIEU+ycZ+zEeXv5+1mGbeNdIRim
dDprsvazGcZ5vk0sfWB5ebFBPcw6MBJHgslSqQV5yU2MZEL3Gdw6OTVCtb1O
6pbhqTzt2gPori3OE1Su1LYK00QGk55g0iFYqLxhcEMxc4dqsrsa8Ee3COtp
T8LMwTYzykEqgxnRj4B/hrNEoVU9Cp6HDwjAWUEHlc6TMkBRDGsXeNAgyyjO
bk+7yWVkJU9bZLvJr5CH2pyh8sFQ0/mdCp2qSzKHrKkt4VuzQ8ZpGDf3K1LW
RuSi6hSFrcNQhvr6OVJblrNW+VOC2CtwpCQzA7UFcnOWaKeTNjp8ICVVmKMc
2n+NVhLJgirTfpZcbFIULndTmHGeRoc7viuhMBcviBRuLUr202sBpBAcJVBb
mF1ICm9MKfRakNExk8OxdMeXT8cp74soR2nxO9RJgAdDTy2+qVrSA8hpHkYR
vY2BaL1V21M53kGpfm54B1J1jbTOrqc/N6RC9I7vUWG3Iu3m/3CQNuL000+f
IJYxo3EvTu5YdUBJobiTVlCXEL+aVUjnOO+K6e6P2JRSjxWXuodCZrB2EacE
nY5mj42Muw0b4/OKM8Q3J6ArDRP1RIKw6wjCqBHQFdN5J9uEobcAluK76B7p
XQFIOHmY1n5Kvb6cUkhpfrIiGRnTaRWbQlyhg5j0jgpYYJjxwa++Q1wvYjn4
K7BFSVJ7dXgw2NSGva9c1KjlY8PW36jUx4YcaxfhV086Bu1VzKGwWYzvlIsx
RdusffTNK+le1t1YBlvPpG2+Mkuhc8hsGuMQneGgEHYbdPJfTeFnUYS7uua3
hW4KM1vEm8Y4NnMdFN6KNnmksTnwXSwb5fIRFqQUeue3TWMcm486tPFjKK/7
cYMTLTa48/Ows2HBJrd7KGIvV8TqYeOc4jaJcWg+ThPbDiu1J5Cqv+BUt0T8
DU8nYccdvfkpoXn50lTCrvEuyd0kxsc51yZap+Ym7Cc8GjhFO7jUSDfyVXhH
+sYx9vMTNoU49cDjR5hywOuCdeHhgjLYuqOmHiuXhXOAj/D3d+LWyEYvtAmz
okHlpmCLvEtxJp2b0nWRm66M2zoiZkqUYdElhUulQcJRfp6QFyzI4Cq0ybs8
tZHVwah0SUbqCJcNkMNqREz/KxmFciUhU1dXjG175yGiakqnayRJOocTm85G
qgWpCkmjn7XVAQ8RDZo7d+6TOPTniwu2SmFXqSS3ZorjQ8P+wiyxzkE1PEZH
PkcTW5yPsjvWdWznk1mNtalJRtIHYrr4Ugc1D1TUto3cUaaoOT9LjT2uKwQ1
YV/3Mgc1+qmnnBYpaowEIt4p8APhnkpls4CmpnwtTshAFTznkzv5ZXX0XFLo
0ylMONJdDcx/G8X04iKH3OBR49+CY9JIQuIak5KYjWK82cU2SWp2K8Ej3JsE
WfB06xlxlZ+V5u/p0KrOyFdCaX9C5IYxriwrLv1Mv6Yn426DGBf1yxzkOW7k
zBy1QYzreR0H+bQU2TueNohxKa/nIGOaFK2IzvExLMY/ZIXDV7LDwKlhw2Kc
vG9wkGcwdXtojE24kYMcSJCS6PYQ93SceGZJo8ttZOU2tunTa/CxT1wWqCOX
PUwtHBoz/95iU9egI5dGxhWtvPZxf6m4Q2I6MRdl38Ajl//B1PchMbtVKxwE
Vyv1H7n8sF9ZE4IHx0zyuZj+Rh65PM5PcTK8BsXoRC4XQCOPXBrpcijzmwy5
wTG+QC6HQKOOXB6dVWHnamJQjFOQyztQy5FLilojt03VN+AGxjgSK2lqw8cr
KScrkAMn0deBMQ5HLqdB7HFISpaTU0qXVj2u0YAYB+XHNqXU0UVq1Byi6mkd
pEaN1MOBxKhxxhM9ZFNDTeAHZkdASKcqqE82Mny6EuSf2sj42BWeeD+OV6FT
3ou/DOnU/n6dSigcQGi980Tizx0UOgKELZL2Y6q5RdIaQmipmj/iIAmeBI8R
Bg6uQqe8y8M/WaGpjZ2E9BbimXZK/x6E8lNGeiAxERr092Tox8PAvWiDUzLW
A8rkBhbuYuEJDmAFtoZg2/dEce1snA6R79XRze9EdMFeWb11Wm7K0hgsdGdY
yOV5QEsDT431WRPcUW2DxfvuKN4j8KQRPMGAY8aFHQmKjTRGVcZIy1Bcculx
Lj+Est4DYWddnwYDPw8OSMPWG7wo7CVdLi44sgHHPP6KZV8B3ijqrVRIHMue
WCiL+tRO5HJM4DMCPQrvhKNf4l+lFB0dZ5111pXGJAqFcPABnFR4DAeP5Yxs
6CnxHyT0nTL2BvGrCOKrGeKfpokv3o/HfYZV0oN58HTjBe1eoSt1RcU4rEdR
vauqp9XbOUrROal6qE5V/FkH1Q+Ikjf0OFUPjtrg0MHrhnnW75OSQcEUxRNS
Ofc4VNwelGG7+BsHxZcjNfKxsJJz++bodN+JAxNOiMPJGXgYC04iRfSOfs12
jUu/MXyOJnrg8IpassDYA7sH233gHcB67Hjxt36xIqwUwQ+8Fa3pva5xOd5P
PTUuw3YwlxMERb5AUPQPbdv7qSkGOBmnH5FQ8t0updA72QxyU7g0R+GLDgpB
RX+HV6FV3strhAxhFx9UHE7VyOeg1JyyTVZ9uasBv437vU0p5YVtnSJXHQPH
XudR1jVroF62kWvdRrHSZoVWoTxD9IpNXYO2UbYg1C1g6zXBbhv0Kq1uDdlG
Ga0I1hrHHR9+o5nLL9LAbZSRdQwTp8H8E01wY7ZRNs0qMGd4hU3Qnx0UN2Qb
xXgzPGfI8ZzFv9IU17+NMjyl1mviqU0fp/n6u4PaurdRjPfYe/V3MLHkdZqz
f9DU1raNMiylkKuvYRuWy7DSiG2UIVlKOXoKH7/xyqVg4W6jGFnZvLY/YEp7
MtTI23o2SdQsjkfdtVJxhoFtZnqrtpmRt6INjwdpYLEJYU8fFlI5FE02rDWo
gzSdqXA4as8zKfLWalOHmgVva71MaBdMMPog0mPivrfvIFIHU/cDtiTrhPUl
VBEGBeY8HQzwHvrm8P9nBJlmvOVE1yBoYw4Cg+Tw8rIv6WaC5FPRQj+CfT4L
SYaj7Z3z5s1bjGQ/4iLZyMLHtdjVasjCyJsjq0z/G9EQboWdb5IMf8NS7QGs
AxMONb5b4lU4bG3SoUtN5hWMsMNPhmokRx+8kftXFNlx2sy0SLlXZSLFt6EW
b4hrMopiPYXKk7Y7qzJoCQ5myS3DFnknzor9za/qLn78y03DeMowbADXF3lW
rL8+KQrHg+GQlq1McKAQdoReNf1u63iffL+hzZQ9bWRO6HqYyruHxoTUCkd7
AE1f+mhf9rAp7Hc+goxAWPtvDaZg5xxXQOd4Tp29rTjRg8M5rIdEG8+NbHUz
QviXogeGu85lTTDY/UsquKdkWSEjuZ13KAcoJWzmcJtSnCth6wW8MUhrBbEP
0CkQJ2LNlVZiO+eIHRKz2E19eo8P8WYWmTONaPSAdcsl2bGQ3yAGQEBtmFZq
ZACZkabOVoPwWlLeRgWQudnoPMiOQb95ADmQWs6L7HfEtgoge9LIZQxd/KDb
OoCMKeO6qwHDNDR6VOXSxVjIL8RrGHNU5dK4WMjPxWsYfBjeyvYBZCt7m9OS
xI/n0LtmjTRsXksyNHpU7RRAfsrfz8kjdArZP6p2CSD/itnPQ6Mn3dD7bR/P
IjstiYHMXHjkcnFYyI/5kSlLUq2yRlUuL4aFjDnGuqs8SxIxqvYMID/s17DE
klCnCf2jau8A8qosMkfDmF536FW+P/XrdlX3c/yomhRAfsiNnNnLiR9VudwN
+Nwnk95OpdkvgYMIkX1jIeqju7u7I0vkA+5hEEMkMQBzbxrWj4hqyWaHhyrg
wMVKXGLr30KO3Kl6mdeW5e5+gjtqqA2LnrQPsbmTKe/qyFinyjo2nTZtmv79
I7hy1CmvgOvDk8Q4KZf3hbm0h7XmNGBQci9sRi5rzlqnyko3YD3QAyMJrV4U
P4tLLiu920o/n3WYr1wOC8UnN2FdCc5t/AV5mpAGKMN402dV4MiBxc+9tfHD
WDocafOjHoDGpaEraU7hyQqwUlL06sQ/h6YCSOL05H5La8JhIHMNx+w7nCmZ
F6VNwpFZ1vCJLzOrXOlwrKcfaSGr+unnxDCrd9TBqn+eOZzHKjdF3AmV9JQd
JFpEHTgIq8KWB+xeWrp6Z8oe5bRwXURinjiO1tVw9jdV1u9Y47geWMgviwsO
A0BmAD0m4VCFZTS/F8dQxNTwYQdDwexu2EEHGydmIG8aPnf4uiiG82OyktU7
31Gt9YSYiXdmc/lJkJlg8jY8z7S1MZeBvkKvQvDvmeL38LzTcke+nfaKZqaW
dR/BSO5N8GgSmRnZsG/g0dSblXR/Gu0EmMI99BEiq29uy7LkdEDjN4hOslnC
WSuYag0f93ytkh6l0FPBzigKSN8GorGYuSVlpkowY6+aMhEzfoM+jWaGl1FN
MdSxlRHsean4/xbCD54k/n0Ky+AtD7bzdBOTo8CeJWG3Z9gcoQMczKaGG9Nw
SEjPyoWiusOBRkiySynaMjcnKxycUIpGjJ1cFhn1AkQ6XZp6StsKB4vOQOWC
LfSpqFBW5rRvZYl2eujUhp5/dOSSyVjLs2+EkalHcYyOz6WHsZBviEd2dVRX
FnlOAPmrfmTq8SNT2mcGkJcykQMHQghpnx1ANjI/eR0zxuk0S9rzAshfjkem
pF3NSzuX7cVCviZF9voDgSOEhLTPCyAvUcg9EchMaedSsVjIi+ORmdK+IIBs
5EcCdOcMHxXfI2/VAPKCeGSmtD8dQL48Ra4SyBUHMkPa8wPIX3QjZ6a59Qlp
t3pdkIsDyF/IIvcxkClpE/38+QDy5whkasaIl3Yu+4mFfHEcspY0Y8bIZTqx
kOf7kZMZI17auawmFvKna0NmSHthALmaIntnjPXd7rVD2leSyNx8UYHkMgld
/aMtnMzb4skXZZBpn+3Jv6P14ymZ3imgf3THqcmlVe/9OM72WL2JCYJ6Ishh
9mYod8q5TOTO6P76SgD5Y2kXaHRyRuoMd0FXFvn6ALKVw8c5F3ZGS/trAeRA
Yp5kXugXLe1Q7pQz3cgrHMjM+f9bAWRuYp5+fmlX89JeFkA+jUCmVozx0r45
gDwrjDzZQmZK+9YA8kw/cjIjxUs7l17FQj6FidwRLe07Asgnp8jeOacjWtq5
hCcW8rTakBnS/n4A+aQU2Wu3292+bW+V9G3vCiBj7p7uCGSmt/XDADIm4emJ
RGZI+94A8vGptDU6OWO0R/u2KwPIx2aRnXNVW7S0fxRAnpIiVwnkigOZIe1c
6hAL+eg45Ajf9sEAspV1xjlXtUbbsFyaEAuZyiZDzVXx0l4VQJ4cRp5sITOl
/XAA+RAmcry0Hw0gH+RHTuaq1rC0u7LIubQaFvIBKbJrxrCRmdJ+PIA8KYws
McvR0s6ltrCQ941HZs7PubwUFnJ3iuydMcrR3lAut4Sx/AxnpsEkHT0hukrR
ffGMapmRmcYSlZEnR5NFnrsrRXfS84FO2i1Fho9ziitFd9JvA8gTs8h9LuRi
9AbhmgDyLsSQoE6nF6Ol/VIAeSd/PycTTSl6ovlDAHkHfz8nps8jbYfL+scA
8vb+fk50OyBtYrjlcg9YyONq62eGtHNJBCzksXH9HOFE5ZIBWMhjwv3sHFV+
aeeC+i3kLWvrZ4a0cwH6FvLm7n7OOI7F6Gk9F2xvIXeF+9k5qvzSfi+AvFl8
PzNtWF8AeRN/P1drH1UKOQA/guhsylf3TFi9dGfLWykAv5G/x7121N/j8tYW
gN+gcd1Ocd8RgB8a3/fMkSZvnQH4wQq+uxoIyahR+LnYbAt+QHzfx4y5XKC1
Bd/fL/w6DKy8DQnA91u7fT8sAI+nrbTgG933ubBjC97IY7A2+j4XS2zBFxvT
9y7hhyKG10vh7RmW6nsteLOTfMLfzA3/fny3x8i9y438TrbHOR5zzHAbTSIz
0iP8OV4VYsahlEghlB6Beiwt8xwY1Hk1paW2YapcvVCeg7QTjSB7atjWqz5j
3epjBdk3Wn22dSO/kUUOKUhmsGK9RPwE8nZu5Nca0/kuaXtigo0g+5h+5krb
ExNsBdlz+jlmOO7sRvYE2Wf6ucah5okJXuPu58zCuqW2UeWJCX5h7fazJyb4
ubh+rlTjRpUnJjgQZB/Tz5S0u93IVJA9tbBuqU3a+7qRGUH2dj/HjKpJbmRu
kH2No+pAN3IgyL5a56jKvXw9RTaC7NdGP+dejp4i/yLczyHr2esZVYe5kY0g
+7XRz7nQzhR5VRaZ289caR/tRsYg++4q35mOGVVT3MgP+vs5sZ41SjsXnJgi
/zi+n2NGVS6KMEX+0drt51zInzu7QBGifKAMsgwYuf7+W32re6QWfej16EMu
lq8BqQUOx7WI+YgPAvaP179Nd9CMuO21oXM9NncNSi1wvPH0EOJKIevfMkx8
BmWQgs7g8od+LYvRb6oPpzu4jEgt0J5JLYD1XsV6F1T0WxdKx2GTEMsJwXNp
3NzdKY/cdUXM7scMmkd2WgGdKvp1UQ9i50qq6qPIIsTSFlJmMEQ7OOhqVMuZ
NjO15BQoHoBFZkC+Tl06JeGHirK/NTvqnH5yjfZW6mPjEgqMwvjht0X9zVNV
hFzwb2H1scJ2Orm9OeU2ZvRxbfwMHrfBnAKK/g790vYnoFxIAfJww7+PYfmt
2cBbI8qbO+xi3IVcFCQ3owD2BiSAWKSnAoy+h3y0RPS9pZTO5USNY26ug5Ng
KgHsl36G4XxFXD+opC/PuVu/6iftF0vpGj3EcpGa3FwCyM15Rk7gQZhNv78Y
RA9g3UuyE9jyxgwhl5bloj/jEgqgrq1A2mcarsiH8df3Zvm5MW7UaD0z5wGf
rp1j84OTFTebwPVYdqFR73ws+0aWEyP0OmbUcPUsF6OKrkVMKoGj0M5Dd50s
OAIbPk38+xaWT8latK9lOQIZ69MtvpHDNde52NfIVALw0pj3iHqX6hCqlJPr
s6NmNcFJPbY5F0sbTiVQhgUGaB+8OescwbF8S0b6RNkI8E60qTWsTVwbXLUp
Thdi1xK93ta4jRVPDO7V4V6q5yHAfDfyYqa0LWTG6Tp588TgWmHWprRXOaSd
9LPzXcjpzRODa4RZV7WuB0Z3gtwWlrYnBveyLHKUbreFdftyN7IR7JxI20DW
EreRVzCRr3AjU8HOCrnNlDbgxqLSUbCy4LNOSbeZktaoFQdqD4G6xI1qhBr3
EP1LSTmxIM4X4qa3a93I1TgpU6i9DtTr3KgXxEk5sRzWKOoiUJe6Uc93SjlB
rdaI6okNpYKmFWqrKWFzzFqAlAp7QkKN2FtLuK2mcCMBb3QDnu2Ua6spV3OU
MgbpTW7AuU6Rlk2RajCOSfCEXloxrqstNM1ejCn4thtttlOYZVuYwCcH7Tsk
GiPofzpPzjFGQYZ7NiDQ/yR/pwBJ1ap7DBeyVMmbylLJD+43pOPqKYCPMSOe
IMkehdad74uSqRfM0dzrBjrRKdkEaAUf6D430AlO+ZX0pKfBGAPYE3d4XAqk
xVdoz3pPpi/nQ/G8inwqITfDL13jQKEGyc/cKEb4pCW0xFOgvD4KxRPBd0QW
JZVYC4AwhrknRu8wQk6DwqPTE3tnhBomMrFa7CJozL1yOm3xQIJ/q0VKO55y
t0i9/H1guEU6Ek0WGIF3CdcDwxq82t3i3gTXjBZfcLe4J8H1gLBmegKsrNd3
9zJb9AROGXFiCdcDwhqee+1r2qIR/0Vx7dLw3LtZ0xZ3yrZoc+3S8DfcLRqv
W+5xtEj1tSc8yHg9csL1+uEWPWE/22Rb7LVadOnj2+4WjeilnogWc2+cTFs0
opKSabl/WB/73C2OJrjmtph7vWLa7EiCdaNZl5rLW+69iGmzxhtpKf57HLou
b7n3GKbNGlE48FltNetSeHnzRHlQ0TX9wzoqb3T0BiMoeKCq122KqJMJiucr
oiJ+rVeZrrbwXEoub54oCWy2B1mQDbYzm/VEPwxJpZM0y9iOlbcR7mZlJJH1
uMOp357XiqmIpFIvClI3Q7XSFWpFdonWCpKQ0Lu+rFvotTrN6s3qzer/vtW5
L0O1bsqTqzlEh2pSuZv8uJp1RYLN6s3qzeoNrS5dTHyRgf7gOwvAHPRo1xnL
4O9k53d5g3/riUlep8nEXZDMUez02PU6Tfq2qtJsXNF8CSqXVBl1Hjt4ljs9
skKxPVJ+C1SOUt9mVmYjVRn8WE5fRhngJox1EQII1Eueo2A9aD+ZeD31MgKt
uz2Tc4dcutx81CMXLr//DLnk+9wpF5e6no6quQBIQHWlDtezDudzVBa+dXac
WxVXE6Lk1AMR2V0Nfyei89Sjugba53Rhvp6fc/ltV/38ulSWwy9Vr3Z+6XoR
GhGjssRLGHmRFk2VbapsoF6jVbZDlQWDZJqq2VTNQL1Gq6Y6Ts0NeaKCe4bK
u4Su4lUYKVGhyijXt4rl5NxMV4PrYRn8rTd79G/z9fyUrr1v/xm80fX+SVwO
UWVUPJZbGcMRadJO9skFe/a2G9yKQYBgEBi1D7Afu1lnNFZtzQZDozzNqqiK
1rtE1WOEVGE8mxCIEAxXCiO8jtXvEU1djM2lCNwQoiCOXKm8WMk+olxgnqZr
U/WCMT4U1CTVBAZwDMSx1FfJTeW8wBsPBHb3EtR02TRmjQtGwISbhZd3Q7gf
vEhYh5yQ4ShUUyrzN/nV/Hq+Kqz3vxE+UNY=\
\>"]]}], "]"}]}], "]"}]], "Input",ExpressionUUID->"3f6e405d-4b74-495e-90d8-2bb9d8f24a78"],

Cell["Figure 2d", "Text",
 CellChangeTimes->{{3.9031709489568787`*^9, 
  3.903170950141571*^9}},ExpressionUUID->"0e7b79b4-45bb-4d4b-91e9-\
1cdc9908480d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"A0", "=", ".8"}], ",", " ", 
       RowBox[{"h", "=", "3.74"}], ",", 
       RowBox[{"rc", "=", "2"}]}], "}"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"A0", "*", 
        RowBox[{"E", "^", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"R", "*", 
            RowBox[{"(", 
             RowBox[{"h", "/", "rc"}], ")"}]}], ")"}]}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"R", ",", "0", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", "Black"}], ",", 
       RowBox[{"Frame", "->", "True"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".1"}], ",", "1"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<Clark-Evans R\>\"", ",", "\"\<Fraction Algae\>\""}], 
         "}"}]}]}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", ".06", "]"}], ",", "Thick", ",", 
      RowBox[{"ColorData", "[", 
       RowBox[{"97", ",", "3"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{".5", ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".8"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", ".06", "]"}], ",", "Dashed", ",", "Thick", 
      ",", 
      RowBox[{"ColorData", "[", 
       RowBox[{"97", ",", "2"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "0.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.903130103428812*^9, 3.903130105303524*^9}, {
  3.903130233486356*^9, 3.9031303798441*^9}, {3.903130432950666*^9, 
  3.903130439292626*^9}, {3.9031305495082407`*^9, 3.9031305636432247`*^9}, {
  3.9031309092204037`*^9, 3.903130980360814*^9}, {3.9031311152413816`*^9, 
  3.903131120009962*^9}, {3.903131176224513*^9, 3.903131281422987*^9}, {
  3.903131337884756*^9, 3.903131393718561*^9}, {3.903438725294636*^9, 
  3.903438728384351*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"54d4c92b-0799-42b8-b1d3-7040c65cbb05"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVxXk41GkAB/BxvrId6tHUijbFrLKyT6Wi5fuSDlHI445Cxs+Mu4MoiSbW
GncHrbBSSadaonLlGLW0GyXVEBFDRY1SGHb3j8/z0fYO3ukrz2Kxtv/n/79a
B+XYBYeYnbALZLKyJDix90e9x5wd6JN4wzFZguYPvTwhxxOKNvnfseMkGLm1
MSmAEwQTmVnUhQAJYtlSzV2caKTUa0fKUwkeNW7rc+Akw9LhwbzC/gEE5x1s
suWcQ9uq4VqByQBqkpLubudcg6efdy398BZKymFEwqtCFeepyzXXXlgd9RL8
6dQIf+eod8vX9KDskK+48J8WWJfbKd+zf40ON75hWHgrEndYWAbLXmHuFiG3
hrYD77I09Ec7oNbmW7LO/SU2urtuCldqx7IlAUUC7y4k6J06pRzehvXiwEfm
6d3IbcwNhdMT1IzH2LSdfYNrair9Tlv+BlMlElXG9sFuLfEd1G5Gls9Fjfl7
+hFZ9bRA9sNDGLh0f5nyleCOkZGe+dpGdEptW6jVEKTvRQXZTXX41PX9z2zH
9+gPbJ96FlqL1OJIP2fnYegN12W3c6vBmaOyPeLsCMarM+Vecu+jNCSmODn3
I0YKXlzV1qxAm24GsU//hMtXtar6PcugE9eq55Elxabc1c87y2/D2K5rTe7Z
Uai8WC9XzS+BOERgJkz6jJURhqbCmBsoMXadVZ/2Ba/q+brU+irYTo0dlwRj
uF7Pl59pdBnoYaXV7v+KjA2HFHD0IrLYzCxOxDeUb7XZHNF1HrHn/OONeONY
/dythXfjD+S0nGlIDpmAS+3Nt+6ZeTgSlDGiFTaJhR2Ph+SicjDkpbfQ1VuG
4XW5S+fws/GbbFCxkzsFdVFK3+X9p1HxbsvwbLdpGKhH9xbJMvFMd32PiQ6L
Goj3DUS3poNZ7mOYUcii3RaOOnkVqahxco8yXyxHzw+et0wfE2K1y2CRer4c
VYzV4zadTkRA3OZ200XyNNHGUdOsKR4JXJVxuQx5Gh1/R+3gTgHua3lND6or
0AfKBZMDw7EonzqhsCJZgXbFmzh2SGPQcmvjoHCuIl2opJAcOC8a9Uu4DUnp
irQn5RcH1buROF7mmN+tqkQfEoGSvDQcu5a+8nQXKtH++tP7+RYHMFFquEif
KFOFS3dWJirtw2EFyV8no5XpyT0i8dHZoWDrGHvpsgg9E5/y9cKOIIQHOY2q
HiJ0Jm/6Te0yPjTX7hVxogh96LUgzZfNR7Us9HeLI4Retx17MnsGH6pCoWXk
MUJH1DRUDnzg4VxxXabkV0KNwtLEKeU8NAysMhJlE1pWWuw3aceDus+cg4J7
hKrXtIizj/ujfIXWtvxKQptjpOMzIvzh+WnF4vvVhCaw12w9yvfHpWObG0br
CP1hooN7eKc/NuQdYe9tJtRqRv3u6iX+8BYPlVp0EuqQ4JETUMmAFH5L9HxN
KKP/wt60hMGVALI7sofQuM8+yuoXGHyZWEpK3hLq3dri0ypkkKjh5qw9TGjP
8/ycLA8Ghj1++qYfCX2do8XKtmfQVnRg2kVK6Mkufeu8TQwWG6ddTB0j9Hi/
R0qlAYMHrNyoK98I/cnqduwzbQaM6IqtaILQWR7yDqPzGcxMrVjWKyN0Us5X
tkCVwU1n0dj0NKG3Y8ejzaf88C/8tz2b
        "]]},
      Annotation[#, "Charting`Private`Tag$19458#1"]& ]}, {}}, 
   {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Arrowheads[
    0.06], ArrowBox[{{0.5, 0.8}, {0, 0.8}}]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], 
    Dashing[{Small, Small}], Arrowheads[0.06], ArrowBox[{{3, 0.2}, {3, 0}}]}},
  
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Fraction Algae\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"Clark-Evans R\"", HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 2.99999993877551}, {-0.1, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.903130380993991*^9, 3.9031304412457943`*^9, 3.903130564159013*^9, 
   3.903130927826007*^9, {3.903130967826853*^9, 3.903130980917042*^9}, 
   3.903131120526293*^9, 3.903131200987912*^9, {3.9031312424231787`*^9, 
   3.9031312818984737`*^9}, {3.903131345073681*^9, 3.903131394291827*^9}, 
   3.903438728699457*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"93feeca4-0bb0-4870-abdb-11a8a92bf1de"]
}, Open  ]],

Cell["Figure 4a", "Text",
 CellChangeTimes->{{3.903101005164613*^9, 
  3.903101008209791*^9}},ExpressionUUID->"579530ad-5967-4e61-9bf4-\
42f01dcc54fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A0", "=", "0.8`"}], ",", 
     RowBox[{"R", "=", "2.14`"}], ",", 
     RowBox[{"g", "=", "2"}], ",", 
     RowBox[{"Hmax", "=", "1.15`"}], ",", 
     RowBox[{"k", "=", "5"}], ",", 
     RowBox[{"m", "=", "0.03`"}], ",", 
     RowBox[{"point", "=", 
      RowBox[{"{", 
       RowBox[{"0.029`", ",", "0.434`"}], "}"}]}], ",", 
     RowBox[{"r", "=", "8"}], ",", 
     RowBox[{"s", "=", "6"}], ",", 
     RowBox[{"\[Gamma]", "=", "0.8`"}], ",", 
     RowBox[{"rc", "=", "2"}]}], "}"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"algaefun$", "=", 
        RowBox[{
         RowBox[{"\[Gamma]", " ", 
          RowBox[{"A", "[", "t", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox[
             RowBox[{"A", "[", "t", "]"}], 
             RowBox[{"A0", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"R", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "rc"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}]}], ")"}]}]]}]]}], 
           ")"}]}], "-", 
         FractionBox[
          RowBox[{"g", " ", 
           RowBox[{"A", "[", "t", "]"}], " ", 
           RowBox[{"H", "[", "t", "]"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]]}]}], ",", 
       RowBox[{"herbfun$", "=", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", " ", 
             RowBox[{"A", "[", "t", "]"}], " ", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"H", "[", "t", "]"}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "A0"}], ")"}], " ", "k"}]]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]], "-", 
         RowBox[{"m", " ", 
          RowBox[{"H", "[", "t", "]"}]}]}]}]}], "}"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"VectorPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"algaefun$", ",", "herbfun$"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"H", "[", "t", "]"}], ",", "0", ",", "Hmax"}], "}"}], ",", 
         
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"VectorColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"VectorStyle", "\[Rule]", "Gray"}], ",", 
         RowBox[{"VectorPoints", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamPoints", "\[Rule]", "Coarse"}], ",", 
         RowBox[{"StreamColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.85`", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.035`", "]"}], ",", "Thick"}], 
           "}"}]}], ",", 
         RowBox[{"StreamScale", "\[Rule]", "Large"}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<A\>\"", ",", "\"\<H\>\""}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", "18"}], 
           "]"}]}]}], "]"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"algaefun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "1", "\[RightDoubleBracket]"}]}], ",", 
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"herbfun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "2", "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "Hmax"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black", ",", 
              RowBox[{"Dashing", "[", ".03", "]"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"A0", ",", "Thick"}], "}"}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLinesStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"Dashing", "[", "0.05`", "]"}], ",", "Thick"}], "}"}], 
            ",", 
            RowBox[{"{", "}"}]}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"First", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"A", "[", "t", "]"}], ",", 
              RowBox[{"H", "[", "t", "]"}]}], "}"}], "/.", "\[VeryThinSpace]", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  SuperscriptBox["A", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "algaefun$"}], ",", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["H", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "herbfun$"}], ",", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"A", "[", "0", "]"}], ",", 
                    RowBox[{"H", "[", "0", "]"}]}], "}"}], "\[Equal]", 
                  "point"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "H"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]}], "]"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.903100889340989*^9, 3.903100889911614*^9}, {
  3.9031272865340967`*^9, 3.903127304945313*^9}, {3.903127951370813*^9, 
  3.903127954480283*^9}, {3.903129160842986*^9, 3.903129162093917*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"537d10ed-565a-47a1-9ba2-fff18ff47ae9"],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`A0$$ = 0.8, $CellContext`R$$ = 
  2.14, $CellContext`g$$ = 2, $CellContext`Hmax$$ = 1.15, $CellContext`k$$ = 
  5, $CellContext`m$$ = 0.03, $CellContext`point$$ = {0.029, 
  0.434}, $CellContext`r$$ = 8, $CellContext`s$$ = 
  6, $CellContext`\[Gamma]$$ = 0.8, $CellContext`rc$$ = 2}, 
  GraphicsBox[{{{}, {
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0012039475587733621`, 0.0062092659000350815`}, {
         0.00514511776117833, 0.006221263497724419}, {0.015997426248865222`, 
         0.006629321849789501}, {0.041120064303367176`, 
         0.007859455911553426}, {0.07882254775396622, 0.009986092351815414}, {
         0.10520425622746252`, 0.011675463210292945`}, {0.1366335105151209, 
         0.013914734107525127`}, {0.16089166258168028`, 
         0.015897094276042273`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1648783730051564, 0.016222885619308104`}, {
         0.17212172960277533`, 0.01681480793746687}, {0.21068033247625945`, 
         0.020486587594073055`}, {0.25907562339339735`, 
         0.026469919070859788`}, {0.30705567823387603`, 
         0.03458234399598908}, {0.3231404226434851, 0.03858239094166829}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.32702219004068156`, 0.03954773123092505}, {
         0.35268470083610215`, 0.04592963232376168}, {0.39402689503848237`, 
         0.061617554008478355`}, {0.41831198934934755`, 0.0746689917820682}, {
         0.4401868691607666, 0.09059757739569116}, {0.4596515344727398, 
         0.10940331084934724`}, {0.4643760990216156, 0.11541008136361074`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.466848989803088, 0.11855409332015748`}, {
         0.476705985285267, 0.13108619214303638`}, {0.49169578372075273`, 
         0.15696787912112892`}, {0.5039725118311841, 0.18691998435700907`}, {
         0.5135206425458095, 0.22099184325092275`}, {0.5203246487938776, 
         0.259232791203116}, {0.5210536526112615, 0.26674787613703055`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5214398613433784, 0.2707291878323436}, {
         0.5244014124962447, 0.3012589435334765}, {0.5257678155737672, 
         0.34668641556189195`}, {0.5243869583797804, 0.39656191121477913`}, {
         0.5226716107508365, 0.4222379177365113}, {0.5219209157728378, 
         0.4304547682935848}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5215569897034282, 0.43443817861842005`}, {
         0.5202988779243912, 0.4482090399874443}, {0.5167833785982678, 
         0.4783098283362611}, {0.5124689538603687, 0.5083398417873777}, {
         0.5074086080304603, 0.5380569007754865}, {0.5016553454283088, 
         0.5672188257352799}, {0.5008330865790427, 0.571112515130554}, {
         0.4999993118585184, 0.5749917606218528}, {0.49549693239886805`, 
         0.5921217360311922}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4944801227706793, 0.5959903401954901}, {
         0.4880668339975851, 0.6203906556199542}, {0.47499242754238374`, 
         0.6624445807870838}, {0.4614882280172974, 0.7024775210472034}, {
         0.4471244423524411, 0.7384684914933032}, {0.44299691762603594`, 
         0.7472806053933353}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4413002450181696, 0.7509029391799591}, {
         0.43217349227928775`, 0.7703882215231379}, {0.41690779952931023`, 
         0.7982074405344628}, {0.4015245144736216, 0.8221894342259848}, {
         0.38622078748333477`, 0.842597488296411}, {0.3588857427286376, 
         0.8721896992205921}, {0.34911197029774105`, 0.8799258802133926}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.34597557011697166`, 0.8824084180088893}, {
         0.33259198681302427`, 0.8930018529904794}, {0.30769987084553546`, 
         0.907449170134041}, {0.28456974593521184`, 0.9179468711792452}, {
         0.24209544035844807`, 0.9294241448288526}, {0.20975254057152248`, 
         0.9327994320205161}, {0.1975252278618218, 0.9331808471230805}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.19352717253635812`, 0.933305561254323}, {
         0.1791361181719081, 0.9337544714610663}, {0.14924416927013603`, 
         0.9330191458140609}, {0.11899837783882397`, 0.9306762644980244}, {
         0.08850956845914136, 0.9264727570463215}, {0.058848597098342295`, 
         0.9195816825782847}, {0.03738479934081496, 0.9085421642237093}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.033827715118206536`, 0.9067126419272422}, {
         0.02570203246737384, 0.9025333431945254}, {0.01954602948447724, 
         0.8966175474365353}, {0.014500542399942019`, 0.8899963325097632}, {
         0.01054564361968484, 0.8826385917770964}, {0.005327372752603404, 
         0.8660779218990643}, {0.0027088885062577376`, 0.8477295747919465}, {
         0.0014608911373601373`, 0.8285505817499303}, {0.0009057800915958575, 
         0.8131877028569534}, {0.0005417458693749567, 0.7979145975382225}, {
         5.005346418916918*^-6, 0.7661852697716673}, {0., 
         0.7652622613605763}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9952000724277611, 0.7683004311593364}, {
         0.9723234388048096, 0.7834806412212558}, {0.9488659344859359, 
         0.7976058933572499}, {0.9250050038876211, 0.8107164709023357}, {
         0.9009180914263459, 0.82285265719153}, {0.8767242752920765, 
         0.8340597879413172}, {0.854373535827267, 0.8436015664386648}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.850672119133427, 0.8451168158747887}, {
         0.8216118408491312, 0.8565142757152896}, {0.7912699377216033, 
         0.8674541434661196}, {0.7615169242922105, 0.8772028021206653}, {
         0.7323528005609528, 0.8857602516789261}, {0.7284600194731409, 
         0.8868338250915697}, {0.724583971153706, 0.8878896675058868}, {
         0.6985398999735409, 0.8940912910493787}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6946486971400307, 0.8950178656596945}, {
         0.6791067527637579, 0.8987187190127963}, {0.6367118210981791, 
         0.9076076590010118}, {0.595931566340545, 0.915656819464349}, {
         0.5583806653988002, 0.9220264208779297}, {0.5375460546470423, 
         0.9250467701068901}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5335874349204232, 0.925620642793138}, {0.523929990802345,
          0.9270206619364428}, {0.4924504150805804, 0.9309437413345771}, {
         0.46370286909548786`, 0.9339949380341745}, {0.43744828370904904`, 
         0.9363735309970771}, {0.40378593831829057`, 0.9388465836823167}, {
         0.3743344011351014, 0.9404346852140848}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.003616121419049443, 0.07720367954164639}, {
         0.006940973815142602, 0.0778325130543261}, {0.015125782624133291`, 
         0.08159931222497017}, {0.03174591932582553, 0.09189709682013018}, {
         0.06372766286563541, 0.11532789478606476`}, {0.08832480933085406, 
         0.13540965507485972`}, {0.11805556648561148`, 
         0.16270951198382078`}, {0.12917618636067693`, 
         0.17461449266077048`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.13190668010610856`, 0.17753757389572766`}, {
         0.15150443930426377`, 0.19851760443239574`}, {0.1690168375719702, 
         0.21991245893538475`}, {0.18655529317161057`, 0.2437536310054701}, {
         0.21126371813567593`, 0.28265706034081883`}, {0.2242719671199704, 
         0.3074048735107742}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.22613305741285228`, 0.3109455433516011}, {
         0.23425898837498563`, 0.3264048893039755}, {0.2357348521818606, 
         0.32950877070281975`}, {0.23719879646537614`, 
         0.33263193460938245`}, {0.25131917284903027`, 0.3686987206110185}, {
         0.26365085829985035`, 0.40631475307259307`}, {0.2750225046507845, 
         0.44429391004289376`}, {0.2792179474818112, 0.46147479637584915`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2801668358450997, 0.4653606181517436}, {
         0.28447407280194653`, 0.48299931603064655`}, {0.2920011019027251, 
         0.521832899259604}, {0.2975991311025087, 0.5601965879535183}, {
         0.3013594890363849, 0.5975521420433728}, {0.3028179481145304, 
         0.6234835352766263}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.30304256509065375`, 0.6274772236988791}, {
         0.3033735043394411, 0.6333613214601506}, {0.3037479962416626, 
         0.6660417742156755}, {0.30278547596345007`, 0.6969073540639563}, {
         0.300623454220353, 0.7255106800815757}, {0.29739944172792115`, 
         0.7514043713451161}, {0.2901805999809875, 0.786433136428888}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2893732332693888, 0.7903508090789447}, {
         0.2882963616170347, 0.7955762296461303}, {0.2765380698747546, 
         0.8304496890393389}, {0.26305808374041206`, 0.8569762113194707}, {
         0.24865204057859744`, 0.8771834118685624}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.13211318852089157`}, {0.9894609480015906, 
         0.1573957983728934}, {0.9770529355896675, 0.18691871552225717`}, {
         0.9627888703591122, 0.22038459431694402`}, {0.9465357862767849, 
         0.2576407607172501}, {0.9368801482889023, 0.2791294166789746}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.935240702927823, 0.2827780080383948}, {
         0.9281607173095457, 0.2985345406834716}, {0.9076190434628069, 
         0.34269958019087093`}, {0.8965244148199562, 0.3657735694264136}, {
         0.8848878151751871, 0.3893780448674224}, {0.8700025175987379, 
         0.41866450670225436`}, {0.8656939160682641, 0.42684475338729855`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.863829843398566, 0.43038385399085377`}, {
         0.8543701422080209, 0.4483439017599857}, {0.8368422626548622, 
         0.48032496783314554`}, {0.8185864839143223, 0.5121922136040934}, {
         0.7996972284667374, 0.5436629088754}, {0.7837945776893346, 
         0.5688665998359278}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7816600902422852, 0.5722494925830288}, {
         0.7802689187924441, 0.5744543234496369}, {0.7776153939300045, 
         0.5785565272035014}, {0.7749541142865306, 0.582641393204777}, {
         0.7584857539975975, 0.6062146392499215}, {0.7418461089919819, 
         0.629033480350746}, {0.7252177327962138, 0.65085448317038}, {
         0.7085397742347832, 0.6717587921544468}, {0.6919315909666824, 
         0.6925764249397532}, {0.6856228400040487, 0.7001109212698258}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6830549018058764, 0.7031777915654802}, {
         0.6754133759195791, 0.7123040114919719}, {0.6589851290934728, 
         0.7309415518111025}, {0.642646850488364, 0.7484890458971454}, {
         0.6106008484914949, 0.7803399108798665}, {0.5796360204793288, 
         0.8078826219500342}, {0.5697248891893414, 0.8157475783621914}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5665915764402352, 0.8182340117951005}, {
         0.5499510285513505, 0.8314390819320188}, {0.5217445348070446, 
         0.8513311936501903}, {0.4988607373197086, 0.8657699453041665}, {
         0.4770792919307425, 0.8782688274454624}, {0.45640019864014614`, 
         0.8888278400740782}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7531084198451415, 0.00927323387481906}, {
         0.7574018638059121, 0.01663438083823661}, {0.7594369249267896, 
         0.030483999193141934`}, {0.7592715122358826, 
         0.042982888057988125`}, {0.757784326110532, 0.06027893158168907}, {
         0.7545841566954137, 0.08391227020764797}, {0.7522115604805618, 
         0.09857341203686973}, {0.7492272379115108, 0.11543563021785666`}, {
         0.7433486564360599, 0.1455018663081456}, {0.7389294508431866, 
         0.16619460326361396`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7380940372046645, 0.1701063910968906}, {
         0.7356357664148658, 0.18161713658034315`}, {0.7350539254923856, 
         0.18425595617489793`}, {0.7344625452895522, 0.1869236924516905}, {
         0.7285456683918538, 0.21227826234842312`}, {0.721815975033714, 
         0.23982966681262252`}, {0.714667000443633, 0.2683467383907493}, {
         0.7066794633896695, 0.29879514419673087`}, {0.6993834860542807, 
         0.3253299719008955}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6983230088060464, 0.32918683435708673`}, {
         0.6978401607440152, 0.33094291028006706`}, {0.6881358893788618, 
         0.3645580626902579}, {0.6775825486070548, 0.3992964002643672}, {
         0.6661960377414395, 0.43481372183945877`}, {0.6546193745265484, 
         0.4691587137285279}, {0.6501490957749437, 0.481731027839069}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6488090244706654, 0.48549987499694763`}, {
         0.6423918522598052, 0.5035476767604079}, {0.6295573675788411, 
         0.5375619459131529}, {0.616159817121287, 0.5707828561648169}, {
         0.6022842605873011, 0.6029444185208945}, {0.5882084680389698, 
         0.6335006072837167}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.586445629592566, 0.637091052988722}, {0.5735040529032093,
          0.6632654630399583}, {0.5587577602784117, 0.6908493454918072}, {
         0.5438903743437461, 0.716556011026292}, {0.5289980356208236, 
         0.740450093651702}, {0.5141691749680931, 0.7624360301654824}, {
         0.5051995595778318, 0.7746478910471268}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5028316591693415, 0.7778717160509804}, {
         0.4994922232440037, 0.7824182573650781}, {0.47078884713880453`, 
         0.8168441362167629}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.00789623470080434, 0.20024041576148321`}, {
         0.01513021682847452, 0.21073316140110798`}, {0.02156182570753787, 
         0.22285229583420108`}, {0.03030112616307165, 0.24139369663955024`}, {
         0.04168653052865276, 0.26812442847587503`}, {0.0587017378792698, 
         0.3131947178976385}, {0.06823034784416471, 0.34135452221726237`}, {
         0.07002978741585097, 0.3471617300331369}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.07121370537942491, 0.35098250721265506`}, {
         0.07811791787536258, 0.37326399829451196`}, {0.08799100818110386, 
         0.4085012730358919}, {0.09747617896962897, 0.4466444733479068}, {
         0.1029833027120178, 0.47125770762935093`}, {0.10809754279456914`, 
         0.4964838741089974}, {0.1098485107723402, 0.5061393895521675}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.11056224516634872`, 0.5100751973745604}, {
         0.11273890298012537`, 0.5220781314100367}, {0.11682738703152744`, 
         0.5477956381556501}, {0.12165446353145883`, 0.5847277182358975}, {
         0.12506562755530312`, 0.6206389568945797}, {0.12524803137899493`, 
         0.6230276909717127}, {0.12542357628995252`, 0.625408530571312}, {
         0.1264135047508953, 0.658842970857566}, {0.12624774321388862`, 
         0.6690512943015721}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1261828002527192, 0.6730507670682995}, {
         0.12591203185342803`, 0.6897258742632115}, {0.12471027267900833`, 
         0.7191448923126933}, {0.12210794095068374`, 0.7456361396498477}, {
         0.1131332094209091, 0.7896652476810244}, {0.09992585284247063, 
         0.822168962500785}, {0.09499949037245926, 0.8274763166761652}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.08728557511904664, 0.8532497471209948}, {
         0.07107622158895807, 0.8532497471209948}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 1.0780511077126846`}, {0.9944942647974229, 
         1.0751729294167613`}, {0.9543116550476237, 1.0573554325578058`}, {
         0.9147600098474935, 1.0423695690463926`}, {0.8760696405845875, 
         1.0296491613793175`}, {0.8709145046097464, 1.0280878314196684`}, {
         0.8657792007123848, 1.0265599922305866`}, {0.8502421600624308, 
         1.0224785152319842`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8463734199459401, 1.0214622229949504`}, {
         0.8391854249922811, 1.0195739846405303`}, {0.8132091693323528, 
         1.0132936700086943`}, {0.7880266729337178, 1.0075650939981282`}, {
         0.7635791893960033, 1.0024395747211483`}, {0.7156547485582246, 
         0.9925643829312754}, {0.6899508594342361, 0.9879925517139073}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6860126688497382, 0.9872920840699916}, {
         0.6711413859175872, 0.9846469981367478}, {0.6300061196252238, 
         0.9782844609057488}, {0.5922159678322667, 0.9730738118064608}, {
         0.5575790332713546, 0.9687902257568729}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12831631622481005`, 0.05961822656860428}, {
         0.1689840998195852, 0.0746687047488773}, {0.21303053850529247`, 
         0.09503684036845939}, {0.23540231430194172`, 0.10761388914966147`}, {
         0.25749210688624846`, 0.12201010284396221`}, {0.2703045757151943, 
         0.13172179287357855`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2734923125822616, 0.1341380572768134}, {
         0.27903927815343144`, 0.1383425873288555}, {0.2996367764143717, 
         0.15679632435784002`}, {0.32869695463980153`, 
         0.18970306439545295`}, {0.35413374219118654`, 
         0.22821832705398434`}, {0.3557259957689705, 0.23100312718407479`}, {
         0.3572992218048373, 0.23381353082484263`}, {0.36917402735715443`, 
         0.2601585375018116}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.37059984763039927`, 0.2638941324361352}, {
         0.38007162025536917`, 0.28972311521943855`}, {0.38986602696473477`, 
         0.3194006676068591}, {0.3980541462307286, 0.3506354956896479}, {
         0.4046511232397738, 0.38314632129668563`}, {0.4096721031782938, 
         0.4166518662568531}, {0.4098649904631778, 0.41853579503782606`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4102724032380783, 0.42251499280004495`}, {
         0.4131676257539433, 0.4507926111419589}, {0.4151882306743772, 
         0.485209036523812}, {0.4157858842089369, 0.5208556771863487}, {
         0.4149939838582973, 0.5560883396638501}, {0.4134062370591245, 
         0.5822458487005838}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4131638852529484, 0.586238500150691}, {
         0.4129108605264863, 0.5904069837983342}, {0.40963484511753157`, 
         0.6233115694318185}, {0.40528748190254577`, 0.6545763555641372}, {
         0.4000035799338325, 0.684132343571019}, {0.39390136728720637`, 
         0.7117146068583243}, {0.3870990720384821, 0.7370582188319131}, {
         0.3849252946963005, 0.7433710026503142}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.38080805393115996`, 0.7731209752740955}, {
         0.37468103189870666`, 0.7731209752740955}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.5274099437719257}, {0.9791244941027919, 
         0.5585716804784149}, {0.9565562683108282, 0.5895894409330127}, {
         0.932893380140893, 0.6195637844753896}, {0.9082884763252574, 
         0.6482601536658478}, {0.9049099267111906, 0.652040405348954}, {
         0.9028491370299218, 0.6543206101684084}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.900098024766169, 0.657222756670254}, {0.8827132358333227,
          0.6747210885506938}, {0.8636363551542878, 0.6928475401215257}, {
         0.8445084619650705, 0.7100909695549595}, {0.8252557477468097, 
         0.7264787822356956}, {0.7869918294192415, 0.7582820189033723}, {
         0.7803786207688446, 0.763176597738088}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7771634401882682, 0.7655562224636036}, {
         0.7489612892514937, 0.7864292446780631}, {0.7116220642609958, 
         0.8110917949038238}, {0.6754320914651778, 0.8324410049247113}, {
         0.6416875486945832, 0.8502314906997581}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6351060904140077, 0.864969370511995}, {
         0.6105728801821991, 0.864969370511995}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.35721223796186796`, 1.15}, {0.34313637182325585`, 
         1.1263623840162005`}, {0.3277577037560794, 1.10236111763439}, {
         0.3008294630734998, 1.0646923454516726`}, {0.2991647546232541, 
         1.0625466116462619`}, {0.29751733818495163`, 1.0604441382703833`}, {
         0.2868741830059594, 1.047800973247067}, {0.2768610962354476, 
         1.036647208084453}, {0.2624856982438502, 1.0216462480220687`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2597181291834895, 1.018758244992961}, {
         0.25792337770821155`, 1.0168853928313524`}, {0.24089351643012008`, 
         1.0015125457454386`}, {0.2253069336482679, 0.9893521302382492}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.26066391680256495`, 0.0026680172593130038`}, {
         0.30660639890540137`, 0.0034225797382905153`}, {0.3511492851105095, 
         0.00444045915912474}, {0.39285058891916047`, 0.005803740227356857}, {
         0.4205908961050028, 0.007155553190892716}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4245861551260714, 0.0073502461660346985`}, {
         0.43125269005235445`, 0.007675113092519684}, {0.46589796823109175`, 
         0.010217267904146045`}, {0.5073508019237537, 
         0.015127549834112195`}, {0.5422550883269396, 
         0.022463340853371504`}, {0.5711428052717862, 0.03342134159783958}, {
         0.5800033642164871, 0.03863650320525941}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5834505793150221, 0.040665470446106994`}, {
         0.5834670710486093, 0.04067517717639123}, {0.5944490852847035, 
         0.04943135840485446}, {0.6164130007893984, 0.08081948863190465}, {
         0.6170080342681534, 0.08212189188452998}, {0.6175931137440827, 
         0.08344345852314658}, {0.6218168660249241, 0.09672138639232086}, {
         0.6252379071756673, 0.1118118725802581}, {0.6304080681869088, 
         0.14582903161122968`}, {0.6320652326648718, 0.18672928745252534`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6319973673231807, 0.19072607331160438`}, {
         0.6300945041753793, 0.23835764295428014`}, {0.6264140028490923, 
         0.27776943715425356`}, {0.6208438326206585, 0.32002839905737396`}, {
         0.6159287836060482, 0.3497473828039988}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6152761126727622, 0.3536937761767942}, {
         0.6133839934900777, 0.3651345286636414}, {0.60403448545735, 
         0.4130878259730558}, {0.5973702135680863, 0.44349937204452505`}, {
         0.5900683721943715, 0.47386166891981224`}, {0.5821289613362056, 
         0.5041747165989174}, {0.5805335966742293, 0.5098039465502707}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5794429230109591, 0.5136523788233203}, {
         0.5735519809935885, 0.5344385150818403}, {0.5644434819023465, 
         0.5641942918116205}, {0.5549095147983056, 0.5929832742312976}, {
         0.544950079681466, 0.6208054623408714}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5502341671210664, 1.15}, {0.5466335332443731, 
         1.1458486049877337`}, {0.5196809985680941, 1.1174567914462483`}, {
         0.49515415676814634`, 1.0938312386180287`}, {0.47274476180871894`, 
         1.0739026367451188`}, {0.4698655619671953, 1.071464479380539}, {
         0.46702004555996923`, 1.0690798770960137`}, {0.4536404010041108, 
         1.058487730005394}, {0.44096692924975056`, 1.0489118766032182`}, {
         0.4321461473048255, 1.0425447200186102`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4289028356975866, 1.040203581445533}, {
         0.4169195267578531, 1.0315535995167868`}, {0.3952682070234308, 
         1.0173830569552231`}, {0.375644334311029, 1.0057097211838373`}, {
         0.3494117728252578, 0.9916853780874347}, {0.32627819463572394`, 
         0.9810325451083372}, {0.2875329755071576, 0.9667420868784828}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.15835384851847598`, 1.15}, {0.15669514705030865`, 
         1.1461833923091225`}, {0.13539906413680314`, 1.1024418188140144`}, {
         0.11627585403237842`, 1.0695165367056698`}, {0.11504589075323436`, 
         1.067589831073578}, {0.11382284153568094`, 1.0656957792390336`}, {
         0.10458553189671052`, 1.0526576520098982`}, {0.09568603931202836, 
         1.041045212427031}, {0.07854945934813243, 1.02014154624044}, {
         0.07383396903479658, 1.015059592004426}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.071113239055923, 1.0121274207300872`}, {
         0.06275686597361266, 1.0031216328349746`}, {0.048447451184437926`, 
         0.9886783150390169}, {0.020739160760685858`, 0.9569300602476112}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.00014192268397389787`}, {0.9970976826360289, 
         0.00017135238686813195`}, {0.9895968025776756, 
         0.00029715692634993824`}, {0.98171899908297, 
         0.0005187516350532289}, {0.9735421797998702, 
         0.0009052603756480775}, {0.9650881723215214, 0.001567504169357043}, {
         0.956170952081101, 0.0027291883677475082`}, {0.9469306884381868, 
         0.004782583882756468}, {0.9372309279753094, 0.008514465252620056}, {
         0.9290959758406295, 0.013406485054182548`}, {0.920297025506648, 
         0.021097784988241206`}, {0.910440170832581, 0.03320602745947679}, {
         0.9049705901618358, 0.04148693029476934}, {0.8990245384590547, 
         0.05168857372191083}, {0.8825637554369804, 0.0855753405427638}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8809312040240925, 0.08922658964144267}, {
         0.8754273452375525, 0.10233384125855728`}, {0.869348116512033, 
         0.11734510654548913`}, {0.8561335005273336, 0.1508749084687261}, {
         0.840622149614644, 0.1916811175931019}, {0.8318935838306057, 
         0.21491660928968892`}, {0.8230820434760994, 0.23839014808615763`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8216672860355857, 0.2421315900153797}, {
         0.8099445490425369, 0.27295503141592803`}, {0.7962991126924709, 
         0.30798668489551484`}, {0.7815235047353125, 0.3451426998420689}, {
         0.7656177251710616, 0.38442307625559036`}, {0.7629053585555875, 
         0.3909440376181454}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7613691657520243, 0.39463728979885015`}, {
         0.7531714157824241, 0.4143459864428346}, {0.7401899810677894, 
         0.44445521827311707`}, {0.7266734210271576, 0.47475077174643776`}, {
         0.7126217356605286, 0.5052326468627967}, {0.6981461082882195, 
         0.5354233071200231}, {0.6956107781596716, 0.5404674175302004}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6938144031152221, 0.5440413560718768}, {
         0.6833577222305477, 0.5648452160159458}, {0.668256577487513, 
         0.5934983735505652}, {0.6528426740591156, 0.6213827797238811}, {
         0.6372538603666917, 0.6481911650917844}, {0.621627984831578, 
         0.6736162602101662}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7190408210908029, 1.15}, {0.6900484410549452, 
         1.1257102921646533`}, {0.6559462969195221, 1.1001149616826336`}, {
         0.6515321955084914, 1.0970180562351386`}, {0.6471634993944606, 
         1.0939947911328038`}, {0.6166864696662518, 1.0748558859324173`}, {
         0.5884120345965925, 1.058510400857696}, {0.5882493064136325, 
         1.0584196871793046`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5847554986388372, 1.056472045725448}, {
         0.5611712206908829, 1.0433248663865953`}, {0.5359976491130729, 
         1.0304592331227365`}, {0.491122572144469, 1.01014250517717}, {
         0.4524448070583384, 0.9950698878318506}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.9261138643383229}, {0.9744571071264322, 
         0.928490613054189}, {0.9391490677627281, 0.9313307147673229}, {
         0.9343737761788004, 0.931685008929863}, {0.9295997550500702, 
         0.9320325436265021}, {0.8875382128516884, 0.9345632601804088}, {
         0.8461274882016467, 0.936731527491431}, {0.8403894078473116, 
         0.9370042744684275}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8363939189371286, 0.9371941912096686}, {
         0.8133175179701355, 0.9382910769650156}, {0.7813627935311989, 
         0.9396108456402774}, {0.7506525077199112, 0.9407840868546217}, {
         0.7210569295912478, 0.9417797161622465}, {0.6915661667050179, 
         0.9427906150363798}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8593541741403856, 1.1477546668160745`}, {
         0.8182609987550158, 1.1180043632318009`}, {0.8128656573298416, 
         1.1144296419719069`}, {0.8075083598772053, 1.1109438481661393`}, {
         0.7701936724899868, 1.0895382511407494`}, {0.7348951889461092, 
         1.0713019951055747`}, {0.7226526484235286, 1.0652536819832754`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7190664319559794, 1.06348194513829}, {0.7006397148801601,
          1.0543783971871918`}, {0.6684702597700687, 1.0400801155023933`}, {
         0.638307066200793, 1.0279645593570002`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.031557558889391796`, 0.3820795506632876}, {
         0.035497737046080016`, 0.40735001735204485`}, {0.03911861139590375, 
         0.4353762085259794}, {0.042138797130245556`, 0.46544695673358427`}, {
         0.044276909440488, 0.49685109452335274`}, {0.045320203899999, 
         0.5285612099519497}, {0.045211571769097424`, 
         0.5412996753908936}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.04517746148116229, 0.5452995299492815}, {
         0.045055936082146475`, 0.5595498910760401}, {0.043430163753079766`, 
         0.588967226461154}, {0.04044704891401388, 0.6154672623325954}, {
         0.0351415627010894, 0.6431840789121855}, {0.034936578416008224`, 
         0.644008945894672}, {0.03473026741104496, 0.6448256573401322}, {
         0.030014819166565447`, 0.6580460007302954}, {0.02527358009212012, 
         0.6675669261195033}, {0.016441654399855288`, 0.6795689577534874}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.3652184501193943}, {0.9964227074100016, 
         0.37271583615374043`}, {0.9806138026746402, 0.4040899239934987}, {
         0.9635655568086006, 0.4360674943204402}, {0.9611866063270222, 
         0.4404138406541455}, {0.9587859096958811, 0.44476552450924167`}, {
         0.9407479834886496, 0.4745870049750446}, {0.9217648792466987, 
         0.5043629721171128}, {0.9216342623961767, 0.5045561437924794}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9193937087865014, 0.5078697399540795}, {
         0.9021230829592908, 0.5334115878270111}, {0.8817270992966718, 
         0.5619601314742183}, {0.8646000523493214, 0.5859901527651109}, {
         0.8471300316036658, 0.6092966879154678}, {0.8293170370597062, 
         0.6318797369252892}, {0.8250474262179579, 0.6370202959339386}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8224917042365398, 0.6400973538069232}, {
         0.8111610687174418, 0.6537392997945749}, {0.7928091603395706, 
         0.674742238645603}, {0.7744083456887906, 0.6947554156006516}, {
         0.7559586247651016, 0.7137788306597204}, {0.7374599975685038, 
         0.7318124838228098}, {0.7115710238373659, 0.7551475404930533}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7085998442687923, 0.7578256166628609}, {
         0.700829031828371, 0.7648298475201454}, {0.6650284559401817, 
         0.7937268497517532}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.088191314713241, 0.2371989117520684}, {
         0.10373454743137869`, 0.2640224358881776}, {0.12007907111866928`, 
         0.29489225883761583`}, {0.13667934406651003`, 0.3296155157516044}, {
         0.15298982456629814`, 0.36799934178136473`}, {0.15785517040585442`, 
         0.3809942829787676}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1592577035267589, 0.38474033434584276`}, {
         0.16857417056869076`, 0.4096238565804077}, {0.18274488948157358`, 
         0.45362368937746106`}, {0.195513020367266, 0.500863606446428}, {
         0.20370928731478322`, 0.5382447039417959}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2045659851220457, 0.5421518856456627}, {
         0.20593349304640776`, 0.5483887429092918}, {0.20655264238367907`, 
         0.5515819297654864}, {0.20716013541857584`, 0.5547705097529702}, {
         0.21306099087505437`, 0.595929909317598}, {0.21697253065938008`, 
         0.6350093116344465}, {0.21995380508492487`, 0.67265763789928}, {
         0.22087139267726033`, 0.7011381562973876}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.22100019816034375`, 0.7051360819029395}, {
         0.2210745487929079, 0.7074438120600838}, {0.22050870668609646`, 
         0.7391239431337476}, {0.2184302236672581, 0.7674541401371622}, {
         0.21049326608817964`, 0.8142867418348857}, {0.19901174668249869`, 
         0.8491684723572945}, {0.19234905500550392`, 0.8607674634143293}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.18910705214246928`, 0.8718206155185741}, {
         0.1859999041037241, 0.8718206155185741}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.05554124180085164, 1.15}, {0.05432049952370678, 
         1.147319322900915}, {0.03801875041256419, 1.1147615475327344`}, {
         0.037036964836661426`, 1.1128597977819796`}, {0.03607149036620969, 
         1.110990089512091}, {0.028816683658047203`, 1.096662079647328}, {
         0.022698607690604236`, 1.0838926578208474`}, {0.012764615621974692`, 
         1.0606354704111634`}, {0.006837806628787617, 1.040838402256638}, {
         0.0036331671919814005`, 1.0227843210125929`}, {0.001981628757391586, 
         1.0057988469339247`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2519451646037696, 1.15}, {0.24247705730409722`, 
         1.129984629705707}, {0.24080458867699572`, 1.1266115742125709`}, {
         0.23915130521359995`, 1.123312113096794}, {0.23057018540823168`, 
         1.1072521882894928`}, {0.22243311604272542`, 1.0928426628697194`}, {
         0.20692941960305225`, 1.066872070235895}, {0.19278207872588368`, 
         1.0458919643723863`}, {0.17967083023655667`, 1.0287023635104413`}, {
         0.16699080910788458`, 1.0152644201403953`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.16122855979716316`, 0.9986470943296095}, {
         0.15131072796894535`, 0.9986470943296095}}]}}}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1gk0lekfB3A11QhRWYpINVq0WCLSlC8SIilr2yhryogwUpQkKVGKZI2Q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         "]]},
       Annotation[#, "Charting`Private`Tag$157940#1"]& ], 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
        LineBox[CompressedData["
1:eJw91gkw1lvcB3C0IF1LF6WIEuVe5KaI4ltUJJQiaRHZQqTlupQSeVQiS9Yi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         "]]},
       Annotation[#, "Charting`Private`Tag$157940#2"]& ]}, {}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
        0.3]], LineBox[CompressedData["
1:eJwUl3c4lf8bxxHfpEJKISMtInsk4U1W9h5ZITTslSg7KkmFEMXJSnapVKJE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         "]]},
       Annotation[#, "Charting`Private`Tag$159697#1"]& ]}, {}}},
   AspectRatio->1,
   DisplayFunction->Identity,
   Frame->True,
   FrameLabel->{
     FormBox["\"A\"", TraditionalForm], 
     FormBox["\"H\"", TraditionalForm]},
   FrameStyle->Directive[FontFamily -> "Arial", 18],
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   Method->{
    "VectorLengthFunction" -> 
     Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
       System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`imin = If[
          NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
          Min[System`VectorPlotsDump`m], 
          Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
          NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
          Max[System`VectorPlotsDump`m], 
          Max[System`VectorPlotsDump`m]]; Map[If[
          
          Or[# > System`VectorPlotsDump`imax, # < 
           System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
         System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "TransparentPolygonMesh" -> True},
   PlotRange->{{0, 1}, {0, 1.15}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.02]}},
   Ticks->{Automatic, Automatic}],
  DynamicModuleValues:>{}]], "Output",
 CellChangeTimes->{
  3.903100911723544*^9, {3.903127290194516*^9, 3.903127305790752*^9}, 
   3.903127955533687*^9, 3.903129162965871*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"67fde18a-c53f-46e6-8f52-1fa95bca0fda"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A0", "=", "0.8`"}], ",", 
     RowBox[{"R", "=", "0.92`"}], ",", 
     RowBox[{"g", "=", "2"}], ",", 
     RowBox[{"Hmax", "=", "1.15`"}], ",", 
     RowBox[{"k", "=", "5"}], ",", 
     RowBox[{"m", "=", "0.03`"}], ",", 
     RowBox[{"point", "=", 
      RowBox[{"{", 
       RowBox[{"0.029`", ",", "0.434`"}], "}"}]}], ",", 
     RowBox[{"r", "=", "8"}], ",", 
     RowBox[{"s", "=", "6"}], ",", 
     RowBox[{"\[Gamma]", "=", "0.8`"}], ",", 
     RowBox[{"rc", "=", "2"}]}], "}"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"algaefun$", "=", 
        RowBox[{
         RowBox[{"\[Gamma]", " ", 
          RowBox[{"A", "[", "t", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox[
             RowBox[{"A", "[", "t", "]"}], 
             RowBox[{"A0", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"R", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "rc"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}]}], ")"}]}]]}]]}], 
           ")"}]}], "-", 
         FractionBox[
          RowBox[{"g", " ", 
           RowBox[{"A", "[", "t", "]"}], " ", 
           RowBox[{"H", "[", "t", "]"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]]}]}], ",", 
       RowBox[{"herbfun$", "=", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", " ", 
             RowBox[{"A", "[", "t", "]"}], " ", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"H", "[", "t", "]"}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "A0"}], ")"}], " ", "k"}]]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]], "-", 
         RowBox[{"m", " ", 
          RowBox[{"H", "[", "t", "]"}]}]}]}]}], "}"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"VectorPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"algaefun$", ",", "herbfun$"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"H", "[", "t", "]"}], ",", "0", ",", "Hmax"}], "}"}], ",", 
         
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"VectorColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"VectorStyle", "\[Rule]", "Gray"}], ",", 
         RowBox[{"VectorPoints", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamPoints", "\[Rule]", "Coarse"}], ",", 
         RowBox[{"StreamColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.85`", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.035`", "]"}], ",", "Thick"}], 
           "}"}]}], ",", 
         RowBox[{"StreamScale", "\[Rule]", "Large"}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<A\>\"", ",", "\"\<H\>\""}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", "18"}], 
           "]"}]}]}], "]"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"algaefun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "1", "\[RightDoubleBracket]"}]}], ",", 
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"herbfun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "2", "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "Hmax"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black", ",", 
              RowBox[{"Dashing", "[", ".03", "]"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"A0", ",", "Thick"}], "}"}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLinesStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"Dashing", "[", "0.05`", "]"}], ",", "Thick"}], "}"}], 
            ",", 
            RowBox[{"{", "}"}]}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"First", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"A", "[", "t", "]"}], ",", 
              RowBox[{"H", "[", "t", "]"}]}], "}"}], "/.", "\[VeryThinSpace]", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  SuperscriptBox["A", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "algaefun$"}], ",", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["H", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "herbfun$"}], ",", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"A", "[", "0", "]"}], ",", 
                    RowBox[{"H", "[", "0", "]"}]}], "}"}], "\[Equal]", 
                  "point"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "H"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]}], "]"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.903100801310251*^9, {3.9031273206937943`*^9, 3.9031273510555887`*^9}, {
   3.903127442967863*^9, 3.903127443131947*^9}, {3.9031277143214006`*^9, 
   3.903127716672637*^9}, {3.903129152567663*^9, 3.903129154008666*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"b48511da-8960-4c5a-8927-ac2ec64b4e31"],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`A0$$ = 0.8, $CellContext`R$$ = 
  0.92, $CellContext`g$$ = 2, $CellContext`Hmax$$ = 1.15, $CellContext`k$$ = 
  5, $CellContext`m$$ = 0.03, $CellContext`point$$ = {0.029, 
  0.434}, $CellContext`r$$ = 8, $CellContext`s$$ = 
  6, $CellContext`\[Gamma]$$ = 0.8, $CellContext`rc$$ = 2}, 
  GraphicsBox[{{{}, {
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.005315180259893875, 0.05755118502610765}, {
         0.009253754587488863, 0.05840574958364356}, {0.016370375073678525`, 
         0.0609785752395866}, {0.028803134761993244`, 0.06636302282993478}, {
         0.053010315051178904`, 0.07770799529403206}, {0.09466376845094, 
         0.09847581472431756}, {0.12425765507992212`, 0.11418316931239039`}, {
         0.14865974365042334`, 0.12806082177891087`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1521367844190754, 0.13003824118134713`}, {
         0.1599378318547599, 0.13447475590321162`}, {0.17990280082841412`, 
         0.1466053545174627}, {0.20120036847637957`, 0.16020087311377262`}, {
         0.22345991901214995`, 0.1752829406951391}, {0.2463108366492189, 
         0.19187318626455974`}, {0.2760296445461572, 0.21558976259231932`}, {
         0.2829512159782154, 0.2217245443905069}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.28594465685093134`, 0.22437771452104008`}, {
         0.3058495418315339, 0.2420199692131521}, {0.3351485153210076, 
         0.2710984463619623}, {0.36330455183023674`, 0.30275983427365394`}, {
         0.3898353270178829, 0.3367432423166446}, {0.39355968297816624`, 
         0.3422397679893843}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.39580344847724896`, 0.3455511900985583}, {
         0.41425851654260754`, 0.3727877798593517}, {0.4363463164276536, 
         0.4105754218659062}, {0.4558010146849347, 0.4495188239708809}, {
         0.46859958717770617`, 0.4790677798611667}, {0.4712997078902921, 
         0.4861678660757577}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.472721539629453, 0.4899066351921267}, {
         0.47986892854918084`, 0.508701008829844}, {0.48964785181892806`, 
         0.5381699484789161}, {0.4979751700065175, 0.5672260364103864}, {
         0.4989998462268385, 0.5711149401586452}, {0.4999993118585184, 
         0.5749917606218528}, {0.5079184844627271, 0.6147726369262214}, {
         0.5123620734002896, 0.644472934211557}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5129539428953563, 0.6484289031827207}, {
         0.5135326731031374, 0.6522970510831271}, {0.5181334132141361, 
         0.6884026284699597}, {0.5207072562663115, 0.7216705323166468}, {
         0.5215571972751283, 0.7519689790059109}, {0.5209862312560516, 
         0.7791661849204752}, {0.5182190440616476, 0.8078433778755741}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5178348511442498, 0.8118248846006999}, {
         0.5166024802937436, 0.8245963142834022}, {0.5098469554205088, 
         0.8581851131811045}, {0.5014703659046529, 0.8831291656567161}, {
         0.4829984695442805, 0.9139570361389971}, {0.4656828608938726, 
         0.92930708233566}, {0.45348891696877963`, 0.9362945802006839}, {
         0.44315373522107315`, 0.9406613943660665}, {0.44099471440144283`, 
         0.941268044770384}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4371438438283965, 0.9423500779628718}, {
         0.43428810473678353`, 0.9431524950858566}, {0.4269112735335155, 
         0.9444448820531242}, {0.4205741042917906, 0.9451371420273712}, {
         0.41512926390729454`, 0.9454962908278867}, {0.41040315750307815`, 
         0.9456648234478999}, {0.4063240292493229, 0.9457231538348787}, {
         0.4027920053989766, 0.9457219946009322}, {0.3979908454307735, 
         0.9456583373884356}, {0.39414436023717564`, 0.945565710873157}, {
         0.39104213508205493`, 0.9454825986151288}, {0.38644551986863024`, 
         0.9453627017937808}, {0.38338142573177797`, 0.9452805476229514}, {
         0.38128807368524203`, 0.9452131082959411}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0012485535472057541`, 0.0019363574419383924`}, {
         0.002079759749410058, 0.0019095332242724634`}, {
         0.0037184635600041945`, 0.0018976191925662955`}, {
         0.007367205051851271, 0.0019208623204036294`}, {
         0.016177776058389666`, 0.0020205075282379898`}, {0.03149051638942077,
          0.002227170284528127}, {0.061166842404928416`, 
         0.0026658583309231033`}, {0.08540916962016178, 
         0.0030211914095529184`}, {0.11726588368895359`, 
         0.003517818895600946}, {0.15209120132918633`, 0.00414117741646965}, {
         0.16122897973583986`, 0.004321050889195625}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.16522820499437332`, 0.004399774021170686}, {
         0.19320012622796473`, 0.004950389979141391}, {0.23953501141086506`, 
         0.00599306365477582}, {0.29003820990346385`, 0.007316805514532598}, {
         0.3163785391140037, 0.008094879512852182}, {0.3251774575317451, 
         0.008384456976941405}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3291752930779486, 0.008516028043333054}, {
         0.34281217159817484`, 0.008964825555992971}, {0.3693391073559777, 
         0.009926643643954973}, {0.39595934638741204`, 0.01098033377673819}, {
         0.4300475942901762, 0.012560742022280687`}, {0.4626481511269155, 
         0.014429319815652963`}, {0.48897632891509246`, 
         0.01625439204981514}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.49296675285715336`, 0.016531008684577526`}, {
         0.49376101689762975`, 0.016586067156855008`}, {0.5233861916023189, 
         0.01903098404588682}, {0.5511649278522698, 0.021903257251945543`}, {
         0.5767384782587688, 0.025342073544228325`}, {0.6212700215414114, 
         0.033919335387466054`}, {0.6501795144732179, 0.04331287784508883}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6539837297562421, 0.044548979006161414`}, {
         0.6574024066927139, 0.04565980744674994}, {0.6855572189551433, 
         0.06146052759322994}, {0.7066496921288792, 0.0823520454747033}, {
         0.7214033290723582, 0.10954149407049109`}, {0.7305905392099711, 
         0.14426225396136128`}, {0.7332791274110022, 0.16475444942484024`}, {
         0.7337404437667153, 0.17165350183796582`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7340073143265253, 0.17564458942210961`}, {
         0.7347986104577926, 0.18747853681267546`}, {0.7348670039192392, 
         0.2308026067479722}, {0.7319839323393835, 0.28039541968188686`}, {
         0.7316936290847007, 0.2839414349689012}, {0.7313908128922378, 
         0.2875131194924334}, {0.7269667270713063, 0.3266680945695409}, {
         0.7258116507089605, 0.335182563397923}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7252739344932893, 0.3391462562810062}, {
         0.7213849861887637, 0.3678130442038631}, {0.7152719059359195, 
         0.4094618448291692}, {0.7080961469424722, 0.45211834743644286`}, {
         0.6999714011034299, 0.4950837135225799}, {0.6995609785980051, 
         0.49703391654947754`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6987372183389694, 0.5009481749767705}, {
         0.6910113603138004, 0.5376591045844762}, {0.6813457180764184, 
         0.5791987286480502}, {0.6711041678941188, 0.6190567937392208}, {
         0.6605184400272874, 0.6562629660853445}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6594238206752066, 0.6601102779357213}, {
         0.6583690781874828, 0.6638174326323755}, {0.6451478210714563, 
         0.7054920896934658}, {0.631686551077056, 0.7431258698970049}, {
         0.6182314227352984, 0.7757638782175059}, {0.6018322901607757, 
         0.8091013015203038}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.600066692638718, 0.812690544531038}, {0.5990748029642207,
          0.8147069344710622}, {0.5806832585283863, 0.8456258654583961}, {
         0.5634358106491619, 0.8697090857623327}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.007991959384349424, 0.18737918942632123`}, {
         0.014665332619929012`, 0.19575462102647093`}, {0.02404284485226666, 
         0.21125452873000952`}, {0.038937399713556094`, 0.2389435150658879}, {
         0.06122684095593691, 0.2836717671747492}, {0.07289826755292106, 
         0.30815402451768015`}, {0.08242433440296044, 
         0.3286901142122216}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.08410753724805241, 0.33231872664430556`}, {
         0.08603590995585036, 0.33647587098469833`}, {0.10049582118279327`, 
         0.3685355646087313}, {0.11613405425181815`, 0.4042313634227067}, {
         0.13264560636247988`, 0.44301681653391284`}, {0.14758808292033565`, 
         0.4791735636722408}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14911583691098265`, 0.4828703146435752}, {
         0.14972547471433337`, 0.48434547304963804`}, {0.16271516849528453`, 
         0.5165533981459839}, {0.17564170031914506`, 0.5492853488098967}, {
         0.18834798379382292`, 0.5820806167619507}, {0.20067693252722205`, 
         0.6144784937227098}, {0.20721354110163237`, 0.6319432947316374}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2086156478211007, 0.6356895057170494}, {
         0.21654686226824882`, 0.6568804766160631}, {0.23125509095513763`, 
         0.6968167623647062}, {0.23220817584001271`, 0.6994278385706469}, {
         0.23315513625933992`, 0.7020239606184527}, {0.24504513044513235`, 
         0.734840650937636}, {0.2557820553010721, 0.7644832403115248}, {
         0.26358919265807296`, 0.7859478138198195}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2649564491854812, 0.7897068841288533}, {
         0.2659399685095208, 0.7924109255543246}, {0.2749398584229873, 
         0.8169088025349469}, {0.28983109174382177`, 0.8563128613966663}, {
         0.30125887971686544`, 0.8846031461851092}, {0.31449650596901896`, 
         0.9130841577407179}, {0.3234564871128151, 0.9275012763716008}, {
         0.3301634417189963, 0.9348833727408711}, {0.330189687019687, 
         0.9349037920307228}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.33334672987062647`, 0.9373600250077289}, {
         0.3348252909022445, 0.9385103706114623}, {0.3389257158870297, 
         0.9408672338505835}, {0.3425447636272148, 0.9422686193013112}, {
         0.3456662295911617, 0.9430537018483448}, {0.34850786694327657`, 
         0.9435411099190769}, {0.35110961976304056`, 
         0.9438597813869771}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.9610126159531893}, {0.9990345385026703, 
         0.9609913329662609}, {0.9696328557403904, 0.9603346581097962}, {
         0.9420927242886611, 0.9597135144087203}, {0.8925971153168553, 
         0.9585778204727349}, {0.8494558297844842, 0.957566573004141}, {
         0.8400421321409274, 0.9573417907136108}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8360432719917645, 0.9572463050736557}, {
         0.8115769858887797, 0.9566620938487753}, {0.8068257181795436, 
         0.9565473689444552}, {0.8021542448459915, 0.9564343176472644}, {
         0.7703943048437545, 0.9556538724170947}, {0.7421029252912291, 
         0.9549499109362772}, {0.6914174176477923, 0.9536750408376361}, {
         0.676092428825847, 0.9532813802130061}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6720937478682476, 0.9531786641026224}, {
         0.6509226576300524, 0.9526348317576792}, {0.6179437514796188, 
         0.9517752291963395}, {0.568227157039481, 0.9504614056519424}, {
         0.5325904038976028, 0.9495064067842274}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9587219655338541, 0.6837119705762049}, {
         0.9159887583189529, 0.7090923473269792}, {0.8779326543830237, 
         0.7327505788633747}, {0.8438185189281922, 0.754643532371413}, {
         0.8394871580697053, 0.7574747188103694}, {0.8352166076158347, 
         0.7602738284143594}, {0.8230011686270816, 0.7684008331922664}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8196708774961272, 0.7706164958432777}, {
         0.8045387780725398, 0.7806839722907871}, {0.7767921762087373, 
         0.7992169157279356}, {0.7503048503493142, 0.8168345400111245}, {
         0.7263360764986495, 0.8326215259863946}, {0.6859410222097616, 
         0.8584491216519179}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6825319729436888, 0.8605408285562286}, {
         0.6498442166506991, 0.880122882526079}, {0.6195722245058977, 
         0.8966699472417003}, {0.5938086869298481, 0.9092379665392357}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20192105761486553`, 0.050400212455347364`}, {
         0.2310241098935508, 0.05675524257666449}, {0.2617353422197898, 
         0.06412907248073081}, {0.29353722744135663`, 0.07265598098840816}, {
         0.3259122384060253, 0.08247024692055831}, {0.35601880242412554`, 
         0.09293071973305797}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3597698655751084, 0.09431647520388836}, {
         0.3901238575859159, 0.10656098496121579`}, {0.4210165189046342, 
         0.12109513000762809`}, {0.4503893615408025, 0.13749840974408714`}, {
         0.47364199171441806`, 0.15292380230558578`}, {0.4952681246792671, 
         0.1698902578392325}, {0.49827342403403857`, 0.17267134016004274`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5012092469100002, 0.17538812944907123`}, {
         0.51526776043535, 0.1883977763450274}, {0.5336408989826664, 
         0.20844635782297039`}, {0.5360070942687994, 0.21125173343278475`}, {
         0.5383405530325152, 0.21408588890658006`}, {0.5544914429346451, 
         0.2385092023620219}, {0.5686397587884312, 0.2647085000225044}, {
         0.5817938752090792, 0.2916812177555716}, {0.5880808190068137, 
         0.30773937583127114`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5895390835408124, 0.3114640858265435}, {
         0.5929595927634507, 0.3202007756338083}, {0.6022166434595903, 
         0.35007091034389287`}, {0.6096447593055423, 0.38109535857250376`}, {
         0.615349772969884, 0.4130015563160257}, {0.6194375171211925, 
         0.4455169395708434}, {0.621121877526172, 0.4677141740268536}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6214245336014829, 0.4717027075042206}, {
         0.6220549048110638, 0.4800100136437039}, {0.6231548993061511, 
         0.5145225065823292}, {0.6229027866713545, 0.5486303781792066}, {
         0.6214638529715736, 0.5819095882268223}, {0.6189723371386794, 
         0.6140910179269589}, {0.6170495608165953, 0.631426664453936}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6163438594696852, 0.6426071307291656}, {
         0.6158094838578031, 0.6426071307291656}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20151070995072387`, 1.15}, {0.19687629648458113`, 
         1.1302868914489757`}, {0.1870570074596501, 1.0933643484661766`}, {
         0.17830845850066812`, 1.0642911839211286`}, {0.17039432484347358`, 
         1.0416069838616109`}, {0.1629774239798851, 1.023281831290051}, {
         0.1539782868639582, 1.0046739025079847`}, {0.15031362738163317`, 
         0.9990428676470912}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14813179641385496`, 0.9956903143472846}, {
         0.1377579866428213, 0.9797501472614446}, {0.13721180560984406`, 
         0.9790813431095936}, {0.1366650579103053, 0.9784211931769761}, {
         0.1257255138608266, 0.968141120356546}, {0.11420697215926141`, 
         0.9596228486068679}, {0.08997270853501137, 0.9449036790634745}, {
         0.0638946167183734, 0.9328023557838603}, {0.038565179065588276`, 
         0.9197282096826157}, {0.02151979395719923, 0.9023880592010154}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.018715716170643684`, 0.8995354905748566}, {
         0.014501586045115849`, 0.895248485613629}, {0.010760229451103224`, 
         0.887676175449977}, {0.007767559400176594, 0.8797326562899801}, {
         0.005542252678650447, 0.8712967267694348}, {0.0030205281638741735`, 
         0.8556358133631217}, {0.0016794965022389672`, 0.8392465480424747}, {
         0.0009606639652322169, 0.822587323237586}, {0.000582868009676899, 
         0.8074007025699049}, {0.0003532419386694125, 0.7923259128024964}, {
         0.00021676599979087268`, 0.7774132100885689}, {
         0.00013749926751834636`, 0.763141808408893}, {0.00008856365235617128,
          0.749085896166136}, {0.00007561935766867175, 0.7432467641908352}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.00006675210620978785, 0.7392467740193659}, {
         0.00005791087142462761, 0.7352585198903073}, {0.00003823696132192895,
          0.7214626555493651}, {0.000025674305940201902`, 
         0.7079119369607114}, {0.000017523084181695026`, 
         0.6946066231647166}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.982420449767751, 0.42304115961063726`}, {
         0.9452713410993222, 0.4552441352262494}, {0.9118889543784554, 
         0.4875268052120116}, {0.8816403251458672, 0.5195956280755437}, {
         0.8777797012494438, 0.5238977668962438}, {0.8739666767523326, 
         0.5281904245278117}, {0.8683358704795866, 0.5349420768125693}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8657739437201243, 0.538013970573615}, {
         0.8571010120403727, 0.5484133017092934}, {0.8411201762929797, 
         0.5683277511162922}, {0.8113555020038121, 0.6067292906028515}, {
         0.7828879831687156, 0.6439514415027064}, {0.7677040929072172, 
         0.6644112794285824}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7653202991395147, 0.6676233702232305}, {
         0.7570147752417615, 0.678814815229153}, {0.7333694789238316, 
         0.7111161746685053}, {0.711585694915808, 0.7406522827070778}, {
         0.6914540053565984, 0.7674160651513953}, {0.6727649923851106, 
         0.7914004478079821}, {0.6693357615712766, 0.795618189175829}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6668123646838165, 0.7987218109550343}, {
         0.6559223332063445, 0.8121158747416993}, {0.6401107941231521, 
         0.8306055929896448}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.0726354132149987}, {0.9797407828781172, 
         0.07952260995481178}, {0.9549158525480289, 0.09009910330778362}, {
         0.9329131476655398, 0.10189030153809975`}, {0.8957123717678481, 
         0.1294802984284502}, {0.8934724692892321, 0.13152900585319185`}, {
         0.891262491749183, 0.13360446839081494`}, {0.875259403446674, 
         0.1523535054427732}, {0.8696798258312124, 0.16019313408533223`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.867360424831514, 0.16345202638220216`}, {
         0.8605154595659482, 0.17306959772031713`}, {0.8462821234542818, 
         0.19474561596022616`}, {0.8330700028807341, 0.21834148612486542`}, {
         0.8206669885374103, 0.2438108954422311}, {0.8088609711164154, 
         0.27110753114031944`}, {0.7975064650358004, 0.30008992637906823`}, {
         0.7954562131516919, 0.30575472349488214`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7940949157064472, 0.3095159559080109}, {
         0.786457984713616, 0.33061661431841527`}, {0.7752090877410085, 
         0.36347973196771827`}, {0.7640754989392153, 0.3971096199262486}, {
         0.7530572183082368, 0.4315062781940062}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.010808276982210856`, 0.11366037247768163`}, {
         0.020142352714313867`, 0.12088660628891897`}, {0.03831805854841904, 
         0.13782970790516683`}, {0.07129924115738799, 0.1714705160801383}, {
         0.10227610379375068`, 0.2049405778298005}, {0.1209381192176681, 
         0.22602632857039046`}, {0.12254369055919041`, 
         0.22790770489640147`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12514028949147515`, 0.2309503474953371}, {
         0.1416432419519349, 0.2502881765070059}, {0.1640932730095261, 
         0.27776634545055506`}, {0.1879900134034168, 0.30850105921194615`}, {
         0.2129744696276323, 0.3423733454932403}, {0.2232636671864492, 
         0.3572314167545538}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.22554093207244374`, 0.36051989127004214`}, {
         0.23838943009657645`, 0.37907370930610684`}, {0.2548150545586289, 
         0.4041800998455383}, {0.271004925910955, 0.4301317312874976}, {
         0.2867344592702193, 0.45660981709109205`}, {0.30193191984725465`, 
         0.4835436113581864}, {0.309068342760124, 0.49687180030233513`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.31095647218867845`, 0.5003981251967581}, {
         0.3164820807158255, 0.5107179108064934}, {0.33026971494969654`, 
         0.5379175121537259}, {0.33207642589527364`, 0.5415847741133107}, {
         0.3338675634079674, 0.5452482424061782}, {0.3529708271870995, 
         0.5883965603702987}, {0.3696080059927753, 0.62963968167688}, {
         0.37608670026906105`, 0.6464043931235386}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3775285722467407, 0.6501354794532799}, {
         0.38499970858582233`, 0.6694683017106617}, {0.39790045875361185`, 
         0.7064679191988444}, {0.40847512567913086`, 0.7403296763308033}, {
         0.4168885785453667, 0.7707447152959137}, {0.42338225282528275`, 
         0.7977319365258512}, {0.4244428304031802, 0.8029250623160135}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.42524321815427646`, 0.8068441667351244}, {
         0.4281975839918426, 0.8213102404522915}, {0.43389497343678224`, 
         0.8583760659140905}, {0.435638319483246, 0.8851358444138618}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5084437047157727, 1.15}, {0.5084082398563076, 
         1.1499096270012632`}, {0.4966495442941996, 1.1210179386134094`}, {
         0.47757030346417173`, 1.0765273957852795`}, {0.4764562395541205, 
         1.0740285357264014`}, {0.4753615853236102, 1.0715841224715434`}, {
         0.4675894068941483, 1.0548248077532298`}, {0.46073041756606903`, 
         1.0405061004615592`}, {0.44858253639245144`, 1.0159623093994508`}, {
         0.4423775210294151, 1.0043675439471538`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.44017942063371573`, 0.9988531814380165}, {
         0.43942647348754615`, 0.9988531814380165}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.05953258930189595, 0.3943212217418805}, {
         0.06727534276680903, 0.4229818389785769}, {0.07526788189609397, 
         0.45401558343865117`}, {0.0832898865022923, 0.4867148634671308}, {
         0.09187610779047584, 0.5238778152115671}, {0.09744865734566155, 
         0.549738882837567}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.09829123905668165, 0.553649132965149}, {
         0.10011514225208229`, 0.5621134962538773}, {0.10777765973876421`, 
         0.6005275804594795}, {0.1146343301021741, 0.6382257416937916}, {
         0.12053148832716866`, 0.6744293332377406}, {0.1253154693986046, 
         0.708359708372253}, {0.125649267090357, 0.7112476285742266}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12610854580668424`, 0.7152211739760974}, {
         0.1289307504481261, 0.7396380648039977}, {0.13131677058289865`, 
         0.7677748464130109}, {0.13256255135097403`, 0.809267445155387}, {
         0.132541855818284, 0.8104975996618802}, {0.1325170429776696, 
         0.8117165995871446}, {0.13093163395580895`, 0.829170431492371}, {
         0.12826443949204624`, 0.8440066034945735}, {0.12083108918145567`, 
         0.8688435464833847}, {0.11812380428111145`, 0.8726815356610075}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.11581814248410424`, 0.8759501628465124}, {
         0.10934594638736946`, 0.8851254877528649}, {0.09411271843762375, 
         0.8947983609935394}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7000126704838011, 1.15}, {0.6838336115890866, 
         1.1320976739693713`}, {0.6586450846038822, 1.1055432289330769`}, {
         0.636622003370999, 1.0833105790749387`}, {0.6338650217120669, 
         1.080603314754877}, {0.6311554224393783, 1.0779581094333726`}, {
         0.61784443825854, 1.0653922723309794`}, {0.6056118901946339, 
         1.054171678525248}, {0.5866315597678032, 1.0372618364643753`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5836449276738833, 1.034601004125507}, {
         0.5830615363272608, 1.0340812526085827`}, {0.5639392353538721, 
         1.018120063193045}, {0.5475481278100937, 1.0053128446293857`}, {
         0.5139329723823047, 0.9819578791797015}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.24670206981448267`}, {0.9668903226725137, 
         0.27222877905708176`}, {0.9369235729742608, 0.29947376532990533`}, {
         0.9331234770762282, 0.3032396360675635}, {0.9293751200344278, 
         0.3070294655705617}, {0.8995586752643364, 0.34279975464595247`}, {
         0.887502022631277, 0.35931027779952524`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8851430698324312, 0.36254065574843736`}, {
         0.8724526471454956, 0.37991907113271683`}, {0.8464655667751125, 
         0.4173551069733554}, {0.8227163819016448, 0.45542458152174253`}, {
         0.8008166273972714, 0.4936398634532358}, {0.7989197684118947, 
         0.49715477855758794`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7970200995309986, 0.5006749004507836}, {
         0.7803778381341718, 0.5315133214431931}, {0.7611818854213926, 
         0.5685941048663276}, {0.7430106405679806, 0.6044313630973523}, {
         0.727282603884666, 0.6360545448080503}, {0.7238610773382753, 
         0.6429562809397394}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.71984260284645, 0.661751162839457}, {0.7145435395290713, 
         0.661751162839457}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9106584515354561, 1.138962939886078}, {
         0.8842316930004651, 1.1242654674754922`}, {0.859586581261107, 
         1.110754818570249}, {0.8156412981692903, 1.0872939912757913`}, {
         0.8102031694842006, 1.0844542401538888`}, {0.8048699729403089, 
         1.0816817471567277`}, {0.7751971668793955, 1.066679417672204}, {
         0.7694172055234665, 1.0638291964680762`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7658296800143823, 1.0620601117551045`}, {
         0.7485852871023686, 1.053556536851491}, {0.7232920147120079, 
         1.041236463679511}, {0.7006359570949796, 1.030522005804997}, {
         0.6618764759475498, 1.0129967422366057`}, {0.6300155855455457, 
         0.9994647919408818}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3548639334195923, 1.15}, {0.3514093567415543, 
         1.132924743954166}, {0.3463575283083049, 1.1078248262546373`}, {
         0.3385608764661015, 1.0683754369161496`}, {0.33812552342029223`, 
         1.066126724314788}, {0.3377004344010081, 1.0639235940785507`}, {
         0.3342640144104573, 1.045383402859212}, {0.331543228940178, 
         1.0299136046501962`}, {0.3273157001163407, 
         1.0040327656713743`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.98799790396016, 0.824318591479259}, {0.9614942481179388, 
         0.8316762381173142}, {0.936810675780761, 0.8386330515134828}, {
         0.930409626883344, 0.8404522186739751}, {0.9241189186025389, 
         0.8422443618024801}, {0.8875988118317715, 0.8527751773403117}, {
         0.8546121578861683, 0.8623364803435737}, {0.8341517017416165, 
         0.8682604132683472}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.830309503337386, 0.8693728481754446}, {0.823159585254092,
          0.8714429699187634}, {0.7947751752490704, 0.879639832637809}, {
         0.769087895416055, 0.8870045624133035}, {0.745726713299999, 
         0.893614653157841}, {0.7049362468335371, 0.9048395290745207}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0929929916126462, 1.15}, {0.08465544086542066, 
         1.129188889324418}, {0.06799622400325998, 1.094812441606252}, {
         0.06691948749536304, 1.0927914885687215`}, {0.06584935729814786, 
         1.0908036081796302`}, {0.05759503966567307, 1.0766281568576337`}, {
         0.04983803486265575, 1.0639759397921107`}, {0.03555760535242913, 
         1.0410533100229193`}, {0.023946006858832095`, 1.0219973701141807`}, {
         0.017351111103734863`, 1.0093465235213266`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.015502069422566859`, 1.0057995466590812`}, {
         0.015230496160272774`, 1.005278593514773}, {0.01120531082407512, 
         0.9955492963137371}, {0.008125633433769772, 0.986131329123122}, {
         0.00583077643966174, 0.9769056723652565}, {0.0029774950959918253`, 
         0.9590449288488035}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.006302186789323222}, {0.9763186813487597, 
         0.007058565446987368}, {0.9395632300874686, 0.008951110183311139}, {
         0.9107426959453558, 0.011370674439836477`}, {0.8877517998015447, 
         0.014446380725209634`}, {0.8696110189244511, 
         0.018289963664117455`}, {0.8549042910061472, 0.02313137490482253}, {
         0.8430902000950558, 0.0293658798749722}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8396698556350507, 0.03138787993248829}, {
         0.8197743277343238, 0.05224988782516116}, {0.8192042924307237, 
         0.05314776669384465}, {0.8186393176612913, 0.05406010015245548}, {
         0.8123444207794711, 0.06769107826457589}, {0.8073008399563562, 
         0.08108665253248365}, {0.8023153310322116, 0.09678242955499847}, {
         0.7922327406150529, 0.1331781535596479}, {0.7821204964583194, 
         0.17751190476894613`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.46117955810874717`, 0.05820431729167524}, {
         0.4916243371702479, 0.06707287426709359}, {0.5200699079889889, 
         0.07723389963090872}, {0.5462154155811227, 0.08886835678829003}, {
         0.5843690372017607, 0.11216168713540742`}, {0.6026262023403438, 
         0.12889363057348704`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6055751239126215, 0.1315961963100706}, {
         0.6156048921399314, 0.14078806774260458`}, {0.6174778564173722, 
         0.1428981067862283}, {0.6193200097083341, 0.14503499942772602`}, {
         0.6315979421531425, 0.16351929672002363`}, {0.6421715258003791, 
         0.18380383400037223`}, {0.6600057315588962, 0.22788203627404235`}, {
         0.6665188983494831, 0.2525050559729904}, {0.6707703258104645, 
         0.2747707318450771}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6715205359700457, 0.2786997501342253}, {
         0.6715371544986826, 0.2787867850831914}, {0.6751420751934727, 
         0.306597780268812}, {0.6774152356208312, 0.3358085981940189}, {
         0.6785470049180533, 0.36937822832648587`}, {0.6783759720620013, 
         0.4037191970236979}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9632506062820955, 0.578361567988282}, {
         0.9576157758986554, 0.5825292403308685}, {0.95206688121142, 
         0.5866778085835272}, {0.9154944638125696, 0.6160820964212395}, {
         0.8823573305616552, 0.6441480976990258}, {0.850699900636691, 
         0.6714306296247068}, {0.8403337502867646, 0.6807194821402569}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8373547673842577, 0.6833888754920452}, {
         0.8220018773636277, 0.6971462228461772}, {0.7958824896717844, 
         0.7212336791378716}, {0.771960966490481, 0.7436318002742249}, {
         0.749984957854487, 0.7643468767128212}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.23345260624243847`, 0.10840046778514222`}, {
         0.263760101048499, 0.12225747722586919`}, {0.29486790445744504`, 
         0.1380797346226339}, {0.32632914389717016`, 0.155978233996493}, {
         0.35739556568161396`, 0.17612142058722574`}, {0.37232158480418337`, 
         0.1871408785375827}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3755396097344574, 0.18951665536803944`}, {
         0.38166100699906863`, 0.19403590991279726`}, {0.4050177306739598, 
         0.2135054125833491}, {0.42724622246488786`, 0.23452601397023926`}, {
         0.44812696813045316`, 0.2570937994448258}, {0.4508484051586081, 
         0.26023738778307}, {0.45354218794753387`, 0.263408141370796}, {
         0.47361122208673956`, 0.2916786212715149}, {0.48270860662659143`, 
         0.30681068273417783`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.48476961189201084`, 0.3102388392790155}, {
         0.4916033883537257, 0.3216057464365371}, {0.5085172020898356, 
         0.3521724851107736}, {0.5232743107641934, 0.38401845080343877`}, {
         0.5359134575735687, 0.41684065955125066`}, {0.5464733857147314, 
         0.45033612739092743`}, {0.5480507683751632, 0.45655054874996653`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5490348661961311, 0.46042760323485143`}, {
         0.555056493069509, 0.484151032936963}, {0.5617651775197295, 
         0.5179315548038511}, {0.5669377461867247, 0.5536382248926459}, {
         0.570311072290544, 0.5886428327862407}, {0.5718647716075591, 
         0.6184402352225573}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5720731376789522, 0.6224394522191699}, {
         0.5720732992042016, 0.6224394522191699}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9758885438793296, 1.0605240777890823`}, {
         0.9676871539624923, 1.0582809934951445`}, {0.9596535332945797, 
         1.0560893557150068`}, {0.9216468677447329, 1.0458639765099353`}, {
         0.8872388765785421, 1.0367179106712852`}, {0.8544093372171426, 
         1.0280450556075251`}, {0.8247367014653267, 1.0203186220935458`}, {
         0.8212579301141818, 1.0194265552265633`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8173832945376153, 1.0184329762670412`}, {
         0.7978548988249701, 1.013425278714617}, {0.7733978587979493, 
         1.0072516940560081`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2751399224313414, 1.15}, {0.27134684058738295`, 
         1.1299784017348316`}, {0.2639087476278454, 1.0914365470637752`}, {
         0.2580829550937208, 1.0615766086849758`}, {0.25218526938262753`, 
         1.0315434200054154`}, {0.24782210080931508`, 1.0092106669952403`}, {
         0.24660933132871882`, 1.0029566672531889`}, {0.24552061090269878`, 
         0.9972986649637522}, {0.24468705630290538`, 0.9929251539766886}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.24394739571736562`, 0.9889941514469782}, {
         0.24068227376150197`, 0.9709993935195665}, {0.2406003551838934, 
         0.9705192055592334}, {0.24052010013281072`, 0.9700465136669146}, {
         0.2404447614052405, 0.9695994584979161}, {0.24026669902854336`, 
         0.968534012695507}, {0.24011228974700718`, 0.9675988375938334}, {
         0.23996475695351635`, 0.966694343762346}, {0.23881204597196148`, 
         0.9590664107094905}, {0.2381592258893808, 0.9535984331113838}, {
         0.23787362541534385`, 0.9496565624409958}, {0.23799481857587454`, 
         0.9451737602219412}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17469455202041329`, 0.728347870918103}, {
         0.18245936238711036`, 0.7596928504099044}, {0.18922830181139907`, 
         0.787682369681002}, {0.19503726906096155`, 0.8122978410557996}, {
         0.19996478154813088`, 0.8336120755006888}, {0.20728857128101366`, 
         0.8661144584934992}, {0.20749201175667614`, 0.8670364006984831}, {
         0.20769287923217455`, 0.8679477927374032}, {0.21112832019388306`, 
         0.883936334724735}, {0.21116815551136486`, 0.8841272596440215}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2119851379403838, 0.8880429383477297}, {
         0.21375208692450795`, 0.8965116694512645}, {0.21761976220264975`, 
         0.9157304608411296}}]}}}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1nk01Pv/B3BbZUtpkSmlonKjROSGPAtFobRIWeom5RKXkCVKIRVKi3uR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         "]]},
       Annotation[#, "Charting`Private`Tag$155793#1"]& ], 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
        LineBox[CompressedData["
1:eJw91gkw1lvcB3C0IF1LF6WIEuVe5KaI4ltUJJQiaRHZQqTlupQSeVQiS9Yi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         "]]},
       Annotation[#, "Charting`Private`Tag$155793#2"]& ]}, {}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
        0.3]], LineBox[CompressedData["
1:eJwUl3c41t8bx1VIUykllBUJyUoh3rYyKntVyCgqK9kZoTKSHZmPrVQIISsN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         "]]},
       Annotation[#, "Charting`Private`Tag$157388#1"]& ]}, {}}},
   AspectRatio->1,
   DisplayFunction->Identity,
   Frame->True,
   FrameLabel->{
     FormBox["\"A\"", TraditionalForm], 
     FormBox["\"H\"", TraditionalForm]},
   FrameStyle->Directive[FontFamily -> "Arial", 18],
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   Method->{
    "VectorLengthFunction" -> 
     Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
       System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`imin = If[
          NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
          Min[System`VectorPlotsDump`m], 
          Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
          NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
          Max[System`VectorPlotsDump`m], 
          Max[System`VectorPlotsDump`m]]; Map[If[
          
          Or[# > System`VectorPlotsDump`imax, # < 
           System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
         System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "TransparentPolygonMesh" -> True},
   PlotRange->{{0, 1}, {0, 1.15}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.02]}},
   Ticks->{Automatic, Automatic}],
  DynamicModuleValues:>{}]], "Output",
 CellChangeTimes->{3.903100803882345*^9, 3.903127325157449*^9, 
  3.903127717513928*^9, 3.903129155057678*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"b1151419-2c22-4265-ab6c-35edf0b83d6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A0", "=", "0.8`"}], ",", 
     RowBox[{"R", "=", "0.92`"}], ",", 
     RowBox[{"g", "=", "2"}], ",", 
     RowBox[{"Hmax", "=", "1.15`"}], ",", 
     RowBox[{"k", "=", "5"}], ",", 
     RowBox[{"m", "=", "0.03`"}], ",", 
     RowBox[{"point", "=", 
      RowBox[{"{", 
       RowBox[{"0.8`", ",", "0.584`"}], "}"}]}], ",", 
     RowBox[{"r", "=", "8"}], ",", 
     RowBox[{"s", "=", "6"}], ",", 
     RowBox[{"\[Gamma]", "=", "0.8`"}], ",", 
     RowBox[{"rc", "=", "2"}]}], "}"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"algaefun$", "=", 
        RowBox[{
         RowBox[{"\[Gamma]", " ", 
          RowBox[{"A", "[", "t", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox[
             RowBox[{"A", "[", "t", "]"}], 
             RowBox[{"A0", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"R", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "rc"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}]}], ")"}]}]]}]]}], 
           ")"}]}], "-", 
         FractionBox[
          RowBox[{"g", " ", 
           RowBox[{"A", "[", "t", "]"}], " ", 
           RowBox[{"H", "[", "t", "]"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]]}]}], ",", 
       RowBox[{"herbfun$", "=", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", " ", 
             RowBox[{"A", "[", "t", "]"}], " ", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"H", "[", "t", "]"}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "A0"}], ")"}], " ", "k"}]]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]], "-", 
         RowBox[{"m", " ", 
          RowBox[{"H", "[", "t", "]"}]}]}]}]}], "}"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"VectorPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"algaefun$", ",", "herbfun$"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"H", "[", "t", "]"}], ",", "0", ",", "Hmax"}], "}"}], ",", 
         
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"VectorColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"VectorStyle", "\[Rule]", "Gray"}], ",", 
         RowBox[{"VectorPoints", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamPoints", "\[Rule]", "Coarse"}], ",", 
         RowBox[{"StreamColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.85`", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.035`", "]"}], ",", "Thick"}], 
           "}"}]}], ",", 
         RowBox[{"StreamScale", "\[Rule]", "Large"}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<A\>\"", ",", "\"\<H\>\""}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", "18"}], 
           "]"}]}]}], "]"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"algaefun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "1", "\[RightDoubleBracket]"}]}], ",", 
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"herbfun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "2", "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "Hmax"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black", ",", 
              RowBox[{"Dashing", "[", ".03", "]"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"A0", ",", "Thick"}], "}"}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLinesStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"Dashing", "[", "0.05`", "]"}], ",", "Thick"}], "}"}], 
            ",", 
            RowBox[{"{", "}"}]}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"First", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"A", "[", "t", "]"}], ",", 
              RowBox[{"H", "[", "t", "]"}]}], "}"}], "/.", "\[VeryThinSpace]", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  SuperscriptBox["A", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "algaefun$"}], ",", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["H", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "herbfun$"}], ",", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"A", "[", "0", "]"}], ",", 
                    RowBox[{"H", "[", "0", "]"}]}], "}"}], "\[Equal]", 
                  "point"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "H"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], "]"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "1000"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9031007079810743`*^9, 3.903100755427177*^9}, {
  3.903127731050419*^9, 3.903127756494968*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"e8f5cb39-9401-4847-8934-2c902a7970f4"],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`A0$$ = 0.8, $CellContext`R$$ = 
  0.92, $CellContext`g$$ = 2, $CellContext`Hmax$$ = 1.15, $CellContext`k$$ = 
  5, $CellContext`m$$ = 0.03, $CellContext`point$$ = {0.8, 
  0.584}, $CellContext`r$$ = 8, $CellContext`s$$ = 
  6, $CellContext`\[Gamma]$$ = 0.8, $CellContext`rc$$ = 2}, 
  GraphicsBox[{{{}, {
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.005315180259893875, 0.05755118502610765}, {
         0.009253754587488863, 0.05840574958364356}, {0.016370375073678525`, 
         0.0609785752395866}, {0.028803134761993244`, 0.06636302282993478}, {
         0.053010315051178904`, 0.07770799529403206}, {0.09466376845094, 
         0.09847581472431756}, {0.12425765507992212`, 0.11418316931239039`}, {
         0.14865974365042334`, 0.12806082177891087`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1521367844190754, 0.13003824118134713`}, {
         0.1599378318547599, 0.13447475590321162`}, {0.17990280082841412`, 
         0.1466053545174627}, {0.20120036847637957`, 0.16020087311377262`}, {
         0.22345991901214995`, 0.1752829406951391}, {0.2463108366492189, 
         0.19187318626455974`}, {0.2760296445461572, 0.21558976259231932`}, {
         0.2829512159782154, 0.2217245443905069}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.28594465685093134`, 0.22437771452104008`}, {
         0.3058495418315339, 0.2420199692131521}, {0.3351485153210076, 
         0.2710984463619623}, {0.36330455183023674`, 0.30275983427365394`}, {
         0.3898353270178829, 0.3367432423166446}, {0.39355968297816624`, 
         0.3422397679893843}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.39580344847724896`, 0.3455511900985583}, {
         0.41425851654260754`, 0.3727877798593517}, {0.4363463164276536, 
         0.4105754218659062}, {0.4558010146849347, 0.4495188239708809}, {
         0.46859958717770617`, 0.4790677798611667}, {0.4712997078902921, 
         0.4861678660757577}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.472721539629453, 0.4899066351921267}, {
         0.47986892854918084`, 0.508701008829844}, {0.48964785181892806`, 
         0.5381699484789161}, {0.4979751700065175, 0.5672260364103864}, {
         0.4989998462268385, 0.5711149401586452}, {0.4999993118585184, 
         0.5749917606218528}, {0.5079184844627271, 0.6147726369262214}, {
         0.5123620734002896, 0.644472934211557}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5129539428953563, 0.6484289031827207}, {
         0.5135326731031374, 0.6522970510831271}, {0.5181334132141361, 
         0.6884026284699597}, {0.5207072562663115, 0.7216705323166468}, {
         0.5215571972751283, 0.7519689790059109}, {0.5209862312560516, 
         0.7791661849204752}, {0.5182190440616476, 0.8078433778755741}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5178348511442498, 0.8118248846006999}, {
         0.5166024802937436, 0.8245963142834022}, {0.5098469554205088, 
         0.8581851131811045}, {0.5014703659046529, 0.8831291656567161}, {
         0.4829984695442805, 0.9139570361389971}, {0.4656828608938726, 
         0.92930708233566}, {0.45348891696877963`, 0.9362945802006839}, {
         0.44315373522107315`, 0.9406613943660665}, {0.44099471440144283`, 
         0.941268044770384}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4371438438283965, 0.9423500779628718}, {
         0.43428810473678353`, 0.9431524950858566}, {0.4269112735335155, 
         0.9444448820531242}, {0.4205741042917906, 0.9451371420273712}, {
         0.41512926390729454`, 0.9454962908278867}, {0.41040315750307815`, 
         0.9456648234478999}, {0.4063240292493229, 0.9457231538348787}, {
         0.4027920053989766, 0.9457219946009322}, {0.3979908454307735, 
         0.9456583373884356}, {0.39414436023717564`, 0.945565710873157}, {
         0.39104213508205493`, 0.9454825986151288}, {0.38644551986863024`, 
         0.9453627017937808}, {0.38338142573177797`, 0.9452805476229514}, {
         0.38128807368524203`, 0.9452131082959411}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0012485535472057541`, 0.0019363574419383924`}, {
         0.002079759749410058, 0.0019095332242724634`}, {
         0.0037184635600041945`, 0.0018976191925662955`}, {
         0.007367205051851271, 0.0019208623204036294`}, {
         0.016177776058389666`, 0.0020205075282379898`}, {0.03149051638942077,
          0.002227170284528127}, {0.061166842404928416`, 
         0.0026658583309231033`}, {0.08540916962016178, 
         0.0030211914095529184`}, {0.11726588368895359`, 
         0.003517818895600946}, {0.15209120132918633`, 0.00414117741646965}, {
         0.16122897973583986`, 0.004321050889195625}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.16522820499437332`, 0.004399774021170686}, {
         0.19320012622796473`, 0.004950389979141391}, {0.23953501141086506`, 
         0.00599306365477582}, {0.29003820990346385`, 0.007316805514532598}, {
         0.3163785391140037, 0.008094879512852182}, {0.3251774575317451, 
         0.008384456976941405}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3291752930779486, 0.008516028043333054}, {
         0.34281217159817484`, 0.008964825555992971}, {0.3693391073559777, 
         0.009926643643954973}, {0.39595934638741204`, 0.01098033377673819}, {
         0.4300475942901762, 0.012560742022280687`}, {0.4626481511269155, 
         0.014429319815652963`}, {0.48897632891509246`, 
         0.01625439204981514}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.49296675285715336`, 0.016531008684577526`}, {
         0.49376101689762975`, 0.016586067156855008`}, {0.5233861916023189, 
         0.01903098404588682}, {0.5511649278522698, 0.021903257251945543`}, {
         0.5767384782587688, 0.025342073544228325`}, {0.6212700215414114, 
         0.033919335387466054`}, {0.6501795144732179, 0.04331287784508883}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6539837297562421, 0.044548979006161414`}, {
         0.6574024066927139, 0.04565980744674994}, {0.6855572189551433, 
         0.06146052759322994}, {0.7066496921288792, 0.0823520454747033}, {
         0.7214033290723582, 0.10954149407049109`}, {0.7305905392099711, 
         0.14426225396136128`}, {0.7332791274110022, 0.16475444942484024`}, {
         0.7337404437667153, 0.17165350183796582`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7340073143265253, 0.17564458942210961`}, {
         0.7347986104577926, 0.18747853681267546`}, {0.7348670039192392, 
         0.2308026067479722}, {0.7319839323393835, 0.28039541968188686`}, {
         0.7316936290847007, 0.2839414349689012}, {0.7313908128922378, 
         0.2875131194924334}, {0.7269667270713063, 0.3266680945695409}, {
         0.7258116507089605, 0.335182563397923}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7252739344932893, 0.3391462562810062}, {
         0.7213849861887637, 0.3678130442038631}, {0.7152719059359195, 
         0.4094618448291692}, {0.7080961469424722, 0.45211834743644286`}, {
         0.6999714011034299, 0.4950837135225799}, {0.6995609785980051, 
         0.49703391654947754`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6987372183389694, 0.5009481749767705}, {
         0.6910113603138004, 0.5376591045844762}, {0.6813457180764184, 
         0.5791987286480502}, {0.6711041678941188, 0.6190567937392208}, {
         0.6605184400272874, 0.6562629660853445}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6594238206752066, 0.6601102779357213}, {
         0.6583690781874828, 0.6638174326323755}, {0.6451478210714563, 
         0.7054920896934658}, {0.631686551077056, 0.7431258698970049}, {
         0.6182314227352984, 0.7757638782175059}, {0.6018322901607757, 
         0.8091013015203038}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.600066692638718, 0.812690544531038}, {0.5990748029642207,
          0.8147069344710622}, {0.5806832585283863, 0.8456258654583961}, {
         0.5634358106491619, 0.8697090857623327}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.007991959384349424, 0.18737918942632123`}, {
         0.014665332619929012`, 0.19575462102647093`}, {0.02404284485226666, 
         0.21125452873000952`}, {0.038937399713556094`, 0.2389435150658879}, {
         0.06122684095593691, 0.2836717671747492}, {0.07289826755292106, 
         0.30815402451768015`}, {0.08242433440296044, 
         0.3286901142122216}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.08410753724805241, 0.33231872664430556`}, {
         0.08603590995585036, 0.33647587098469833`}, {0.10049582118279327`, 
         0.3685355646087313}, {0.11613405425181815`, 0.4042313634227067}, {
         0.13264560636247988`, 0.44301681653391284`}, {0.14758808292033565`, 
         0.4791735636722408}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14911583691098265`, 0.4828703146435752}, {
         0.14972547471433337`, 0.48434547304963804`}, {0.16271516849528453`, 
         0.5165533981459839}, {0.17564170031914506`, 0.5492853488098967}, {
         0.18834798379382292`, 0.5820806167619507}, {0.20067693252722205`, 
         0.6144784937227098}, {0.20721354110163237`, 0.6319432947316374}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2086156478211007, 0.6356895057170494}, {
         0.21654686226824882`, 0.6568804766160631}, {0.23125509095513763`, 
         0.6968167623647062}, {0.23220817584001271`, 0.6994278385706469}, {
         0.23315513625933992`, 0.7020239606184527}, {0.24504513044513235`, 
         0.734840650937636}, {0.2557820553010721, 0.7644832403115248}, {
         0.26358919265807296`, 0.7859478138198195}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2649564491854812, 0.7897068841288533}, {
         0.2659399685095208, 0.7924109255543246}, {0.2749398584229873, 
         0.8169088025349469}, {0.28983109174382177`, 0.8563128613966663}, {
         0.30125887971686544`, 0.8846031461851092}, {0.31449650596901896`, 
         0.9130841577407179}, {0.3234564871128151, 0.9275012763716008}, {
         0.3301634417189963, 0.9348833727408711}, {0.330189687019687, 
         0.9349037920307228}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.33334672987062647`, 0.9373600250077289}, {
         0.3348252909022445, 0.9385103706114623}, {0.3389257158870297, 
         0.9408672338505835}, {0.3425447636272148, 0.9422686193013112}, {
         0.3456662295911617, 0.9430537018483448}, {0.34850786694327657`, 
         0.9435411099190769}, {0.35110961976304056`, 
         0.9438597813869771}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.9610126159531893}, {0.9990345385026703, 
         0.9609913329662609}, {0.9696328557403904, 0.9603346581097962}, {
         0.9420927242886611, 0.9597135144087203}, {0.8925971153168553, 
         0.9585778204727349}, {0.8494558297844842, 0.957566573004141}, {
         0.8400421321409274, 0.9573417907136108}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8360432719917645, 0.9572463050736557}, {
         0.8115769858887797, 0.9566620938487753}, {0.8068257181795436, 
         0.9565473689444552}, {0.8021542448459915, 0.9564343176472644}, {
         0.7703943048437545, 0.9556538724170947}, {0.7421029252912291, 
         0.9549499109362772}, {0.6914174176477923, 0.9536750408376361}, {
         0.676092428825847, 0.9532813802130061}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6720937478682476, 0.9531786641026224}, {
         0.6509226576300524, 0.9526348317576792}, {0.6179437514796188, 
         0.9517752291963395}, {0.568227157039481, 0.9504614056519424}, {
         0.5325904038976028, 0.9495064067842274}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9587219655338541, 0.6837119705762049}, {
         0.9159887583189529, 0.7090923473269792}, {0.8779326543830237, 
         0.7327505788633747}, {0.8438185189281922, 0.754643532371413}, {
         0.8394871580697053, 0.7574747188103694}, {0.8352166076158347, 
         0.7602738284143594}, {0.8230011686270816, 0.7684008331922664}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8196708774961272, 0.7706164958432777}, {
         0.8045387780725398, 0.7806839722907871}, {0.7767921762087373, 
         0.7992169157279356}, {0.7503048503493142, 0.8168345400111245}, {
         0.7263360764986495, 0.8326215259863946}, {0.6859410222097616, 
         0.8584491216519179}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6825319729436888, 0.8605408285562286}, {
         0.6498442166506991, 0.880122882526079}, {0.6195722245058977, 
         0.8966699472417003}, {0.5938086869298481, 0.9092379665392357}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20192105761486553`, 0.050400212455347364`}, {
         0.2310241098935508, 0.05675524257666449}, {0.2617353422197898, 
         0.06412907248073081}, {0.29353722744135663`, 0.07265598098840816}, {
         0.3259122384060253, 0.08247024692055831}, {0.35601880242412554`, 
         0.09293071973305797}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3597698655751084, 0.09431647520388836}, {
         0.3901238575859159, 0.10656098496121579`}, {0.4210165189046342, 
         0.12109513000762809`}, {0.4503893615408025, 0.13749840974408714`}, {
         0.47364199171441806`, 0.15292380230558578`}, {0.4952681246792671, 
         0.1698902578392325}, {0.49827342403403857`, 0.17267134016004274`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5012092469100002, 0.17538812944907123`}, {
         0.51526776043535, 0.1883977763450274}, {0.5336408989826664, 
         0.20844635782297039`}, {0.5360070942687994, 0.21125173343278475`}, {
         0.5383405530325152, 0.21408588890658006`}, {0.5544914429346451, 
         0.2385092023620219}, {0.5686397587884312, 0.2647085000225044}, {
         0.5817938752090792, 0.2916812177555716}, {0.5880808190068137, 
         0.30773937583127114`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5895390835408124, 0.3114640858265435}, {
         0.5929595927634507, 0.3202007756338083}, {0.6022166434595903, 
         0.35007091034389287`}, {0.6096447593055423, 0.38109535857250376`}, {
         0.615349772969884, 0.4130015563160257}, {0.6194375171211925, 
         0.4455169395708434}, {0.621121877526172, 0.4677141740268536}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6214245336014829, 0.4717027075042206}, {
         0.6220549048110638, 0.4800100136437039}, {0.6231548993061511, 
         0.5145225065823292}, {0.6229027866713545, 0.5486303781792066}, {
         0.6214638529715736, 0.5819095882268223}, {0.6189723371386794, 
         0.6140910179269589}, {0.6170495608165953, 0.631426664453936}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6163438594696852, 0.6426071307291656}, {
         0.6158094838578031, 0.6426071307291656}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20151070995072387`, 1.15}, {0.19687629648458113`, 
         1.1302868914489757`}, {0.1870570074596501, 1.0933643484661766`}, {
         0.17830845850066812`, 1.0642911839211286`}, {0.17039432484347358`, 
         1.0416069838616109`}, {0.1629774239798851, 1.023281831290051}, {
         0.1539782868639582, 1.0046739025079847`}, {0.15031362738163317`, 
         0.9990428676470912}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14813179641385496`, 0.9956903143472846}, {
         0.1377579866428213, 0.9797501472614446}, {0.13721180560984406`, 
         0.9790813431095936}, {0.1366650579103053, 0.9784211931769761}, {
         0.1257255138608266, 0.968141120356546}, {0.11420697215926141`, 
         0.9596228486068679}, {0.08997270853501137, 0.9449036790634745}, {
         0.0638946167183734, 0.9328023557838603}, {0.038565179065588276`, 
         0.9197282096826157}, {0.02151979395719923, 0.9023880592010154}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.018715716170643684`, 0.8995354905748566}, {
         0.014501586045115849`, 0.895248485613629}, {0.010760229451103224`, 
         0.887676175449977}, {0.007767559400176594, 0.8797326562899801}, {
         0.005542252678650447, 0.8712967267694348}, {0.0030205281638741735`, 
         0.8556358133631217}, {0.0016794965022389672`, 0.8392465480424747}, {
         0.0009606639652322169, 0.822587323237586}, {0.000582868009676899, 
         0.8074007025699049}, {0.0003532419386694125, 0.7923259128024964}, {
         0.00021676599979087268`, 0.7774132100885689}, {
         0.00013749926751834636`, 0.763141808408893}, {0.00008856365235617128,
          0.749085896166136}, {0.00007561935766867175, 0.7432467641908352}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.00006675210620978785, 0.7392467740193659}, {
         0.00005791087142462761, 0.7352585198903073}, {0.00003823696132192895,
          0.7214626555493651}, {0.000025674305940201902`, 
         0.7079119369607114}, {0.000017523084181695026`, 
         0.6946066231647166}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.982420449767751, 0.42304115961063726`}, {
         0.9452713410993222, 0.4552441352262494}, {0.9118889543784554, 
         0.4875268052120116}, {0.8816403251458672, 0.5195956280755437}, {
         0.8777797012494438, 0.5238977668962438}, {0.8739666767523326, 
         0.5281904245278117}, {0.8683358704795866, 0.5349420768125693}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8657739437201243, 0.538013970573615}, {
         0.8571010120403727, 0.5484133017092934}, {0.8411201762929797, 
         0.5683277511162922}, {0.8113555020038121, 0.6067292906028515}, {
         0.7828879831687156, 0.6439514415027064}, {0.7677040929072172, 
         0.6644112794285824}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7653202991395147, 0.6676233702232305}, {
         0.7570147752417615, 0.678814815229153}, {0.7333694789238316, 
         0.7111161746685053}, {0.711585694915808, 0.7406522827070778}, {
         0.6914540053565984, 0.7674160651513953}, {0.6727649923851106, 
         0.7914004478079821}, {0.6693357615712766, 0.795618189175829}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6668123646838165, 0.7987218109550343}, {
         0.6559223332063445, 0.8121158747416993}, {0.6401107941231521, 
         0.8306055929896448}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.0726354132149987}, {0.9797407828781172, 
         0.07952260995481178}, {0.9549158525480289, 0.09009910330778362}, {
         0.9329131476655398, 0.10189030153809975`}, {0.8957123717678481, 
         0.1294802984284502}, {0.8934724692892321, 0.13152900585319185`}, {
         0.891262491749183, 0.13360446839081494`}, {0.875259403446674, 
         0.1523535054427732}, {0.8696798258312124, 0.16019313408533223`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.867360424831514, 0.16345202638220216`}, {
         0.8605154595659482, 0.17306959772031713`}, {0.8462821234542818, 
         0.19474561596022616`}, {0.8330700028807341, 0.21834148612486542`}, {
         0.8206669885374103, 0.2438108954422311}, {0.8088609711164154, 
         0.27110753114031944`}, {0.7975064650358004, 0.30008992637906823`}, {
         0.7954562131516919, 0.30575472349488214`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7940949157064472, 0.3095159559080109}, {
         0.786457984713616, 0.33061661431841527`}, {0.7752090877410085, 
         0.36347973196771827`}, {0.7640754989392153, 0.3971096199262486}, {
         0.7530572183082368, 0.4315062781940062}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.010808276982210856`, 0.11366037247768163`}, {
         0.020142352714313867`, 0.12088660628891897`}, {0.03831805854841904, 
         0.13782970790516683`}, {0.07129924115738799, 0.1714705160801383}, {
         0.10227610379375068`, 0.2049405778298005}, {0.1209381192176681, 
         0.22602632857039046`}, {0.12254369055919041`, 
         0.22790770489640147`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12514028949147515`, 0.2309503474953371}, {
         0.1416432419519349, 0.2502881765070059}, {0.1640932730095261, 
         0.27776634545055506`}, {0.1879900134034168, 0.30850105921194615`}, {
         0.2129744696276323, 0.3423733454932403}, {0.2232636671864492, 
         0.3572314167545538}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.22554093207244374`, 0.36051989127004214`}, {
         0.23838943009657645`, 0.37907370930610684`}, {0.2548150545586289, 
         0.4041800998455383}, {0.271004925910955, 0.4301317312874976}, {
         0.2867344592702193, 0.45660981709109205`}, {0.30193191984725465`, 
         0.4835436113581864}, {0.309068342760124, 0.49687180030233513`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.31095647218867845`, 0.5003981251967581}, {
         0.3164820807158255, 0.5107179108064934}, {0.33026971494969654`, 
         0.5379175121537259}, {0.33207642589527364`, 0.5415847741133107}, {
         0.3338675634079674, 0.5452482424061782}, {0.3529708271870995, 
         0.5883965603702987}, {0.3696080059927753, 0.62963968167688}, {
         0.37608670026906105`, 0.6464043931235386}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3775285722467407, 0.6501354794532799}, {
         0.38499970858582233`, 0.6694683017106617}, {0.39790045875361185`, 
         0.7064679191988444}, {0.40847512567913086`, 0.7403296763308033}, {
         0.4168885785453667, 0.7707447152959137}, {0.42338225282528275`, 
         0.7977319365258512}, {0.4244428304031802, 0.8029250623160135}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.42524321815427646`, 0.8068441667351244}, {
         0.4281975839918426, 0.8213102404522915}, {0.43389497343678224`, 
         0.8583760659140905}, {0.435638319483246, 0.8851358444138618}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5084437047157727, 1.15}, {0.5084082398563076, 
         1.1499096270012632`}, {0.4966495442941996, 1.1210179386134094`}, {
         0.47757030346417173`, 1.0765273957852795`}, {0.4764562395541205, 
         1.0740285357264014`}, {0.4753615853236102, 1.0715841224715434`}, {
         0.4675894068941483, 1.0548248077532298`}, {0.46073041756606903`, 
         1.0405061004615592`}, {0.44858253639245144`, 1.0159623093994508`}, {
         0.4423775210294151, 1.0043675439471538`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.44017942063371573`, 0.9988531814380165}, {
         0.43942647348754615`, 0.9988531814380165}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.05953258930189595, 0.3943212217418805}, {
         0.06727534276680903, 0.4229818389785769}, {0.07526788189609397, 
         0.45401558343865117`}, {0.0832898865022923, 0.4867148634671308}, {
         0.09187610779047584, 0.5238778152115671}, {0.09744865734566155, 
         0.549738882837567}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.09829123905668165, 0.553649132965149}, {
         0.10011514225208229`, 0.5621134962538773}, {0.10777765973876421`, 
         0.6005275804594795}, {0.1146343301021741, 0.6382257416937916}, {
         0.12053148832716866`, 0.6744293332377406}, {0.1253154693986046, 
         0.708359708372253}, {0.125649267090357, 0.7112476285742266}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12610854580668424`, 0.7152211739760974}, {
         0.1289307504481261, 0.7396380648039977}, {0.13131677058289865`, 
         0.7677748464130109}, {0.13256255135097403`, 0.809267445155387}, {
         0.132541855818284, 0.8104975996618802}, {0.1325170429776696, 
         0.8117165995871446}, {0.13093163395580895`, 0.829170431492371}, {
         0.12826443949204624`, 0.8440066034945735}, {0.12083108918145567`, 
         0.8688435464833847}, {0.11812380428111145`, 0.8726815356610075}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.11581814248410424`, 0.8759501628465124}, {
         0.10934594638736946`, 0.8851254877528649}, {0.09411271843762375, 
         0.8947983609935394}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7000126704838011, 1.15}, {0.6838336115890866, 
         1.1320976739693713`}, {0.6586450846038822, 1.1055432289330769`}, {
         0.636622003370999, 1.0833105790749387`}, {0.6338650217120669, 
         1.080603314754877}, {0.6311554224393783, 1.0779581094333726`}, {
         0.61784443825854, 1.0653922723309794`}, {0.6056118901946339, 
         1.054171678525248}, {0.5866315597678032, 1.0372618364643753`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5836449276738833, 1.034601004125507}, {
         0.5830615363272608, 1.0340812526085827`}, {0.5639392353538721, 
         1.018120063193045}, {0.5475481278100937, 1.0053128446293857`}, {
         0.5139329723823047, 0.9819578791797015}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.24670206981448267`}, {0.9668903226725137, 
         0.27222877905708176`}, {0.9369235729742608, 0.29947376532990533`}, {
         0.9331234770762282, 0.3032396360675635}, {0.9293751200344278, 
         0.3070294655705617}, {0.8995586752643364, 0.34279975464595247`}, {
         0.887502022631277, 0.35931027779952524`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8851430698324312, 0.36254065574843736`}, {
         0.8724526471454956, 0.37991907113271683`}, {0.8464655667751125, 
         0.4173551069733554}, {0.8227163819016448, 0.45542458152174253`}, {
         0.8008166273972714, 0.4936398634532358}, {0.7989197684118947, 
         0.49715477855758794`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7970200995309986, 0.5006749004507836}, {
         0.7803778381341718, 0.5315133214431931}, {0.7611818854213926, 
         0.5685941048663276}, {0.7430106405679806, 0.6044313630973523}, {
         0.727282603884666, 0.6360545448080503}, {0.7238610773382753, 
         0.6429562809397394}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.71984260284645, 0.661751162839457}, {0.7145435395290713, 
         0.661751162839457}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9106584515354561, 1.138962939886078}, {
         0.8842316930004651, 1.1242654674754922`}, {0.859586581261107, 
         1.110754818570249}, {0.8156412981692903, 1.0872939912757913`}, {
         0.8102031694842006, 1.0844542401538888`}, {0.8048699729403089, 
         1.0816817471567277`}, {0.7751971668793955, 1.066679417672204}, {
         0.7694172055234665, 1.0638291964680762`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7658296800143823, 1.0620601117551045`}, {
         0.7485852871023686, 1.053556536851491}, {0.7232920147120079, 
         1.041236463679511}, {0.7006359570949796, 1.030522005804997}, {
         0.6618764759475498, 1.0129967422366057`}, {0.6300155855455457, 
         0.9994647919408818}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3548639334195923, 1.15}, {0.3514093567415543, 
         1.132924743954166}, {0.3463575283083049, 1.1078248262546373`}, {
         0.3385608764661015, 1.0683754369161496`}, {0.33812552342029223`, 
         1.066126724314788}, {0.3377004344010081, 1.0639235940785507`}, {
         0.3342640144104573, 1.045383402859212}, {0.331543228940178, 
         1.0299136046501962`}, {0.3273157001163407, 
         1.0040327656713743`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.98799790396016, 0.824318591479259}, {0.9614942481179388, 
         0.8316762381173142}, {0.936810675780761, 0.8386330515134828}, {
         0.930409626883344, 0.8404522186739751}, {0.9241189186025389, 
         0.8422443618024801}, {0.8875988118317715, 0.8527751773403117}, {
         0.8546121578861683, 0.8623364803435737}, {0.8341517017416165, 
         0.8682604132683472}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.830309503337386, 0.8693728481754446}, {0.823159585254092,
          0.8714429699187634}, {0.7947751752490704, 0.879639832637809}, {
         0.769087895416055, 0.8870045624133035}, {0.745726713299999, 
         0.893614653157841}, {0.7049362468335371, 0.9048395290745207}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0929929916126462, 1.15}, {0.08465544086542066, 
         1.129188889324418}, {0.06799622400325998, 1.094812441606252}, {
         0.06691948749536304, 1.0927914885687215`}, {0.06584935729814786, 
         1.0908036081796302`}, {0.05759503966567307, 1.0766281568576337`}, {
         0.04983803486265575, 1.0639759397921107`}, {0.03555760535242913, 
         1.0410533100229193`}, {0.023946006858832095`, 1.0219973701141807`}, {
         0.017351111103734863`, 1.0093465235213266`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.015502069422566859`, 1.0057995466590812`}, {
         0.015230496160272774`, 1.005278593514773}, {0.01120531082407512, 
         0.9955492963137371}, {0.008125633433769772, 0.986131329123122}, {
         0.00583077643966174, 0.9769056723652565}, {0.0029774950959918253`, 
         0.9590449288488035}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.006302186789323222}, {0.9763186813487597, 
         0.007058565446987368}, {0.9395632300874686, 0.008951110183311139}, {
         0.9107426959453558, 0.011370674439836477`}, {0.8877517998015447, 
         0.014446380725209634`}, {0.8696110189244511, 
         0.018289963664117455`}, {0.8549042910061472, 0.02313137490482253}, {
         0.8430902000950558, 0.0293658798749722}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8396698556350507, 0.03138787993248829}, {
         0.8197743277343238, 0.05224988782516116}, {0.8192042924307237, 
         0.05314776669384465}, {0.8186393176612913, 0.05406010015245548}, {
         0.8123444207794711, 0.06769107826457589}, {0.8073008399563562, 
         0.08108665253248365}, {0.8023153310322116, 0.09678242955499847}, {
         0.7922327406150529, 0.1331781535596479}, {0.7821204964583194, 
         0.17751190476894613`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.46117955810874717`, 0.05820431729167524}, {
         0.4916243371702479, 0.06707287426709359}, {0.5200699079889889, 
         0.07723389963090872}, {0.5462154155811227, 0.08886835678829003}, {
         0.5843690372017607, 0.11216168713540742`}, {0.6026262023403438, 
         0.12889363057348704`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6055751239126215, 0.1315961963100706}, {
         0.6156048921399314, 0.14078806774260458`}, {0.6174778564173722, 
         0.1428981067862283}, {0.6193200097083341, 0.14503499942772602`}, {
         0.6315979421531425, 0.16351929672002363`}, {0.6421715258003791, 
         0.18380383400037223`}, {0.6600057315588962, 0.22788203627404235`}, {
         0.6665188983494831, 0.2525050559729904}, {0.6707703258104645, 
         0.2747707318450771}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6715205359700457, 0.2786997501342253}, {
         0.6715371544986826, 0.2787867850831914}, {0.6751420751934727, 
         0.306597780268812}, {0.6774152356208312, 0.3358085981940189}, {
         0.6785470049180533, 0.36937822832648587`}, {0.6783759720620013, 
         0.4037191970236979}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9632506062820955, 0.578361567988282}, {
         0.9576157758986554, 0.5825292403308685}, {0.95206688121142, 
         0.5866778085835272}, {0.9154944638125696, 0.6160820964212395}, {
         0.8823573305616552, 0.6441480976990258}, {0.850699900636691, 
         0.6714306296247068}, {0.8403337502867646, 0.6807194821402569}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8373547673842577, 0.6833888754920452}, {
         0.8220018773636277, 0.6971462228461772}, {0.7958824896717844, 
         0.7212336791378716}, {0.771960966490481, 0.7436318002742249}, {
         0.749984957854487, 0.7643468767128212}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.23345260624243847`, 0.10840046778514222`}, {
         0.263760101048499, 0.12225747722586919`}, {0.29486790445744504`, 
         0.1380797346226339}, {0.32632914389717016`, 0.155978233996493}, {
         0.35739556568161396`, 0.17612142058722574`}, {0.37232158480418337`, 
         0.1871408785375827}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3755396097344574, 0.18951665536803944`}, {
         0.38166100699906863`, 0.19403590991279726`}, {0.4050177306739598, 
         0.2135054125833491}, {0.42724622246488786`, 0.23452601397023926`}, {
         0.44812696813045316`, 0.2570937994448258}, {0.4508484051586081, 
         0.26023738778307}, {0.45354218794753387`, 0.263408141370796}, {
         0.47361122208673956`, 0.2916786212715149}, {0.48270860662659143`, 
         0.30681068273417783`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.48476961189201084`, 0.3102388392790155}, {
         0.4916033883537257, 0.3216057464365371}, {0.5085172020898356, 
         0.3521724851107736}, {0.5232743107641934, 0.38401845080343877`}, {
         0.5359134575735687, 0.41684065955125066`}, {0.5464733857147314, 
         0.45033612739092743`}, {0.5480507683751632, 0.45655054874996653`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5490348661961311, 0.46042760323485143`}, {
         0.555056493069509, 0.484151032936963}, {0.5617651775197295, 
         0.5179315548038511}, {0.5669377461867247, 0.5536382248926459}, {
         0.570311072290544, 0.5886428327862407}, {0.5718647716075591, 
         0.6184402352225573}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5720731376789522, 0.6224394522191699}, {
         0.5720732992042016, 0.6224394522191699}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9758885438793296, 1.0605240777890823`}, {
         0.9676871539624923, 1.0582809934951445`}, {0.9596535332945797, 
         1.0560893557150068`}, {0.9216468677447329, 1.0458639765099353`}, {
         0.8872388765785421, 1.0367179106712852`}, {0.8544093372171426, 
         1.0280450556075251`}, {0.8247367014653267, 1.0203186220935458`}, {
         0.8212579301141818, 1.0194265552265633`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8173832945376153, 1.0184329762670412`}, {
         0.7978548988249701, 1.013425278714617}, {0.7733978587979493, 
         1.0072516940560081`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2751399224313414, 1.15}, {0.27134684058738295`, 
         1.1299784017348316`}, {0.2639087476278454, 1.0914365470637752`}, {
         0.2580829550937208, 1.0615766086849758`}, {0.25218526938262753`, 
         1.0315434200054154`}, {0.24782210080931508`, 1.0092106669952403`}, {
         0.24660933132871882`, 1.0029566672531889`}, {0.24552061090269878`, 
         0.9972986649637522}, {0.24468705630290538`, 0.9929251539766886}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.24394739571736562`, 0.9889941514469782}, {
         0.24068227376150197`, 0.9709993935195665}, {0.2406003551838934, 
         0.9705192055592334}, {0.24052010013281072`, 0.9700465136669146}, {
         0.2404447614052405, 0.9695994584979161}, {0.24026669902854336`, 
         0.968534012695507}, {0.24011228974700718`, 0.9675988375938334}, {
         0.23996475695351635`, 0.966694343762346}, {0.23881204597196148`, 
         0.9590664107094905}, {0.2381592258893808, 0.9535984331113838}, {
         0.23787362541534385`, 0.9496565624409958}, {0.23799481857587454`, 
         0.9451737602219412}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17469455202041329`, 0.728347870918103}, {
         0.18245936238711036`, 0.7596928504099044}, {0.18922830181139907`, 
         0.787682369681002}, {0.19503726906096155`, 0.8122978410557996}, {
         0.19996478154813088`, 0.8336120755006888}, {0.20728857128101366`, 
         0.8661144584934992}, {0.20749201175667614`, 0.8670364006984831}, {
         0.20769287923217455`, 0.8679477927374032}, {0.21112832019388306`, 
         0.883936334724735}, {0.21116815551136486`, 0.8841272596440215}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2119851379403838, 0.8880429383477297}, {
         0.21375208692450795`, 0.8965116694512645}, {0.21761976220264975`, 
         0.9157304608411296}}]}}}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1nk01Pv/B3BbZUtpkSmlonKjROSGPAtFobRIWeom5RKXkCVKIRVKi3uR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         "]]},
       Annotation[#, "Charting`Private`Tag$137477#1"]& ], 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
        LineBox[CompressedData["
1:eJw91gkw1lvcB3C0IF1LF6WIEuVe5KaI4ltUJJQiaRHZQqTlupQSeVQiS9Yi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         "]]},
       Annotation[#, "Charting`Private`Tag$137477#2"]& ]}, {}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
        0.3]], LineBox[CompressedData["
1:eJyV0nlUjGscB/Bu2pBLYynStOkq0kZDi34tQqEoLidr1onJdLVRKVqUw0nd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         "]]},
       Annotation[#, "Charting`Private`Tag$139072#1"]& ]}, {}}},
   AspectRatio->1,
   DisplayFunction->Identity,
   Frame->True,
   FrameLabel->{
     FormBox["\"A\"", TraditionalForm], 
     FormBox["\"H\"", TraditionalForm]},
   FrameStyle->Directive[FontFamily -> "Arial", 18],
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   Method->{
    "VectorLengthFunction" -> 
     Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
       System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`imin = If[
          NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
          Min[System`VectorPlotsDump`m], 
          Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
          NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
          Max[System`VectorPlotsDump`m], 
          Max[System`VectorPlotsDump`m]]; Map[If[
          
          Or[# > System`VectorPlotsDump`imax, # < 
           System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
         System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "TransparentPolygonMesh" -> True},
   PlotRange->{{0, 1}, {0, 1.15}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.02]}},
   Ticks->{Automatic, Automatic}],
  DynamicModuleValues:>{}]], "Output",
 CellChangeTimes->{{3.903100741048211*^9, 3.903100759306416*^9}, {
  3.9031277341075153`*^9, 3.903127757486422*^9}},
 CellLabel->
  "Out[141]=",ExpressionUUID->"e120053b-def8-4ddc-99f0-c46a5a5b2419"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   GraphicsBox[{{{}, {
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.005315180259893875, 0.05755118502610765}, {
          0.009253754587488863, 0.05840574958364356}, {0.016370375073678525`, 
          0.0609785752395866}, {0.028803134761993244`, 0.06636302282993478}, {
          0.053010315051178904`, 0.07770799529403206}, {0.09466376845094, 
          0.09847581472431756}, {0.12425765507992212`, 
          0.11418316931239039`}, {0.14865974365042334`, 
          0.12806082177891087`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.1521367844190754, 0.13003824118134713`}, {
          0.1599378318547599, 0.13447475590321162`}, {0.17990280082841412`, 
          0.1466053545174627}, {0.20120036847637957`, 0.16020087311377262`}, {
          0.22345991901214995`, 0.1752829406951391}, {0.2463108366492189, 
          0.19187318626455974`}, {0.2760296445461572, 0.21558976259231932`}, {
          0.2829512159782154, 0.2217245443905069}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.28594465685093134`, 0.22437771452104008`}, {
          0.3058495418315339, 0.2420199692131521}, {0.3351485153210076, 
          0.2710984463619623}, {0.36330455183023674`, 0.30275983427365394`}, {
          0.3898353270178829, 0.3367432423166446}, {0.39355968297816624`, 
          0.3422397679893843}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.39580344847724896`, 0.3455511900985583}, {
          0.41425851654260754`, 0.3727877798593517}, {0.4363463164276536, 
          0.4105754218659062}, {0.4558010146849347, 0.4495188239708809}, {
          0.46859958717770617`, 0.4790677798611667}, {0.4712997078902921, 
          0.4861678660757577}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.472721539629453, 0.4899066351921267}, {
          0.47986892854918084`, 0.508701008829844}, {0.48964785181892806`, 
          0.5381699484789161}, {0.4979751700065175, 0.5672260364103864}, {
          0.4989998462268385, 0.5711149401586452}, {0.4999993118585184, 
          0.5749917606218528}, {0.5079184844627271, 0.6147726369262214}, {
          0.5123620734002896, 0.644472934211557}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5129539428953563, 0.6484289031827207}, {
          0.5135326731031374, 0.6522970510831271}, {0.5181334132141361, 
          0.6884026284699597}, {0.5207072562663115, 0.7216705323166468}, {
          0.5215571972751283, 0.7519689790059109}, {0.5209862312560516, 
          0.7791661849204752}, {0.5182190440616476, 0.8078433778755741}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5178348511442498, 0.8118248846006999}, {
          0.5166024802937436, 0.8245963142834022}, {0.5098469554205088, 
          0.8581851131811045}, {0.5014703659046529, 0.8831291656567161}, {
          0.4829984695442805, 0.9139570361389971}, {0.4656828608938726, 
          0.92930708233566}, {0.45348891696877963`, 0.9362945802006839}, {
          0.44315373522107315`, 0.9406613943660665}, {0.44099471440144283`, 
          0.941268044770384}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.4371438438283965, 0.9423500779628718}, {
          0.43428810473678353`, 0.9431524950858566}, {0.4269112735335155, 
          0.9444448820531242}, {0.4205741042917906, 0.9451371420273712}, {
          0.41512926390729454`, 0.9454962908278867}, {0.41040315750307815`, 
          0.9456648234478999}, {0.4063240292493229, 0.9457231538348787}, {
          0.4027920053989766, 0.9457219946009322}, {0.3979908454307735, 
          0.9456583373884356}, {0.39414436023717564`, 0.945565710873157}, {
          0.39104213508205493`, 0.9454825986151288}, {0.38644551986863024`, 
          0.9453627017937808}, {0.38338142573177797`, 0.9452805476229514}, {
          0.38128807368524203`, 0.9452131082959411}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.0012485535472057541`, 0.0019363574419383924`}, {
          0.002079759749410058, 0.0019095332242724634`}, {
          0.0037184635600041945`, 0.0018976191925662955`}, {
          0.007367205051851271, 0.0019208623204036294`}, {
          0.016177776058389666`, 0.0020205075282379898`}, {
          0.03149051638942077, 0.002227170284528127}, {0.061166842404928416`, 
          0.0026658583309231033`}, {0.08540916962016178, 
          0.0030211914095529184`}, {0.11726588368895359`, 
          0.003517818895600946}, {0.15209120132918633`, 
          0.00414117741646965}, {0.16122897973583986`, 
          0.004321050889195625}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.16522820499437332`, 0.004399774021170686}, {
          0.19320012622796473`, 0.004950389979141391}, {0.23953501141086506`, 
          0.00599306365477582}, {0.29003820990346385`, 
          0.007316805514532598}, {0.3163785391140037, 0.008094879512852182}, {
          0.3251774575317451, 0.008384456976941405}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3291752930779486, 0.008516028043333054}, {
          0.34281217159817484`, 0.008964825555992971}, {0.3693391073559777, 
          0.009926643643954973}, {0.39595934638741204`, 
          0.01098033377673819}, {0.4300475942901762, 0.012560742022280687`}, {
          0.4626481511269155, 0.014429319815652963`}, {0.48897632891509246`, 
          0.01625439204981514}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.49296675285715336`, 0.016531008684577526`}, {
          0.49376101689762975`, 0.016586067156855008`}, {0.5233861916023189, 
          0.01903098404588682}, {0.5511649278522698, 0.021903257251945543`}, {
          0.5767384782587688, 0.025342073544228325`}, {0.6212700215414114, 
          0.033919335387466054`}, {0.6501795144732179, 
          0.04331287784508883}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6539837297562421, 0.044548979006161414`}, {
          0.6574024066927139, 0.04565980744674994}, {0.6855572189551433, 
          0.06146052759322994}, {0.7066496921288792, 0.0823520454747033}, {
          0.7214033290723582, 0.10954149407049109`}, {0.7305905392099711, 
          0.14426225396136128`}, {0.7332791274110022, 0.16475444942484024`}, {
          0.7337404437667153, 0.17165350183796582`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7340073143265253, 0.17564458942210961`}, {
          0.7347986104577926, 0.18747853681267546`}, {0.7348670039192392, 
          0.2308026067479722}, {0.7319839323393835, 0.28039541968188686`}, {
          0.7316936290847007, 0.2839414349689012}, {0.7313908128922378, 
          0.2875131194924334}, {0.7269667270713063, 0.3266680945695409}, {
          0.7258116507089605, 0.335182563397923}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7252739344932893, 0.3391462562810062}, {
          0.7213849861887637, 0.3678130442038631}, {0.7152719059359195, 
          0.4094618448291692}, {0.7080961469424722, 0.45211834743644286`}, {
          0.6999714011034299, 0.4950837135225799}, {0.6995609785980051, 
          0.49703391654947754`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6987372183389694, 0.5009481749767705}, {
          0.6910113603138004, 0.5376591045844762}, {0.6813457180764184, 
          0.5791987286480502}, {0.6711041678941188, 0.6190567937392208}, {
          0.6605184400272874, 0.6562629660853445}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6594238206752066, 0.6601102779357213}, {
          0.6583690781874828, 0.6638174326323755}, {0.6451478210714563, 
          0.7054920896934658}, {0.631686551077056, 0.7431258698970049}, {
          0.6182314227352984, 0.7757638782175059}, {0.6018322901607757, 
          0.8091013015203038}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.600066692638718, 0.812690544531038}, {
          0.5990748029642207, 0.8147069344710622}, {0.5806832585283863, 
          0.8456258654583961}, {0.5634358106491619, 0.8697090857623327}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.007991959384349424, 0.18737918942632123`}, {
          0.014665332619929012`, 0.19575462102647093`}, {0.02404284485226666, 
          0.21125452873000952`}, {0.038937399713556094`, 
          0.2389435150658879}, {0.06122684095593691, 0.2836717671747492}, {
          0.07289826755292106, 0.30815402451768015`}, {0.08242433440296044, 
          0.3286901142122216}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.08410753724805241, 0.33231872664430556`}, {
          0.08603590995585036, 0.33647587098469833`}, {0.10049582118279327`, 
          0.3685355646087313}, {0.11613405425181815`, 0.4042313634227067}, {
          0.13264560636247988`, 0.44301681653391284`}, {0.14758808292033565`, 
          0.4791735636722408}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.14911583691098265`, 0.4828703146435752}, {
          0.14972547471433337`, 0.48434547304963804`}, {0.16271516849528453`, 
          0.5165533981459839}, {0.17564170031914506`, 0.5492853488098967}, {
          0.18834798379382292`, 0.5820806167619507}, {0.20067693252722205`, 
          0.6144784937227098}, {0.20721354110163237`, 
          0.6319432947316374}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2086156478211007, 0.6356895057170494}, {
          0.21654686226824882`, 0.6568804766160631}, {0.23125509095513763`, 
          0.6968167623647062}, {0.23220817584001271`, 0.6994278385706469}, {
          0.23315513625933992`, 0.7020239606184527}, {0.24504513044513235`, 
          0.734840650937636}, {0.2557820553010721, 0.7644832403115248}, {
          0.26358919265807296`, 0.7859478138198195}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2649564491854812, 0.7897068841288533}, {
          0.2659399685095208, 0.7924109255543246}, {0.2749398584229873, 
          0.8169088025349469}, {0.28983109174382177`, 0.8563128613966663}, {
          0.30125887971686544`, 0.8846031461851092}, {0.31449650596901896`, 
          0.9130841577407179}, {0.3234564871128151, 0.9275012763716008}, {
          0.3301634417189963, 0.9348833727408711}, {0.330189687019687, 
          0.9349037920307228}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.33334672987062647`, 0.9373600250077289}, {
          0.3348252909022445, 0.9385103706114623}, {0.3389257158870297, 
          0.9408672338505835}, {0.3425447636272148, 0.9422686193013112}, {
          0.3456662295911617, 0.9430537018483448}, {0.34850786694327657`, 
          0.9435411099190769}, {0.35110961976304056`, 0.9438597813869771}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.9610126159531893}, {0.9990345385026703, 
          0.9609913329662609}, {0.9696328557403904, 0.9603346581097962}, {
          0.9420927242886611, 0.9597135144087203}, {0.8925971153168553, 
          0.9585778204727349}, {0.8494558297844842, 0.957566573004141}, {
          0.8400421321409274, 0.9573417907136108}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8360432719917645, 0.9572463050736557}, {
          0.8115769858887797, 0.9566620938487753}, {0.8068257181795436, 
          0.9565473689444552}, {0.8021542448459915, 0.9564343176472644}, {
          0.7703943048437545, 0.9556538724170947}, {0.7421029252912291, 
          0.9549499109362772}, {0.6914174176477923, 0.9536750408376361}, {
          0.676092428825847, 0.9532813802130061}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6720937478682476, 0.9531786641026224}, {
          0.6509226576300524, 0.9526348317576792}, {0.6179437514796188, 
          0.9517752291963395}, {0.568227157039481, 0.9504614056519424}, {
          0.5325904038976028, 0.9495064067842274}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9587219655338541, 0.6837119705762049}, {
          0.9159887583189529, 0.7090923473269792}, {0.8779326543830237, 
          0.7327505788633747}, {0.8438185189281922, 0.754643532371413}, {
          0.8394871580697053, 0.7574747188103694}, {0.8352166076158347, 
          0.7602738284143594}, {0.8230011686270816, 0.7684008331922664}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8196708774961272, 0.7706164958432777}, {
          0.8045387780725398, 0.7806839722907871}, {0.7767921762087373, 
          0.7992169157279356}, {0.7503048503493142, 0.8168345400111245}, {
          0.7263360764986495, 0.8326215259863946}, {0.6859410222097616, 
          0.8584491216519179}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6825319729436888, 0.8605408285562286}, {
          0.6498442166506991, 0.880122882526079}, {0.6195722245058977, 
          0.8966699472417003}, {0.5938086869298481, 0.9092379665392357}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.20192105761486553`, 0.050400212455347364`}, {
          0.2310241098935508, 0.05675524257666449}, {0.2617353422197898, 
          0.06412907248073081}, {0.29353722744135663`, 0.07265598098840816}, {
          0.3259122384060253, 0.08247024692055831}, {0.35601880242412554`, 
          0.09293071973305797}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3597698655751084, 0.09431647520388836}, {
          0.3901238575859159, 0.10656098496121579`}, {0.4210165189046342, 
          0.12109513000762809`}, {0.4503893615408025, 0.13749840974408714`}, {
          0.47364199171441806`, 0.15292380230558578`}, {0.4952681246792671, 
          0.1698902578392325}, {0.49827342403403857`, 
          0.17267134016004274`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5012092469100002, 0.17538812944907123`}, {
          0.51526776043535, 0.1883977763450274}, {0.5336408989826664, 
          0.20844635782297039`}, {0.5360070942687994, 0.21125173343278475`}, {
          0.5383405530325152, 0.21408588890658006`}, {0.5544914429346451, 
          0.2385092023620219}, {0.5686397587884312, 0.2647085000225044}, {
          0.5817938752090792, 0.2916812177555716}, {0.5880808190068137, 
          0.30773937583127114`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5895390835408124, 0.3114640858265435}, {
          0.5929595927634507, 0.3202007756338083}, {0.6022166434595903, 
          0.35007091034389287`}, {0.6096447593055423, 0.38109535857250376`}, {
          0.615349772969884, 0.4130015563160257}, {0.6194375171211925, 
          0.4455169395708434}, {0.621121877526172, 0.4677141740268536}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6214245336014829, 0.4717027075042206}, {
          0.6220549048110638, 0.4800100136437039}, {0.6231548993061511, 
          0.5145225065823292}, {0.6229027866713545, 0.5486303781792066}, {
          0.6214638529715736, 0.5819095882268223}, {0.6189723371386794, 
          0.6140910179269589}, {0.6170495608165953, 0.631426664453936}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6163438594696852, 0.6426071307291656}, {
          0.6158094838578031, 0.6426071307291656}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.20151070995072387`, 1.15}, {0.19687629648458113`, 
          1.1302868914489757`}, {0.1870570074596501, 1.0933643484661766`}, {
          0.17830845850066812`, 1.0642911839211286`}, {0.17039432484347358`, 
          1.0416069838616109`}, {0.1629774239798851, 1.023281831290051}, {
          0.1539782868639582, 1.0046739025079847`}, {0.15031362738163317`, 
          0.9990428676470912}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.14813179641385496`, 0.9956903143472846}, {
          0.1377579866428213, 0.9797501472614446}, {0.13721180560984406`, 
          0.9790813431095936}, {0.1366650579103053, 0.9784211931769761}, {
          0.1257255138608266, 0.968141120356546}, {0.11420697215926141`, 
          0.9596228486068679}, {0.08997270853501137, 0.9449036790634745}, {
          0.0638946167183734, 0.9328023557838603}, {0.038565179065588276`, 
          0.9197282096826157}, {0.02151979395719923, 0.9023880592010154}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.018715716170643684`, 0.8995354905748566}, {
          0.014501586045115849`, 0.895248485613629}, {0.010760229451103224`, 
          0.887676175449977}, {0.007767559400176594, 0.8797326562899801}, {
          0.005542252678650447, 0.8712967267694348}, {0.0030205281638741735`, 
          0.8556358133631217}, {0.0016794965022389672`, 0.8392465480424747}, {
          0.0009606639652322169, 0.822587323237586}, {0.000582868009676899, 
          0.8074007025699049}, {0.0003532419386694125, 0.7923259128024964}, {
          0.00021676599979087268`, 0.7774132100885689}, {
          0.00013749926751834636`, 0.763141808408893}, {
          0.00008856365235617128, 0.749085896166136}, {0.00007561935766867175,
           0.7432467641908352}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.00006675210620978785, 0.7392467740193659}, {
          0.00005791087142462761, 0.7352585198903073}, {
          0.00003823696132192895, 0.7214626555493651}, {
          0.000025674305940201902`, 0.7079119369607114}, {
          0.000017523084181695026`, 0.6946066231647166}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.982420449767751, 0.42304115961063726`}, {
          0.9452713410993222, 0.4552441352262494}, {0.9118889543784554, 
          0.4875268052120116}, {0.8816403251458672, 0.5195956280755437}, {
          0.8777797012494438, 0.5238977668962438}, {0.8739666767523326, 
          0.5281904245278117}, {0.8683358704795866, 0.5349420768125693}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8657739437201243, 0.538013970573615}, {
          0.8571010120403727, 0.5484133017092934}, {0.8411201762929797, 
          0.5683277511162922}, {0.8113555020038121, 0.6067292906028515}, {
          0.7828879831687156, 0.6439514415027064}, {0.7677040929072172, 
          0.6644112794285824}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7653202991395147, 0.6676233702232305}, {
          0.7570147752417615, 0.678814815229153}, {0.7333694789238316, 
          0.7111161746685053}, {0.711585694915808, 0.7406522827070778}, {
          0.6914540053565984, 0.7674160651513953}, {0.6727649923851106, 
          0.7914004478079821}, {0.6693357615712766, 0.795618189175829}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6668123646838165, 0.7987218109550343}, {
          0.6559223332063445, 0.8121158747416993}, {0.6401107941231521, 
          0.8306055929896448}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.0726354132149987}, {0.9797407828781172, 
          0.07952260995481178}, {0.9549158525480289, 0.09009910330778362}, {
          0.9329131476655398, 0.10189030153809975`}, {0.8957123717678481, 
          0.1294802984284502}, {0.8934724692892321, 0.13152900585319185`}, {
          0.891262491749183, 0.13360446839081494`}, {0.875259403446674, 
          0.1523535054427732}, {0.8696798258312124, 
          0.16019313408533223`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.867360424831514, 0.16345202638220216`}, {
          0.8605154595659482, 0.17306959772031713`}, {0.8462821234542818, 
          0.19474561596022616`}, {0.8330700028807341, 0.21834148612486542`}, {
          0.8206669885374103, 0.2438108954422311}, {0.8088609711164154, 
          0.27110753114031944`}, {0.7975064650358004, 0.30008992637906823`}, {
          0.7954562131516919, 0.30575472349488214`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7940949157064472, 0.3095159559080109}, {
          0.786457984713616, 0.33061661431841527`}, {0.7752090877410085, 
          0.36347973196771827`}, {0.7640754989392153, 0.3971096199262486}, {
          0.7530572183082368, 0.4315062781940062}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.010808276982210856`, 0.11366037247768163`}, {
          0.020142352714313867`, 0.12088660628891897`}, {0.03831805854841904, 
          0.13782970790516683`}, {0.07129924115738799, 0.1714705160801383}, {
          0.10227610379375068`, 0.2049405778298005}, {0.1209381192176681, 
          0.22602632857039046`}, {0.12254369055919041`, 
          0.22790770489640147`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.12514028949147515`, 0.2309503474953371}, {
          0.1416432419519349, 0.2502881765070059}, {0.1640932730095261, 
          0.27776634545055506`}, {0.1879900134034168, 0.30850105921194615`}, {
          0.2129744696276323, 0.3423733454932403}, {0.2232636671864492, 
          0.3572314167545538}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.22554093207244374`, 0.36051989127004214`}, {
          0.23838943009657645`, 0.37907370930610684`}, {0.2548150545586289, 
          0.4041800998455383}, {0.271004925910955, 0.4301317312874976}, {
          0.2867344592702193, 0.45660981709109205`}, {0.30193191984725465`, 
          0.4835436113581864}, {0.309068342760124, 0.49687180030233513`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.31095647218867845`, 0.5003981251967581}, {
          0.3164820807158255, 0.5107179108064934}, {0.33026971494969654`, 
          0.5379175121537259}, {0.33207642589527364`, 0.5415847741133107}, {
          0.3338675634079674, 0.5452482424061782}, {0.3529708271870995, 
          0.5883965603702987}, {0.3696080059927753, 0.62963968167688}, {
          0.37608670026906105`, 0.6464043931235386}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3775285722467407, 0.6501354794532799}, {
          0.38499970858582233`, 0.6694683017106617}, {0.39790045875361185`, 
          0.7064679191988444}, {0.40847512567913086`, 0.7403296763308033}, {
          0.4168885785453667, 0.7707447152959137}, {0.42338225282528275`, 
          0.7977319365258512}, {0.4244428304031802, 0.8029250623160135}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.42524321815427646`, 0.8068441667351244}, {
          0.4281975839918426, 0.8213102404522915}, {0.43389497343678224`, 
          0.8583760659140905}, {0.435638319483246, 0.8851358444138618}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5084437047157727, 1.15}, {0.5084082398563076, 
          1.1499096270012632`}, {0.4966495442941996, 1.1210179386134094`}, {
          0.47757030346417173`, 1.0765273957852795`}, {0.4764562395541205, 
          1.0740285357264014`}, {0.4753615853236102, 1.0715841224715434`}, {
          0.4675894068941483, 1.0548248077532298`}, {0.46073041756606903`, 
          1.0405061004615592`}, {0.44858253639245144`, 1.0159623093994508`}, {
          0.4423775210294151, 1.0043675439471538`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.44017942063371573`, 0.9988531814380165}, {
          0.43942647348754615`, 0.9988531814380165}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.05953258930189595, 0.3943212217418805}, {
          0.06727534276680903, 0.4229818389785769}, {0.07526788189609397, 
          0.45401558343865117`}, {0.0832898865022923, 0.4867148634671308}, {
          0.09187610779047584, 0.5238778152115671}, {0.09744865734566155, 
          0.549738882837567}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.09829123905668165, 0.553649132965149}, {
          0.10011514225208229`, 0.5621134962538773}, {0.10777765973876421`, 
          0.6005275804594795}, {0.1146343301021741, 0.6382257416937916}, {
          0.12053148832716866`, 0.6744293332377406}, {0.1253154693986046, 
          0.708359708372253}, {0.125649267090357, 0.7112476285742266}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.12610854580668424`, 0.7152211739760974}, {
          0.1289307504481261, 0.7396380648039977}, {0.13131677058289865`, 
          0.7677748464130109}, {0.13256255135097403`, 0.809267445155387}, {
          0.132541855818284, 0.8104975996618802}, {0.1325170429776696, 
          0.8117165995871446}, {0.13093163395580895`, 0.829170431492371}, {
          0.12826443949204624`, 0.8440066034945735}, {0.12083108918145567`, 
          0.8688435464833847}, {0.11812380428111145`, 
          0.8726815356610075}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.11581814248410424`, 0.8759501628465124}, {
          0.10934594638736946`, 0.8851254877528649}, {0.09411271843762375, 
          0.8947983609935394}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7000126704838011, 1.15}, {0.6838336115890866, 
          1.1320976739693713`}, {0.6586450846038822, 1.1055432289330769`}, {
          0.636622003370999, 1.0833105790749387`}, {0.6338650217120669, 
          1.080603314754877}, {0.6311554224393783, 1.0779581094333726`}, {
          0.61784443825854, 1.0653922723309794`}, {0.6056118901946339, 
          1.054171678525248}, {0.5866315597678032, 1.0372618364643753`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5836449276738833, 1.034601004125507}, {
          0.5830615363272608, 1.0340812526085827`}, {0.5639392353538721, 
          1.018120063193045}, {0.5475481278100937, 1.0053128446293857`}, {
          0.5139329723823047, 0.9819578791797015}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.24670206981448267`}, {0.9668903226725137, 
          0.27222877905708176`}, {0.9369235729742608, 0.29947376532990533`}, {
          0.9331234770762282, 0.3032396360675635}, {0.9293751200344278, 
          0.3070294655705617}, {0.8995586752643364, 0.34279975464595247`}, {
          0.887502022631277, 0.35931027779952524`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8851430698324312, 0.36254065574843736`}, {
          0.8724526471454956, 0.37991907113271683`}, {0.8464655667751125, 
          0.4173551069733554}, {0.8227163819016448, 0.45542458152174253`}, {
          0.8008166273972714, 0.4936398634532358}, {0.7989197684118947, 
          0.49715477855758794`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7970200995309986, 0.5006749004507836}, {
          0.7803778381341718, 0.5315133214431931}, {0.7611818854213926, 
          0.5685941048663276}, {0.7430106405679806, 0.6044313630973523}, {
          0.727282603884666, 0.6360545448080503}, {0.7238610773382753, 
          0.6429562809397394}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.71984260284645, 0.661751162839457}, {0.7145435395290713,
           0.661751162839457}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9106584515354561, 1.138962939886078}, {
          0.8842316930004651, 1.1242654674754922`}, {0.859586581261107, 
          1.110754818570249}, {0.8156412981692903, 1.0872939912757913`}, {
          0.8102031694842006, 1.0844542401538888`}, {0.8048699729403089, 
          1.0816817471567277`}, {0.7751971668793955, 1.066679417672204}, {
          0.7694172055234665, 1.0638291964680762`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7658296800143823, 1.0620601117551045`}, {
          0.7485852871023686, 1.053556536851491}, {0.7232920147120079, 
          1.041236463679511}, {0.7006359570949796, 1.030522005804997}, {
          0.6618764759475498, 1.0129967422366057`}, {0.6300155855455457, 
          0.9994647919408818}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3548639334195923, 1.15}, {0.3514093567415543, 
          1.132924743954166}, {0.3463575283083049, 1.1078248262546373`}, {
          0.3385608764661015, 1.0683754369161496`}, {0.33812552342029223`, 
          1.066126724314788}, {0.3377004344010081, 1.0639235940785507`}, {
          0.3342640144104573, 1.045383402859212}, {0.331543228940178, 
          1.0299136046501962`}, {0.3273157001163407, 1.0040327656713743`}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.98799790396016, 0.824318591479259}, {0.9614942481179388,
           0.8316762381173142}, {0.936810675780761, 0.8386330515134828}, {
          0.930409626883344, 0.8404522186739751}, {0.9241189186025389, 
          0.8422443618024801}, {0.8875988118317715, 0.8527751773403117}, {
          0.8546121578861683, 0.8623364803435737}, {0.8341517017416165, 
          0.8682604132683472}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.830309503337386, 0.8693728481754446}, {
          0.823159585254092, 0.8714429699187634}, {0.7947751752490704, 
          0.879639832637809}, {0.769087895416055, 0.8870045624133035}, {
          0.745726713299999, 0.893614653157841}, {0.7049362468335371, 
          0.9048395290745207}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.0929929916126462, 1.15}, {0.08465544086542066, 
          1.129188889324418}, {0.06799622400325998, 1.094812441606252}, {
          0.06691948749536304, 1.0927914885687215`}, {0.06584935729814786, 
          1.0908036081796302`}, {0.05759503966567307, 1.0766281568576337`}, {
          0.04983803486265575, 1.0639759397921107`}, {0.03555760535242913, 
          1.0410533100229193`}, {0.023946006858832095`, 
          1.0219973701141807`}, {0.017351111103734863`, 
          1.0093465235213266`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.015502069422566859`, 1.0057995466590812`}, {
          0.015230496160272774`, 1.005278593514773}, {0.01120531082407512, 
          0.9955492963137371}, {0.008125633433769772, 0.986131329123122}, {
          0.00583077643966174, 0.9769056723652565}, {0.0029774950959918253`, 
          0.9590449288488035}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.006302186789323222}, {0.9763186813487597, 
          0.007058565446987368}, {0.9395632300874686, 0.008951110183311139}, {
          0.9107426959453558, 0.011370674439836477`}, {0.8877517998015447, 
          0.014446380725209634`}, {0.8696110189244511, 
          0.018289963664117455`}, {0.8549042910061472, 0.02313137490482253}, {
          0.8430902000950558, 0.0293658798749722}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8396698556350507, 0.03138787993248829}, {
          0.8197743277343238, 0.05224988782516116}, {0.8192042924307237, 
          0.05314776669384465}, {0.8186393176612913, 0.05406010015245548}, {
          0.8123444207794711, 0.06769107826457589}, {0.8073008399563562, 
          0.08108665253248365}, {0.8023153310322116, 0.09678242955499847}, {
          0.7922327406150529, 0.1331781535596479}, {0.7821204964583194, 
          0.17751190476894613`}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.46117955810874717`, 0.05820431729167524}, {
          0.4916243371702479, 0.06707287426709359}, {0.5200699079889889, 
          0.07723389963090872}, {0.5462154155811227, 0.08886835678829003}, {
          0.5843690372017607, 0.11216168713540742`}, {0.6026262023403438, 
          0.12889363057348704`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6055751239126215, 0.1315961963100706}, {
          0.6156048921399314, 0.14078806774260458`}, {0.6174778564173722, 
          0.1428981067862283}, {0.6193200097083341, 0.14503499942772602`}, {
          0.6315979421531425, 0.16351929672002363`}, {0.6421715258003791, 
          0.18380383400037223`}, {0.6600057315588962, 0.22788203627404235`}, {
          0.6665188983494831, 0.2525050559729904}, {0.6707703258104645, 
          0.2747707318450771}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6715205359700457, 0.2786997501342253}, {
          0.6715371544986826, 0.2787867850831914}, {0.6751420751934727, 
          0.306597780268812}, {0.6774152356208312, 0.3358085981940189}, {
          0.6785470049180533, 0.36937822832648587`}, {0.6783759720620013, 
          0.4037191970236979}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9632506062820955, 0.578361567988282}, {
          0.9576157758986554, 0.5825292403308685}, {0.95206688121142, 
          0.5866778085835272}, {0.9154944638125696, 0.6160820964212395}, {
          0.8823573305616552, 0.6441480976990258}, {0.850699900636691, 
          0.6714306296247068}, {0.8403337502867646, 0.6807194821402569}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8373547673842577, 0.6833888754920452}, {
          0.8220018773636277, 0.6971462228461772}, {0.7958824896717844, 
          0.7212336791378716}, {0.771960966490481, 0.7436318002742249}, {
          0.749984957854487, 0.7643468767128212}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.23345260624243847`, 0.10840046778514222`}, {
          0.263760101048499, 0.12225747722586919`}, {0.29486790445744504`, 
          0.1380797346226339}, {0.32632914389717016`, 0.155978233996493}, {
          0.35739556568161396`, 0.17612142058722574`}, {0.37232158480418337`, 
          0.1871408785375827}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3755396097344574, 0.18951665536803944`}, {
          0.38166100699906863`, 0.19403590991279726`}, {0.4050177306739598, 
          0.2135054125833491}, {0.42724622246488786`, 0.23452601397023926`}, {
          0.44812696813045316`, 0.2570937994448258}, {0.4508484051586081, 
          0.26023738778307}, {0.45354218794753387`, 0.263408141370796}, {
          0.47361122208673956`, 0.2916786212715149}, {0.48270860662659143`, 
          0.30681068273417783`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.48476961189201084`, 0.3102388392790155}, {
          0.4916033883537257, 0.3216057464365371}, {0.5085172020898356, 
          0.3521724851107736}, {0.5232743107641934, 0.38401845080343877`}, {
          0.5359134575735687, 0.41684065955125066`}, {0.5464733857147314, 
          0.45033612739092743`}, {0.5480507683751632, 
          0.45655054874996653`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5490348661961311, 0.46042760323485143`}, {
          0.555056493069509, 0.484151032936963}, {0.5617651775197295, 
          0.5179315548038511}, {0.5669377461867247, 0.5536382248926459}, {
          0.570311072290544, 0.5886428327862407}, {0.5718647716075591, 
          0.6184402352225573}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5720731376789522, 0.6224394522191699}, {
          0.5720732992042016, 0.6224394522191699}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9758885438793296, 1.0605240777890823`}, {
          0.9676871539624923, 1.0582809934951445`}, {0.9596535332945797, 
          1.0560893557150068`}, {0.9216468677447329, 1.0458639765099353`}, {
          0.8872388765785421, 1.0367179106712852`}, {0.8544093372171426, 
          1.0280450556075251`}, {0.8247367014653267, 1.0203186220935458`}, {
          0.8212579301141818, 1.0194265552265633`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8173832945376153, 1.0184329762670412`}, {
          0.7978548988249701, 1.013425278714617}, {0.7733978587979493, 
          1.0072516940560081`}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2751399224313414, 1.15}, {0.27134684058738295`, 
          1.1299784017348316`}, {0.2639087476278454, 1.0914365470637752`}, {
          0.2580829550937208, 1.0615766086849758`}, {0.25218526938262753`, 
          1.0315434200054154`}, {0.24782210080931508`, 1.0092106669952403`}, {
          0.24660933132871882`, 1.0029566672531889`}, {0.24552061090269878`, 
          0.9972986649637522}, {0.24468705630290538`, 
          0.9929251539766886}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.24394739571736562`, 0.9889941514469782}, {
          0.24068227376150197`, 0.9709993935195665}, {0.2406003551838934, 
          0.9705192055592334}, {0.24052010013281072`, 0.9700465136669146}, {
          0.2404447614052405, 0.9695994584979161}, {0.24026669902854336`, 
          0.968534012695507}, {0.24011228974700718`, 0.9675988375938334}, {
          0.23996475695351635`, 0.966694343762346}, {0.23881204597196148`, 
          0.9590664107094905}, {0.2381592258893808, 0.9535984331113838}, {
          0.23787362541534385`, 0.9496565624409958}, {0.23799481857587454`, 
          0.9451737602219412}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.17469455202041329`, 0.728347870918103}, {
          0.18245936238711036`, 0.7596928504099044}, {0.18922830181139907`, 
          0.787682369681002}, {0.19503726906096155`, 0.8122978410557996}, {
          0.19996478154813088`, 0.8336120755006888}, {0.20728857128101366`, 
          0.8661144584934992}, {0.20749201175667614`, 0.8670364006984831}, {
          0.20769287923217455`, 0.8679477927374032}, {0.21112832019388306`, 
          0.883936334724735}, {0.21116815551136486`, 0.8841272596440215}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2119851379403838, 0.8880429383477297}, {
          0.21375208692450795`, 0.8965116694512645}, {0.21761976220264975`, 
          0.9157304608411296}}]}}}}, {{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1nk01Pv/B3BbZUtpkSmlonKjROSGPAtFobRIWeom5RKXkCVKIRVKi3uR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          "]]},
        Annotation[#, "Charting`Private`Tag$137477#1"]& ], 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
         LineBox[CompressedData["
1:eJw91gkw1lvcB3C0IF1LF6WIEuVe5KaI4ltUJJQiaRHZQqTlupQSeVQiS9Yi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          "]]},
        Annotation[#, "Charting`Private`Tag$137477#2"]& ]}, {}}, {{{}, {}, 
       TagBox[
        {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
         0.3]], LineBox[CompressedData["
1:eJyV0nlUjGscB/Bu2pBLYynStOkq0kZDi34tQqEoLidr1onJdLVRKVqUw0nd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          "]]},
        Annotation[#, "Charting`Private`Tag$139072#1"]& ]}, {}}},
    AspectRatio->1,
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{
      FormBox["\"A\"", TraditionalForm], 
      FormBox["\"H\"", TraditionalForm]},
    FrameStyle->Directive[FontFamily -> "Arial", 18],
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{
     "VectorLengthFunction" -> 
      Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
        System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
        System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
        System`VectorPlotsDump`imin = If[
           NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
           Min[System`VectorPlotsDump`m], 
           Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
           NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
           Max[System`VectorPlotsDump`m], 
           Max[System`VectorPlotsDump`m]]; Map[If[
           
           Or[# > System`VectorPlotsDump`imax, # < 
            System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
          System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "TransparentPolygonMesh" -> True},
    PlotRange->{{0, 1}, {0, 1.15}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.005315180259893875, 0.05755118502610765}, {
          0.009253754587488863, 0.05840574958364356}, {0.016370375073678525`, 
          0.0609785752395866}, {0.028803134761993244`, 0.06636302282993478}, {
          0.053010315051178904`, 0.07770799529403206}, {0.09466376845094, 
          0.09847581472431756}, {0.12425765507992212`, 
          0.11418316931239039`}, {0.14865974365042334`, 
          0.12806082177891087`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.1521367844190754, 0.13003824118134713`}, {
          0.1599378318547599, 0.13447475590321162`}, {0.17990280082841412`, 
          0.1466053545174627}, {0.20120036847637957`, 0.16020087311377262`}, {
          0.22345991901214995`, 0.1752829406951391}, {0.2463108366492189, 
          0.19187318626455974`}, {0.2760296445461572, 0.21558976259231932`}, {
          0.2829512159782154, 0.2217245443905069}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.28594465685093134`, 0.22437771452104008`}, {
          0.3058495418315339, 0.2420199692131521}, {0.3351485153210076, 
          0.2710984463619623}, {0.36330455183023674`, 0.30275983427365394`}, {
          0.3898353270178829, 0.3367432423166446}, {0.39355968297816624`, 
          0.3422397679893843}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.39580344847724896`, 0.3455511900985583}, {
          0.41425851654260754`, 0.3727877798593517}, {0.4363463164276536, 
          0.4105754218659062}, {0.4558010146849347, 0.4495188239708809}, {
          0.46859958717770617`, 0.4790677798611667}, {0.4712997078902921, 
          0.4861678660757577}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.472721539629453, 0.4899066351921267}, {
          0.47986892854918084`, 0.508701008829844}, {0.48964785181892806`, 
          0.5381699484789161}, {0.4979751700065175, 0.5672260364103864}, {
          0.4989998462268385, 0.5711149401586452}, {0.4999993118585184, 
          0.5749917606218528}, {0.5079184844627271, 0.6147726369262214}, {
          0.5123620734002896, 0.644472934211557}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5129539428953563, 0.6484289031827207}, {
          0.5135326731031374, 0.6522970510831271}, {0.5181334132141361, 
          0.6884026284699597}, {0.5207072562663115, 0.7216705323166468}, {
          0.5215571972751283, 0.7519689790059109}, {0.5209862312560516, 
          0.7791661849204752}, {0.5182190440616476, 0.8078433778755741}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5178348511442498, 0.8118248846006999}, {
          0.5166024802937436, 0.8245963142834022}, {0.5098469554205088, 
          0.8581851131811045}, {0.5014703659046529, 0.8831291656567161}, {
          0.4829984695442805, 0.9139570361389971}, {0.4656828608938726, 
          0.92930708233566}, {0.45348891696877963`, 0.9362945802006839}, {
          0.44315373522107315`, 0.9406613943660665}, {0.44099471440144283`, 
          0.941268044770384}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.4371438438283965, 0.9423500779628718}, {
          0.43428810473678353`, 0.9431524950858566}, {0.4269112735335155, 
          0.9444448820531242}, {0.4205741042917906, 0.9451371420273712}, {
          0.41512926390729454`, 0.9454962908278867}, {0.41040315750307815`, 
          0.9456648234478999}, {0.4063240292493229, 0.9457231538348787}, {
          0.4027920053989766, 0.9457219946009322}, {0.3979908454307735, 
          0.9456583373884356}, {0.39414436023717564`, 0.945565710873157}, {
          0.39104213508205493`, 0.9454825986151288}, {0.38644551986863024`, 
          0.9453627017937808}, {0.38338142573177797`, 0.9452805476229514}, {
          0.38128807368524203`, 0.9452131082959411}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.0012485535472057541`, 0.0019363574419383924`}, {
          0.002079759749410058, 0.0019095332242724634`}, {
          0.0037184635600041945`, 0.0018976191925662955`}, {
          0.007367205051851271, 0.0019208623204036294`}, {
          0.016177776058389666`, 0.0020205075282379898`}, {
          0.03149051638942077, 0.002227170284528127}, {0.061166842404928416`, 
          0.0026658583309231033`}, {0.08540916962016178, 
          0.0030211914095529184`}, {0.11726588368895359`, 
          0.003517818895600946}, {0.15209120132918633`, 
          0.00414117741646965}, {0.16122897973583986`, 
          0.004321050889195625}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.16522820499437332`, 0.004399774021170686}, {
          0.19320012622796473`, 0.004950389979141391}, {0.23953501141086506`, 
          0.00599306365477582}, {0.29003820990346385`, 
          0.007316805514532598}, {0.3163785391140037, 0.008094879512852182}, {
          0.3251774575317451, 0.008384456976941405}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3291752930779486, 0.008516028043333054}, {
          0.34281217159817484`, 0.008964825555992971}, {0.3693391073559777, 
          0.009926643643954973}, {0.39595934638741204`, 
          0.01098033377673819}, {0.4300475942901762, 0.012560742022280687`}, {
          0.4626481511269155, 0.014429319815652963`}, {0.48897632891509246`, 
          0.01625439204981514}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.49296675285715336`, 0.016531008684577526`}, {
          0.49376101689762975`, 0.016586067156855008`}, {0.5233861916023189, 
          0.01903098404588682}, {0.5511649278522698, 0.021903257251945543`}, {
          0.5767384782587688, 0.025342073544228325`}, {0.6212700215414114, 
          0.033919335387466054`}, {0.6501795144732179, 
          0.04331287784508883}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6539837297562421, 0.044548979006161414`}, {
          0.6574024066927139, 0.04565980744674994}, {0.6855572189551433, 
          0.06146052759322994}, {0.7066496921288792, 0.0823520454747033}, {
          0.7214033290723582, 0.10954149407049109`}, {0.7305905392099711, 
          0.14426225396136128`}, {0.7332791274110022, 0.16475444942484024`}, {
          0.7337404437667153, 0.17165350183796582`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7340073143265253, 0.17564458942210961`}, {
          0.7347986104577926, 0.18747853681267546`}, {0.7348670039192392, 
          0.2308026067479722}, {0.7319839323393835, 0.28039541968188686`}, {
          0.7316936290847007, 0.2839414349689012}, {0.7313908128922378, 
          0.2875131194924334}, {0.7269667270713063, 0.3266680945695409}, {
          0.7258116507089605, 0.335182563397923}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7252739344932893, 0.3391462562810062}, {
          0.7213849861887637, 0.3678130442038631}, {0.7152719059359195, 
          0.4094618448291692}, {0.7080961469424722, 0.45211834743644286`}, {
          0.6999714011034299, 0.4950837135225799}, {0.6995609785980051, 
          0.49703391654947754`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6987372183389694, 0.5009481749767705}, {
          0.6910113603138004, 0.5376591045844762}, {0.6813457180764184, 
          0.5791987286480502}, {0.6711041678941188, 0.6190567937392208}, {
          0.6605184400272874, 0.6562629660853445}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6594238206752066, 0.6601102779357213}, {
          0.6583690781874828, 0.6638174326323755}, {0.6451478210714563, 
          0.7054920896934658}, {0.631686551077056, 0.7431258698970049}, {
          0.6182314227352984, 0.7757638782175059}, {0.6018322901607757, 
          0.8091013015203038}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.600066692638718, 0.812690544531038}, {
          0.5990748029642207, 0.8147069344710622}, {0.5806832585283863, 
          0.8456258654583961}, {0.5634358106491619, 0.8697090857623327}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.007991959384349424, 0.18737918942632123`}, {
          0.014665332619929012`, 0.19575462102647093`}, {0.02404284485226666, 
          0.21125452873000952`}, {0.038937399713556094`, 
          0.2389435150658879}, {0.06122684095593691, 0.2836717671747492}, {
          0.07289826755292106, 0.30815402451768015`}, {0.08242433440296044, 
          0.3286901142122216}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.08410753724805241, 0.33231872664430556`}, {
          0.08603590995585036, 0.33647587098469833`}, {0.10049582118279327`, 
          0.3685355646087313}, {0.11613405425181815`, 0.4042313634227067}, {
          0.13264560636247988`, 0.44301681653391284`}, {0.14758808292033565`, 
          0.4791735636722408}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.14911583691098265`, 0.4828703146435752}, {
          0.14972547471433337`, 0.48434547304963804`}, {0.16271516849528453`, 
          0.5165533981459839}, {0.17564170031914506`, 0.5492853488098967}, {
          0.18834798379382292`, 0.5820806167619507}, {0.20067693252722205`, 
          0.6144784937227098}, {0.20721354110163237`, 
          0.6319432947316374}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2086156478211007, 0.6356895057170494}, {
          0.21654686226824882`, 0.6568804766160631}, {0.23125509095513763`, 
          0.6968167623647062}, {0.23220817584001271`, 0.6994278385706469}, {
          0.23315513625933992`, 0.7020239606184527}, {0.24504513044513235`, 
          0.734840650937636}, {0.2557820553010721, 0.7644832403115248}, {
          0.26358919265807296`, 0.7859478138198195}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2649564491854812, 0.7897068841288533}, {
          0.2659399685095208, 0.7924109255543246}, {0.2749398584229873, 
          0.8169088025349469}, {0.28983109174382177`, 0.8563128613966663}, {
          0.30125887971686544`, 0.8846031461851092}, {0.31449650596901896`, 
          0.9130841577407179}, {0.3234564871128151, 0.9275012763716008}, {
          0.3301634417189963, 0.9348833727408711}, {0.330189687019687, 
          0.9349037920307228}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.33334672987062647`, 0.9373600250077289}, {
          0.3348252909022445, 0.9385103706114623}, {0.3389257158870297, 
          0.9408672338505835}, {0.3425447636272148, 0.9422686193013112}, {
          0.3456662295911617, 0.9430537018483448}, {0.34850786694327657`, 
          0.9435411099190769}, {0.35110961976304056`, 0.9438597813869771}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.9610126159531893}, {0.9990345385026703, 
          0.9609913329662609}, {0.9696328557403904, 0.9603346581097962}, {
          0.9420927242886611, 0.9597135144087203}, {0.8925971153168553, 
          0.9585778204727349}, {0.8494558297844842, 0.957566573004141}, {
          0.8400421321409274, 0.9573417907136108}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8360432719917645, 0.9572463050736557}, {
          0.8115769858887797, 0.9566620938487753}, {0.8068257181795436, 
          0.9565473689444552}, {0.8021542448459915, 0.9564343176472644}, {
          0.7703943048437545, 0.9556538724170947}, {0.7421029252912291, 
          0.9549499109362772}, {0.6914174176477923, 0.9536750408376361}, {
          0.676092428825847, 0.9532813802130061}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6720937478682476, 0.9531786641026224}, {
          0.6509226576300524, 0.9526348317576792}, {0.6179437514796188, 
          0.9517752291963395}, {0.568227157039481, 0.9504614056519424}, {
          0.5325904038976028, 0.9495064067842274}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9587219655338541, 0.6837119705762049}, {
          0.9159887583189529, 0.7090923473269792}, {0.8779326543830237, 
          0.7327505788633747}, {0.8438185189281922, 0.754643532371413}, {
          0.8394871580697053, 0.7574747188103694}, {0.8352166076158347, 
          0.7602738284143594}, {0.8230011686270816, 0.7684008331922664}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8196708774961272, 0.7706164958432777}, {
          0.8045387780725398, 0.7806839722907871}, {0.7767921762087373, 
          0.7992169157279356}, {0.7503048503493142, 0.8168345400111245}, {
          0.7263360764986495, 0.8326215259863946}, {0.6859410222097616, 
          0.8584491216519179}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6825319729436888, 0.8605408285562286}, {
          0.6498442166506991, 0.880122882526079}, {0.6195722245058977, 
          0.8966699472417003}, {0.5938086869298481, 0.9092379665392357}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.20192105761486553`, 0.050400212455347364`}, {
          0.2310241098935508, 0.05675524257666449}, {0.2617353422197898, 
          0.06412907248073081}, {0.29353722744135663`, 0.07265598098840816}, {
          0.3259122384060253, 0.08247024692055831}, {0.35601880242412554`, 
          0.09293071973305797}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3597698655751084, 0.09431647520388836}, {
          0.3901238575859159, 0.10656098496121579`}, {0.4210165189046342, 
          0.12109513000762809`}, {0.4503893615408025, 0.13749840974408714`}, {
          0.47364199171441806`, 0.15292380230558578`}, {0.4952681246792671, 
          0.1698902578392325}, {0.49827342403403857`, 
          0.17267134016004274`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5012092469100002, 0.17538812944907123`}, {
          0.51526776043535, 0.1883977763450274}, {0.5336408989826664, 
          0.20844635782297039`}, {0.5360070942687994, 0.21125173343278475`}, {
          0.5383405530325152, 0.21408588890658006`}, {0.5544914429346451, 
          0.2385092023620219}, {0.5686397587884312, 0.2647085000225044}, {
          0.5817938752090792, 0.2916812177555716}, {0.5880808190068137, 
          0.30773937583127114`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5895390835408124, 0.3114640858265435}, {
          0.5929595927634507, 0.3202007756338083}, {0.6022166434595903, 
          0.35007091034389287`}, {0.6096447593055423, 0.38109535857250376`}, {
          0.615349772969884, 0.4130015563160257}, {0.6194375171211925, 
          0.4455169395708434}, {0.621121877526172, 0.4677141740268536}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6214245336014829, 0.4717027075042206}, {
          0.6220549048110638, 0.4800100136437039}, {0.6231548993061511, 
          0.5145225065823292}, {0.6229027866713545, 0.5486303781792066}, {
          0.6214638529715736, 0.5819095882268223}, {0.6189723371386794, 
          0.6140910179269589}, {0.6170495608165953, 0.631426664453936}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6163438594696852, 0.6426071307291656}, {
          0.6158094838578031, 0.6426071307291656}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.20151070995072387`, 1.15}, {0.19687629648458113`, 
          1.1302868914489757`}, {0.1870570074596501, 1.0933643484661766`}, {
          0.17830845850066812`, 1.0642911839211286`}, {0.17039432484347358`, 
          1.0416069838616109`}, {0.1629774239798851, 1.023281831290051}, {
          0.1539782868639582, 1.0046739025079847`}, {0.15031362738163317`, 
          0.9990428676470912}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.14813179641385496`, 0.9956903143472846}, {
          0.1377579866428213, 0.9797501472614446}, {0.13721180560984406`, 
          0.9790813431095936}, {0.1366650579103053, 0.9784211931769761}, {
          0.1257255138608266, 0.968141120356546}, {0.11420697215926141`, 
          0.9596228486068679}, {0.08997270853501137, 0.9449036790634745}, {
          0.0638946167183734, 0.9328023557838603}, {0.038565179065588276`, 
          0.9197282096826157}, {0.02151979395719923, 0.9023880592010154}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.018715716170643684`, 0.8995354905748566}, {
          0.014501586045115849`, 0.895248485613629}, {0.010760229451103224`, 
          0.887676175449977}, {0.007767559400176594, 0.8797326562899801}, {
          0.005542252678650447, 0.8712967267694348}, {0.0030205281638741735`, 
          0.8556358133631217}, {0.0016794965022389672`, 0.8392465480424747}, {
          0.0009606639652322169, 0.822587323237586}, {0.000582868009676899, 
          0.8074007025699049}, {0.0003532419386694125, 0.7923259128024964}, {
          0.00021676599979087268`, 0.7774132100885689}, {
          0.00013749926751834636`, 0.763141808408893}, {
          0.00008856365235617128, 0.749085896166136}, {0.00007561935766867175,
           0.7432467641908352}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.00006675210620978785, 0.7392467740193659}, {
          0.00005791087142462761, 0.7352585198903073}, {
          0.00003823696132192895, 0.7214626555493651}, {
          0.000025674305940201902`, 0.7079119369607114}, {
          0.000017523084181695026`, 0.6946066231647166}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.982420449767751, 0.42304115961063726`}, {
          0.9452713410993222, 0.4552441352262494}, {0.9118889543784554, 
          0.4875268052120116}, {0.8816403251458672, 0.5195956280755437}, {
          0.8777797012494438, 0.5238977668962438}, {0.8739666767523326, 
          0.5281904245278117}, {0.8683358704795866, 0.5349420768125693}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8657739437201243, 0.538013970573615}, {
          0.8571010120403727, 0.5484133017092934}, {0.8411201762929797, 
          0.5683277511162922}, {0.8113555020038121, 0.6067292906028515}, {
          0.7828879831687156, 0.6439514415027064}, {0.7677040929072172, 
          0.6644112794285824}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7653202991395147, 0.6676233702232305}, {
          0.7570147752417615, 0.678814815229153}, {0.7333694789238316, 
          0.7111161746685053}, {0.711585694915808, 0.7406522827070778}, {
          0.6914540053565984, 0.7674160651513953}, {0.6727649923851106, 
          0.7914004478079821}, {0.6693357615712766, 0.795618189175829}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6668123646838165, 0.7987218109550343}, {
          0.6559223332063445, 0.8121158747416993}, {0.6401107941231521, 
          0.8306055929896448}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.0726354132149987}, {0.9797407828781172, 
          0.07952260995481178}, {0.9549158525480289, 0.09009910330778362}, {
          0.9329131476655398, 0.10189030153809975`}, {0.8957123717678481, 
          0.1294802984284502}, {0.8934724692892321, 0.13152900585319185`}, {
          0.891262491749183, 0.13360446839081494`}, {0.875259403446674, 
          0.1523535054427732}, {0.8696798258312124, 
          0.16019313408533223`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.867360424831514, 0.16345202638220216`}, {
          0.8605154595659482, 0.17306959772031713`}, {0.8462821234542818, 
          0.19474561596022616`}, {0.8330700028807341, 0.21834148612486542`}, {
          0.8206669885374103, 0.2438108954422311}, {0.8088609711164154, 
          0.27110753114031944`}, {0.7975064650358004, 0.30008992637906823`}, {
          0.7954562131516919, 0.30575472349488214`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7940949157064472, 0.3095159559080109}, {
          0.786457984713616, 0.33061661431841527`}, {0.7752090877410085, 
          0.36347973196771827`}, {0.7640754989392153, 0.3971096199262486}, {
          0.7530572183082368, 0.4315062781940062}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.010808276982210856`, 0.11366037247768163`}, {
          0.020142352714313867`, 0.12088660628891897`}, {0.03831805854841904, 
          0.13782970790516683`}, {0.07129924115738799, 0.1714705160801383}, {
          0.10227610379375068`, 0.2049405778298005}, {0.1209381192176681, 
          0.22602632857039046`}, {0.12254369055919041`, 
          0.22790770489640147`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.12514028949147515`, 0.2309503474953371}, {
          0.1416432419519349, 0.2502881765070059}, {0.1640932730095261, 
          0.27776634545055506`}, {0.1879900134034168, 0.30850105921194615`}, {
          0.2129744696276323, 0.3423733454932403}, {0.2232636671864492, 
          0.3572314167545538}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.22554093207244374`, 0.36051989127004214`}, {
          0.23838943009657645`, 0.37907370930610684`}, {0.2548150545586289, 
          0.4041800998455383}, {0.271004925910955, 0.4301317312874976}, {
          0.2867344592702193, 0.45660981709109205`}, {0.30193191984725465`, 
          0.4835436113581864}, {0.309068342760124, 0.49687180030233513`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.31095647218867845`, 0.5003981251967581}, {
          0.3164820807158255, 0.5107179108064934}, {0.33026971494969654`, 
          0.5379175121537259}, {0.33207642589527364`, 0.5415847741133107}, {
          0.3338675634079674, 0.5452482424061782}, {0.3529708271870995, 
          0.5883965603702987}, {0.3696080059927753, 0.62963968167688}, {
          0.37608670026906105`, 0.6464043931235386}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3775285722467407, 0.6501354794532799}, {
          0.38499970858582233`, 0.6694683017106617}, {0.39790045875361185`, 
          0.7064679191988444}, {0.40847512567913086`, 0.7403296763308033}, {
          0.4168885785453667, 0.7707447152959137}, {0.42338225282528275`, 
          0.7977319365258512}, {0.4244428304031802, 0.8029250623160135}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.42524321815427646`, 0.8068441667351244}, {
          0.4281975839918426, 0.8213102404522915}, {0.43389497343678224`, 
          0.8583760659140905}, {0.435638319483246, 0.8851358444138618}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5084437047157727, 1.15}, {0.5084082398563076, 
          1.1499096270012632`}, {0.4966495442941996, 1.1210179386134094`}, {
          0.47757030346417173`, 1.0765273957852795`}, {0.4764562395541205, 
          1.0740285357264014`}, {0.4753615853236102, 1.0715841224715434`}, {
          0.4675894068941483, 1.0548248077532298`}, {0.46073041756606903`, 
          1.0405061004615592`}, {0.44858253639245144`, 1.0159623093994508`}, {
          0.4423775210294151, 1.0043675439471538`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.44017942063371573`, 0.9988531814380165}, {
          0.43942647348754615`, 0.9988531814380165}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.05953258930189595, 0.3943212217418805}, {
          0.06727534276680903, 0.4229818389785769}, {0.07526788189609397, 
          0.45401558343865117`}, {0.0832898865022923, 0.4867148634671308}, {
          0.09187610779047584, 0.5238778152115671}, {0.09744865734566155, 
          0.549738882837567}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.09829123905668165, 0.553649132965149}, {
          0.10011514225208229`, 0.5621134962538773}, {0.10777765973876421`, 
          0.6005275804594795}, {0.1146343301021741, 0.6382257416937916}, {
          0.12053148832716866`, 0.6744293332377406}, {0.1253154693986046, 
          0.708359708372253}, {0.125649267090357, 0.7112476285742266}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.12610854580668424`, 0.7152211739760974}, {
          0.1289307504481261, 0.7396380648039977}, {0.13131677058289865`, 
          0.7677748464130109}, {0.13256255135097403`, 0.809267445155387}, {
          0.132541855818284, 0.8104975996618802}, {0.1325170429776696, 
          0.8117165995871446}, {0.13093163395580895`, 0.829170431492371}, {
          0.12826443949204624`, 0.8440066034945735}, {0.12083108918145567`, 
          0.8688435464833847}, {0.11812380428111145`, 
          0.8726815356610075}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.11581814248410424`, 0.8759501628465124}, {
          0.10934594638736946`, 0.8851254877528649}, {0.09411271843762375, 
          0.8947983609935394}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7000126704838011, 1.15}, {0.6838336115890866, 
          1.1320976739693713`}, {0.6586450846038822, 1.1055432289330769`}, {
          0.636622003370999, 1.0833105790749387`}, {0.6338650217120669, 
          1.080603314754877}, {0.6311554224393783, 1.0779581094333726`}, {
          0.61784443825854, 1.0653922723309794`}, {0.6056118901946339, 
          1.054171678525248}, {0.5866315597678032, 1.0372618364643753`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5836449276738833, 1.034601004125507}, {
          0.5830615363272608, 1.0340812526085827`}, {0.5639392353538721, 
          1.018120063193045}, {0.5475481278100937, 1.0053128446293857`}, {
          0.5139329723823047, 0.9819578791797015}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.24670206981448267`}, {0.9668903226725137, 
          0.27222877905708176`}, {0.9369235729742608, 0.29947376532990533`}, {
          0.9331234770762282, 0.3032396360675635}, {0.9293751200344278, 
          0.3070294655705617}, {0.8995586752643364, 0.34279975464595247`}, {
          0.887502022631277, 0.35931027779952524`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8851430698324312, 0.36254065574843736`}, {
          0.8724526471454956, 0.37991907113271683`}, {0.8464655667751125, 
          0.4173551069733554}, {0.8227163819016448, 0.45542458152174253`}, {
          0.8008166273972714, 0.4936398634532358}, {0.7989197684118947, 
          0.49715477855758794`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7970200995309986, 0.5006749004507836}, {
          0.7803778381341718, 0.5315133214431931}, {0.7611818854213926, 
          0.5685941048663276}, {0.7430106405679806, 0.6044313630973523}, {
          0.727282603884666, 0.6360545448080503}, {0.7238610773382753, 
          0.6429562809397394}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.71984260284645, 0.661751162839457}, {0.7145435395290713,
           0.661751162839457}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9106584515354561, 1.138962939886078}, {
          0.8842316930004651, 1.1242654674754922`}, {0.859586581261107, 
          1.110754818570249}, {0.8156412981692903, 1.0872939912757913`}, {
          0.8102031694842006, 1.0844542401538888`}, {0.8048699729403089, 
          1.0816817471567277`}, {0.7751971668793955, 1.066679417672204}, {
          0.7694172055234665, 1.0638291964680762`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.7658296800143823, 1.0620601117551045`}, {
          0.7485852871023686, 1.053556536851491}, {0.7232920147120079, 
          1.041236463679511}, {0.7006359570949796, 1.030522005804997}, {
          0.6618764759475498, 1.0129967422366057`}, {0.6300155855455457, 
          0.9994647919408818}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3548639334195923, 1.15}, {0.3514093567415543, 
          1.132924743954166}, {0.3463575283083049, 1.1078248262546373`}, {
          0.3385608764661015, 1.0683754369161496`}, {0.33812552342029223`, 
          1.066126724314788}, {0.3377004344010081, 1.0639235940785507`}, {
          0.3342640144104573, 1.045383402859212}, {0.331543228940178, 
          1.0299136046501962`}, {0.3273157001163407, 1.0040327656713743`}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.98799790396016, 0.824318591479259}, {0.9614942481179388,
           0.8316762381173142}, {0.936810675780761, 0.8386330515134828}, {
          0.930409626883344, 0.8404522186739751}, {0.9241189186025389, 
          0.8422443618024801}, {0.8875988118317715, 0.8527751773403117}, {
          0.8546121578861683, 0.8623364803435737}, {0.8341517017416165, 
          0.8682604132683472}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.830309503337386, 0.8693728481754446}, {
          0.823159585254092, 0.8714429699187634}, {0.7947751752490704, 
          0.879639832637809}, {0.769087895416055, 0.8870045624133035}, {
          0.745726713299999, 0.893614653157841}, {0.7049362468335371, 
          0.9048395290745207}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.0929929916126462, 1.15}, {0.08465544086542066, 
          1.129188889324418}, {0.06799622400325998, 1.094812441606252}, {
          0.06691948749536304, 1.0927914885687215`}, {0.06584935729814786, 
          1.0908036081796302`}, {0.05759503966567307, 1.0766281568576337`}, {
          0.04983803486265575, 1.0639759397921107`}, {0.03555760535242913, 
          1.0410533100229193`}, {0.023946006858832095`, 
          1.0219973701141807`}, {0.017351111103734863`, 
          1.0093465235213266`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.015502069422566859`, 1.0057995466590812`}, {
          0.015230496160272774`, 1.005278593514773}, {0.01120531082407512, 
          0.9955492963137371}, {0.008125633433769772, 0.986131329123122}, {
          0.00583077643966174, 0.9769056723652565}, {0.0029774950959918253`, 
          0.9590449288488035}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{1., 0.006302186789323222}, {0.9763186813487597, 
          0.007058565446987368}, {0.9395632300874686, 0.008951110183311139}, {
          0.9107426959453558, 0.011370674439836477`}, {0.8877517998015447, 
          0.014446380725209634`}, {0.8696110189244511, 
          0.018289963664117455`}, {0.8549042910061472, 0.02313137490482253}, {
          0.8430902000950558, 0.0293658798749722}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8396698556350507, 0.03138787993248829}, {
          0.8197743277343238, 0.05224988782516116}, {0.8192042924307237, 
          0.05314776669384465}, {0.8186393176612913, 0.05406010015245548}, {
          0.8123444207794711, 0.06769107826457589}, {0.8073008399563562, 
          0.08108665253248365}, {0.8023153310322116, 0.09678242955499847}, {
          0.7922327406150529, 0.1331781535596479}, {0.7821204964583194, 
          0.17751190476894613`}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.46117955810874717`, 0.05820431729167524}, {
          0.4916243371702479, 0.06707287426709359}, {0.5200699079889889, 
          0.07723389963090872}, {0.5462154155811227, 0.08886835678829003}, {
          0.5843690372017607, 0.11216168713540742`}, {0.6026262023403438, 
          0.12889363057348704`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6055751239126215, 0.1315961963100706}, {
          0.6156048921399314, 0.14078806774260458`}, {0.6174778564173722, 
          0.1428981067862283}, {0.6193200097083341, 0.14503499942772602`}, {
          0.6315979421531425, 0.16351929672002363`}, {0.6421715258003791, 
          0.18380383400037223`}, {0.6600057315588962, 0.22788203627404235`}, {
          0.6665188983494831, 0.2525050559729904}, {0.6707703258104645, 
          0.2747707318450771}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.6715205359700457, 0.2786997501342253}, {
          0.6715371544986826, 0.2787867850831914}, {0.6751420751934727, 
          0.306597780268812}, {0.6774152356208312, 0.3358085981940189}, {
          0.6785470049180533, 0.36937822832648587`}, {0.6783759720620013, 
          0.4037191970236979}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9632506062820955, 0.578361567988282}, {
          0.9576157758986554, 0.5825292403308685}, {0.95206688121142, 
          0.5866778085835272}, {0.9154944638125696, 0.6160820964212395}, {
          0.8823573305616552, 0.6441480976990258}, {0.850699900636691, 
          0.6714306296247068}, {0.8403337502867646, 0.6807194821402569}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8373547673842577, 0.6833888754920452}, {
          0.8220018773636277, 0.6971462228461772}, {0.7958824896717844, 
          0.7212336791378716}, {0.771960966490481, 0.7436318002742249}, {
          0.749984957854487, 0.7643468767128212}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.23345260624243847`, 0.10840046778514222`}, {
          0.263760101048499, 0.12225747722586919`}, {0.29486790445744504`, 
          0.1380797346226339}, {0.32632914389717016`, 0.155978233996493}, {
          0.35739556568161396`, 0.17612142058722574`}, {0.37232158480418337`, 
          0.1871408785375827}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.3755396097344574, 0.18951665536803944`}, {
          0.38166100699906863`, 0.19403590991279726`}, {0.4050177306739598, 
          0.2135054125833491}, {0.42724622246488786`, 0.23452601397023926`}, {
          0.44812696813045316`, 0.2570937994448258}, {0.4508484051586081, 
          0.26023738778307}, {0.45354218794753387`, 0.263408141370796}, {
          0.47361122208673956`, 0.2916786212715149}, {0.48270860662659143`, 
          0.30681068273417783`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.48476961189201084`, 0.3102388392790155}, {
          0.4916033883537257, 0.3216057464365371}, {0.5085172020898356, 
          0.3521724851107736}, {0.5232743107641934, 0.38401845080343877`}, {
          0.5359134575735687, 0.41684065955125066`}, {0.5464733857147314, 
          0.45033612739092743`}, {0.5480507683751632, 
          0.45655054874996653`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5490348661961311, 0.46042760323485143`}, {
          0.555056493069509, 0.484151032936963}, {0.5617651775197295, 
          0.5179315548038511}, {0.5669377461867247, 0.5536382248926459}, {
          0.570311072290544, 0.5886428327862407}, {0.5718647716075591, 
          0.6184402352225573}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.5720731376789522, 0.6224394522191699}, {
          0.5720732992042016, 0.6224394522191699}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.9758885438793296, 1.0605240777890823`}, {
          0.9676871539624923, 1.0582809934951445`}, {0.9596535332945797, 
          1.0560893557150068`}, {0.9216468677447329, 1.0458639765099353`}, {
          0.8872388765785421, 1.0367179106712852`}, {0.8544093372171426, 
          1.0280450556075251`}, {0.8247367014653267, 1.0203186220935458`}, {
          0.8212579301141818, 1.0194265552265633`}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.8173832945376153, 1.0184329762670412`}, {
          0.7978548988249701, 1.013425278714617}, {0.7733978587979493, 
          1.0072516940560081`}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2751399224313414, 1.15}, {0.27134684058738295`, 
          1.1299784017348316`}, {0.2639087476278454, 1.0914365470637752`}, {
          0.2580829550937208, 1.0615766086849758`}, {0.25218526938262753`, 
          1.0315434200054154`}, {0.24782210080931508`, 1.0092106669952403`}, {
          0.24660933132871882`, 1.0029566672531889`}, {0.24552061090269878`, 
          0.9972986649637522}, {0.24468705630290538`, 
          0.9929251539766886}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.24394739571736562`, 0.9889941514469782}, {
          0.24068227376150197`, 0.9709993935195665}, {0.2406003551838934, 
          0.9705192055592334}, {0.24052010013281072`, 0.9700465136669146}, {
          0.2404447614052405, 0.9695994584979161}, {0.24026669902854336`, 
          0.968534012695507}, {0.24011228974700718`, 0.9675988375938334}, {
          0.23996475695351635`, 0.966694343762346}, {0.23881204597196148`, 
          0.9590664107094905}, {0.2381592258893808, 0.9535984331113838}, {
          0.23787362541534385`, 0.9496565624409958}, {0.23799481857587454`, 
          0.9451737602219412}}]}}, 
       {GrayLevel[0.85], Thickness[Large], 
        {Arrowheads[0.035], 
         ArrowBox[{{0.17469455202041329`, 0.728347870918103}, {
          0.18245936238711036`, 0.7596928504099044}, {0.18922830181139907`, 
          0.787682369681002}, {0.19503726906096155`, 0.8122978410557996}, {
          0.19996478154813088`, 0.8336120755006888}, {0.20728857128101366`, 
          0.8661144584934992}, {0.20749201175667614`, 0.8670364006984831}, {
          0.20769287923217455`, 0.8679477927374032}, {0.21112832019388306`, 
          0.883936334724735}, {0.21116815551136486`, 0.8841272596440215}}]}, 
        {Arrowheads[0.035], 
         ArrowBox[{{0.2119851379403838, 0.8880429383477297}, {
          0.21375208692450795`, 0.8965116694512645}, {0.21761976220264975`, 
          0.9157304608411296}}]}}}}, {{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1nk01Pv/B3BbZUtpkSmlonKjROSGPAtFobRIWeom5RKXkCVKIRVKi3uR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          "]]},
        Annotation[#, "Charting`Private`Tag$155793#1"]& ], 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
         LineBox[CompressedData["
1:eJw91gkw1lvcB3C0IF1LF6WIEuVe5KaI4ltUJJQiaRHZQqTlupQSeVQiS9Yi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          "]]},
        Annotation[#, "Charting`Private`Tag$155793#2"]& ]}, {}}, {{{}, {}, 
       TagBox[
        {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
         0.3]], LineBox[CompressedData["
1:eJwUl3c41t8bx1VIUykllBUJyUoh3rYyKntVyCgqK9kZoTKSHZmPrVQIISsN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          "]]},
        Annotation[#, "Charting`Private`Tag$157388#1"]& ]}, {}}},
    AspectRatio->1,
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{
      FormBox["\"A\"", TraditionalForm], 
      FormBox["\"H\"", TraditionalForm]},
    FrameStyle->Directive[FontFamily -> "Arial", 18],
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{
     "VectorLengthFunction" -> 
      Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
        System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
        System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
        System`VectorPlotsDump`imin = If[
           NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
           Min[System`VectorPlotsDump`m], 
           Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
           NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
           Max[System`VectorPlotsDump`m], 
           Max[System`VectorPlotsDump`m]]; Map[If[
           
           Or[# > System`VectorPlotsDump`imax, # < 
            System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
          System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "TransparentPolygonMesh" -> True},
    PlotRange->{{0, 1}, {0, 1.15}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}},
    Ticks->{Automatic, Automatic}]}], "]"}]], "Input",
 CellChangeTimes->{{3.903439303988641*^9, 3.9034393332839518`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"4b659f0d-067f-4abd-8007-e72b9a185ef9"],

Cell[BoxData[
 GraphicsBox[{{{{}, {
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.005315180259893875, 0.05755118502610765}, {
         0.009253754587488863, 0.05840574958364356}, {0.016370375073678525`, 
         0.0609785752395866}, {0.028803134761993244`, 0.06636302282993478}, {
         0.053010315051178904`, 0.07770799529403206}, {0.09466376845094, 
         0.09847581472431756}, {0.12425765507992212`, 0.11418316931239039`}, {
         0.14865974365042334`, 0.12806082177891087`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1521367844190754, 0.13003824118134713`}, {
         0.1599378318547599, 0.13447475590321162`}, {0.17990280082841412`, 
         0.1466053545174627}, {0.20120036847637957`, 0.16020087311377262`}, {
         0.22345991901214995`, 0.1752829406951391}, {0.2463108366492189, 
         0.19187318626455974`}, {0.2760296445461572, 0.21558976259231932`}, {
         0.2829512159782154, 0.2217245443905069}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.28594465685093134`, 0.22437771452104008`}, {
         0.3058495418315339, 0.2420199692131521}, {0.3351485153210076, 
         0.2710984463619623}, {0.36330455183023674`, 0.30275983427365394`}, {
         0.3898353270178829, 0.3367432423166446}, {0.39355968297816624`, 
         0.3422397679893843}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.39580344847724896`, 0.3455511900985583}, {
         0.41425851654260754`, 0.3727877798593517}, {0.4363463164276536, 
         0.4105754218659062}, {0.4558010146849347, 0.4495188239708809}, {
         0.46859958717770617`, 0.4790677798611667}, {0.4712997078902921, 
         0.4861678660757577}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.472721539629453, 0.4899066351921267}, {
         0.47986892854918084`, 0.508701008829844}, {0.48964785181892806`, 
         0.5381699484789161}, {0.4979751700065175, 0.5672260364103864}, {
         0.4989998462268385, 0.5711149401586452}, {0.4999993118585184, 
         0.5749917606218528}, {0.5079184844627271, 0.6147726369262214}, {
         0.5123620734002896, 0.644472934211557}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5129539428953563, 0.6484289031827207}, {
         0.5135326731031374, 0.6522970510831271}, {0.5181334132141361, 
         0.6884026284699597}, {0.5207072562663115, 0.7216705323166468}, {
         0.5215571972751283, 0.7519689790059109}, {0.5209862312560516, 
         0.7791661849204752}, {0.5182190440616476, 0.8078433778755741}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5178348511442498, 0.8118248846006999}, {
         0.5166024802937436, 0.8245963142834022}, {0.5098469554205088, 
         0.8581851131811045}, {0.5014703659046529, 0.8831291656567161}, {
         0.4829984695442805, 0.9139570361389971}, {0.4656828608938726, 
         0.92930708233566}, {0.45348891696877963`, 0.9362945802006839}, {
         0.44315373522107315`, 0.9406613943660665}, {0.44099471440144283`, 
         0.941268044770384}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4371438438283965, 0.9423500779628718}, {
         0.43428810473678353`, 0.9431524950858566}, {0.4269112735335155, 
         0.9444448820531242}, {0.4205741042917906, 0.9451371420273712}, {
         0.41512926390729454`, 0.9454962908278867}, {0.41040315750307815`, 
         0.9456648234478999}, {0.4063240292493229, 0.9457231538348787}, {
         0.4027920053989766, 0.9457219946009322}, {0.3979908454307735, 
         0.9456583373884356}, {0.39414436023717564`, 0.945565710873157}, {
         0.39104213508205493`, 0.9454825986151288}, {0.38644551986863024`, 
         0.9453627017937808}, {0.38338142573177797`, 0.9452805476229514}, {
         0.38128807368524203`, 0.9452131082959411}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0012485535472057541`, 0.0019363574419383924`}, {
         0.002079759749410058, 0.0019095332242724634`}, {
         0.0037184635600041945`, 0.0018976191925662955`}, {
         0.007367205051851271, 0.0019208623204036294`}, {
         0.016177776058389666`, 0.0020205075282379898`}, {0.03149051638942077,
          0.002227170284528127}, {0.061166842404928416`, 
         0.0026658583309231033`}, {0.08540916962016178, 
         0.0030211914095529184`}, {0.11726588368895359`, 
         0.003517818895600946}, {0.15209120132918633`, 0.00414117741646965}, {
         0.16122897973583986`, 0.004321050889195625}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.16522820499437332`, 0.004399774021170686}, {
         0.19320012622796473`, 0.004950389979141391}, {0.23953501141086506`, 
         0.00599306365477582}, {0.29003820990346385`, 0.007316805514532598}, {
         0.3163785391140037, 0.008094879512852182}, {0.3251774575317451, 
         0.008384456976941405}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3291752930779486, 0.008516028043333054}, {
         0.34281217159817484`, 0.008964825555992971}, {0.3693391073559777, 
         0.009926643643954973}, {0.39595934638741204`, 0.01098033377673819}, {
         0.4300475942901762, 0.012560742022280687`}, {0.4626481511269155, 
         0.014429319815652963`}, {0.48897632891509246`, 
         0.01625439204981514}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.49296675285715336`, 0.016531008684577526`}, {
         0.49376101689762975`, 0.016586067156855008`}, {0.5233861916023189, 
         0.01903098404588682}, {0.5511649278522698, 0.021903257251945543`}, {
         0.5767384782587688, 0.025342073544228325`}, {0.6212700215414114, 
         0.033919335387466054`}, {0.6501795144732179, 0.04331287784508883}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6539837297562421, 0.044548979006161414`}, {
         0.6574024066927139, 0.04565980744674994}, {0.6855572189551433, 
         0.06146052759322994}, {0.7066496921288792, 0.0823520454747033}, {
         0.7214033290723582, 0.10954149407049109`}, {0.7305905392099711, 
         0.14426225396136128`}, {0.7332791274110022, 0.16475444942484024`}, {
         0.7337404437667153, 0.17165350183796582`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7340073143265253, 0.17564458942210961`}, {
         0.7347986104577926, 0.18747853681267546`}, {0.7348670039192392, 
         0.2308026067479722}, {0.7319839323393835, 0.28039541968188686`}, {
         0.7316936290847007, 0.2839414349689012}, {0.7313908128922378, 
         0.2875131194924334}, {0.7269667270713063, 0.3266680945695409}, {
         0.7258116507089605, 0.335182563397923}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7252739344932893, 0.3391462562810062}, {
         0.7213849861887637, 0.3678130442038631}, {0.7152719059359195, 
         0.4094618448291692}, {0.7080961469424722, 0.45211834743644286`}, {
         0.6999714011034299, 0.4950837135225799}, {0.6995609785980051, 
         0.49703391654947754`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6987372183389694, 0.5009481749767705}, {
         0.6910113603138004, 0.5376591045844762}, {0.6813457180764184, 
         0.5791987286480502}, {0.6711041678941188, 0.6190567937392208}, {
         0.6605184400272874, 0.6562629660853445}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6594238206752066, 0.6601102779357213}, {
         0.6583690781874828, 0.6638174326323755}, {0.6451478210714563, 
         0.7054920896934658}, {0.631686551077056, 0.7431258698970049}, {
         0.6182314227352984, 0.7757638782175059}, {0.6018322901607757, 
         0.8091013015203038}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.600066692638718, 0.812690544531038}, {0.5990748029642207,
          0.8147069344710622}, {0.5806832585283863, 0.8456258654583961}, {
         0.5634358106491619, 0.8697090857623327}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.007991959384349424, 0.18737918942632123`}, {
         0.014665332619929012`, 0.19575462102647093`}, {0.02404284485226666, 
         0.21125452873000952`}, {0.038937399713556094`, 0.2389435150658879}, {
         0.06122684095593691, 0.2836717671747492}, {0.07289826755292106, 
         0.30815402451768015`}, {0.08242433440296044, 
         0.3286901142122216}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.08410753724805241, 0.33231872664430556`}, {
         0.08603590995585036, 0.33647587098469833`}, {0.10049582118279327`, 
         0.3685355646087313}, {0.11613405425181815`, 0.4042313634227067}, {
         0.13264560636247988`, 0.44301681653391284`}, {0.14758808292033565`, 
         0.4791735636722408}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14911583691098265`, 0.4828703146435752}, {
         0.14972547471433337`, 0.48434547304963804`}, {0.16271516849528453`, 
         0.5165533981459839}, {0.17564170031914506`, 0.5492853488098967}, {
         0.18834798379382292`, 0.5820806167619507}, {0.20067693252722205`, 
         0.6144784937227098}, {0.20721354110163237`, 0.6319432947316374}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2086156478211007, 0.6356895057170494}, {
         0.21654686226824882`, 0.6568804766160631}, {0.23125509095513763`, 
         0.6968167623647062}, {0.23220817584001271`, 0.6994278385706469}, {
         0.23315513625933992`, 0.7020239606184527}, {0.24504513044513235`, 
         0.734840650937636}, {0.2557820553010721, 0.7644832403115248}, {
         0.26358919265807296`, 0.7859478138198195}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2649564491854812, 0.7897068841288533}, {
         0.2659399685095208, 0.7924109255543246}, {0.2749398584229873, 
         0.8169088025349469}, {0.28983109174382177`, 0.8563128613966663}, {
         0.30125887971686544`, 0.8846031461851092}, {0.31449650596901896`, 
         0.9130841577407179}, {0.3234564871128151, 0.9275012763716008}, {
         0.3301634417189963, 0.9348833727408711}, {0.330189687019687, 
         0.9349037920307228}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.33334672987062647`, 0.9373600250077289}, {
         0.3348252909022445, 0.9385103706114623}, {0.3389257158870297, 
         0.9408672338505835}, {0.3425447636272148, 0.9422686193013112}, {
         0.3456662295911617, 0.9430537018483448}, {0.34850786694327657`, 
         0.9435411099190769}, {0.35110961976304056`, 
         0.9438597813869771}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.9610126159531893}, {0.9990345385026703, 
         0.9609913329662609}, {0.9696328557403904, 0.9603346581097962}, {
         0.9420927242886611, 0.9597135144087203}, {0.8925971153168553, 
         0.9585778204727349}, {0.8494558297844842, 0.957566573004141}, {
         0.8400421321409274, 0.9573417907136108}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8360432719917645, 0.9572463050736557}, {
         0.8115769858887797, 0.9566620938487753}, {0.8068257181795436, 
         0.9565473689444552}, {0.8021542448459915, 0.9564343176472644}, {
         0.7703943048437545, 0.9556538724170947}, {0.7421029252912291, 
         0.9549499109362772}, {0.6914174176477923, 0.9536750408376361}, {
         0.676092428825847, 0.9532813802130061}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6720937478682476, 0.9531786641026224}, {
         0.6509226576300524, 0.9526348317576792}, {0.6179437514796188, 
         0.9517752291963395}, {0.568227157039481, 0.9504614056519424}, {
         0.5325904038976028, 0.9495064067842274}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9587219655338541, 0.6837119705762049}, {
         0.9159887583189529, 0.7090923473269792}, {0.8779326543830237, 
         0.7327505788633747}, {0.8438185189281922, 0.754643532371413}, {
         0.8394871580697053, 0.7574747188103694}, {0.8352166076158347, 
         0.7602738284143594}, {0.8230011686270816, 0.7684008331922664}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8196708774961272, 0.7706164958432777}, {
         0.8045387780725398, 0.7806839722907871}, {0.7767921762087373, 
         0.7992169157279356}, {0.7503048503493142, 0.8168345400111245}, {
         0.7263360764986495, 0.8326215259863946}, {0.6859410222097616, 
         0.8584491216519179}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6825319729436888, 0.8605408285562286}, {
         0.6498442166506991, 0.880122882526079}, {0.6195722245058977, 
         0.8966699472417003}, {0.5938086869298481, 0.9092379665392357}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20192105761486553`, 0.050400212455347364`}, {
         0.2310241098935508, 0.05675524257666449}, {0.2617353422197898, 
         0.06412907248073081}, {0.29353722744135663`, 0.07265598098840816}, {
         0.3259122384060253, 0.08247024692055831}, {0.35601880242412554`, 
         0.09293071973305797}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3597698655751084, 0.09431647520388836}, {
         0.3901238575859159, 0.10656098496121579`}, {0.4210165189046342, 
         0.12109513000762809`}, {0.4503893615408025, 0.13749840974408714`}, {
         0.47364199171441806`, 0.15292380230558578`}, {0.4952681246792671, 
         0.1698902578392325}, {0.49827342403403857`, 0.17267134016004274`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5012092469100002, 0.17538812944907123`}, {
         0.51526776043535, 0.1883977763450274}, {0.5336408989826664, 
         0.20844635782297039`}, {0.5360070942687994, 0.21125173343278475`}, {
         0.5383405530325152, 0.21408588890658006`}, {0.5544914429346451, 
         0.2385092023620219}, {0.5686397587884312, 0.2647085000225044}, {
         0.5817938752090792, 0.2916812177555716}, {0.5880808190068137, 
         0.30773937583127114`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5895390835408124, 0.3114640858265435}, {
         0.5929595927634507, 0.3202007756338083}, {0.6022166434595903, 
         0.35007091034389287`}, {0.6096447593055423, 0.38109535857250376`}, {
         0.615349772969884, 0.4130015563160257}, {0.6194375171211925, 
         0.4455169395708434}, {0.621121877526172, 0.4677141740268536}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6214245336014829, 0.4717027075042206}, {
         0.6220549048110638, 0.4800100136437039}, {0.6231548993061511, 
         0.5145225065823292}, {0.6229027866713545, 0.5486303781792066}, {
         0.6214638529715736, 0.5819095882268223}, {0.6189723371386794, 
         0.6140910179269589}, {0.6170495608165953, 0.631426664453936}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6163438594696852, 0.6426071307291656}, {
         0.6158094838578031, 0.6426071307291656}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20151070995072387`, 1.15}, {0.19687629648458113`, 
         1.1302868914489757`}, {0.1870570074596501, 1.0933643484661766`}, {
         0.17830845850066812`, 1.0642911839211286`}, {0.17039432484347358`, 
         1.0416069838616109`}, {0.1629774239798851, 1.023281831290051}, {
         0.1539782868639582, 1.0046739025079847`}, {0.15031362738163317`, 
         0.9990428676470912}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14813179641385496`, 0.9956903143472846}, {
         0.1377579866428213, 0.9797501472614446}, {0.13721180560984406`, 
         0.9790813431095936}, {0.1366650579103053, 0.9784211931769761}, {
         0.1257255138608266, 0.968141120356546}, {0.11420697215926141`, 
         0.9596228486068679}, {0.08997270853501137, 0.9449036790634745}, {
         0.0638946167183734, 0.9328023557838603}, {0.038565179065588276`, 
         0.9197282096826157}, {0.02151979395719923, 0.9023880592010154}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.018715716170643684`, 0.8995354905748566}, {
         0.014501586045115849`, 0.895248485613629}, {0.010760229451103224`, 
         0.887676175449977}, {0.007767559400176594, 0.8797326562899801}, {
         0.005542252678650447, 0.8712967267694348}, {0.0030205281638741735`, 
         0.8556358133631217}, {0.0016794965022389672`, 0.8392465480424747}, {
         0.0009606639652322169, 0.822587323237586}, {0.000582868009676899, 
         0.8074007025699049}, {0.0003532419386694125, 0.7923259128024964}, {
         0.00021676599979087268`, 0.7774132100885689}, {
         0.00013749926751834636`, 0.763141808408893}, {0.00008856365235617128,
          0.749085896166136}, {0.00007561935766867175, 0.7432467641908352}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.00006675210620978785, 0.7392467740193659}, {
         0.00005791087142462761, 0.7352585198903073}, {0.00003823696132192895,
          0.7214626555493651}, {0.000025674305940201902`, 
         0.7079119369607114}, {0.000017523084181695026`, 
         0.6946066231647166}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.982420449767751, 0.42304115961063726`}, {
         0.9452713410993222, 0.4552441352262494}, {0.9118889543784554, 
         0.4875268052120116}, {0.8816403251458672, 0.5195956280755437}, {
         0.8777797012494438, 0.5238977668962438}, {0.8739666767523326, 
         0.5281904245278117}, {0.8683358704795866, 0.5349420768125693}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8657739437201243, 0.538013970573615}, {
         0.8571010120403727, 0.5484133017092934}, {0.8411201762929797, 
         0.5683277511162922}, {0.8113555020038121, 0.6067292906028515}, {
         0.7828879831687156, 0.6439514415027064}, {0.7677040929072172, 
         0.6644112794285824}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7653202991395147, 0.6676233702232305}, {
         0.7570147752417615, 0.678814815229153}, {0.7333694789238316, 
         0.7111161746685053}, {0.711585694915808, 0.7406522827070778}, {
         0.6914540053565984, 0.7674160651513953}, {0.6727649923851106, 
         0.7914004478079821}, {0.6693357615712766, 0.795618189175829}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6668123646838165, 0.7987218109550343}, {
         0.6559223332063445, 0.8121158747416993}, {0.6401107941231521, 
         0.8306055929896448}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.0726354132149987}, {0.9797407828781172, 
         0.07952260995481178}, {0.9549158525480289, 0.09009910330778362}, {
         0.9329131476655398, 0.10189030153809975`}, {0.8957123717678481, 
         0.1294802984284502}, {0.8934724692892321, 0.13152900585319185`}, {
         0.891262491749183, 0.13360446839081494`}, {0.875259403446674, 
         0.1523535054427732}, {0.8696798258312124, 0.16019313408533223`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.867360424831514, 0.16345202638220216`}, {
         0.8605154595659482, 0.17306959772031713`}, {0.8462821234542818, 
         0.19474561596022616`}, {0.8330700028807341, 0.21834148612486542`}, {
         0.8206669885374103, 0.2438108954422311}, {0.8088609711164154, 
         0.27110753114031944`}, {0.7975064650358004, 0.30008992637906823`}, {
         0.7954562131516919, 0.30575472349488214`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7940949157064472, 0.3095159559080109}, {
         0.786457984713616, 0.33061661431841527`}, {0.7752090877410085, 
         0.36347973196771827`}, {0.7640754989392153, 0.3971096199262486}, {
         0.7530572183082368, 0.4315062781940062}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.010808276982210856`, 0.11366037247768163`}, {
         0.020142352714313867`, 0.12088660628891897`}, {0.03831805854841904, 
         0.13782970790516683`}, {0.07129924115738799, 0.1714705160801383}, {
         0.10227610379375068`, 0.2049405778298005}, {0.1209381192176681, 
         0.22602632857039046`}, {0.12254369055919041`, 
         0.22790770489640147`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12514028949147515`, 0.2309503474953371}, {
         0.1416432419519349, 0.2502881765070059}, {0.1640932730095261, 
         0.27776634545055506`}, {0.1879900134034168, 0.30850105921194615`}, {
         0.2129744696276323, 0.3423733454932403}, {0.2232636671864492, 
         0.3572314167545538}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.22554093207244374`, 0.36051989127004214`}, {
         0.23838943009657645`, 0.37907370930610684`}, {0.2548150545586289, 
         0.4041800998455383}, {0.271004925910955, 0.4301317312874976}, {
         0.2867344592702193, 0.45660981709109205`}, {0.30193191984725465`, 
         0.4835436113581864}, {0.309068342760124, 0.49687180030233513`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.31095647218867845`, 0.5003981251967581}, {
         0.3164820807158255, 0.5107179108064934}, {0.33026971494969654`, 
         0.5379175121537259}, {0.33207642589527364`, 0.5415847741133107}, {
         0.3338675634079674, 0.5452482424061782}, {0.3529708271870995, 
         0.5883965603702987}, {0.3696080059927753, 0.62963968167688}, {
         0.37608670026906105`, 0.6464043931235386}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3775285722467407, 0.6501354794532799}, {
         0.38499970858582233`, 0.6694683017106617}, {0.39790045875361185`, 
         0.7064679191988444}, {0.40847512567913086`, 0.7403296763308033}, {
         0.4168885785453667, 0.7707447152959137}, {0.42338225282528275`, 
         0.7977319365258512}, {0.4244428304031802, 0.8029250623160135}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.42524321815427646`, 0.8068441667351244}, {
         0.4281975839918426, 0.8213102404522915}, {0.43389497343678224`, 
         0.8583760659140905}, {0.435638319483246, 0.8851358444138618}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5084437047157727, 1.15}, {0.5084082398563076, 
         1.1499096270012632`}, {0.4966495442941996, 1.1210179386134094`}, {
         0.47757030346417173`, 1.0765273957852795`}, {0.4764562395541205, 
         1.0740285357264014`}, {0.4753615853236102, 1.0715841224715434`}, {
         0.4675894068941483, 1.0548248077532298`}, {0.46073041756606903`, 
         1.0405061004615592`}, {0.44858253639245144`, 1.0159623093994508`}, {
         0.4423775210294151, 1.0043675439471538`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.44017942063371573`, 0.9988531814380165}, {
         0.43942647348754615`, 0.9988531814380165}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.05953258930189595, 0.3943212217418805}, {
         0.06727534276680903, 0.4229818389785769}, {0.07526788189609397, 
         0.45401558343865117`}, {0.0832898865022923, 0.4867148634671308}, {
         0.09187610779047584, 0.5238778152115671}, {0.09744865734566155, 
         0.549738882837567}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.09829123905668165, 0.553649132965149}, {
         0.10011514225208229`, 0.5621134962538773}, {0.10777765973876421`, 
         0.6005275804594795}, {0.1146343301021741, 0.6382257416937916}, {
         0.12053148832716866`, 0.6744293332377406}, {0.1253154693986046, 
         0.708359708372253}, {0.125649267090357, 0.7112476285742266}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12610854580668424`, 0.7152211739760974}, {
         0.1289307504481261, 0.7396380648039977}, {0.13131677058289865`, 
         0.7677748464130109}, {0.13256255135097403`, 0.809267445155387}, {
         0.132541855818284, 0.8104975996618802}, {0.1325170429776696, 
         0.8117165995871446}, {0.13093163395580895`, 0.829170431492371}, {
         0.12826443949204624`, 0.8440066034945735}, {0.12083108918145567`, 
         0.8688435464833847}, {0.11812380428111145`, 0.8726815356610075}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.11581814248410424`, 0.8759501628465124}, {
         0.10934594638736946`, 0.8851254877528649}, {0.09411271843762375, 
         0.8947983609935394}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7000126704838011, 1.15}, {0.6838336115890866, 
         1.1320976739693713`}, {0.6586450846038822, 1.1055432289330769`}, {
         0.636622003370999, 1.0833105790749387`}, {0.6338650217120669, 
         1.080603314754877}, {0.6311554224393783, 1.0779581094333726`}, {
         0.61784443825854, 1.0653922723309794`}, {0.6056118901946339, 
         1.054171678525248}, {0.5866315597678032, 1.0372618364643753`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5836449276738833, 1.034601004125507}, {
         0.5830615363272608, 1.0340812526085827`}, {0.5639392353538721, 
         1.018120063193045}, {0.5475481278100937, 1.0053128446293857`}, {
         0.5139329723823047, 0.9819578791797015}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.24670206981448267`}, {0.9668903226725137, 
         0.27222877905708176`}, {0.9369235729742608, 0.29947376532990533`}, {
         0.9331234770762282, 0.3032396360675635}, {0.9293751200344278, 
         0.3070294655705617}, {0.8995586752643364, 0.34279975464595247`}, {
         0.887502022631277, 0.35931027779952524`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8851430698324312, 0.36254065574843736`}, {
         0.8724526471454956, 0.37991907113271683`}, {0.8464655667751125, 
         0.4173551069733554}, {0.8227163819016448, 0.45542458152174253`}, {
         0.8008166273972714, 0.4936398634532358}, {0.7989197684118947, 
         0.49715477855758794`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7970200995309986, 0.5006749004507836}, {
         0.7803778381341718, 0.5315133214431931}, {0.7611818854213926, 
         0.5685941048663276}, {0.7430106405679806, 0.6044313630973523}, {
         0.727282603884666, 0.6360545448080503}, {0.7238610773382753, 
         0.6429562809397394}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.71984260284645, 0.661751162839457}, {0.7145435395290713, 
         0.661751162839457}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9106584515354561, 1.138962939886078}, {
         0.8842316930004651, 1.1242654674754922`}, {0.859586581261107, 
         1.110754818570249}, {0.8156412981692903, 1.0872939912757913`}, {
         0.8102031694842006, 1.0844542401538888`}, {0.8048699729403089, 
         1.0816817471567277`}, {0.7751971668793955, 1.066679417672204}, {
         0.7694172055234665, 1.0638291964680762`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7658296800143823, 1.0620601117551045`}, {
         0.7485852871023686, 1.053556536851491}, {0.7232920147120079, 
         1.041236463679511}, {0.7006359570949796, 1.030522005804997}, {
         0.6618764759475498, 1.0129967422366057`}, {0.6300155855455457, 
         0.9994647919408818}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3548639334195923, 1.15}, {0.3514093567415543, 
         1.132924743954166}, {0.3463575283083049, 1.1078248262546373`}, {
         0.3385608764661015, 1.0683754369161496`}, {0.33812552342029223`, 
         1.066126724314788}, {0.3377004344010081, 1.0639235940785507`}, {
         0.3342640144104573, 1.045383402859212}, {0.331543228940178, 
         1.0299136046501962`}, {0.3273157001163407, 
         1.0040327656713743`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.98799790396016, 0.824318591479259}, {0.9614942481179388, 
         0.8316762381173142}, {0.936810675780761, 0.8386330515134828}, {
         0.930409626883344, 0.8404522186739751}, {0.9241189186025389, 
         0.8422443618024801}, {0.8875988118317715, 0.8527751773403117}, {
         0.8546121578861683, 0.8623364803435737}, {0.8341517017416165, 
         0.8682604132683472}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.830309503337386, 0.8693728481754446}, {0.823159585254092,
          0.8714429699187634}, {0.7947751752490704, 0.879639832637809}, {
         0.769087895416055, 0.8870045624133035}, {0.745726713299999, 
         0.893614653157841}, {0.7049362468335371, 0.9048395290745207}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0929929916126462, 1.15}, {0.08465544086542066, 
         1.129188889324418}, {0.06799622400325998, 1.094812441606252}, {
         0.06691948749536304, 1.0927914885687215`}, {0.06584935729814786, 
         1.0908036081796302`}, {0.05759503966567307, 1.0766281568576337`}, {
         0.04983803486265575, 1.0639759397921107`}, {0.03555760535242913, 
         1.0410533100229193`}, {0.023946006858832095`, 1.0219973701141807`}, {
         0.017351111103734863`, 1.0093465235213266`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.015502069422566859`, 1.0057995466590812`}, {
         0.015230496160272774`, 1.005278593514773}, {0.01120531082407512, 
         0.9955492963137371}, {0.008125633433769772, 0.986131329123122}, {
         0.00583077643966174, 0.9769056723652565}, {0.0029774950959918253`, 
         0.9590449288488035}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.006302186789323222}, {0.9763186813487597, 
         0.007058565446987368}, {0.9395632300874686, 0.008951110183311139}, {
         0.9107426959453558, 0.011370674439836477`}, {0.8877517998015447, 
         0.014446380725209634`}, {0.8696110189244511, 
         0.018289963664117455`}, {0.8549042910061472, 0.02313137490482253}, {
         0.8430902000950558, 0.0293658798749722}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8396698556350507, 0.03138787993248829}, {
         0.8197743277343238, 0.05224988782516116}, {0.8192042924307237, 
         0.05314776669384465}, {0.8186393176612913, 0.05406010015245548}, {
         0.8123444207794711, 0.06769107826457589}, {0.8073008399563562, 
         0.08108665253248365}, {0.8023153310322116, 0.09678242955499847}, {
         0.7922327406150529, 0.1331781535596479}, {0.7821204964583194, 
         0.17751190476894613`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.46117955810874717`, 0.05820431729167524}, {
         0.4916243371702479, 0.06707287426709359}, {0.5200699079889889, 
         0.07723389963090872}, {0.5462154155811227, 0.08886835678829003}, {
         0.5843690372017607, 0.11216168713540742`}, {0.6026262023403438, 
         0.12889363057348704`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6055751239126215, 0.1315961963100706}, {
         0.6156048921399314, 0.14078806774260458`}, {0.6174778564173722, 
         0.1428981067862283}, {0.6193200097083341, 0.14503499942772602`}, {
         0.6315979421531425, 0.16351929672002363`}, {0.6421715258003791, 
         0.18380383400037223`}, {0.6600057315588962, 0.22788203627404235`}, {
         0.6665188983494831, 0.2525050559729904}, {0.6707703258104645, 
         0.2747707318450771}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6715205359700457, 0.2786997501342253}, {
         0.6715371544986826, 0.2787867850831914}, {0.6751420751934727, 
         0.306597780268812}, {0.6774152356208312, 0.3358085981940189}, {
         0.6785470049180533, 0.36937822832648587`}, {0.6783759720620013, 
         0.4037191970236979}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9632506062820955, 0.578361567988282}, {
         0.9576157758986554, 0.5825292403308685}, {0.95206688121142, 
         0.5866778085835272}, {0.9154944638125696, 0.6160820964212395}, {
         0.8823573305616552, 0.6441480976990258}, {0.850699900636691, 
         0.6714306296247068}, {0.8403337502867646, 0.6807194821402569}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8373547673842577, 0.6833888754920452}, {
         0.8220018773636277, 0.6971462228461772}, {0.7958824896717844, 
         0.7212336791378716}, {0.771960966490481, 0.7436318002742249}, {
         0.749984957854487, 0.7643468767128212}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.23345260624243847`, 0.10840046778514222`}, {
         0.263760101048499, 0.12225747722586919`}, {0.29486790445744504`, 
         0.1380797346226339}, {0.32632914389717016`, 0.155978233996493}, {
         0.35739556568161396`, 0.17612142058722574`}, {0.37232158480418337`, 
         0.1871408785375827}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3755396097344574, 0.18951665536803944`}, {
         0.38166100699906863`, 0.19403590991279726`}, {0.4050177306739598, 
         0.2135054125833491}, {0.42724622246488786`, 0.23452601397023926`}, {
         0.44812696813045316`, 0.2570937994448258}, {0.4508484051586081, 
         0.26023738778307}, {0.45354218794753387`, 0.263408141370796}, {
         0.47361122208673956`, 0.2916786212715149}, {0.48270860662659143`, 
         0.30681068273417783`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.48476961189201084`, 0.3102388392790155}, {
         0.4916033883537257, 0.3216057464365371}, {0.5085172020898356, 
         0.3521724851107736}, {0.5232743107641934, 0.38401845080343877`}, {
         0.5359134575735687, 0.41684065955125066`}, {0.5464733857147314, 
         0.45033612739092743`}, {0.5480507683751632, 0.45655054874996653`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5490348661961311, 0.46042760323485143`}, {
         0.555056493069509, 0.484151032936963}, {0.5617651775197295, 
         0.5179315548038511}, {0.5669377461867247, 0.5536382248926459}, {
         0.570311072290544, 0.5886428327862407}, {0.5718647716075591, 
         0.6184402352225573}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5720731376789522, 0.6224394522191699}, {
         0.5720732992042016, 0.6224394522191699}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9758885438793296, 1.0605240777890823`}, {
         0.9676871539624923, 1.0582809934951445`}, {0.9596535332945797, 
         1.0560893557150068`}, {0.9216468677447329, 1.0458639765099353`}, {
         0.8872388765785421, 1.0367179106712852`}, {0.8544093372171426, 
         1.0280450556075251`}, {0.8247367014653267, 1.0203186220935458`}, {
         0.8212579301141818, 1.0194265552265633`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8173832945376153, 1.0184329762670412`}, {
         0.7978548988249701, 1.013425278714617}, {0.7733978587979493, 
         1.0072516940560081`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2751399224313414, 1.15}, {0.27134684058738295`, 
         1.1299784017348316`}, {0.2639087476278454, 1.0914365470637752`}, {
         0.2580829550937208, 1.0615766086849758`}, {0.25218526938262753`, 
         1.0315434200054154`}, {0.24782210080931508`, 1.0092106669952403`}, {
         0.24660933132871882`, 1.0029566672531889`}, {0.24552061090269878`, 
         0.9972986649637522}, {0.24468705630290538`, 0.9929251539766886}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.24394739571736562`, 0.9889941514469782}, {
         0.24068227376150197`, 0.9709993935195665}, {0.2406003551838934, 
         0.9705192055592334}, {0.24052010013281072`, 0.9700465136669146}, {
         0.2404447614052405, 0.9695994584979161}, {0.24026669902854336`, 
         0.968534012695507}, {0.24011228974700718`, 0.9675988375938334}, {
         0.23996475695351635`, 0.966694343762346}, {0.23881204597196148`, 
         0.9590664107094905}, {0.2381592258893808, 0.9535984331113838}, {
         0.23787362541534385`, 0.9496565624409958}, {0.23799481857587454`, 
         0.9451737602219412}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17469455202041329`, 0.728347870918103}, {
         0.18245936238711036`, 0.7596928504099044}, {0.18922830181139907`, 
         0.787682369681002}, {0.19503726906096155`, 0.8122978410557996}, {
         0.19996478154813088`, 0.8336120755006888}, {0.20728857128101366`, 
         0.8661144584934992}, {0.20749201175667614`, 0.8670364006984831}, {
         0.20769287923217455`, 0.8679477927374032}, {0.21112832019388306`, 
         0.883936334724735}, {0.21116815551136486`, 0.8841272596440215}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2119851379403838, 0.8880429383477297}, {
         0.21375208692450795`, 0.8965116694512645}, {0.21761976220264975`, 
         0.9157304608411296}}]}}}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1nk01Pv/B3BbZUtpkSmlonKjROSGPAtFobRIWeom5RKXkCVKIRVKi3uR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         "]]},
       Annotation[#, "Charting`Private`Tag$137477#1"]& ], 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
        LineBox[CompressedData["
1:eJw91gkw1lvcB3C0IF1LF6WIEuVe5KaI4ltUJJQiaRHZQqTlupQSeVQiS9Yi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         "]]},
       Annotation[#, "Charting`Private`Tag$137477#2"]& ]}, {}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
        0.3]], LineBox[CompressedData["
1:eJyV0nlUjGscB/Bu2pBLYynStOkq0kZDi34tQqEoLidr1onJdLVRKVqUw0nd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         "]]},
       Annotation[#, "Charting`Private`Tag$139072#1"]& ]}, {}}}, {{{}, {
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.005315180259893875, 0.05755118502610765}, {
         0.009253754587488863, 0.05840574958364356}, {0.016370375073678525`, 
         0.0609785752395866}, {0.028803134761993244`, 0.06636302282993478}, {
         0.053010315051178904`, 0.07770799529403206}, {0.09466376845094, 
         0.09847581472431756}, {0.12425765507992212`, 0.11418316931239039`}, {
         0.14865974365042334`, 0.12806082177891087`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1521367844190754, 0.13003824118134713`}, {
         0.1599378318547599, 0.13447475590321162`}, {0.17990280082841412`, 
         0.1466053545174627}, {0.20120036847637957`, 0.16020087311377262`}, {
         0.22345991901214995`, 0.1752829406951391}, {0.2463108366492189, 
         0.19187318626455974`}, {0.2760296445461572, 0.21558976259231932`}, {
         0.2829512159782154, 0.2217245443905069}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.28594465685093134`, 0.22437771452104008`}, {
         0.3058495418315339, 0.2420199692131521}, {0.3351485153210076, 
         0.2710984463619623}, {0.36330455183023674`, 0.30275983427365394`}, {
         0.3898353270178829, 0.3367432423166446}, {0.39355968297816624`, 
         0.3422397679893843}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.39580344847724896`, 0.3455511900985583}, {
         0.41425851654260754`, 0.3727877798593517}, {0.4363463164276536, 
         0.4105754218659062}, {0.4558010146849347, 0.4495188239708809}, {
         0.46859958717770617`, 0.4790677798611667}, {0.4712997078902921, 
         0.4861678660757577}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.472721539629453, 0.4899066351921267}, {
         0.47986892854918084`, 0.508701008829844}, {0.48964785181892806`, 
         0.5381699484789161}, {0.4979751700065175, 0.5672260364103864}, {
         0.4989998462268385, 0.5711149401586452}, {0.4999993118585184, 
         0.5749917606218528}, {0.5079184844627271, 0.6147726369262214}, {
         0.5123620734002896, 0.644472934211557}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5129539428953563, 0.6484289031827207}, {
         0.5135326731031374, 0.6522970510831271}, {0.5181334132141361, 
         0.6884026284699597}, {0.5207072562663115, 0.7216705323166468}, {
         0.5215571972751283, 0.7519689790059109}, {0.5209862312560516, 
         0.7791661849204752}, {0.5182190440616476, 0.8078433778755741}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5178348511442498, 0.8118248846006999}, {
         0.5166024802937436, 0.8245963142834022}, {0.5098469554205088, 
         0.8581851131811045}, {0.5014703659046529, 0.8831291656567161}, {
         0.4829984695442805, 0.9139570361389971}, {0.4656828608938726, 
         0.92930708233566}, {0.45348891696877963`, 0.9362945802006839}, {
         0.44315373522107315`, 0.9406613943660665}, {0.44099471440144283`, 
         0.941268044770384}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4371438438283965, 0.9423500779628718}, {
         0.43428810473678353`, 0.9431524950858566}, {0.4269112735335155, 
         0.9444448820531242}, {0.4205741042917906, 0.9451371420273712}, {
         0.41512926390729454`, 0.9454962908278867}, {0.41040315750307815`, 
         0.9456648234478999}, {0.4063240292493229, 0.9457231538348787}, {
         0.4027920053989766, 0.9457219946009322}, {0.3979908454307735, 
         0.9456583373884356}, {0.39414436023717564`, 0.945565710873157}, {
         0.39104213508205493`, 0.9454825986151288}, {0.38644551986863024`, 
         0.9453627017937808}, {0.38338142573177797`, 0.9452805476229514}, {
         0.38128807368524203`, 0.9452131082959411}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0012485535472057541`, 0.0019363574419383924`}, {
         0.002079759749410058, 0.0019095332242724634`}, {
         0.0037184635600041945`, 0.0018976191925662955`}, {
         0.007367205051851271, 0.0019208623204036294`}, {
         0.016177776058389666`, 0.0020205075282379898`}, {0.03149051638942077,
          0.002227170284528127}, {0.061166842404928416`, 
         0.0026658583309231033`}, {0.08540916962016178, 
         0.0030211914095529184`}, {0.11726588368895359`, 
         0.003517818895600946}, {0.15209120132918633`, 0.00414117741646965}, {
         0.16122897973583986`, 0.004321050889195625}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.16522820499437332`, 0.004399774021170686}, {
         0.19320012622796473`, 0.004950389979141391}, {0.23953501141086506`, 
         0.00599306365477582}, {0.29003820990346385`, 0.007316805514532598}, {
         0.3163785391140037, 0.008094879512852182}, {0.3251774575317451, 
         0.008384456976941405}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3291752930779486, 0.008516028043333054}, {
         0.34281217159817484`, 0.008964825555992971}, {0.3693391073559777, 
         0.009926643643954973}, {0.39595934638741204`, 0.01098033377673819}, {
         0.4300475942901762, 0.012560742022280687`}, {0.4626481511269155, 
         0.014429319815652963`}, {0.48897632891509246`, 
         0.01625439204981514}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.49296675285715336`, 0.016531008684577526`}, {
         0.49376101689762975`, 0.016586067156855008`}, {0.5233861916023189, 
         0.01903098404588682}, {0.5511649278522698, 0.021903257251945543`}, {
         0.5767384782587688, 0.025342073544228325`}, {0.6212700215414114, 
         0.033919335387466054`}, {0.6501795144732179, 0.04331287784508883}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6539837297562421, 0.044548979006161414`}, {
         0.6574024066927139, 0.04565980744674994}, {0.6855572189551433, 
         0.06146052759322994}, {0.7066496921288792, 0.0823520454747033}, {
         0.7214033290723582, 0.10954149407049109`}, {0.7305905392099711, 
         0.14426225396136128`}, {0.7332791274110022, 0.16475444942484024`}, {
         0.7337404437667153, 0.17165350183796582`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7340073143265253, 0.17564458942210961`}, {
         0.7347986104577926, 0.18747853681267546`}, {0.7348670039192392, 
         0.2308026067479722}, {0.7319839323393835, 0.28039541968188686`}, {
         0.7316936290847007, 0.2839414349689012}, {0.7313908128922378, 
         0.2875131194924334}, {0.7269667270713063, 0.3266680945695409}, {
         0.7258116507089605, 0.335182563397923}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7252739344932893, 0.3391462562810062}, {
         0.7213849861887637, 0.3678130442038631}, {0.7152719059359195, 
         0.4094618448291692}, {0.7080961469424722, 0.45211834743644286`}, {
         0.6999714011034299, 0.4950837135225799}, {0.6995609785980051, 
         0.49703391654947754`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6987372183389694, 0.5009481749767705}, {
         0.6910113603138004, 0.5376591045844762}, {0.6813457180764184, 
         0.5791987286480502}, {0.6711041678941188, 0.6190567937392208}, {
         0.6605184400272874, 0.6562629660853445}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6594238206752066, 0.6601102779357213}, {
         0.6583690781874828, 0.6638174326323755}, {0.6451478210714563, 
         0.7054920896934658}, {0.631686551077056, 0.7431258698970049}, {
         0.6182314227352984, 0.7757638782175059}, {0.6018322901607757, 
         0.8091013015203038}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.600066692638718, 0.812690544531038}, {0.5990748029642207,
          0.8147069344710622}, {0.5806832585283863, 0.8456258654583961}, {
         0.5634358106491619, 0.8697090857623327}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.007991959384349424, 0.18737918942632123`}, {
         0.014665332619929012`, 0.19575462102647093`}, {0.02404284485226666, 
         0.21125452873000952`}, {0.038937399713556094`, 0.2389435150658879}, {
         0.06122684095593691, 0.2836717671747492}, {0.07289826755292106, 
         0.30815402451768015`}, {0.08242433440296044, 
         0.3286901142122216}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.08410753724805241, 0.33231872664430556`}, {
         0.08603590995585036, 0.33647587098469833`}, {0.10049582118279327`, 
         0.3685355646087313}, {0.11613405425181815`, 0.4042313634227067}, {
         0.13264560636247988`, 0.44301681653391284`}, {0.14758808292033565`, 
         0.4791735636722408}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14911583691098265`, 0.4828703146435752}, {
         0.14972547471433337`, 0.48434547304963804`}, {0.16271516849528453`, 
         0.5165533981459839}, {0.17564170031914506`, 0.5492853488098967}, {
         0.18834798379382292`, 0.5820806167619507}, {0.20067693252722205`, 
         0.6144784937227098}, {0.20721354110163237`, 0.6319432947316374}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2086156478211007, 0.6356895057170494}, {
         0.21654686226824882`, 0.6568804766160631}, {0.23125509095513763`, 
         0.6968167623647062}, {0.23220817584001271`, 0.6994278385706469}, {
         0.23315513625933992`, 0.7020239606184527}, {0.24504513044513235`, 
         0.734840650937636}, {0.2557820553010721, 0.7644832403115248}, {
         0.26358919265807296`, 0.7859478138198195}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2649564491854812, 0.7897068841288533}, {
         0.2659399685095208, 0.7924109255543246}, {0.2749398584229873, 
         0.8169088025349469}, {0.28983109174382177`, 0.8563128613966663}, {
         0.30125887971686544`, 0.8846031461851092}, {0.31449650596901896`, 
         0.9130841577407179}, {0.3234564871128151, 0.9275012763716008}, {
         0.3301634417189963, 0.9348833727408711}, {0.330189687019687, 
         0.9349037920307228}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.33334672987062647`, 0.9373600250077289}, {
         0.3348252909022445, 0.9385103706114623}, {0.3389257158870297, 
         0.9408672338505835}, {0.3425447636272148, 0.9422686193013112}, {
         0.3456662295911617, 0.9430537018483448}, {0.34850786694327657`, 
         0.9435411099190769}, {0.35110961976304056`, 
         0.9438597813869771}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.9610126159531893}, {0.9990345385026703, 
         0.9609913329662609}, {0.9696328557403904, 0.9603346581097962}, {
         0.9420927242886611, 0.9597135144087203}, {0.8925971153168553, 
         0.9585778204727349}, {0.8494558297844842, 0.957566573004141}, {
         0.8400421321409274, 0.9573417907136108}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8360432719917645, 0.9572463050736557}, {
         0.8115769858887797, 0.9566620938487753}, {0.8068257181795436, 
         0.9565473689444552}, {0.8021542448459915, 0.9564343176472644}, {
         0.7703943048437545, 0.9556538724170947}, {0.7421029252912291, 
         0.9549499109362772}, {0.6914174176477923, 0.9536750408376361}, {
         0.676092428825847, 0.9532813802130061}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6720937478682476, 0.9531786641026224}, {
         0.6509226576300524, 0.9526348317576792}, {0.6179437514796188, 
         0.9517752291963395}, {0.568227157039481, 0.9504614056519424}, {
         0.5325904038976028, 0.9495064067842274}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9587219655338541, 0.6837119705762049}, {
         0.9159887583189529, 0.7090923473269792}, {0.8779326543830237, 
         0.7327505788633747}, {0.8438185189281922, 0.754643532371413}, {
         0.8394871580697053, 0.7574747188103694}, {0.8352166076158347, 
         0.7602738284143594}, {0.8230011686270816, 0.7684008331922664}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8196708774961272, 0.7706164958432777}, {
         0.8045387780725398, 0.7806839722907871}, {0.7767921762087373, 
         0.7992169157279356}, {0.7503048503493142, 0.8168345400111245}, {
         0.7263360764986495, 0.8326215259863946}, {0.6859410222097616, 
         0.8584491216519179}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6825319729436888, 0.8605408285562286}, {
         0.6498442166506991, 0.880122882526079}, {0.6195722245058977, 
         0.8966699472417003}, {0.5938086869298481, 0.9092379665392357}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20192105761486553`, 0.050400212455347364`}, {
         0.2310241098935508, 0.05675524257666449}, {0.2617353422197898, 
         0.06412907248073081}, {0.29353722744135663`, 0.07265598098840816}, {
         0.3259122384060253, 0.08247024692055831}, {0.35601880242412554`, 
         0.09293071973305797}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3597698655751084, 0.09431647520388836}, {
         0.3901238575859159, 0.10656098496121579`}, {0.4210165189046342, 
         0.12109513000762809`}, {0.4503893615408025, 0.13749840974408714`}, {
         0.47364199171441806`, 0.15292380230558578`}, {0.4952681246792671, 
         0.1698902578392325}, {0.49827342403403857`, 0.17267134016004274`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5012092469100002, 0.17538812944907123`}, {
         0.51526776043535, 0.1883977763450274}, {0.5336408989826664, 
         0.20844635782297039`}, {0.5360070942687994, 0.21125173343278475`}, {
         0.5383405530325152, 0.21408588890658006`}, {0.5544914429346451, 
         0.2385092023620219}, {0.5686397587884312, 0.2647085000225044}, {
         0.5817938752090792, 0.2916812177555716}, {0.5880808190068137, 
         0.30773937583127114`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5895390835408124, 0.3114640858265435}, {
         0.5929595927634507, 0.3202007756338083}, {0.6022166434595903, 
         0.35007091034389287`}, {0.6096447593055423, 0.38109535857250376`}, {
         0.615349772969884, 0.4130015563160257}, {0.6194375171211925, 
         0.4455169395708434}, {0.621121877526172, 0.4677141740268536}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6214245336014829, 0.4717027075042206}, {
         0.6220549048110638, 0.4800100136437039}, {0.6231548993061511, 
         0.5145225065823292}, {0.6229027866713545, 0.5486303781792066}, {
         0.6214638529715736, 0.5819095882268223}, {0.6189723371386794, 
         0.6140910179269589}, {0.6170495608165953, 0.631426664453936}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6163438594696852, 0.6426071307291656}, {
         0.6158094838578031, 0.6426071307291656}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.20151070995072387`, 1.15}, {0.19687629648458113`, 
         1.1302868914489757`}, {0.1870570074596501, 1.0933643484661766`}, {
         0.17830845850066812`, 1.0642911839211286`}, {0.17039432484347358`, 
         1.0416069838616109`}, {0.1629774239798851, 1.023281831290051}, {
         0.1539782868639582, 1.0046739025079847`}, {0.15031362738163317`, 
         0.9990428676470912}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14813179641385496`, 0.9956903143472846}, {
         0.1377579866428213, 0.9797501472614446}, {0.13721180560984406`, 
         0.9790813431095936}, {0.1366650579103053, 0.9784211931769761}, {
         0.1257255138608266, 0.968141120356546}, {0.11420697215926141`, 
         0.9596228486068679}, {0.08997270853501137, 0.9449036790634745}, {
         0.0638946167183734, 0.9328023557838603}, {0.038565179065588276`, 
         0.9197282096826157}, {0.02151979395719923, 0.9023880592010154}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.018715716170643684`, 0.8995354905748566}, {
         0.014501586045115849`, 0.895248485613629}, {0.010760229451103224`, 
         0.887676175449977}, {0.007767559400176594, 0.8797326562899801}, {
         0.005542252678650447, 0.8712967267694348}, {0.0030205281638741735`, 
         0.8556358133631217}, {0.0016794965022389672`, 0.8392465480424747}, {
         0.0009606639652322169, 0.822587323237586}, {0.000582868009676899, 
         0.8074007025699049}, {0.0003532419386694125, 0.7923259128024964}, {
         0.00021676599979087268`, 0.7774132100885689}, {
         0.00013749926751834636`, 0.763141808408893}, {0.00008856365235617128,
          0.749085896166136}, {0.00007561935766867175, 0.7432467641908352}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.00006675210620978785, 0.7392467740193659}, {
         0.00005791087142462761, 0.7352585198903073}, {0.00003823696132192895,
          0.7214626555493651}, {0.000025674305940201902`, 
         0.7079119369607114}, {0.000017523084181695026`, 
         0.6946066231647166}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.982420449767751, 0.42304115961063726`}, {
         0.9452713410993222, 0.4552441352262494}, {0.9118889543784554, 
         0.4875268052120116}, {0.8816403251458672, 0.5195956280755437}, {
         0.8777797012494438, 0.5238977668962438}, {0.8739666767523326, 
         0.5281904245278117}, {0.8683358704795866, 0.5349420768125693}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8657739437201243, 0.538013970573615}, {
         0.8571010120403727, 0.5484133017092934}, {0.8411201762929797, 
         0.5683277511162922}, {0.8113555020038121, 0.6067292906028515}, {
         0.7828879831687156, 0.6439514415027064}, {0.7677040929072172, 
         0.6644112794285824}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7653202991395147, 0.6676233702232305}, {
         0.7570147752417615, 0.678814815229153}, {0.7333694789238316, 
         0.7111161746685053}, {0.711585694915808, 0.7406522827070778}, {
         0.6914540053565984, 0.7674160651513953}, {0.6727649923851106, 
         0.7914004478079821}, {0.6693357615712766, 0.795618189175829}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6668123646838165, 0.7987218109550343}, {
         0.6559223332063445, 0.8121158747416993}, {0.6401107941231521, 
         0.8306055929896448}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.0726354132149987}, {0.9797407828781172, 
         0.07952260995481178}, {0.9549158525480289, 0.09009910330778362}, {
         0.9329131476655398, 0.10189030153809975`}, {0.8957123717678481, 
         0.1294802984284502}, {0.8934724692892321, 0.13152900585319185`}, {
         0.891262491749183, 0.13360446839081494`}, {0.875259403446674, 
         0.1523535054427732}, {0.8696798258312124, 0.16019313408533223`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.867360424831514, 0.16345202638220216`}, {
         0.8605154595659482, 0.17306959772031713`}, {0.8462821234542818, 
         0.19474561596022616`}, {0.8330700028807341, 0.21834148612486542`}, {
         0.8206669885374103, 0.2438108954422311}, {0.8088609711164154, 
         0.27110753114031944`}, {0.7975064650358004, 0.30008992637906823`}, {
         0.7954562131516919, 0.30575472349488214`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7940949157064472, 0.3095159559080109}, {
         0.786457984713616, 0.33061661431841527`}, {0.7752090877410085, 
         0.36347973196771827`}, {0.7640754989392153, 0.3971096199262486}, {
         0.7530572183082368, 0.4315062781940062}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.010808276982210856`, 0.11366037247768163`}, {
         0.020142352714313867`, 0.12088660628891897`}, {0.03831805854841904, 
         0.13782970790516683`}, {0.07129924115738799, 0.1714705160801383}, {
         0.10227610379375068`, 0.2049405778298005}, {0.1209381192176681, 
         0.22602632857039046`}, {0.12254369055919041`, 
         0.22790770489640147`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12514028949147515`, 0.2309503474953371}, {
         0.1416432419519349, 0.2502881765070059}, {0.1640932730095261, 
         0.27776634545055506`}, {0.1879900134034168, 0.30850105921194615`}, {
         0.2129744696276323, 0.3423733454932403}, {0.2232636671864492, 
         0.3572314167545538}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.22554093207244374`, 0.36051989127004214`}, {
         0.23838943009657645`, 0.37907370930610684`}, {0.2548150545586289, 
         0.4041800998455383}, {0.271004925910955, 0.4301317312874976}, {
         0.2867344592702193, 0.45660981709109205`}, {0.30193191984725465`, 
         0.4835436113581864}, {0.309068342760124, 0.49687180030233513`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.31095647218867845`, 0.5003981251967581}, {
         0.3164820807158255, 0.5107179108064934}, {0.33026971494969654`, 
         0.5379175121537259}, {0.33207642589527364`, 0.5415847741133107}, {
         0.3338675634079674, 0.5452482424061782}, {0.3529708271870995, 
         0.5883965603702987}, {0.3696080059927753, 0.62963968167688}, {
         0.37608670026906105`, 0.6464043931235386}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3775285722467407, 0.6501354794532799}, {
         0.38499970858582233`, 0.6694683017106617}, {0.39790045875361185`, 
         0.7064679191988444}, {0.40847512567913086`, 0.7403296763308033}, {
         0.4168885785453667, 0.7707447152959137}, {0.42338225282528275`, 
         0.7977319365258512}, {0.4244428304031802, 0.8029250623160135}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.42524321815427646`, 0.8068441667351244}, {
         0.4281975839918426, 0.8213102404522915}, {0.43389497343678224`, 
         0.8583760659140905}, {0.435638319483246, 0.8851358444138618}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5084437047157727, 1.15}, {0.5084082398563076, 
         1.1499096270012632`}, {0.4966495442941996, 1.1210179386134094`}, {
         0.47757030346417173`, 1.0765273957852795`}, {0.4764562395541205, 
         1.0740285357264014`}, {0.4753615853236102, 1.0715841224715434`}, {
         0.4675894068941483, 1.0548248077532298`}, {0.46073041756606903`, 
         1.0405061004615592`}, {0.44858253639245144`, 1.0159623093994508`}, {
         0.4423775210294151, 1.0043675439471538`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.44017942063371573`, 0.9988531814380165}, {
         0.43942647348754615`, 0.9988531814380165}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.05953258930189595, 0.3943212217418805}, {
         0.06727534276680903, 0.4229818389785769}, {0.07526788189609397, 
         0.45401558343865117`}, {0.0832898865022923, 0.4867148634671308}, {
         0.09187610779047584, 0.5238778152115671}, {0.09744865734566155, 
         0.549738882837567}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.09829123905668165, 0.553649132965149}, {
         0.10011514225208229`, 0.5621134962538773}, {0.10777765973876421`, 
         0.6005275804594795}, {0.1146343301021741, 0.6382257416937916}, {
         0.12053148832716866`, 0.6744293332377406}, {0.1253154693986046, 
         0.708359708372253}, {0.125649267090357, 0.7112476285742266}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12610854580668424`, 0.7152211739760974}, {
         0.1289307504481261, 0.7396380648039977}, {0.13131677058289865`, 
         0.7677748464130109}, {0.13256255135097403`, 0.809267445155387}, {
         0.132541855818284, 0.8104975996618802}, {0.1325170429776696, 
         0.8117165995871446}, {0.13093163395580895`, 0.829170431492371}, {
         0.12826443949204624`, 0.8440066034945735}, {0.12083108918145567`, 
         0.8688435464833847}, {0.11812380428111145`, 0.8726815356610075}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.11581814248410424`, 0.8759501628465124}, {
         0.10934594638736946`, 0.8851254877528649}, {0.09411271843762375, 
         0.8947983609935394}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7000126704838011, 1.15}, {0.6838336115890866, 
         1.1320976739693713`}, {0.6586450846038822, 1.1055432289330769`}, {
         0.636622003370999, 1.0833105790749387`}, {0.6338650217120669, 
         1.080603314754877}, {0.6311554224393783, 1.0779581094333726`}, {
         0.61784443825854, 1.0653922723309794`}, {0.6056118901946339, 
         1.054171678525248}, {0.5866315597678032, 1.0372618364643753`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5836449276738833, 1.034601004125507}, {
         0.5830615363272608, 1.0340812526085827`}, {0.5639392353538721, 
         1.018120063193045}, {0.5475481278100937, 1.0053128446293857`}, {
         0.5139329723823047, 0.9819578791797015}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.24670206981448267`}, {0.9668903226725137, 
         0.27222877905708176`}, {0.9369235729742608, 0.29947376532990533`}, {
         0.9331234770762282, 0.3032396360675635}, {0.9293751200344278, 
         0.3070294655705617}, {0.8995586752643364, 0.34279975464595247`}, {
         0.887502022631277, 0.35931027779952524`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8851430698324312, 0.36254065574843736`}, {
         0.8724526471454956, 0.37991907113271683`}, {0.8464655667751125, 
         0.4173551069733554}, {0.8227163819016448, 0.45542458152174253`}, {
         0.8008166273972714, 0.4936398634532358}, {0.7989197684118947, 
         0.49715477855758794`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7970200995309986, 0.5006749004507836}, {
         0.7803778381341718, 0.5315133214431931}, {0.7611818854213926, 
         0.5685941048663276}, {0.7430106405679806, 0.6044313630973523}, {
         0.727282603884666, 0.6360545448080503}, {0.7238610773382753, 
         0.6429562809397394}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.71984260284645, 0.661751162839457}, {0.7145435395290713, 
         0.661751162839457}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9106584515354561, 1.138962939886078}, {
         0.8842316930004651, 1.1242654674754922`}, {0.859586581261107, 
         1.110754818570249}, {0.8156412981692903, 1.0872939912757913`}, {
         0.8102031694842006, 1.0844542401538888`}, {0.8048699729403089, 
         1.0816817471567277`}, {0.7751971668793955, 1.066679417672204}, {
         0.7694172055234665, 1.0638291964680762`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7658296800143823, 1.0620601117551045`}, {
         0.7485852871023686, 1.053556536851491}, {0.7232920147120079, 
         1.041236463679511}, {0.7006359570949796, 1.030522005804997}, {
         0.6618764759475498, 1.0129967422366057`}, {0.6300155855455457, 
         0.9994647919408818}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3548639334195923, 1.15}, {0.3514093567415543, 
         1.132924743954166}, {0.3463575283083049, 1.1078248262546373`}, {
         0.3385608764661015, 1.0683754369161496`}, {0.33812552342029223`, 
         1.066126724314788}, {0.3377004344010081, 1.0639235940785507`}, {
         0.3342640144104573, 1.045383402859212}, {0.331543228940178, 
         1.0299136046501962`}, {0.3273157001163407, 
         1.0040327656713743`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.98799790396016, 0.824318591479259}, {0.9614942481179388, 
         0.8316762381173142}, {0.936810675780761, 0.8386330515134828}, {
         0.930409626883344, 0.8404522186739751}, {0.9241189186025389, 
         0.8422443618024801}, {0.8875988118317715, 0.8527751773403117}, {
         0.8546121578861683, 0.8623364803435737}, {0.8341517017416165, 
         0.8682604132683472}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.830309503337386, 0.8693728481754446}, {0.823159585254092,
          0.8714429699187634}, {0.7947751752490704, 0.879639832637809}, {
         0.769087895416055, 0.8870045624133035}, {0.745726713299999, 
         0.893614653157841}, {0.7049362468335371, 0.9048395290745207}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0929929916126462, 1.15}, {0.08465544086542066, 
         1.129188889324418}, {0.06799622400325998, 1.094812441606252}, {
         0.06691948749536304, 1.0927914885687215`}, {0.06584935729814786, 
         1.0908036081796302`}, {0.05759503966567307, 1.0766281568576337`}, {
         0.04983803486265575, 1.0639759397921107`}, {0.03555760535242913, 
         1.0410533100229193`}, {0.023946006858832095`, 1.0219973701141807`}, {
         0.017351111103734863`, 1.0093465235213266`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.015502069422566859`, 1.0057995466590812`}, {
         0.015230496160272774`, 1.005278593514773}, {0.01120531082407512, 
         0.9955492963137371}, {0.008125633433769772, 0.986131329123122}, {
         0.00583077643966174, 0.9769056723652565}, {0.0029774950959918253`, 
         0.9590449288488035}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.006302186789323222}, {0.9763186813487597, 
         0.007058565446987368}, {0.9395632300874686, 0.008951110183311139}, {
         0.9107426959453558, 0.011370674439836477`}, {0.8877517998015447, 
         0.014446380725209634`}, {0.8696110189244511, 
         0.018289963664117455`}, {0.8549042910061472, 0.02313137490482253}, {
         0.8430902000950558, 0.0293658798749722}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8396698556350507, 0.03138787993248829}, {
         0.8197743277343238, 0.05224988782516116}, {0.8192042924307237, 
         0.05314776669384465}, {0.8186393176612913, 0.05406010015245548}, {
         0.8123444207794711, 0.06769107826457589}, {0.8073008399563562, 
         0.08108665253248365}, {0.8023153310322116, 0.09678242955499847}, {
         0.7922327406150529, 0.1331781535596479}, {0.7821204964583194, 
         0.17751190476894613`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.46117955810874717`, 0.05820431729167524}, {
         0.4916243371702479, 0.06707287426709359}, {0.5200699079889889, 
         0.07723389963090872}, {0.5462154155811227, 0.08886835678829003}, {
         0.5843690372017607, 0.11216168713540742`}, {0.6026262023403438, 
         0.12889363057348704`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6055751239126215, 0.1315961963100706}, {
         0.6156048921399314, 0.14078806774260458`}, {0.6174778564173722, 
         0.1428981067862283}, {0.6193200097083341, 0.14503499942772602`}, {
         0.6315979421531425, 0.16351929672002363`}, {0.6421715258003791, 
         0.18380383400037223`}, {0.6600057315588962, 0.22788203627404235`}, {
         0.6665188983494831, 0.2525050559729904}, {0.6707703258104645, 
         0.2747707318450771}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6715205359700457, 0.2786997501342253}, {
         0.6715371544986826, 0.2787867850831914}, {0.6751420751934727, 
         0.306597780268812}, {0.6774152356208312, 0.3358085981940189}, {
         0.6785470049180533, 0.36937822832648587`}, {0.6783759720620013, 
         0.4037191970236979}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9632506062820955, 0.578361567988282}, {
         0.9576157758986554, 0.5825292403308685}, {0.95206688121142, 
         0.5866778085835272}, {0.9154944638125696, 0.6160820964212395}, {
         0.8823573305616552, 0.6441480976990258}, {0.850699900636691, 
         0.6714306296247068}, {0.8403337502867646, 0.6807194821402569}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8373547673842577, 0.6833888754920452}, {
         0.8220018773636277, 0.6971462228461772}, {0.7958824896717844, 
         0.7212336791378716}, {0.771960966490481, 0.7436318002742249}, {
         0.749984957854487, 0.7643468767128212}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.23345260624243847`, 0.10840046778514222`}, {
         0.263760101048499, 0.12225747722586919`}, {0.29486790445744504`, 
         0.1380797346226339}, {0.32632914389717016`, 0.155978233996493}, {
         0.35739556568161396`, 0.17612142058722574`}, {0.37232158480418337`, 
         0.1871408785375827}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3755396097344574, 0.18951665536803944`}, {
         0.38166100699906863`, 0.19403590991279726`}, {0.4050177306739598, 
         0.2135054125833491}, {0.42724622246488786`, 0.23452601397023926`}, {
         0.44812696813045316`, 0.2570937994448258}, {0.4508484051586081, 
         0.26023738778307}, {0.45354218794753387`, 0.263408141370796}, {
         0.47361122208673956`, 0.2916786212715149}, {0.48270860662659143`, 
         0.30681068273417783`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.48476961189201084`, 0.3102388392790155}, {
         0.4916033883537257, 0.3216057464365371}, {0.5085172020898356, 
         0.3521724851107736}, {0.5232743107641934, 0.38401845080343877`}, {
         0.5359134575735687, 0.41684065955125066`}, {0.5464733857147314, 
         0.45033612739092743`}, {0.5480507683751632, 0.45655054874996653`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5490348661961311, 0.46042760323485143`}, {
         0.555056493069509, 0.484151032936963}, {0.5617651775197295, 
         0.5179315548038511}, {0.5669377461867247, 0.5536382248926459}, {
         0.570311072290544, 0.5886428327862407}, {0.5718647716075591, 
         0.6184402352225573}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5720731376789522, 0.6224394522191699}, {
         0.5720732992042016, 0.6224394522191699}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9758885438793296, 1.0605240777890823`}, {
         0.9676871539624923, 1.0582809934951445`}, {0.9596535332945797, 
         1.0560893557150068`}, {0.9216468677447329, 1.0458639765099353`}, {
         0.8872388765785421, 1.0367179106712852`}, {0.8544093372171426, 
         1.0280450556075251`}, {0.8247367014653267, 1.0203186220935458`}, {
         0.8212579301141818, 1.0194265552265633`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8173832945376153, 1.0184329762670412`}, {
         0.7978548988249701, 1.013425278714617}, {0.7733978587979493, 
         1.0072516940560081`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2751399224313414, 1.15}, {0.27134684058738295`, 
         1.1299784017348316`}, {0.2639087476278454, 1.0914365470637752`}, {
         0.2580829550937208, 1.0615766086849758`}, {0.25218526938262753`, 
         1.0315434200054154`}, {0.24782210080931508`, 1.0092106669952403`}, {
         0.24660933132871882`, 1.0029566672531889`}, {0.24552061090269878`, 
         0.9972986649637522}, {0.24468705630290538`, 0.9929251539766886}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.24394739571736562`, 0.9889941514469782}, {
         0.24068227376150197`, 0.9709993935195665}, {0.2406003551838934, 
         0.9705192055592334}, {0.24052010013281072`, 0.9700465136669146}, {
         0.2404447614052405, 0.9695994584979161}, {0.24026669902854336`, 
         0.968534012695507}, {0.24011228974700718`, 0.9675988375938334}, {
         0.23996475695351635`, 0.966694343762346}, {0.23881204597196148`, 
         0.9590664107094905}, {0.2381592258893808, 0.9535984331113838}, {
         0.23787362541534385`, 0.9496565624409958}, {0.23799481857587454`, 
         0.9451737602219412}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17469455202041329`, 0.728347870918103}, {
         0.18245936238711036`, 0.7596928504099044}, {0.18922830181139907`, 
         0.787682369681002}, {0.19503726906096155`, 0.8122978410557996}, {
         0.19996478154813088`, 0.8336120755006888}, {0.20728857128101366`, 
         0.8661144584934992}, {0.20749201175667614`, 0.8670364006984831}, {
         0.20769287923217455`, 0.8679477927374032}, {0.21112832019388306`, 
         0.883936334724735}, {0.21116815551136486`, 0.8841272596440215}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2119851379403838, 0.8880429383477297}, {
         0.21375208692450795`, 0.8965116694512645}, {0.21761976220264975`, 
         0.9157304608411296}}]}}}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1nk01Pv/B3BbZUtpkSmlonKjROSGPAtFobRIWeom5RKXkCVKIRVKi3uR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         "]]},
       Annotation[#, "Charting`Private`Tag$155793#1"]& ], 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
        LineBox[CompressedData["
1:eJw91gkw1lvcB3C0IF1LF6WIEuVe5KaI4ltUJJQiaRHZQqTlupQSeVQiS9Yi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         "]]},
       Annotation[#, "Charting`Private`Tag$155793#2"]& ]}, {}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
        0.3]], LineBox[CompressedData["
1:eJwUl3c41t8bx1VIUykllBUJyUoh3rYyKntVyCgqK9kZoTKSHZmPrVQIISsN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         "]]},
       Annotation[#, "Charting`Private`Tag$157388#1"]& ]}, {}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox["\"A\"", TraditionalForm], 
    FormBox["\"H\"", TraditionalForm]},
  FrameStyle->Directive[FontFamily -> "Arial", 18],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "VectorLengthFunction" -> 
    Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
      System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`imin = If[
         NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
         Min[System`VectorPlotsDump`m], 
         Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
         NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
         Max[System`VectorPlotsDump`m], 
         Max[System`VectorPlotsDump`m]]; Map[If[
         Or[# > System`VectorPlotsDump`imax, # < 
          System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
        System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
    "TransparentPolygonMesh" -> True},
  PlotRange->{{0, 1}, {0, 1.15}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9034393154473257`*^9, 3.9034393337934837`*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"6f6b4388-5a8e-464d-8902-31ab4b0fb61d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A0", "=", "0.8`"}], ",", 
     RowBox[{"R", "=", "0.1`"}], ",", 
     RowBox[{"g", "=", "2"}], ",", 
     RowBox[{"Hmax", "=", "1.15`"}], ",", 
     RowBox[{"k", "=", "5"}], ",", 
     RowBox[{"m", "=", "0.14`"}], ",", 
     RowBox[{"point", "=", 
      RowBox[{"{", 
       RowBox[{"0.05`", ",", "0.33999999999999997`"}], "}"}]}], ",", 
     RowBox[{"r", "=", "8"}], ",", 
     RowBox[{"s", "=", "6"}], ",", 
     RowBox[{"\[Gamma]", "=", "0.8`"}], ",", 
     RowBox[{"rc", "=", "2"}]}], "}"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"algaefun$", "=", 
        RowBox[{
         RowBox[{"\[Gamma]", " ", 
          RowBox[{"A", "[", "t", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox[
             RowBox[{"A", "[", "t", "]"}], 
             RowBox[{"A0", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"R", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "rc"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}]}], ")"}]}]]}]]}], 
           ")"}]}], "-", 
         FractionBox[
          RowBox[{"g", " ", 
           RowBox[{"A", "[", "t", "]"}], " ", 
           RowBox[{"H", "[", "t", "]"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]]}]}], ",", 
       RowBox[{"herbfun$", "=", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", " ", 
             RowBox[{"A", "[", "t", "]"}], " ", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"H", "[", "t", "]"}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "A0"}], ")"}], " ", "k"}]]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{"g", " ", "s", " ", 
            RowBox[{"A", "[", "t", "]"}]}]}]], "-", 
         RowBox[{"m", " ", 
          RowBox[{"H", "[", "t", "]"}]}]}]}]}], "}"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"VectorPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"algaefun$", ",", "herbfun$"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"H", "[", "t", "]"}], ",", "0", ",", "Hmax"}], "}"}], ",", 
         
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"VectorColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"VectorStyle", "\[Rule]", "Gray"}], ",", 
         RowBox[{"VectorPoints", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamPoints", "\[Rule]", "Coarse"}], ",", 
         RowBox[{"StreamColorFunction", "\[Rule]", "None"}], ",", 
         RowBox[{"StreamStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.85`", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.035`", "]"}], ",", "Thick"}], 
           "}"}]}], ",", 
         RowBox[{"StreamScale", "\[Rule]", "Large"}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<A\>\"", ",", "\"\<H\>\""}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", "18"}], 
           "]"}]}]}], "]"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"algaefun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "1", "\[RightDoubleBracket]"}]}], ",", 
           RowBox[{
            RowBox[{"H", "[", "t", "]"}], "/.", "\[VeryThinSpace]", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{
               RowBox[{"herbfun$", "\[Equal]", "0"}], ",", 
               RowBox[{"H", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
             "2", "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "Hmax"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".01", "]"}], ",", "Black", ",", 
              RowBox[{"Dashing", "[", ".03", "]"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"A0", ",", "Thick"}], "}"}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "}"}]}], ",", 
         RowBox[{"GridLinesStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"Dashing", "[", "0.05`", "]"}], ",", "Thick"}], "}"}], 
            ",", 
            RowBox[{"{", "}"}]}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"First", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"A", "[", "t", "]"}], ",", 
              RowBox[{"H", "[", "t", "]"}]}], "}"}], "/.", "\[VeryThinSpace]", 
            RowBox[{"NDSolve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  SuperscriptBox["A", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "algaefun$"}], ",", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["H", "\[Prime]",
                   MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
                 "herbfun$"}], ",", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"A", "[", "0", "]"}], ",", 
                    RowBox[{"H", "[", "0", "]"}]}], "}"}], "\[Equal]", 
                  "point"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "H"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]}], "]"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.903100411334831*^9, 3.903100456648641*^9}, {
  3.903100492918792*^9, 3.903100597451132*^9}, {3.90312886958524*^9, 
  3.903128872919285*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"6d2f7947-4d4e-406c-a537-27780c36525e"],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`A0$$ = 0.8, $CellContext`R$$ = 
  0.1, $CellContext`g$$ = 2, $CellContext`Hmax$$ = 1.15, $CellContext`k$$ = 
  5, $CellContext`m$$ = 0.14, $CellContext`point$$ = {0.05, 
  0.33999999999999997`}, $CellContext`r$$ = 8, $CellContext`s$$ = 
  6, $CellContext`\[Gamma]$$ = 0.8, $CellContext`rc$$ = 2}, 
  GraphicsBox[{{{}, {
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.031222289681897476`, 0.22832032369624986`}, {
         0.05192988889421365, 0.23545280501151306`}, {0.08727063579905905, 
         0.25879381836658527`}, {0.11278200186537327`, 0.2776533755518001}, {
         0.1446258830190042, 0.301522535304455}, {0.16401240242739054`, 
         0.3160460828504183}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.16721369726784008`, 0.31844435542552546`}, {
         0.17110243217648963`, 0.32135762856907835`}, {0.2008609764685685, 
         0.3434444979064807}, {0.23345768833301578`, 0.36746680195329534`}, {
         0.2684487402076065, 0.39310819934615576`}, {0.2960232962480126, 
         0.4133543310896269}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2992475333429545, 0.41572167034617646`}, {
         0.3049549761707451, 0.41991225964307943`}, {0.3420972403008359, 
         0.44742255240208406`}, {0.36367211255619947`, 
         0.46358454577472147`}, {0.38489622230573983`, 0.4797143215055159}, {
         0.40558006962626764`, 0.4957162727656129}, {0.4255341545945834, 
         0.5114947927261502}, {0.42668767896701787`, 0.5124439844608197}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4297764107901017, 0.5149855854769254}, {
         0.46294639214721267`, 0.5422799131007684}, {0.4958809324824792, 
         0.5712220096116087}, {0.49795158391965083`, 0.5731122052861549}, {
         0.4999993118585184, 0.5749917606218528}, {0.520262648625902, 
         0.5948363941152562}, {0.5378157181273292, 0.6131935298451158}, {
         0.5470207753881952, 0.6235492030062153}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5496782330740444, 0.6265388382093664}, {
         0.5676381844217586, 0.6467437517558444}, {0.5879909463012077, 
         0.6741197956798315}, {0.6011041610907988, 0.6958251519783216}, {
         0.6128265362296512, 0.7231569917817713}, {0.6158178976849537, 
         0.7394644986600135}, {0.6157216151643188, 0.7488775058527772}, {
         0.6150927219820986, 0.7537526280319554}, {0.6144284629086967, 
         0.7567803693328653}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.009510710977620485, 0.03248847569718015}, {
         0.014698410384793803`, 0.031357200667067125`}, {0.02277287234897075, 
         0.03093508393895158}, {0.02826445193206073, 0.031036514012447825`}, {
         0.035035294555388605`, 0.03138193647231342}, {0.04355053308617967, 
         0.0320376622328426}, {0.06796406905414913, 0.03452088613690938}, {
         0.10297898842184429`, 0.03862472311062613}, {0.12985558822265691`, 
         0.04199439982395725}, {0.16206224337395858`, 0.04620104441939943}, {
         0.1684331561606559, 0.047077826706166656`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17239580587129305`, 0.04762317730054373}, {
         0.1994943802934367, 0.05135255656619459}, {0.24204742539877866`, 
         0.05755683593358467}, {0.28869483979480737`, 0.0649389972159814}, {
         0.3304771572462436, 0.07223828791993522}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.33441748094925966`, 0.07292665491177151}, {
         0.33841008458634536`, 0.07362415510779644}, {0.3717352544964588, 
         0.08007818684940746}, {0.40465859493470896`, 0.08722460767016868}, {
         0.43718010590109607`, 0.09506341757008017}, {0.4692997873956199, 
         0.10359461654914186`}, {0.4899998178263074, 0.10985599908345058`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.49382849781180727`, 0.111014105109958}, {
         0.5048553834851688, 0.11434953737389558`}, {0.5380024396952677, 
         0.12616665543242206`}, {0.5683835990807493, 0.13908077476435554`}, {
         0.5956415046964458, 0.1531266994093301}, {0.6197193925666706, 
         0.16831350475425297`}, {0.636361755243357, 
         0.18135898836560824`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6395098439268659, 0.18382668722097195`}, {
         0.640560498715737, 0.1846502661860314}, {0.6582656944814839, 
         0.20212187182455846`}, {0.6730509422189195, 0.22068916303939679`}, {
         0.692619688287506, 0.2554813718293024}, {0.7053798497814863, 
         0.2929319144173897}, {0.7060343764707172, 0.29553747921140144`}, {
         0.706664235967452, 0.29815210064922776`}, {0.7093218771716985, 
         0.3126860197806614}, {0.7107673531413583, 0.32300769980540944`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7113221104282561, 0.32696904356133794`}, {
         0.7113847428475706, 0.327416281567994}, {0.7144188683109038, 
         0.35713436223813044`}, {0.7154757377471852, 0.3871792328498412}, {
         0.7149344919012287, 0.4171717232350882}, {0.713084633266732, 
         0.44606399830489696`}, {0.7101861914686107, 0.47431696333123946`}, {
         0.7085653034979774, 0.4864716832647489}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.708036565720422, 0.4904365838136386}, {
         0.7065532843621459, 0.5015594188393037}, {0.7025000298026183, 
         0.5274201653542773}, {0.6935028978556219, 0.5745609588829244}, {
         0.6839356346901146, 0.6148681988731228}, {0.6748224548800978, 
         0.6467757168900344}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6715939059820816, 0.6689279951940974}, {
         0.6672601474543208, 0.6689279951940974}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2513499595860249, 1.127969974101633}, {
         0.25085315924933166`, 1.0843930061032099`}, {0.2513833472359357, 
         1.0467808278189834`}, {0.2528448191989568, 1.0141816902718392`}, {
         0.25514187079151496`, 0.9856438444846637}, {0.2572929301815122, 
         0.9682339660104169}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2577834164138249, 0.9642641520026941}, {
         0.2582241727746201, 0.9606968331672038}, {0.2620155571162226, 
         0.9386414392056601}, {0.2732265271043352, 0.8964359355232103}, {
         0.28751443070362864`, 0.8640489059772407}, {0.28857503622489383`, 
         0.862144376470638}, {0.28964765852484453`, 0.8602724757956924}, {
         0.2997910066543599, 0.8464321818767886}, {0.3106662152585816, 
         0.83437397702898}, {0.32338262648068544`, 0.8227563120243624}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.32633575555444777`, 0.8200583445164595}, {
         0.33365798877575487`, 0.8133687800501137}, {0.35871611878050225`, 
         0.7977882497720552}, {0.38498334123639505`, 0.7862689843827906}, {
         0.4172360677470077, 0.776706889961324}, {0.44846228140954736`, 
         0.770285102437768}, {0.4745230636945723, 0.7662391977038402}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4784817295338027, 0.7656699559916741}, {
         0.5030295409797231, 0.7628265822224032}, {0.5436067390776497, 
         0.7598282473097108}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9829529686038686, 1.066127023343949}, {
         0.9416079194730185, 1.0419227857778406`}, {0.9061812173633953, 
         1.0202077796935165`}, {0.8754585881477067, 1.0006183075916928`}, {
         0.8470711957721894, 0.9817207280578842}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8437415147895541, 0.9795041485862936}, {
         0.8351089968475435, 0.9737574532847952}, {0.8019046275327256, 
         0.9505394788533119}, {0.7973298856356141, 0.9472361439064784}, {
         0.7928840791821264, 0.9440034030107132}, {0.7778437089828132, 
         0.9327397953596849}, {0.7642076482588351, 0.9222974506838368}, {
         0.7394034938525237, 0.902894924865823}, {0.7189948358875016, 
         0.8861953021864848}, {0.7158410530257239, 0.8835038613881387}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7127984077986326, 0.8809072655354774}, {
         0.702051133542593, 0.8717355331520328}, {0.6684852125427372, 
         0.8410925058965986}, {0.6474949410093805, 0.8196503696178473}, {
         0.6339692411171751, 0.8042828924907773}, {0.622261025689945, 
         0.7890633104683153}, {0.6162287702191226, 0.7794086780641424}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.12835169672199997`, 1.0997365569693536`}, {
         0.12463566793127988`, 1.0708968971326382`}, {0.12123016048549674`, 
         1.0446098961774481`}, {0.1152268948227313, 0.9984612304741094}, {
         0.1101540143187867, 0.9593976019176966}, {0.10780427035775342`, 
         0.9410614396095431}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1072958357834891, 0.9370938844071933}, {
         0.10578845056316519`, 0.9253310453408397}, {0.10197120575427615`, 
         0.894833913080278}, {0.09598167297669544, 0.84454792150804}, {
         0.0916351627561736, 0.8034749986667999}, {0.08946676884833543, 
         0.7781053351034785}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.08912612318053184, 0.7741198664322922}, {
         0.08877826328678275, 0.7700499931312805}, {0.08693619086612026, 
         0.7201005889025985}, {0.08984414311978156, 0.6861134319890795}, {
         0.09596999889728698, 0.6675541919171172}, {0.10612321889157238`, 
         0.6562112674617375}, {0.12136822458821224`, 0.6515070241362623}, {
         0.1312832275919243, 0.6514920358717308}, {0.14238713249986704`, 
         0.6528268402530543}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.14630605185891393`, 0.6536162548529243}, {
         0.1696757658835067, 0.6586878014843041}, {0.17070033081415523`, 
         0.6589501248235018}, {0.17173394042679435`, 0.6592164017083172}, {
         0.1861122914051505, 0.6631295162864774}, {0.2020444311830054, 
         0.6675385175226344}, {0.23685401404960893`, 0.6770483218918488}, {
         0.2771334848230299, 0.6875644823075581}, {0.301245767386144, 
         0.6934248289838952}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3051326155417727, 0.6943695042800081}, {
         0.32155384371128465`, 0.6983605859900319}, {0.3645372194093349, 
         0.7081198722296281}, {0.4070035397452797, 0.7171813465484618}, {
         0.44703400598951604`, 0.7253401582893659}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5052010722686241, 1.116933877172449}, {
         0.5025920289104451, 1.06697960599527}, {0.5016477532161732, 
         1.0257927448035498`}, {0.5019795502161792, 0.9911782843522198}, {
         0.502110362305589, 0.9869526973780743}, {0.5022592359615605, 
         0.9828204564706061}, {0.5035927981003796, 0.9629872646735572}, {
         0.5041567839017382, 0.9570907762840426}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5045376367226166, 0.9531089486724014}, {
         0.5052947888917824, 0.9451929001409913}, {0.5093276877893709, 
         0.9131480742392779}, {0.5144022902587565, 0.8873371065060348}, {
         0.5201429753841679, 0.8663124521671123}, {0.5354090823541585, 
         0.8287810355380895}, {0.5506390830944543, 0.8053531157716223}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.7106059761736955}, {0.9839352280043314, 
         0.7120368649509203}, {0.9485180337974878, 0.7154531722876656}, {
         0.9037087412627721, 0.7201484615068716}, {0.8666811170578064, 
         0.7243858418215016}, {0.8614592422866546, 0.7250175112697876}, {
         0.856382121477566, 0.7256389055067602}, {0.8409185549539614, 
         0.7276297238112531}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8369518450571756, 0.7281446525676893}, {
         0.821104832480228, 0.730260165834368}, {0.790732512941745, 
         0.734441897164339}, {0.765826882593441, 0.7380847707967397}, {
         0.745121899565868, 0.7412567108882289}, {0.705362050585377, 
         0.7476450673815751}, {0.6790090387840654, 0.7520667414774058}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.01899811703922439, 0.10007495949805072`}, {
         0.028148452961481524`, 0.09951773944391724}, {0.034237308275592904`, 
         0.1002419308244472}, {0.041635184417744636`, 0.10173465892409499`}, {
         0.05070329720852861, 0.10414032830259355`}, {0.07581687725104964, 
         0.11230893442066743`}, {0.11105959845164942`, 
         0.12515816050979986`}, {0.1333213804468049, 0.133670300662198}, {
         0.1589954226799665, 0.14371419845535555`}, {0.17054818338615116`, 
         0.1483524052492016}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17426019223357572`, 0.14984270398322838`}, {
         0.18801379114494524`, 0.15536450414276923`}, {0.2203085518355521, 
         0.16869586797793587`}, {0.25538560156944706`, 
         0.18373797453199947`}, {0.2927508371642902, 0.20052050837610402`}, {
         0.3190858926205621, 0.21289268552749457`}, {0.32089588470342284`, 
         0.21378334904236326`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.32448488912074236`, 0.21554943151282177`}, {
         0.34582068653934117`, 0.2260483814813434}, {0.37263152967826535`, 
         0.23995882519703568`}, {0.39919473279495854`, 
         0.25459524563394925`}, {0.42717584658756214`, 0.2711256357707873}, {
         0.4541259820288265, 0.2883819785208391}, {0.4632972777927325, 
         0.29478791515681135`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.466576550513055, 0.2970784108293129}, {
         0.4797494286688117, 0.30627935963212655`}, {0.5037504760575778, 
         0.32473286485267155`}, {0.5068753491475005, 0.32725697674456866`}, {
         0.509966560901369, 0.32978927617388437`}, {0.5357514371727744, 
         0.3542811965069853}, {0.5584183871101109, 0.37909615145517495`}, {
         0.5794875123087146, 0.4038969829661969}, {0.5817868772347469, 
         0.40708389597234473`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5841273043334012, 0.41032772102864545`}, {
         0.5973609880298524, 0.42866956760288366`}, {0.6122459771542177, 
         0.4531800142070742}, {0.6243496425625039, 0.47719443162060776`}, {
         0.6413819702247658, 0.522959625059104}, {0.6481851633118207, 
         0.5552324974287567}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6493961751628574, 0.5647605718808387}, {
         0.6501937025426301, 0.5647605718808387}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.08608914861636521}, {0.9979203535156139, 
         0.08642878547585517}, {0.9736192264695165, 0.09125734001462489}, {
         0.9524127508008747, 0.09630498273355687}, {0.9200067597836957, 
         0.10602739043938618`}, {0.8939501455183266, 0.11652264763637929`}, {
         0.8554551630598723, 0.1399397111772144}, {0.8533488517737791, 
         0.1416308224352331}, {0.8520909133349467, 0.14267461771393672`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8492204334028938, 0.14545443693247295`}, {
         0.840576072809667, 0.15428774084355945`}, {0.8310509686225307, 
         0.1658196757182427}, {0.8139901432604898, 0.1900029011295975}, {
         0.8002231064659563, 0.2163733706680996}, {0.7886206508567639, 
         0.24478459795833665`}, {0.7789880165607768, 0.2730332625380573}, {
         0.7753635008389967, 0.285314978536381}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7742313152200779, 0.28915140339871226`}, {
         0.7702616436030306, 0.3026026843834279}, {0.7621582737780738, 
         0.33313947472004346`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.3966128875691216}, {0.9981680959262436, 
         0.39723773862957334`}, {0.9680695664025383, 0.4089723727012883}, {
         0.9259447223449149, 0.4280916736131485}, {0.891324109018966, 
         0.4468964046988363}, {0.8867210056576279, 0.4496771076105358}, {
         0.882240669327717, 0.4524489479255814}, {0.8673698794513708, 
         0.4626193993169022}, {0.8581570097932272, 0.46939857826107273`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8549352421213549, 0.4717692771176293}, {
         0.8537435105201816, 0.47264619843287176`}, {0.8286683965348102, 
         0.49237581691527194`}, {0.8074545707287799, 0.5114199257741043}, {
         0.7892558425909064, 0.529709672473314}, {0.7666420384728039, 
         0.5548886369580337}, {0.7479983945396065, 0.5782246136278094}, {
         0.7430441707633318, 0.5852450877371173}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7361556427916001, 0.6127279533941394}, {
         0.7236500010308828, 0.6127279533941394}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.05330967205771148, 0.42943507624054467`}, {
         0.06387968972183558, 0.43479196722666064`}, {0.07768896786115957, 
         0.44541365019885787`}, {0.08603879314510535, 0.45273649706980884`}, {
         0.09551867539665797, 0.46137776569755573`}, {0.12387754930754905`, 
         0.48724004122114223`}, {0.12497385560294298`, 
         0.48823138707632535`}, {0.12608042695290728`, 
         0.48922979713012926`}, {0.1374539624105291, 0.4992027256867116}, {
         0.14984443506545578`, 0.5097154124841522}, {0.17626732998864184`, 
         0.531223068526749}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.179458390072113, 0.5336343360327239}, {
         0.20746846231984262`, 0.5545777594759258}, {0.24205593111122606`, 
         0.5781069104125673}, {0.2653739936581703, 0.5928025563648227}, {
         0.2893529726420306, 0.6070755541637296}, {0.31352225657744553`, 
         0.6206613680428751}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.31704923572259036`, 0.6225479858522222}, {
         0.3392936799204993, 0.6343536053014981}, {0.3803797424347574, 
         0.65490305242078}, {0.41960146916650287`, 0.6732192616039545}, {
         0.45574785610660834`, 0.6892386738804444}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7017503972376079, 1.15}, {0.6999529364294769, 
         1.1454859185667885`}, {0.689723927923302, 1.119603670522409}, {
         0.6803727649365703, 1.0957395780778256`}, {0.664303975521437, 
         1.0540658599880475`}, {0.662128107907421, 1.0483442466395492`}, {
         0.6600160172456446, 1.0427661502297414`}, {0.6529805724277736, 
         1.02379270515773}, {0.6466468137210407, 1.0063890464399259`}, {
         0.6445751551452954, 1.0005733866023576`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6432328915955987, 0.9968053196492428}, {
         0.6352383656848708, 0.9743627010615288}, {0.6260936420044405, 
         0.9473320629862196}, {0.6187667934273994, 0.9243140575029357}, {
         0.6054008693519867, 0.8762918598138808}, {0.598838985860968, 
         0.8438503234098834}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.9569401319954143, 0.866110194927656}, {
         0.9147693488160203, 0.8582042292995035}, {0.9074802259878505, 
         0.8567609488061726}, {0.9004238325468841, 0.8553423230632903}, {
         0.8813966779919065, 0.8513056413299771}, {0.8639569773524859, 
         0.8474642385997099}, {0.8318753003961039, 0.8401470498426823}, {
         0.8048070173205458, 0.8335193587326089}, {0.8005644722052686, 
         0.8324127517065613}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7966939710584493, 0.831403187012017}, {
         0.7817447114755659, 0.8275038871250089}, {0.7330264301678064, 
         0.8135481790844327}, {0.6999586108275305, 0.8027123736481585}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.2636715182681604, 0.012838348327852545`}, {
         0.29154937270445247`, 0.013828027356692661`}, {0.32076651498565856`, 
         0.014915409294278389`}, {0.350716908170889, 0.016119854975308077`}, {
         0.38079451531925435`, 0.017460725234480078`}, {0.4109993364307546, 
         0.01893802007179439}, {0.4235258269478366, 0.019604452142877298`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4275201780696744, 0.019816958885059292`}, {
         0.44133137150538976`, 0.02055173948725102}, {0.4808454438611824, 
         0.022943952815981314`}, {0.5185728331127561, 
         0.025648733946615692`}, {0.5539687372339877, 0.0287024971642521}, {
         0.5864883541987532, 0.03214165675398846}, {0.5870141094732885, 
         0.03221074163571727}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5909800177627667, 0.03273186680249401}, {
         0.6159268480983133, 0.03600991061244633}, {0.6420793830239282, 
         0.04035095663624725}, {0.6649812719572412, 0.045199635970228476`}, {
         0.6847636784778955, 0.05061593698891621}, {0.7127210933345257, 
         0.061713770776465296`}, {0.7330470402620783, 0.07505557749488874}, {
         0.7341865259190146, 0.07603713951660454}, {0.7352980724847296, 
         0.07703033646821623}, {0.7395515395555783, 0.08261583737803192}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7419749363391809, 0.08579815540570053}, {
         0.7438935351558281, 0.08831759078804993}, {0.7504874380750145, 
         0.10100133115207027`}, {0.7601198399636881, 0.12927435378121632`}, {
         0.7637369776527229, 0.16353769513345787`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.5611907255785027}, {0.9746128945977421, 
         0.5678404402138888}, {0.934185570753902, 0.5799838617801297}, {
         0.9276197609072492, 0.5821246534309937}, {0.9212536066998483, 
         0.5842465799735957}, {0.9030872180132321, 0.5908189682677232}, {
         0.8864288664252549, 0.5972028953492724}, {0.8557596300944315, 
         0.6095911006970275}, {0.8487403023523697, 0.612739449423592}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8450906054590928, 0.6143764321929591}, {
         0.8298127169190587, 0.6212289574912699}, {0.807602344156069, 
         0.6321359270454885}, {0.7812364339706386, 0.6461957263847279}, {
         0.7594872405809414, 0.6589405199613318}, {0.7260397587852065, 
         0.6808160975273322}, {0.706991560271833, 0.6945056797980877}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7034132990906293, 0.6982019318777957}, {
         0.701848456415395, 0.6982019318777957}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.374989436415749, 1.1061404912673853`}, {
         0.3768413553091181, 1.0606973128320316`}, {0.37720934471825257`, 
         1.0549006966364398`}, {0.37760193364639544`, 1.049240951832648}, {
         0.3796748032140916, 1.028423554197205}, {0.38207578330674846`, 
         1.009361462956036}, {0.38747661576399256`, 0.9743491202511569}, {
         0.3933902669905092, 0.9475150394055032}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3943426259880086, 0.9436323256318533}, {
         0.40131913792935775`, 0.919992629557781}, {0.41226006191384756`, 
         0.8917002677576702}, {0.42414141251934595`, 0.868775650685869}, {
         0.4494197139144713, 0.8348679081483819}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.2590730787759761}, {0.9790483133014964, 
         0.2667598995680239}, {0.9386011075235163, 0.28462859864195206`}, {
         0.9055587096612132, 0.3028898593327646}, {0.9012205499936717, 
         0.3056189588122929}, {0.89700080884315, 0.3083549253736913}, {
         0.8830909326643732, 0.31861593203050254`}, {0.8703608533497956, 
         0.32894744063751813`}, {0.8614761884073651, 0.33682979374330496`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8584840228550327, 0.33948440205856273`}, {
         0.8469625436648818, 0.349706100666918}, {0.8272045900998013, 
         0.37059776736213573`}, {0.8102581039235078, 0.3915045442079803}, {
         0.789678491941416, 0.420862025427777}, {0.7725237948629844, 
         0.44967861000642695`}, {0.7635140252595592, 0.46701988488128743`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7608314306857937, 0.47605454613321646`}, {
         0.7588200095708466, 0.47605454613321646`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8451888825803586, 1.1445606996622684`}, {
         0.8282481703693213, 1.1235137634052148`}, {0.8128534568422355, 
         1.1041509095421171`}, {0.8072844746419716, 1.0970968750584533`}, {
         0.8018902598985482, 1.0902364890800227`}, {0.7809443879426942, 
         1.063073511758286}, {0.7624805413481245, 1.0387317216399026`}, {
         0.7470417130975981, 1.0182138973008814`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.7446420189462217, 1.0150136991138758`}, {
         0.7297789148905146, 0.9948796426818826}, {0.7043780482143797, 
         0.9594585782462097}, {0.6843670018054493, 0.9304057449782022}, {
         0.6683152815688724, 0.9061358673663222}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17276419978054836`, 1.1278267468481484`}, {
         0.1700058291472524, 1.095118654176696}, {0.1676622438680434, 
         1.0652630433497603`}, {0.1657334439429215, 1.0382599143673417`}, {
         0.1642194293718866, 1.0141092672294398`}, {0.16281023284141108`, 
         0.9867866451223386}, {0.16210487231844772`, 0.9682005978501395}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.16195317721063993`, 0.9642034753108285}, {
         0.1618677447547033, 0.9619523546244209}, {0.1613828939125911, 
         0.9197487684561358}, {0.16260076298489018`, 0.8854695423430752}, {
         0.16535723811094072`, 0.8570857099037296}, {0.16960725228677004`, 
         0.8337638516968809}, {0.17530110438479332`, 0.8143078621391324}, {
         0.1796295629651548, 0.8067095692990953}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.1816094883603636, 0.8032339549031349}, {
         0.19515290708205593`, 0.7794594726961076}, {0.19596964428445493`, 
         0.7785484083646328}, {0.19679645522749853`, 0.7776520657563345}, {
         0.2094665529910838, 0.768261341627302}, {0.22393106816758818`, 
         0.760760912610554}, {0.25626210846407865`, 0.7490298600161449}, {
         0.2948278245200176, 0.7428772877704425}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.05141463214879372, 0.6160184954449875}, {
         0.051242756872518586`, 0.5978755008587474}, {0.05191644654178457, 
         0.5822637549411059}, {0.05405272885029531, 0.5662772061225178}, {
         0.054150032258117375`, 0.5658073607564739}, {0.05424914618970042, 
         0.565342333494283}, {0.05434030476055116, 0.5649345815446587}, {
         0.054432927113142876`, 0.5645306936238096}, {0.05457425086942876, 
         0.5639311515266173}, {0.05467019031388268, 0.563535978676578}, {
         0.054767614480903774`, 0.563144688967436}, {0.055825729869056644`, 
         0.559447517266074}, {0.05704071463785319, 0.5561465725548054}, {
         0.05842111251601653, 0.5532492937968968}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.02494173905188447, 0.15424262460129054`}, {
         0.044226550774751246`, 0.15772743117301977`}, {0.07837090976152511, 
         0.17329008195203033`}, {0.11131087947608324`, 
         0.19108021960409297`}, {0.1553278312587171, 0.21585820483964543`}, {
         0.16828090779498972`, 0.22328323965789162`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.17175119084859858`, 0.22527249467619248`}, {
         0.18170778523172215`, 0.23097986927239944`}, {0.21093354983265453`, 
         0.24793295396923284`}, {0.2427666411162309, 0.26667586182676617`}, {
         0.2766800168764298, 0.28710530674254753`}, {0.30092602310321265`, 
         0.3021060424392366}, {0.3091081244145789, 0.3073029432039815}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.3124846178817935, 0.30944753917195705`}, {
         0.32559915301314046`, 0.3177772988583463}, {0.35122493742842914`, 
         0.3345831854783895}, {0.3766916336044105, 0.3519330348911973}, {
         0.4016952142667898, 0.36972153029941446`}, {0.42593165214127243`, 
         0.38784335490568594`}, {0.4291455975673564, 0.39030755375907417`}, {
         0.43234032357614727`, 0.39277562276766415`}, {0.44298085217637495`, 
         0.40182571296908226`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.44602781220651155`, 0.40441724428757914`}, {
         0.4648310630288409, 0.4204099757030399}, {0.4941042588360963, 
         0.44785735967548107`}, {0.5215455644417926, 0.4749573290559512}, {
         0.5453230896443707, 0.5013624692524795}, {0.5584418542590468, 
         0.5178715175531459}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5609303875788676, 0.5210031627942519}, {
         0.5655277017605268, 0.5267885613517839}, {0.5822502681069569, 
         0.5509513864405822}, {0.6065316087493356, 0.5948076601053199}, {
         0.6198613815703716, 0.6277452220287271}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.18614224801851986`, 0.094882830532188}, {
         0.2185368589286831, 0.1034320659340871}, {0.25400095279168955`, 
         0.113229180585694}, {0.29188230394396397`, 0.1243435029671752}, {
         0.3315286867219309, 0.1368443615586971}, {0.3397120524180092, 
         0.1396628539264469}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.34349402234422416`, 0.14096542963526612`}, {
         0.37198146698713985`, 0.15077699718396204`}, {0.41228201060114017`, 
         0.16618665066667243`}, {0.4516780377525343, 0.18308307569610374`}, {
         0.48898972026131765`, 0.20146279615799603`}, {0.4909609007833628, 
         0.20257768777342117`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4944425874769795, 0.2045469154818115}, {
         0.5159561623898912, 0.2167149051813754}, {0.5408006458261052, 
         0.2327503649607188}, {0.5635231705699598, 0.24956917549602628`}, {
         0.5841237366214548, 0.26717133678729776`}, {0.5867577652285679, 
         0.26959699098630097`}, {0.5893494730224436, 0.2720346556745391}, {
         0.6089610033006692, 0.2947100082729726}, {0.6166291068247967, 
         0.30548983723722023`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.6189476934205562, 0.3087493090039279}, {
         0.6255794743714838, 0.318072274474388}, {0.640767979603286, 
         0.341637017445162}, {0.6530965531570639, 0.3656067139546532}, {
         0.6628559238981343, 0.38977578497927573`}, {0.6703368206918143, 
         0.41393865149544384`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.03950358899519504, 0.3380617615180037}, {
         0.03987704640675966, 0.3380617615180037}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.044152073752100965`, 1.15}, {0.03950266518923369, 
         1.1214550967249213`}, {0.03855190648816394, 1.1155786875678901`}, {
         0.037620565676155834`, 1.109791779954941}, {0.03150366837151155, 
         1.0694796675191172`}, {0.026315087424241188`, 1.0324953110926567`}, {
         0.02154727084470686, 0.9967011948006264}, {0.02095974620093789, 
         0.9917012214463479}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.02049293568867162, 0.9877285538355808}, {
         0.017620983000644602`, 0.9632875587774565}, {0.014418586436585761`, 
         0.9317897183224562}, {0.011822443697061683`, 0.9017429887349347}, {
         0.009733469163120312, 0.8729299033374176}, {0.008052577215809589, 
         0.8451329954524305}, {0.007203622061005879, 0.8283188570491964}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.00700191678653314, 0.8243239459134826}, {
         0.0066845265184238365`, 0.8180378142307516}, {0.005552909464599002, 
         0.7916779130437764}, {0.004657726054335086, 0.7660532918915052}, {
         0.003998976287632089, 0.7411639507739376}, {0.003065967274452657, 
         0.6935502261526748}, {0.0026510288479133777`, 0.6643926726011978}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.002594110983965627, 0.6603930775771031}, {
         0.0024290720146045125`, 0.6487958566897488}, {0.0019987620767072368`,
          0.6068278109309604}, {0.0016855090293804108`, 0.56757305742211}, {
         0.0014731324378007395`, 0.5317159420291802}, {0.0013366891193796512`,
          0.5003986338496881}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.0013215733211210461`, 0.4963986633093383}, {
         0.0012321044274310193`, 0.46658926194625644`}, {
         0.0011653693313239024`, 0.4288197218324168}, {0.0011508317848640585`,
          0.39395123060223913`}, {0.0011884917880514874`, 
         0.3619837882557234}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.9661325552496611}, {0.9867834560374595, 
         0.9617465239982669}, {0.9766339553175291, 0.9582269809447677}, {
         0.966855239370562, 0.9547848268644947}, {0.9347520742083761, 
         0.9427883662334902}, {0.90631883871324, 0.9316887410031739}, {
         0.8794276735960038, 0.9209915693753699}, {0.8556206492345672, 
         0.9110993049525901}, {0.8506335113246747, 0.9089015487378367}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8469731759038991, 0.9072884943037224}, {
         0.8155371413732329, 0.8934351095557433}, {0.7832330740575862, 
         0.8781774216058038}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{1., 0.1696812679274571}, {0.9721188483594455, 
         0.17815638954408425`}, {0.9662354284100672, 0.180205024113249}, {
         0.9605420348198638, 0.1822686928437881}, {0.9436928882563829, 
         0.18945050990012674`}, {0.9283855301166857, 0.19680304344818197`}, {
         0.9004600857678328, 0.21183483428118136`}, {0.8772741665064518, 
         0.22750460164694533`}, {0.8591561159669201, 0.24259199930278044`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.8523410557344177, 0.26277754773705714`}, {
         0.8392211739435379, 0.26277754773705714`}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.06681416800635609, 0.3279991823444832}, {
         0.08822779294881922, 0.3461361290448017}, {0.11661935502481355`, 
         0.3715175432581938}, {0.153225359131132, 0.40376427537700643`}, {
         0.17481935247278438`, 0.42218300583748897`}, {0.18768397184399394`, 
         0.43281430817446004`}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.19076734710773505`, 0.435362404911821}, {
         0.19858146696762877`, 0.441819981955552}, {0.23114028846986845`, 
         0.4676935906183691}, {0.26629354750881623`, 0.49444440398075773`}, {
         0.26873918351196896`, 0.49626677313211365`}, {0.27119282280012946`, 
         0.4980900705514647}, {0.2958951167840651, 0.5157647083231968}, {
         0.31853102667880456`, 0.5315914260041251}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.32181193583346135`, 0.5338795611878654}, {
         0.34555568991581764`, 0.5503051733835722}, {0.3698317333440676, 
         0.5668417283147864}, {0.4030959128448983, 0.5896158425689166}, {
         0.4343887801797756, 0.6109121190988671}, {0.45387523463968865`, 
         0.6242072906597924}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.4571794372848384, 0.6264616741408766}, {
         0.4631924037682543, 0.6305641865374527}, {0.4889888520298891, 
         0.6484056735174886}, {0.511675180611608, 0.6644297577589617}, {
         0.5311484451603388, 0.678629616981859}}]}}, 
      {GrayLevel[0.85], Thickness[Large], 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5961383753386282, 1.1404470508288487`}, {
         0.587461885925255, 1.094204934615944}, {0.5862461804461919, 
         1.0874744069238134`}, {0.585076897883857, 1.0809205237750283`}, {
         0.5815739063418067, 1.0601178323748277`}, {0.5785169589249315, 
         1.040994650763794}, {0.5732102747293191, 1.0057276793284309`}, {
         0.5702303579885896, 0.9825901963486107}}]}, 
       {Arrowheads[0.035], 
        ArrowBox[{{0.5697194112088151, 0.9786229638890441}, {
         0.5693587399138391, 0.9758225413689261}, {0.5666805081495431, 
         0.9502409949951799}, {0.5644331994473669, 0.9204327661572567}, {
         0.563607521579093, 0.895973739130686}}]}}}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], LineBox[CompressedData["
1:eJwt1gk0VV0bB/BIb9KARmODCpUkQ4bkLxSFVGhUZKiPBkPoTcqQpDI0qAjV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         "]]},
       Annotation[#, "Charting`Private`Tag$153599#1"]& ], 
      TagBox[
       {GrayLevel[0], Thickness[0.01], Opacity[1.], Dashing[0.03], 
        LineBox[CompressedData["
1:eJxF0Hk01Qu0B3Aq0URcKUIplBIahErfkjIn4kaZQgplSEmqG8KVTEXGk5Ap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         "]]},
       Annotation[#, "Charting`Private`Tag$153599#2"]& ]}, {}}, {{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
        0.3]], LineBox[CompressedData["
1:eJwt1nk0VV0UAHBlKCJEhCIUvlBCJWRHUpqRKTSITEkokoxJJBpUKEmEJFTG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         "]]},
       Annotation[#, "Charting`Private`Tag$155026#1"]& ]}, {}}},
   AspectRatio->1,
   DisplayFunction->Identity,
   Frame->True,
   FrameLabel->{
     FormBox["\"A\"", TraditionalForm], 
     FormBox["\"H\"", TraditionalForm]},
   FrameStyle->Directive[FontFamily -> "Arial", 18],
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   Method->{
    "VectorLengthFunction" -> 
     Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
       System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
       System`VectorPlotsDump`imin = If[
          NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
          Min[System`VectorPlotsDump`m], 
          Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
          NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
          Max[System`VectorPlotsDump`m], 
          Max[System`VectorPlotsDump`m]]; Map[If[
          
          Or[# > System`VectorPlotsDump`imax, # < 
           System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
         System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "TransparentPolygonMesh" -> True},
   PlotRange->{{0, 1}, {0, 1.15}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.02]}},
   Ticks->{Automatic, Automatic}],
  DynamicModuleValues:>{}]], "Output",
 CellChangeTimes->{{3.9031004779895782`*^9, 3.903100598056485*^9}, 
   3.903128874400895*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"f08c6be1-3fc0-47f3-9266-0b54b96df999"]
}, Open  ]],

Cell["Figure 4b", "Text",
 CellChangeTimes->{{3.9030994036824417`*^9, 3.9030994085067177`*^9}, 
   3.903099646369244*^9, {3.903100008099217*^9, 
   3.903100012913866*^9}},ExpressionUUID->"00956225-4ef7-416e-a26c-\
b1d48a506390"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A0", "=", "0.8`"}], ",", 
      RowBox[{"R", "=", "1.4`"}], ",", 
      RowBox[{"g", "=", "2"}], ",", 
      RowBox[{"k", "=", "5"}], ",", 
      RowBox[{"m", "=", "0.03`"}], ",", 
      RowBox[{"a0", "=", "0.029`"}], ",", 
      RowBox[{"h0", "=", "0.434`"}], ",", 
      RowBox[{"r", "=", "8"}], ",", 
      RowBox[{"s", "=", "6"}], ",", 
      RowBox[{"\[Gamma]", "=", "0.8`"}], ",", 
      RowBox[{"tmax", "=", "500"}], ",", 
      RowBox[{"rc", "=", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"sol", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"A", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Gamma]", "*", 
            RowBox[{"A", "[", "t", "]"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"A", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"A0", "*", 
                 RowBox[{"E", "^", 
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"R", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "/", "rc"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}]}], ")"}]}]}]}], 
                ")"}]}]}], ")"}]}], "-", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g", "*", 
              RowBox[{"A", "[", "t", "]"}], "*", 
              RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"g", "*", "s", "*", 
               RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"H", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"r", "*", 
               RowBox[{"A", "[", "t", "]"}], "*", 
               RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"g", "*", "s", "*", 
                RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"H", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "A0"}], ")"}], "*", "k"}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{"(", 
            RowBox[{"m", "*", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"A", "[", "0", "]"}], "\[Equal]", "a0"}], ",", 
         RowBox[{
          RowBox[{"H", "[", "0", "]"}], "\[Equal]", "h0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A", "[", "t", "]"}], ",", 
         RowBox[{"H", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", "0.0001"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A0", "=", ".8"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A0", "-", 
          RowBox[{"A", "[", "t", "]"}]}], ",", 
         RowBox[{"H", "[", "t", "]"}], ",", 
         RowBox[{"A", "[", "t", "]"}]}], "}"}], "/.", "%"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "500"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ColorData", "[", 
         RowBox[{"97", ",", "2"}], "]"}], ",", "Black", ",", 
        RowBox[{"ColorData", "[", 
         RowBox[{"97", ",", "3"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "->", "\"\<Arial\>\""}], ",", "18"}], "]"}]}], 
     ",", 
     RowBox[{"AspectRatio", "->", "1"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9030994785753937`*^9, 3.903099556013023*^9}, {
  3.903099992202388*^9, 3.903100022064966*^9}, {3.903100057239543*^9, 
  3.903100059519334*^9}, {3.9031001639009113`*^9, 3.9031001905101423`*^9}, {
  3.903128067842944*^9, 3.90312807007161*^9}, {3.915152733906328*^9, 
  3.9151527364586763`*^9}, {3.915152776085334*^9, 3.9151527766088142`*^9}},
 CellLabel->
  "In[209]:=",ExpressionUUID->"ab372b30-513d-4798-98dd-5f8b92120870"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwc23c8lV8cB3D7J0olMirJikKy9/ma2Xvvce1N9h5ZEYlKUSqptAiFJBUZ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       "]]},
     Annotation[#, "Charting`Private`Tag$55418875#1"]& ], 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwcWnc8le/7F1KZUYjQoKIkGUnJdRnZOwlZ51jZ45wjUUpJlJCUzDSMSksl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       "]]},
     Annotation[#, "Charting`Private`Tag$55418875#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwklXc8F973x+1USkZIkll29qjce+yRvfd8v42GzUcI2VQyQwiZlexNKBSy
KklSZJWMyI7y7ff4/XUf53HuOef5OucOTgd3AyIZCQnJfwdJSP5vXfi1p6Xq
NItmKBYEzlVlY6/C6xLKeR14QR2fMRJ6gP0PLzmdyHuHt5uak5IfPsCBrUUk
FHnTWGVmauX1zRw8NoaKcex3fOLaRuT2fA4+vzWiHei5hL0+Pp40PJOL/6SF
a+/kruFbY9fK9kJysVDRIAfz8U28K2Xt/qM4F1vVnFyXjN3GJ9m/iBv25eLb
L5xfGfz5jW+iJTXqpVzcMlR938PzD87j/NEwfjAPL37ZvxY/u4+pyr3TCrny
cPxmIceIECnEeDxVPy+Th4v+XDo060QGpcUeb3zU8nArxa+1tVxyKE76xilu
mIdHDqd/JvtEAf0bNHYGFnl4mR69ojtOBSrLkaKNVnmYinWmgkP3AJTyqv/R
/udn54y7fy6WGqjvBsjtGeRhaT7RCNRxEGLaf+dVq+ZhnXMj17T/HILhlsXr
LlJ52Ek6yNRKhgZ6vOpeMJzOwzfkuRSueB4Be98Ot2ryPJyi3C0Q8OQolPi7
xGtO5+LSS26MsbO0gMTk/L4+y8UO/If2X989Blbh7F8ik3PxstBn73dCdEC6
5LetScjFAaIV38d66GDvYkyohmguppIMt55yogetC3Qh+GcOZr/Ar7aaywCz
v7dUh1Yf4Mdor3lbnhG6e1/+R3B6gKUVB0VJPjGC15qjzYF32VhHw5eV9jgT
yD54MqRxLwsHmz5fEoplgfLz1POO7zLwIcsUB8kzJ8CcVcXxBVMGvmfj/OFC
xwl4y0Ah8sAkHZcRjzzX/MMK6206FlcG7uHP3uYpLp6noMo15mlvRTJ2+U/o
oMdRdti0VvnP4UcSXg/Yv/HfE3YYaOXwyeBNwjRhhc5Rs6dBzPoMPWd+Au5T
vLisqsABFpRd3Ot9d3FSZ2FJ710OoI1z8SCzjMfs3f6n3gpxAv3AQIx3wi08
ozH1wTiQEzaP7/PJy8Xhx68vJX3s4YSPlJ6V5xZjsPQg+4GvTlwgxrH53sIr
Cu/pxTwn1HJB5J9Sf6waiV+8XQ38Ts4NyUE/w4p4I7DOSOfKz1xuCLV/Ge1y
IAyHTFibH93khtL/3Lf31kNxxffN50KXeODDg1OvDCZDMN0uX7LrBg+QSD74
/J0tCCtSvNiN1uSFiVi9e3v2AdjriCWhKIcXmLXdzm61+ePh03ekpjXOgPm7
ynjVDl9MyX/mAWnOGXD/Q2rV4+SDpcXbqDjWz8D1+J3he6e9sdMFM3ekcRaK
bU8KVC164jTl1Q9WD86CUF+qM1u/B+7WjoPAtbOgaHr1dFmIO9424X6Uoc4H
I8w/H/VFX8MWrsYBI7/4oJKbosR02xXf8lqeWlfjh/vx1HxHrV1wS2D0JYZs
ftgUdbOk+uyEFyM4asR+8QNfuhT/XT8iPhXfyKanJgDWzUneh/gIWCfNINIt
SwCiL8nWL/10wMG5C0u3VwXAPSne/EWfPZ6sOtXWkykI91ivtyWG2GK6lrqz
31cEYfPEk9eTRdZYsUs3gUpVCMTmvhO/LVli74Hv2zyZQhDAR0t23cACF3y4
aa+0IgSUC14at9+a4feTrL32KsKQTe9yX+6qKab6US0eel8Y8lMu+jSeMsHO
e7Pkz5RFICmyvejRc0OcThly9VOGCDjFC/xlqzTA3UdZ3u8si8CzptO5xCp9
vMNcKc+ifA6Ykz7YKXfqYQFOzSLpjHPwgYtXlfO1LrYUmD5qvHwOfmcmdl0T
0MEvT7Q2N3KKAknjSo5bgRbe4jLlGfUThbhv6+zKXzVwQnG+mXOeKOx6zOq9
ylXHfEIrtzdfi8Iik5CZqY8abq+4+DxyUxQcbdtDUyxUsZlU7AYjpxi8Fr6U
KWugglca3/MXXBKDwU+r3MctlHEs4rKR8BODuHPRMXSeSrhJrfml/msx8BGv
6r3SrYAN+g7sTm6IQZvua51tKgW8oGd0zoNDHPZrYrX29QBHvM913NcUB+sJ
+Q8hlzBms1hKi/cVh06HZJOjBxGu+SLXdypXHKxIHWqtP17EWo5RJE97xeFC
VZGGXPMFfOPqadfXpyXA4+aBOyLlcphp9Uq2haYE+Jw+rqLaJovLfBvezPtI
gMwrH+vpcRn8JVj/PHWvBJScJ40iyEtjP/IHbmnrElCTWKHYHSyFaWN+PDxz
WhLs2OMyy3olMSSGH1bxkYQ6jq9Hb4dI4FdfmBBZliQsH6RjkFoVxzpCjz3a
OiSBXdlXkumyOLZ+NfRejkEKdD6HOf92F8MzjATqrfNScLE7PU5jTxRfddg6
X+MgBRLLmqdd4kVxwJ9TuSJVUiCnvsHcH3kOk16qfLvwUQp6B8fW/XpEcEy6
MuUjUmkoKAv+lMQkgtMkrlzm1pcGUuedOZ3XQpj95t+sSX9pqPlevcAsLoSL
BhIHs3OlYbyrYzg/VxDXuDZIsqxIgwx+xZ6ZLIAv1F9yfs8sAzy7fkW2zAL4
BcVERhKWAaaPVTXpefz4TQ7lPs1dGQjKjAO9bj5stpQu1lsnA/sa8kRtAh+e
PC9EiP4iA/5lt740U/Lh5fcGPaQisiDhtXic0ews9uWe2201lgXXHtbFDOqz
eM/jukjQDVnYfqz7rfvZGRzRSmMvVygL9w3v1vn9dwYfpslN3uz75/9O2Rco
dQYnmUu8rF6XBTI6MtnqLV7MWvxy24NNDpyd70X9fsaL+RSXrBeuyIGQUP6j
8ya8uPxuaEJJshwQH99a2jnLi6U/M3QQm+Ug/q1Iq/EfHtwqULzBNS0H1P1u
dtIjPFjF/zzf5KHzsLdbthFZxYP7uvotssXPA2XHjLNoEg82YrC/Y2FxHoqG
FUy5fXnwJ7v1Nuaw83BD0v6gjiUPdiiL/jX86Dy8J50yz1PmwfO7rLxJb87D
tS9WpbRiPNhDo8xUd+c8uF95OHGbgwdv31OIo+G8AO+/iCseZeDBITPDLT3q
F0Ds7GR0HDUPphJ3+RnlcQFYrt1p3yHhwfEhu5zK6Rfg8EESPeM9bny8P96I
tP0ChMvWz6X95sZZrFzRrd8uQAnZ88Bnu9yY26W2MZD2IpT2h6t17HPjx7Xq
i7IyF0FAzLetmIoHi5OPs2/aXIQHMfVJl4/x4EY9d/3qqIvg3pJeTHOKB8MD
sgiPsosgn7V0IkGIB3cvpNYJj1yEa+Sq57cRD9aV45//8eci8I9u3tEw4sEj
US0nS3jl4WLX1mDsVR5sM6yrQ9SWhx8Wyb/aonnwLOd0KJevPMQenOdcL+TB
V939qiey5KFMSOHVuVc8eL3l4FxWpzwYckjeubHAgwMPZbNYLMpDD0sRYZ6e
F5OZiV5iZkTgI3U/LlSeF9OtmVQkOiKwu5VjeTWLF7NbcxpFxyEQ0TS9+naQ
Fwu9WtgKqkQweuvL23CqM1g9MxS77CN4lEK5cjz4DDahvDRtfQZDqVXyW462
M9jR/Xi0oTaG7idd11+Tn8XBSo8HUCaGu57cC4T0s/j2Ux8vyRcYpCUTeeK+
n8UZzJhJYB5DyuXt0y0X+fDYxnxZ3EkANu0nii9X+fBXgcFQynMA5D0Gh6cN
+PF32xqDUEUADfMmknsN/HizJ3jT1xXg59x9GpskAfznr2P3ShDAYtfQ9W4q
QUwhqXH/SgIAiZD7uneoIKZ7wIDs6wHAQcDEMEIIs7zbph3vBVi5bhuyclQY
s1N/+WryBUDNaiUgL0cYC3mVRGpRKkDVn3cEsWERLFF8x/QViwJwZdYlJPqf
w+fHvfgVhRRAwLdXmIJeFKuryvfLGCrAuzqD8MpuUezI+paRO08BqgmcO07O
4viybv1cdo0CvOL7bOY0Jo49IrIaWLoVgJ9m/rG+gQQOXnayOvpTARTbq371
6kviSG4tkVgyRbjzLTlr8KMkvm0mRkLBpAgpB6xXnzpL4fsvdvN3LipCVUJd
AfU9aZy3Nenro6cI5aKksUwyMrhE6KXaT0dF+CusE8M5IYNr7yUszMQpgl6p
89QNFTk8dJlXYmhUEdhDiyUCfS/iDzmHKC8tKgKZ6RWbMDN5/GX450jXviIw
XY8LLFBBeBE1BTSfUYIroSrarByA17xztKTPK4HXJmuRWTHg3yUR7JXaSlCR
w3SrWlIBH2DQfVHkowRTPCWNWw6K+Ki6ZApnjBIMBWTTxVAoYcYbJ5yyMpWg
zaM/PvypEub6Nn0w6YUS8EhKBCFmFczP1vOJZkQJNvKdgvtGVbCoftnT6Hkl
wFq3iI75qhg1++vfOKYMNl3H7OKM1THH2/mBB7zK4Jn0WlvPQAOTzltotZ9X
hiOrJRKcVpq4k0lejZyoDGupAYYTGVq4SLiskydAGXT+E7zkPKiNo5VPK6re
VQZ6s2Q+seO6WNOLVD62URlm9d6vF//Qw0KxXk2PB5RBK17s3EiJPj6SOy3T
N60MmOv+B2FPAzzU3yVOe1QFvps/s2/hMsJVM9IVotwqIOpPdebiEWOcvFss
bCCrAgMd75T8KUywCX8cX6qDCjBMZ/MKsplhWdgtrPtPBSTa/lgoInN8wvQq
9+htFfiELl4w87DA4xE67CfrVUCG21HSkNoat2a2ZV7sU4GxzDsqah42OKdK
9ITNVxVQi0yrMV+0xQ6T9Ix5h1WBRraj7UOSPVbeCk98waEK44GDqi+9HDDv
0Y2jM1Kq4PAntdXG1hF/v/Dh4Fk7VSgyez2SYU/EvQbq0eq+qhAx1lE84e+E
S10bKS7HqQJFMfNB5lxn7J6WuV9aowrlY/YXRbguY70ymhsDParA0VvtdzLk
ChbvuvH75xdV2JYO9WdauYo3f9luiB9Ug4PZ8pzBBz3w6ME3XkbsaiA41xHY
NO2BGzkUV3wl1MCcxdvxdq8nDtLhWWiwVoM2u/HHM+3e2IaY6jLmpQYZlo9X
/rzxwTiIam43Wg3ak23wu1++mOzx90lUpQaTwLWs5eyPZ9rNbexeqcGIAevC
WMt13PWh99PNcTWYnx8t2OYNxDGUT0c6qdThYkLeqrRMML7Mxm40d1Id8pbi
z+R8DcGXJO6+OSCmDtwcGyIMb0PxUXvPPk1LddCwVX6q3xyGV/6b0rjqoQ4u
LyYkcjrD8Zt4w1d3ItXBLvkyU954BE5pkXoxVK4O20IeN3MvRGO/d0X4V6c6
pOu9N2WJiMGmP5ifMYypw95eJJXsl1jMyvK73oRCA9Qg/kFU7228J3JFyv+E
BrA2K3Op2MTjzyrjVRkiGqB0wUSdQJ6Ac71bn46bacDaKZLk+32JeGfZQCD1
qgbYdvoP3a5MwgaXvxVph2pADEua6XBuMqawP5bbWqwB/ddtOEJyUrH1eAHb
f80aQFNo1UYsv4frTOUyzg1qwOdnH8uLetOwi45DUu6mBsi4sXbvcd/Hz3s2
j5of0gT7ey/a7BwyMavKrVt07Jrg1ix5t6k0C/ddqIkIU9GEYPM0phBiDhbl
p/qPkKIJiZGb7yerHuLYgvtrbCWa0PaU86vqzXw8dfqcx/tmTZBXpLFkNy7A
KUxmrqrTmlAszhh9gaYIb5M/tuQTvwRlqQx5T8of4bYv2rA4eAlsu0Icq6oq
MIvFVEvB9CWo8GUK9xKuxB7v/eSsty7BVlPAzkxRJebqyxEfYNeCv8FK4VYp
VThQTbI8SlwLpLl+fM86UI2HX3QLYlUtIOneijngX42jGld5Kq5pwWOa963D
OjV4QjIqz+WmFnwdvfj8v5oaLFvBys6ZqgXRL18eenW8FicKlt//WKIFv+r1
FF29avGPIiXmpBYtyFg2uU/dW4uVuEaTNYe04MmlVg1DtjqclX31GPmMFmhu
3d7adanDGyykd5q3tKDodjRLU3kd1klJPehzWBsE//yV11ypw8W0AlFCp7VB
J9rb2E2gHpPcaiWbFdeGrSrqj0vW9dicyjAkW1UbWtZYV1Pj6nHVzW+7xhba
cIAzLVquoh4f/hPof9RNG57m72lXDtRjgv+xjZc3tWEmVaL+02w9frZW4BmS
qg1Tp9LmsjbqMZO73LLMI21ovPw89cufeuz+o//ySos2cNf0/Lr7tx53Ex2+
lQxpw9n7z/wLt+ox59dNR/sZbdgpEOlkma/HAVa3Jk9sa0MEWzXx+9t6/O7D
aeu3h3Xg1wuZGubaeixkWPMx7rQORB/eyi27W48jB9RNlCR0oPjQp/hGh3r8
RePz211VHeA0+y2iIVKP6Yv//Law0oFa1hPlrEt1WJWCnbvJUwdmD3yzs8yv
wwH26NKJaB1wkfz8XVS/Dj9ttfH2z9KBC6bnY19u1uLJkyGZHyp1QPlggLR2
Si1mvJ7TIf1KBx7u8Lfv8tfiIIlJho1VHWCrGf6vF9XgigSSi0YHdIGRqp/H
v7UaTy9xEKrZdEGI2yvBVaYaa5bY13iq6YJIR0NwJFMVPnFq2mg5Sxek3GIz
FQTLsVYA+Q3tKt1/elgveI48xaEfuAtLX+lC2uD3oPHAUvw9kbBx+ZcuLA6H
+k42PcKW5Gu9a9x6MK8ftO0jWYDXxcht80X0gI0zlCH200Mcb8ewZiCnB6v7
zzsCYvPwi2cSJ6t09IBSlniMgvQBtlpUKrc314O4MYqzahmZeJPVSImOoAdr
ik5y+pcysIC/zxWP63oQrJF92I8yFXcWReyfjtADpaiC0fFjydjmfUryYLwe
2O7uMSVdTPx33wrPhmTowcnShwwn6O/iJPHaZpECPVChsaa4t3gLC9l36X4p
04P7Qv0ZDQdi8cu776fvNOqBQcGt0ff2UdiudfY/+U49OP3UQSdtOxzvLG4c
XhrQgyH0svhkz02cdJIqN+ujHrRo8B4Syw3BQppMklozelCbLnFqiyEIv/Q/
0727rAfmJa3a9HP+2K5Y2urJjh6MqkRx/jzqh3+/V12xoNAHJDBXeTjaG6dQ
mEYcotWHdiJvKJuaJxaRcGZpOqEPMT8dVvUS3HC3/X+lrjz6wNMmXCJ34Ap2
SIiGE+f04aNIz+PqOWe815o23C2nD/6zbCe8uYn43lKxi7+yPhiaXEjmrnbA
59ga9s7q6sNERUsj4bYd7tbsTvhgrg+z2lZRYdrW2OH6KE80QR8gyvOp8oY5
3iv+3iDtrg/V5+dP3iQzxfdGtrXmruvDG7uxy2ddjbAo5cGvqRH68E7QUyGC
3QD3SpzwVbn7L/7gaSuOE3qY4MB/cCNDH7YkezMU8rTw3wS57IICfZDSuEBt
EKiB09s0xIzK9SHRc2D5RrUqFl827yJv0ofwlR1OR6SM+9gum1d36oNS6J0Z
MnpFTLwUsOQwqA+6Vxr30ngBcyiMZk9+/MfDeuTwl9WLeFxaWsdm5l9/SD8t
yW3L4TShlL+flvVh1adagNpQBhtw/Soz39EHMcfpANdtSXyURc/2A7kBvKYF
nYoJcdxzpIzW+KgBKNbdMrtAKoYjyGna37IYQCB39YVHpSIYdlw99LgNIEFS
+S9flSDeW37FMSBsACNtFwoTqPlx/Qzvm0uyBvCdVvliQ9EZ7DUWfrNH0QDe
XrPii4/gwSJDX8XUtA0gyqVyb/0+F/7Rhac6TQ3ARwYlFU5z4MLm7CRFBwNw
niGr569ix3aVu4rtV//lV4j73bh4ErMVm6/J/2cAUmsG0QZuJ/BoVn1+800D
WBmrENE4x4yTk44byd02AOp6WeVhvuNYJ8abov6eAQzLQMNPIwZ8KPhNjWSe
AXwa3YtWKaPDL73PEaueGECLqQjzCdFj+KbrneOidQawHbnJf7n0CL5ou9D1
tN0A7pVYSNTLHcbbRhp+gq8NIF2N7IoH6UFco1l85tF7A1iyH3cs/kOF3YHy
w5lJA+BlKMim56fEAtKO0QU/DCDm1FDa72ByPCf4XIZrwwD4rE8L8O+S4jzO
099z9g3+3S/HsbEMEmzFfCP91CFDaDg1MulY/hexHPmknsloCGWms5wmjnvo
HZncDstpQ5AW47A9o/kbxW/fe3SP3xDmIwQt/9hsI83ldXNGSUOoenaLLDx7
E1HOGBxKQobA+OVW3BDpBmr/WNFEq2EI8V9S+Qgxayho8OiVO4b/4iV+ijKJ
/EIyXVdPHrYxBGqJ7560KyuorIIviMrbEDrqdOtqbyyhy0VRQhE3DKHiTa5r
YvwC4s2aGSeNMYQjj7hG9F7Oo8lExTshSYYQEz85f5vzO8qKzpX/k2UIn2Vk
7oplzyGzG3+XAooN4ZKpv6Sv9Cxi8LZ6sF1pCEcjhdGbH9MozoZlf+2lIbC7
P+edyPyKVI38yj3fGEI0xbBPRsokItUctv35yRCmok0rZ2ECtWDxY9fmDGH2
vadmfeBn5C+V0P5jxRCGm34eGBr5hCQFlz1cdg3B/cjBvXTdMfSTQ4tzjtII
Ts9mvqidHkVONNRhX1mNYN+YnPKG8QjiInMSt+U1grGv5aSEc+/R562OqfFz
RtAcd02Z9tQwSl/iTLY4bwRvoyaW/rC9Q0bTIUqjykbQFnI1dVD4LaL9+HnN
WNcIRqSCDBR03qDegQsF78yNIOT5CK3gjSGk0LRFMehmBKBKJxREMYBkHb5J
pvsbgSzr1QLfjj4keugDwT7MCGYuCg4Lpr5G7BZ1nWupRtBPM/5q5UoPOk5W
tN6SYwTC3DVvety6Ec3jVJ6oR0bgIJtyfSXkFfq94xPB8swIMuLtMxN6utBq
HqHm60sj8Ib+XWeSLvRdw2jm8dA/fYFtF1QVO9GHDAll+RkjqNSq+Hp15gUa
UOD2oVo2Ai6O2JIbSi/Qy3n6gsGtf/6gGhWeJ89RjdwvcofDxnCRrD1SIqkd
Pfn6VULwuDF0BeofrjrWjh7GvnFcZzeGR8dP938VbEMJHys6osSNwcNNt9XC
6RmKvpm7pnvRGK5Rf8taS2lBwfwJ3CdUjSFb+Vam6kAzunbdPfyJuTF8V9XI
H7RpQgRO22ofR2MI1VRp3KppRFY9OtPy14wh/+D3+haGRqR5QkRpKNQYQpjU
z1vN1yOF56e8M+KM4e+c4i9n23ok63ok3yHFGNYEL1J5jdehM42LZBvFxhBQ
ZcjA96MWnbIfF2+tNAZLKdiQDKhFjAf7HKKbjcGh10Wf9FgtIjN/8uLEoDHs
iGa5DlyqQTskmb+mRo1hZcnQz2i1Gq2UxHGVThnDha/lrAWZ1Whi2zUMbRpD
7pvotbd/qtBIrnnVARITOPDbI9GwtgoNqGtMDR00gZGbbrKTHlWoa0WW/j6D
CfDFUvXriVahlnQ+RcdTJvDeavFVyFolqgYWL6GzJsD96uExzaZK9Pj7gYcb
oiZQk/ZhLD6iEqXLfiONUTaB4a+/Q2m5K9HdyRExfR0TCElrEGTcqkBRMS/t
Wc1M4FLhjXaegQoULFqXOG1vAh1VX88LlFQg39HC56VXTICYoKBIG1mBroam
rvr6mkChS8rxdkIFIvBFcuIQE1gXHPIXUKtAlkM++tSxJrCq15kvL1SBDPwJ
N98kmYApk5H4D4YKpMFhVHk/ywSu1W4KKu+VI+hW+upYZAKfu4/TVb4vRzIe
EnTCFSYwLnachKKmHImwcCtsNpqAp5ajGl9aOeJtp/ds6zCBiVN94YdDyhGb
C1leTL8J5Fdejc++Uo4Yj/0a0v9gAuI1YVeHrMrR4YavJCe/mkBgEplCukE5
WtFLi6pfMIFgft3sQq1yNDyvRWO0aQLyv8lmSf7ZDWFkSSskpiD5YP5Avl45
yj7ZwHznsCnQnzxSEm1RjsJqrmXzM5lCUortsaeu5chJm5v7JYcpPJGuFmYM
Lkeac6MlDoKmUEtcjW3/x3suJF5kX8oUGo9GajTU/eNjUa7JBFMILlwWoPhU
jrYrduRkL5kCT5B8pylZBRrXKG8bNjaFVkUakZkTFej5FEHF084UfjYXPDwn
WYGKAllfH7liCh8vZ3Qr6VegOMYhvce+pnDrB/GhoGcFMlS9YDUdZwpVx5mv
PWqsQLITK19DUk3BKdf7itVUBWLzL3Jmy/2n74aX5qmjlYiEzmqp4bEp5Hx8
qvn3YiWafUTnbVxrCkND7ojBvRL1Kr7aXm0zBc7gV/c8CypR2aeg4PheU3h+
ZNZT9HMl+u/I99hXE/94+U1/SJpXIauibFrCD1PQ53nfWJlVhQAbppJsmMIO
ya97f6ar0EHP1ly5Q2YQcIuqKSq4Gi0f9DkzwmgGK6sctw+/rUZvH/KXep02
g9XMjfpl/hqUOZxS/0TSDK7osZlc/1aDQq9pyqtjM3AW7fsZqF2LCFQkHTMa
ZvD9sbRfckMtEpa9MnDK1gzkL720+vCgDtG/4TBqcjWDpg9MPX6s9WjTdeSj
iY8Z9M+6JtNl1aO2TIXZu7Fm8MXqRYBqVQMqkNy6LJRiBuSXZ9k91RpRTH/p
SveDf/nuJj1smG5E+vvMe6Q1ZsBjpUa2It6MpNP7bz5oNYO1xXj21LlmxCoW
fuBCjxn82WARffGwBU07LNP7fDGD95rJjZbSrah7Nz/92LwZFG6uxj052oZK
U8zZn66ZwTeLh12aq23I92Un/xy1OdyUPpfWtdCOLGwDysMYzIG1yXmHx+05
QtvnpE6zm4Nk+y/u3s3n6IBAJphJmMPHgs/qkmwdaPGF3st1eXMguQU0Txs7
0JAllVaiujkkCA/2vbPpRBl3PE17rc3hoeon0TfPu1DwmbOfnVzMwaTu9Ie4
0JfIoW3cgdzbHK4qWho1qr9CgqtqbhdjzCGotrA9bqsbaV28682TZA4hFhrv
bg32oKvRI/40WeYgu2x/vb6yF5WeIoaPl5tDnVTu+ap7fajPpTSms9EcVI5o
ihbf70eL1Wt3SjvMgU7o0DWGJwNISDMsPeiDOTz78hRIAoaQVmpPNuGrOQhx
qDHtML1BVyeP5WstmIPBjZgDOc1v0FO/nKds++bgc+6RzMNT79DA87kqioMW
YCG3WfXt0zu0TCPSsEhvAfmcv9Ke5A8jkfyWFy1nLOCY1efpQf0RpLNM3l0g
agFj61FtxnIfkJvcpf7b5y3g1jk38iKhUVQ++PGDlY4FHJn65mQmN4aGWDk/
K5tZwGcpmwciRp/QCtFlSsjBAlS1+T403BhHonubi3u+FnDObI/ZlGQC6amh
XzMhFhA83qf+UHgSeSRFbvXFWsDQZzaC9swkquRjJMvOtoCBNyzBHu5T6K23
5YHIYguQo2B/xqQyjX61PqS5VmkBv+JV6XTPzCBxYzFm+S4LmDjBe03x6Bwy
yPVn4x20ADXdD42hTN+Q10Ib55GPFnCdzlveXPg7qr6pI/R50QJ0LMSZPeN+
oOG+VLGuTQvYtVKyevh2Aa0zf5Z+SmIJya1qQ4bCS0iy7IrCDUZLsB9mzLpK
u4KMdqpUieyWcIjnzCDz+AryUf59SZvPEqr0uFeialZR7ViMyamLljAbHj5R
fmsNjfAOWVKqWkIhlVbCwdvraNOD2X5J1xJUrj/oc8ncQNIHiq48c7SE97nc
XCcXtpCJwZJH4TVLMHqzHhknvIP8siX97vxnCXO5B0PPh/9G974HBvretIRT
RuMprku7qF6iI9T6liWMWOuKXL32B40GH4pSSbUE7f8KRcso9tF2j/4t4RxL
YDuwZ2JhQYJl7SZT/1RZwp0GLfERcTJs9uRs5myLJaSxcLqelCLH/ptuuf0v
/+npdlS2UaPA6Qp1hbVDlvA74LhH+WVK3Hj7z+PsMUt4OGr/TjyXCo99UK6I
nLGER15qexzzB/Bvrtu115YtYVSHr7hb9SA+38jaLk9mBbmFKzbbKjQ46HX5
17XDVsDkcP0d49QR3PpZmfzxcSvQHTSZOJZOi0lWPvLYnbaC4bT13OGaY1iB
zF2Vid8KbD+MslqX0uEwRgqXPnErCKd58zW3mh53nsmIDbtoBQ/f7HBWvmbA
6pc6+pZ1/8W3v6v5Is6E46zNlgvMrSDCVLI/MoIZ97kv0Vo6WsFL/QP8xxZZ
8NGwMDG6a/9sKjlukiusWC+F2fCVnxX0rr4+sk7GhpOKSn1uhFqB09M0rZLa
U3i4QeGeRJwVsLe9z9iJOI1NP1/5mJNtBVHX0l1ft3Pi9J8ku8bFVmDygfra
449ceIz0HhtNpRVwfHpJqU3Jg9kYBdGLJit4vW7/gkqFF9ucabf177SCq9Xr
asr3z+BcWeObIgNWQH3AQf4OFR+e0vzxcOaDFdRYsVlH3eLHTu6Mc3oLVuAV
r7zdNCeES24+OnBgwwqWJX8rz7WL4B/JiP/ZXys4Oyvn8M5aFAsVvdP0prYG
43s500+uiuFrDS5X+emtIc/9IalCvDgu6/1zZ+KkNbAXM9/+2SGBV8aTylN5
rcGA48pTEVop7EP67BepnDUUf+9Keb0og+sYDBgbFK2Blre2qixMDm/zfpNy
07KGNC71w+JSF/B52SBTHpN/+dJOlXtRyeMgTbrrY7bWoEy0JKvfRrjVquh+
gqs1fD5ssCsbDZjE/UKLqrc1rHRvKHIXKuDwZOJ+VZQ1SO2ffPLttDLuLPzN
4ZpgDYd2zIKWQ1QwVcNdxdP3rSHh8ASF3Y4qVu/lIbzPt4ZPKs+YeePVcdx4
Y+Stp9YwWu2OtEAT9y3rFCvUW0MVb8cjGnotfJR0pnur3Rp+D6VZ9VDq4CTe
ozSEYWu4dnWh6aOIPh6WyRdm/WINx1kF/g45GmAmTVndoW/W0CAcmX2r3BCb
WfV7RK1aA4uJ50YngzHOcHNIurhrDVfcNEoskkzwWOhW9S8KG6C0kcC6wmaY
Lfn2+5KjNnB8ZW63b84c59bXsRznsgHScYqvs63WeKrn0vnXgjZATH7j3jBl
i3nGJy1vStlA8bHEI13M9thp2feGDLYBq5Z3XcjIAZeQHM5ZUrcBjcxwq+sl
jvgHfW57voENZJAqVKswEbEQr9SUuZUNyPiwraflOOFyDVvel+42QC+zk21z
5DL+otWUpRtgA4bu1QvPOa/io3rHGT9G2MADNyexaXs3LG/occvhrg14jDU8
K3fxwFdNXpMtZtjAj/2VqaNNnjjT/EyAb4EN/OknZRM46417rW6u/i2zgfJH
yv2qVT6Yz1Fmkq7TBlZFmD4EC/ljU6ck08wBGzggFRlMzxmAo1yXBng+2sDA
NLXqAxSE666qq5ZN24CujySfc0wwnnXPfyazbAN3zAkCW6GhmNH7r+TzbRug
Xo9iCPhwEyv7mZdqktvCMQq3G880wvHDINpMaxZbkM7n1ZGJi8JvQi7Tf+Oy
BW7PUn4O6xhMEt4V6yFsC9HPJflFjePwuSgO0t8ytiC7IP7wlO9tbBMb6B+u
aAvWg75ZnW3x+M7tkZ802rYQJd8lwZCVgFvuijnfM7UFzu19vZqVRHzy3jfj
R1dtgall8te3+RSsmaHYL/6fLZCeTEhZTbyHA7KylVtu2sL7pNlZY/N0/Chn
u1nlti2QsxwbWlK4j0cfGkoM3rOFn0UmhenaWfhAUdljszxbuP9aW0A2+AGW
fnSQa+qJLVAlray9v5yLU8rbjm2020KFUO07UZJ83FHFGhP82hbKtsSIiVcK
8K9a3/0DI7bgL57x/t1SIdZvEVxmXbCF25b3uQfkHuHQtihiwYYt8P/Sciqn
eILNvnosM5HYQaiYQGzz91IcPfOamHvIDhxaEh6lBFdgdqfrnLO0diAcG5T9
4l4lrvt25jP/cTtQjhBMD2yuwnM/bhpVn7YDQ9KnCg78tVh5VUbppaQdYMfr
pXQxTXjca/bvofN2YDTQ8s13sxl7ryc16WI7EC+h5Pt+5Rl+uLUk9lHDDsjy
34nFSLRjkr/5HIs2diDTfYL8wMUOnB6iPy5KsAPCMeFP5Xsd+Bzpfpqvqx1U
MtUYazZ3YhsKC9p9bztI1vLcDzv3Ej87dOwvXawdfJujF9Sf6sZexKjre3fs
4FlYtpCBXw/ma99bn0uygyjdK3x5FL04yXd+oTnLDg4StX/z077G6kO2zkV5
djCxk2pFdus1/iMwMpVQZAdpyyy6RJI+7DL54iOxwg6aP+2KRH7ow+wX5Iz1
au0g7rPPW1m5fvwutXzofJMdZG1Tbjuk9OOYFV4t3jY7WOw6eer4fD9Gl7Je
0XbaQc2IFrOLzABeL6RX+t1tB5biq1KBIQP4EUls60y/HRQzyhG9nw9gG8t9
ucG3dvBlP8Ak4M8AZqzzrW38YAdj6oMVzyQGce+xRdGCcTvY33XXciMM4pAr
DqXxX+2A1rwloO3uIJZ8OXr2+pwdTH4Vt5qrHcQ/OHTzHRf+8bdKq5z4MIhz
A7vYdVbsgDOUSvzu2iA2HrlwX3bDDuJnNgraKIfwIbGq49y/7UAupEw2gXYI
t9/iSzyybwfnk1V8jZiHsN/cA5ptcntQ6nhLevbUEBZUOB4zRW0PHYF73zk5
h/Bk5i3y/iP2IO4YFGTDPYTvbZKG1NPbww1LFrTxz9bS9/+dx2wP+t9v9//h
GsKkpcu+t9ns4YLs3Fg8xxCuoyKu+nHa/3s/utla2YbwVftPV+3P2AP5voBm
7r/6XC363y8J2oNHKguzBt0Q/sDU7Sgtag8DH/5KvD44hG97ogkOKXvwOy6h
K0s6hBX7aiwOn7cHHJgmqvhzEG+fERzZQPbArrkXKzA2iJ/ezNOfVLIHJ/dr
Imodg5hFJl69VtseCuK1ZOMSBvFAIkVnjoE97FJNFE75DOLwxQAcZ2oPxtGk
ie9MB/FynrO0rb09lNOtU745MYg7aBR4Dvraw1g+8xO+hAHs71yfs3bdHrpL
iO/RlQEs8kL45Jdge7iVkGzupjKA0/9jpa+OsYfS/Sg7pa1+7Da1tm+VZQ87
FpuDdfr9mLWh6FNFhz1Ev5JMfT73GqseJiGj7LGHiJjbdqlVr7GXjTmf+YA9
rIepNNffeI17KWh8ST/awxLDfervdK9xoL7nUYNle/jeZTs/KtaLx39cUFhj
cQAaWzfRWO1uTI1SndXYHeDel34B1SPdWDJx+U4mtwPkSudnsPW9wrdl8saU
RByghY9Zdlf1FZaPoPJJUXKAS/ZedtWiL/GDU2+KpNwcoKTgctazvg7c6yHQ
H+vtAFeA5alZQAfe7Ahf++zvAGv6n0zCz3RgncvSEBXuAOX20Rm2AS/wfl3m
x5F0B8g5Mix7hvY5ttNzovHvcACysQ27sr5mfDu/Tbyv2wG+VU6h+F9NuGGT
xZxjwAHeKsx++svYhI9lvy7sHnUAZvfLl0j1GvDzeVF8YtkBRvyKW17m12Cu
8F3PJhZHML8WPYClHuOJxsCijVOOEFRc7R55pQRnreyOiXI7Ql1/+9DU4yLM
ZLOnVCzsCMkCJMwxWvn4XUqQ/5S4I5g1ptner8rDCa/3Sk/JOoJGcKAi5s/F
h+T+HE9RdISFhwJ3+bLv41fuNzQH1Rxhv9Cf+tl+Go4o+hN8SNsR4mpP6VTc
ScUKn29Uqxg4QjtRofuUejL+y/D3W6ipIyyun5rzPpeImzWD2VqsHOEqVbH1
QlQ89r/5V2/L3hHOsFynjaW6hSUbgiPFnR3hv9tYa2osGq8u/228dtUR5o+J
bnOTROIy3pDlEk9HuObx36kmzzB82Wqfa8bPEYzIgT1KIBSfTQ4xPR3kCFPH
1anOagbhmZ79WxY3HWE33+1WQr0/ziMJbU+NcoQvs1/n2JJ8sY0MycbQLUfo
/kVJszjghU+6hfLTJDqChL+TTbajBx4tILFRu+cIoYY8NN9vX8Wpn0KTwjId
QY6B1u/TuAs2oCd99SzXEd73OfllFRExrcbN3e1CR1C3NQxT+uSA+0JIRSWf
OEKxWqKb5zU7HFt3k+Be4Qj448fbAQ+tsOoSacbjWkdYfi40JLNthsl5wvpn
mxwhh4KSI6bHGLdbkJFxtjtCiGhbAyeVIb6RGCZt1eUIr0/8ju3O0cPnu8mu
pPU6Qs99PnkBRm289Tcs5+2gI+RNiRXe8NHANVLkw0feO4JJ/B/5YW1V7Hk1
nFpjzBGkOlhrN+8qYZF8cvmICUf49kXu0LiQAl74GO7ZNvOPh6SW5IUowiXH
KIp+zzsC5zzLBG3CeUxUixiT+ukIjMGvykOJMpgrmILWc90RfASNqK/kSeKJ
mgil0h1HeGF9iEZNWhxnLVD4f/vrCBM8EVWOLKLYnCuylIuCAENrHce1AoUw
kznlV+uDBPD5ERz18Dw/fns38njGUQJ03bxbUWp7Bt99Sak5zEAAWuHaT0af
ubHWn8hg2hMEONl8dlylhBNTS1JVa7ITQOeEXabFtdO463LUt0huAnz8ceIT
DQkbDsujYnvORwB9iuyO0R0WjEej9PaECbDTSN87q82E944eiJSRIAD1o7Gv
1KsMuFElutFLlgBLy4ZKcR/psF/QgeWn8gQ4NrGYPfeHFktUR3PNKxJAU8Ji
4GU1DV6ZP2DKo04Ar+mw2PevDuKnHDG3bLUJsGnSPzYscgBfNqVuv29AgOhD
IbyrXyjw2fiY9femBJgIcvNNHCTDM53U/HTWBAgOi9UX2SHBebsx1loOBHh+
qUPL6vFfZCN+MCnamQCsHc0kd5p3kZyiQZTLVQK4cW9PtqjuIEaDzAANTwIw
GG2vW9JuoWX7GTcBPwLkfHtVsXZ0A/V4CjseDiTA7Hiq70u8hgpu+pkuhhAg
q8jiTWPWKgpObLvUH/Ev33TeZSXOFWSeRw1lsQTQe3k9rCJpCUlW6kvejSdA
kJ/0SjPXAqJ9fp/PI5kA5XNzfRcWv6MfQ9Ns+ukEIH/2+5r3/BzqmhSiE88m
QBr115eKx2dR7oovJcPDf/PuHHnOeGUaBZK07awVEaDny5+ywbmvyOQY9fLw
EwJonJyNfhUxiUQ59KdqKwhQJ8mb5Rj+BR0WvT9yr/afvs+TBVJS42gOT/f+
10SAfNYi74YTY6hdV6jNrI0AD+ofi/ILjaJMW99quU4C3CjioQCXEeTn3lrM
2kOAA9emvnH1DiP9kANZu/0EIM1v2DDXeYeE7uoljL8lQL3Ga8qu1TdoqmzK
/8E4AfzcQ2evMQ2iZ62C10K+EqBwOofQt92H0gd87O3mCOD5tfkTC9Vr5PXl
mbHCAgEmoz5IJZ7vQdrLVJpcKwRQvGBzcyDpFeL7q4vINwignDTa0Hz4JSI7
miE+s0OAxZy16DsPO1GDsODJInIi/MoMrNs8/QIly/vQRlMTQTntVRA/2XPk
pv2M3OUIES50Lv4d/dWG1K2pttXpiRD+aan6IHUr4r6mu8jPTASvx+dSWqEF
/Q1KnzzERgQFCOlkud+ERm9/HV7gIP7TWy8fQNeI4ku9nz0VIILfid7R33p1
yLWlpTL+HBGKsn6+XWKsRcp9lEXukkR4q+liFLVcjdjHde7ryRFBbHex58R4
FdpZSIsXQ0Rg848v5RyvRMO7k2H0SkTgSPaWk12qQGWHBf5bUyMCZdrpwONH
KxBBsMW2Vp8I7o6n1uk3ShG+QGl0z4QIkleEl9liniDWSzrq/1kS4dzhpS2C
+GO0bpF20cyOCNdlgy3QrxI0eHlSVI5IhM62KynsL4vR4wB+XtbLRBBndCbe
Ly1CEXFeJ3bdiLAb+e20Y0EhOv+YguyZPxHol2iYODvy0fEm7c3sG0QQNHIl
Xfv2EK303PsRHEaEbS86m1cnHqKieb53cJsIujQrEQfyctHNHc9XnIlEYM4W
8eqez0FWB5ubye4RgdaOyKpS+ADR8WsXdOYQ4Q638HCQQRZyELuuRFtIhL9+
xNYkwUxUI1c4Zf6YCIc1KbWITPcRpeKbmwXlREg5pDzdTpeBTDT/cPysIYL8
592MWLZ0VGLA3y7XRASJ3mW5Rqk0tGNhbBvRRoStl3te1lb3UNaVp9kneokg
Y0s8nzKQgpa9P14kDBLBtro9PY0lBeEgyvGyYSJ0eXunLl9NRlO3rVmVJ4hg
eog+/ph4EpJMjW2Mn/k3P43/uGvzElFkdq3Zx3kibNjQNtucSER8ZUfS3NaJ
8JzbW+QrewIKqJOTbtz5Vz9s3bjV9C563Up8T75PhNjHdNomwfHIbfAZQ8ZB
JwCjHKs7y7dR+4f5qumjTnCUw7hrRvo2ops8biDC6AQX/O6SqsXeQjUr1xI6
2J2gInBAiU4zDlHtZJw7yuMEWgd8ysPqY5Ep6csBM34nMHLs8DomHIt+07Ef
WZZwgnmDg7k/RGKQFqtmqaycE6y4GE8FNUWjbC6/S+HICZruEBXrtKIRSAzE
smg4QWWwa8hCeBRKuvCbz1HHCVpgZ9yCLwpNK53pfmroBFRvUipM30YiSS0D
520zJ7jr3SVbfDMSRRkFUynZOEHXFf7X9NKRaNTqceEdx3/8ETSpzj8jED9x
RHnUxQleHP5r5/c0AvX5ioRf83aCBj66P8dlIhB7sAVXg78TbJ/2KTQji0Du
UVHPyYKdIFh7oaThTThqj6+y0w53Ao4k3qNMheGIPu3LflqME8TAVQ/DoHBE
yDmUM3XHCUS+wYSxaTiqLZZGwslOkL3R3E4hHY6oKhw+/5fuBFfYgus0WMKR
WUN80ItsJzjy36HIY3/D0OP2ppNH8p3gGcHxj+q3MLTbPddkWuIEE8Gvvo+/
C0Nab+gtHj51gkFH982OjjD04CPaWaz6x0sv+uRnXRha+Xo5XabBCRiJ3w2M
n4YhhR/3ZMKeOYFoz8O1haIwlPTrxUjfCyeQGjdRLM0PQzO/l32Zu50go0E2
I+GfLU1+8rhDvxOM7kb+TPm3P/qwWk3pWycIufnibV1pGBpl8Dbc+uAElvVm
9hu1YUiALeeXwmcnIJxPVtV/EYYCeV4n3p5yAjeOb/V9b8JQn9CW6IdvTmCy
Hu19ZSYMsUtxD3EuOYHTHm4X/x2G3OV13a/++ldvNsaNnyEcfWFXHrDacgIv
enWitXA40iGRE9bec4K6kEpSZ81w9Oyr8G15Umeg3/4VpHs5HAl1cC0IUzmD
2jqjGuedcJRVwKzJftgZUhUoaL5XhaPDUTSPjh5zhuec3o0Vn8LRD/VNp58n
nIEutHnzpnQEMhdY6Jpgdwa/628XHrtEoO7DkzxD3M7Qr9lfyPQgAhUP9ExV
CDsD/0PPVCqGSMRU0aqQJ+4MIpQSGXUG/85bYnVuoowzGK83MZPei0QEo2wb
LwVn2Jp5mz1wNgoNSyU9c1B1huOfjl2P84tCSszRbIaXnEGiXTDDoCcKcY15
jEkYO0N+LHXJncBolNhMlOOxcIakl9+y1T9FI5Jsi3RGW2dYd3VkzMUxaMJW
2WTDxRksvS8/7WOKRToKcrWz15xBs7N7djc2FrVyiTCOeDnD0emTlEFkcShr
lvltXZAz3D9AfgoobiGaVzRixTed4brmhfm1O7dQYAlpQlqUM2TEtMSPnrqN
LK4saPsnOEO2eweS0b+DerQmS11SnWH3Z3HChY07SFbk/WHz+84gk8zxODI3
HjGvtvbIFTiD3ZvfHscPJKCot9V8Ao+cwWAjzDrdJQFtVpdEs5b944tV43Ud
SEDDfkkqu/XOMNBoldlYnIiUzaILFlqcYSqWtPLhySRULRdEPv783zy/9T4r
TUlCSXvE5y2vnSFPODmeOS0Z6YbJyQdPOEPDtLFA7UwqanUUyXKbcQbC9fnj
+zH3kIgK967NvDOcHb11pkoyDdFQH2nEa87gJTxI3pufjoLmSVlEt51hOXSf
fcs5Ay30bvpx/HGGCuL7LHap+6j3zqQk6QEXmB94BCKLmUjO/X3y6mEXqPVi
aqH9kIVK9Hp/fT3mAq51L+gn+rJRNENNxQtWF5C5fm/p1qcctLleQlt92gW4
pqyshwJykdNItls+jwtg+/7g2KN5SDkjWihCxAVCeBX5vS89RALettJfJFwg
sE5Mb5s8Hx3TlgFZORfgPNHhLfgyH42TfDNcVHIBYmJ32YxrIXox1mqtquEC
Asr3Nou0ilBJzT3nXB0XUGQv/5FwoRj5uKgGGpm7QOwRI57X8AhZKLJHltm4
wEyU/36l2WMEbJvx1AQXeH3B0O1nyBNEM1T4sMXNBT4JXHklTVKGfj26Ucrk
4wKHvjDlaFuWo9Fw4zqP6y7AV655f4FQgQpkKHt5IlwgmkfdmXGtEsXRfX4X
HOsC7NVni7ReVyGPhZrPo/EuUM7OqP69vBpdzCGs3s5wAcmO/B/+ebWI6/rF
3bkHLqC2W/yKr6IOURsyUioUuIAf0/s31QP1aJiqk2WjzAVyPh0JD8dNqGky
k0u35h8f46+tQynNKLfJW+hRowuQPx77s7HXgqJSLkmTt7lAp/AHsczAVnTV
jRusO11g1WSgvIa6HRmo72rU97jAfW+GkvWJdiTL9c6QbtAFjH31vth2PkcU
I2HOXR9dIJdDpFq7oQP9KLfwPD3xr9/u5F2dPZ1oKFY88PqMC1gSi6IMFrtQ
neOhyHfzLuA/vVTDwfkKZclPxQv/dAEX/KXOzbUbhTE3pUevu0Czh5da8sse
5LKa+PDrjgtMeqUr/JV7jSQLFepSKVxBcM9fa8V1ALGGnGj/edAVaGIEg9YY
hxCJ+WqPBq0r6JBZ/A0nf4PmxHve5TO6gqxqWWEF6VvUR5P3+c8JV0jMNTid
cuwdqprz/2Z62hX+/mCzsBEbRuntequVPK5gmpIraUJ8jwg+JJRO51whj9GT
1IVmFGnqjB5tl3SF7jt7oclhH5EoXwUL63lX2H/6RJCR/hNiIovh8sGucCHR
/dCLlnG098lWaEDZFbqyX0VlRHxBU7Uy0nyarrBLdBOekJpE3XdpIUzXFXCj
ix0+/xWlKLUZSlu4gs+NDpOAgGkUcCrNOsHWFcrGFcdPNc4guy035x8EVzhn
SLXAc3QOqb5R9VS+7ApPLg9Mywd+Q0JP2AMfuLvCqRBnOTmyeUQfuRmx7eMK
vG17CjSFP9C2zUC8QYArGIUYqQ4TF1EnffBDqkhX+JzfL6zJu4IuDAU1qcW5
wio24s6TXEVVdwLfxtx1hR8q5Q9NTX8hvksBP3pSXOHQfO7ubPwayqG+Tnb4
vitM6OpcnxpfR0wv/2PVynGFwEb2CXKlTXQ73E/8ToErbHhos/F0bKGAv94O
tOWu4JKmmRB3YhetNnsF6NW4QrpHgLje+h5yue6ZlNjoCvNZ2S2sv/6iCWmP
x29bXUHmb0PV2zgSbLLu9oKh0xXOOAzK/qogxf2V18aMelxhe/cBBeUSGVb+
9xumDrhCPnrT0gUUWOyHKxfLR1cw4Lr9Zl36AC4pdjlv/sUV1FP/s8j8TI3Z
ic4G96f/v1/OBYdwKpfT5U/f/80/cVZi4Q4NppkkhLEtuwKtVt3B1ayjODzb
8b71miv0HbJlxZeP4d8WDlUPtl1BnhASt5hJh7+/t53iIL8M+rLbpy+qM+L/
UWTd8Vj9XxyVpGEkpaKMRCGbwudzqJDSUBnZW4/xLJ6hEo8tMxSRrShJQrJ3
sj0klIqEr7QTSvo9vz/v63zOuee8x7n3vq59ot1vRz4CLMq3hIy3bcFDp22F
czcSwPNhIbrkvBWf2GSzb1KYAFFxhrYBu8Vwc+cFgz3bCLCH+OxaMtcOfCjS
6oKbOAH0Z5jP8nnFcYmhJeWuFAHcC3cED2jswhmN53PkFQlQ/GW1Rc0mKbzl
6rkqgioBPvGsu/PCRxpH655l39ciAMtq5yj+KIN5fp+ZndMlQN6tGX3rMFnM
fHKaR8mAAB80rbhqDeTwV99T24lGBEgMt21Wk96H3VRPqpacIIB1hs9M1z4F
fO7BcSdVCwKUxmeWXbJTxp0EE3+qDQFCO8mrIu+qYAO5Y9fLHAkQFLW58cl6
NVz5wejevBsBjsasH78Qo44P5Bo2aXoRgP/Tn+ElJU18x+HoKJ1MgA0xN23O
/9DCOyWOfK+kEcBDaiXca+wg5k/Vl9IJIsCpTkqejDLCQeZw6HIYAc6lqN3Y
dhrw4mZsVnuNAMrcPUbEHH3s069HWIkngPltjSpHocP4Q6wuC98ggP/quFJi
5hFsc0LnVmAaARR5mvaYnTLE7HWHShuzCIDC7Zy5ZIxxQ4jWxOH7BDBUdo5a
MD6BtQw0f4eUEGDg3TPh9KyTuPifunBbOQF044Y6ZpJP4z21avvWVhNgezpZ
LnHhDE73VzUwbiBAzuGKyHb6WbxZW+VCZCsB4nxiTPTEzuOo+QOUjg4CrHUY
637/xhzTSYo5J15w+DXkNp5+fwFvWDvPVBslwEYpcdYXblucdbvmzPa3BAjR
T/P7fdwea6iHyHNPEsAkuC3vxYQD7ug4zj0zQwBZ2Upe5kEnbOe4eaTnEwF6
Yw595ityxj8WRkvKvxOAuwFXDui64p17CA7By5x5SurajZs98KNqFW0CtydU
9ljej68jYEOzJYEzvJ4wOpI+Y/7eC4/ONExrrfeEZ/POrFUaREy8GlEvIegJ
q87d5M95RcKrRU/fXLOFc50fSOTTouCUoq3EOTFP2Pskb9VIMRU3jdyRqJL2
hMC+h4GSf2nYnOTzK0vOE76ZqLc2DTPwR17NnnBFTyhUu7gs+8ofB97+m++j
6gmfwm9Huq69gkXUW6+c1/IEF9HF5l6Hq7iwI/q8rq4nyD6hCfvPB2LkeE5R
Wt8T9mnPVvSdY2H32Pevv5p4Qp18XvF1Qihelrlf9vKUJ2gLzg357wnH8dWU
6LpznvA2i1mQuyoS7zE75JJvxbl/QpPkvbXXcNUMt260nSc0FDTeNVOPwSev
Pt9MdfaEoTQfn8joOPx+S8JHKw9P2OBjo/doXQLecHh32l6KJ7hGisStHUvE
WSPTlE10TziiqmvsSkrGGqSHJvOXPOHYWNy7JcmbuIOXLvU6kJM/7tFR8CMF
291Gv5tCPcH2jXKi0/Qt/EONl10Y5Qmfn5btkPqXjiM6ugvj4zj1RqOV/9PN
xI8WbKzsUj0hjFBy7JRYDjaMlVE5muEJq1XOmR+l5+JRmTk+hVxPMLpvtKI5
l4dXm12qXCryBOH5wE0PJQpwyoxB/LtHnuBHkv82NlaIFa/yezyr8ATulQOU
00/uY/Oi1K3JDZ7Qc/gVUaf6If5o4PjlUqsneNp3EXV/lODAEblnTh2ekLVZ
qbVGtBQX8lbSlAc94c72y3TF8DK87DD0onPaE7impU7t4q3C8Qu3H5TOeUKx
orBLc3A13hPrGpr6zRNa5TR42etr8cnqn+rufzwh7322e/SOBpy9ZXMSj4AX
FGSSqkY9m3FRXq3oWREvCH85+L3yfAuuVPNIzRXzgvb8rkAibsU9Z2ozjsh4
AQ0d4aNseoZH37lLJst7gd/vbfu7vz3DH4jCeR+UvMBpaUhCtr8dL8e4F4Yd
9IJjDPWbjoEdeK24sMJL5AVeQzWtZSc7sXBRTfHeI15weV7W9eOWLizfIVTW
fpITPyU8XB/djdWtajTFznkBe1rnCFWnB8OM29OLVl5QTDj+SGO8B5vz1tTx
u3jBALH2DIuvDzslu+lbX/SC77U01kXTPuwtI9Ry38cLyJktPSkxfZjxuNpw
meoFiptTz2193odDDNyen2B6QTbP7+4f//pwXL/gidsBXtAqFv/wsGo/vuVQ
3fMp2AvKkdYRKYd+fOeL6xkU6QXXT690PIzsx48CBAdjY7043xtS6YIP+3HN
xmrzt4leoGlZaunV14/b011HDqR6wYvitL2fPvXjgf2CNoEZXlBxXJWnfi0b
v6mqetOXy8kvcRESkGDj2WOujpKFXtAVZrJzvQobzw8LTJKLvWB/hBTfOLAx
l0eVW9NjDl5zHhfrTNl4w4LLf8JPvUDgmvmePgs23hYm4OVcx+GnZ0jKwJ6N
pbdUfX7c7AWLxwbXYRc2VspzIa9+7gXb7mQIfHVj40NqAj/P9XgBaZVE72V3
Nj7a9JSWP+AFQztD96/nxE+fcVmaH/aCvPmDuvVObGzzbtNlwzdeUHqxCqpt
2did+HTlxnsviIw5l7aLc3/KinPQ9IwXRLRn9fOfYuOAmE2rtT9z+mc1J6Qe
ZePInU/DIn54gfyq5OqpQ2ycdN953ciiF9R9mPJaf4CNsw5tipZf8YJMP03B
XVJsfP955Sb/Vd7QrqLqrSXCxk3TG0V2bPKGK7VlJa3z/bibVnnDc7M3uJxc
Srf/0I+H1ziL1WzzBs1X876Gg/34i3SlhK20N/hK+l5SL+nHOx2c5DO1veFx
9wHxKcd+TB+uQNLO3sCt5D51uKwPZ8G+IDEPbxiPSrv3LaMPdxTcbhbw9ob9
6nRXSmQf3skMMV6mecNQHCV43rYPN4iZmb2I8oZj7t8KlP//f9f6k2t4qTcM
H0DWXrd6sFqzQ8GVJ97g0DkUiD17sM3+wVlqjTd4jpqYdXP0/PBPFdGhzRsE
tKZDN7/uxufSI5gHR73B2TCmaptYN84Yk475yO0D5tHiA+9ZnfjZ0Zu947w+
MF8s/cia45+vD/iFh9f7QNVLdpGzWCc+HPDtRssWH1CVk+7cXNyBZyTqs27L
+0CA+Ce2f/9zrOJwoezUGR+IRbEhm5ef4Qvt3b+OmvtATvaV2vN1z3CIsv5B
XWsfCHcKU3xx9Rke4pKrk3P1gS1NG7XIXM+wf/b8M26mDzidlOCzXmjFLRPx
rx5n+UBLrWucVXkzDlDar5CQ7wNxjYGuERebsbZ/62Wfe5x+m5ZXh+3k7Beh
3+LyZZw4acaoJ6AJJ4GzQ8YzH4jO+ritXq0Ru2RofIj47AMHiMnLgY9rsMRs
r4bbD059U93nTV+q8bAGIezwog9wgSdTTL4an+jO2LvCTQTjKwKiuolPsfry
WgJ1CxGYNPvdEsYVePWF0c+2ukT4wfp2OrqrGNfl+2IdfSKk8JyLHRN5gBnf
NsVvMyTCi4cLgkKO9/FcxGGVgVNEONAzEVvOX4DvDI4FlZwjQvdDa8+dnnew
w24GO8aKCJOn9u01fJGHB58UUY2dibBaWFCFpzsbx64yatnjQYT+ioSfobZZ
2PjUuMgqbyKorL27RvvPbcyTdsn1HZkIz6Zzvk7apOGaqS0VtTQitG/ZtF5o
IgXTVEt40y4RYdBtIzKNvoGVA0wsGIFEsDeR0nlkk4TztlxdVI0iglxOLFc3
OZ7z/iF2TDCOCJcePFN09YrB2x48Tv2USITXOk+/nIYozF40ne1IIYLNT7g0
aBOOo4/MHCq4TYS199xaK+tCsGE861poDhHq97pJ6zmxMNfrna+d7hJBKNZ3
q97hQFy194kCFHHydw3NF1Zdxr7UM1fEHxHBlultsdaSiZXqP3b/LidCVfqz
93HnaXiGP0xiuIoIdQ16beR7VJxjvptYXk+EFaVUUdWTZGyTU1V/vYUIbkKu
u6+TfbDo53OCpOdEKO8x1yS0EnDfwS8Opj1ECHKyHVgf5Y6jQiMf7RsggmJc
gURTqQs+0i/NwzdMhEOWbz7zqDthvy3Zf0+OceoHROvoFdvjO1YSS8kTROjr
e5BYkmSNh26n/Xw9TYQaIfF5H15LvHZi21fpT0TwvOe+IPTtHNaWvfGR8J0I
43O+z68eMcMehM3TjxaIcHrvw3LrD6dwanH8xOIyEYg382S73hzHrku8X3Zx
k0DYL/TOLgdjHJDW6tW8igTEItnh3+ZH8Q29kFk3XhLQzrHLLj82wMVvDTz4
15Hg5vf1UXPugNuCuKcerCdBvH7KmYk+XfxGusH5zCYSCC5reWSfP4gXWgPG
fwqS4MvBR09JJzSxoIeefcpmEnS76SeL3lHDcvzLr3VESTA2eXSceF4FQ1HV
hbfbSHCDS//UiQwlbHmSOczaQYLOf/dOvhXej0lftcxlJUgg3rnzfMnCXhx5
/dfA890kcJw8sCKF9uAc9fIz3tIkaFz4vTN5RApXDVF7BWVJ8Mg2wHFb/W7M
ZqialsmRoGSDSJNnhzie3f6tw2I/CdaLDR7xDd+OeWofGv9RJEFC2tElwbtb
8Q57n7YMZRKEj3y++t/OLVidW/GIgRoJ3m1TijryRhifyP3Y+EGDBPLzMzq9
44LY5eg9HKlNAte2K3+H0SZ8edqjVkGHBOWOwcdEd6/HSZF7dfr0SHCvSLRl
lTUffrB/qpIKJOCXMol/N7kGt3XnaW49TILCb9lixmWr8Buic1nVURLodG/j
Wt3IjX8JSanaGZPgOP8xi8lVXHhT2buH3Mc5/D37dPfQp2Uka56pmG9Kgrx4
O+Oze38jvGh73/g0p59TT5McixaQ5a2d8nNmJMghxL0cp84jku6rO3HnSfDY
ePsBC9oPFPEmVUbNkgT/0kwO7nvwDWUFWuYMXSDBL2ksHy38FVVKbd3tb8vh
y0jGvNrgE+pveXFb3IEE1ptrJVXvzaJZt6QdjU4k8JY6/CDg7AziWXc21cWV
BJFCFhpxWlNo+32hrXweJCj+vstL8vQkUjXtS7pP4PDZlWhZeHMCmXyJFT7l
zcFLtcZNZ904ck4wjf9OJMGbtHvM7/AWXVbbsOkGhQTK9r++cD9+jZJedFw7
6EeC6Wv3/9U4jqIieuS6MToJfvgcs/hrOIxaxIzDA/1JsEL9b9HIdgi9ruZd
I3OFBKfq6klPMwfRvG0r69lVjh5uu1B/rhtAm7hCuDxZJDAxTU8WTulHsjkG
AZtCSWAW+WDkhmEfQke4lx+Fc/DZF1fcLNODzKfqmeejSOD5xiH55LdO5BMR
sLAYTQKjF7j2+afnKHyfnl96HAnirCY3l21pR5U+VaT3SSSoz1ZxFhhuQfZX
bHusbpJAoGDJa5nVjHijuRT6UknwkvXA6blREyq+lRtpmE6CRZDPN5JpROcL
DadrMkiw+wel95JoA1p+8t8RtWwS8DVetFU5WIfy2qJzCnNJcOZzbeD8xRr0
/T3b9kYBCZwGBnZQFJ+i1O9+1Rvuk8AgLKNxseoJAm4xseAHHH95qHenOlWg
GYEa2tJDTn9d4wePSpWjOAn7QWIpCQIUDZ9sW3yMNBV5VKfKOHjZs9ytJ0rR
G538OJsnJLjeQ1vn//YRUrD6aHKshgQbrQlt+RtK0IB7bEF9HQkObor4ed63
GPnTVHg1G0ngH7lu7tNsEZIKHXQuaibB1ldT79dduo+eJ9IbpdpIoCCYOt0h
dQ+RcrbvSm0nQSXVfpTxrgBte1R7WaCTBEIXeASult5Fbj2rtJd7SaA395L5
LiYfbRy7k0xhk+BA8H2pwqQ8VPbx2I+ZQRK4bXkllnUvF9n8njtt/5IEUmtS
Zyp7ctCqdfHFL0Y4/dmXd/75l43ubVXbcOI1B08L0cVgvWxkJjt0sekNB/+T
/GsDwrJQ1uGdex6+5/g9Kux8AjEDGZnVs/ZMkcCrVEzLX+82+uzg9C5thrMv
P+fU9u9MR3oBBWkRn0hgHNnX67L+FpqMPr608oUEFT+PCWZuS0XRaZ/N/b6T
ICjfRNVALQWNVqoLOy1w5rUrzQiIuYGCnr0kDi+RYLWAgN6tzmQkN+TffXKZ
BH8kOuUlRZIR/UdDhA43GRyav3r9a0xEEjwuU49WkWHffOZdbdlE1Ca49ogc
Lxk6PdNdMq9fRyJKpv9E1pOhf9RxowQrAVXrfrW5tpEM51W7J21XJyCn44lV
3IJksN9d8VMsJh498hjx+yxChrabgooGjnHIkn55wGUrGXhd6XVxybGIK2yX
yisxMlh03vtjMBiDTua6zj2TIENGq61XpU80+vWIzwRJkmE+wsP56vNr6HbD
/btl0mQQcThnX6ZwDc2NfXPKliODZrRTTCt/FEqcS2rYup8MiseV+t6FRKJD
f7QkYhXJ4PXygc30mkgUuS1gxF+VDIL5lht9d0Qgr9zrG2Q1yLCjQ3jl1p1w
dFLpLu7XIsOY0JobAdrhSOVpNeXyITJU0h/r9PaFIZEjffl79chQJCnVZUAM
Q796JofZmAzlRk9w0uYwNGK1tD7AgAwSY2bmwbWhKIMoRRk0IsPCl8XwU5Kh
KPC3Zv5VEzJMM5/5NI6GIOfQ48P7TMlQyn9C+HdKCDIUdFg/dIoMKpkbVndb
hyC5NF8UZEYGE9X9u4WkQxC/bCRZ4TwZdteQ7LI+B6NPJbfzXlqQwfOj3F2L
umDUp1P6knWBDOhWxH3R68GotK2NX8mWDGIH7RvrLwajpDOv9EbsOXjsGGnU
OhqM6K+/kEKcyMDoEP/oKhOMLrivzjvgSoZFo1stamuDke73bS9H3cnAn9i5
JuYTC+26osgfRiDDy07Hq/YvWYiHz0BPxZsz/4YU3rQWFpq8bk56TSSDQlCW
k0o5Cz0T98wNp5AhnbxWV7SQhe4VXB1S9SODzNfvG3EWC0WrJa17QyfDlbi9
Yrm3WIhYV6Ab6U+GNztrLXVSWMjsWC1R/QoZgqpJDJ5UFlIf7M95e5Wjnz/B
XT/TWWir/dSLKBYZorK2HxfMY6Hf//3m0wwlQ+Mwf/i5YhZ67SugOx5OhmeE
LUVN1SxU90+aGB1FhmazK5dtu1goO0o7RyuGDNGTC6fk37FQyBbTFxNxZDiq
83WzwgILuWU58sVeJ8O/C9tNvYWC0bH9NJ2DyWSw+X52+y+lYKRQEeUzeZMM
e9XZ2v2ngtEm/czsuFtkSKu9vW69bzD61vl48NBtDt6/7VIepQWjQfP2tVOZ
ZKj5EpA72BaMKsZfH0rI4ei7Lzs/dD4YpXp989bNJ4OzLuvdy70h6PLCmuzp
u2SgX9a4+M42BNmxtg9ev8epXzqhUXEzBOlvPLAWPSDDW9tFBcqLEMQrbemd
VMrRx/W04/y2oWjmgVcWLieDk7ZhvNTdUNSpHTQw+4QMG82tnVPnQ1H8yXsH
9WvJwCI++KGWFYaoI3Vec/UcvkhOV+8shyFzl4HMm01koOReIm6xC0c7/JfX
fH5Ghr48am+ucgRaWS10MLWDDMqbeM/J5USgd3F7vI50k6GkTbyUKhaJ7uSf
ZN9ik0HOcUDMdHsUilB2XmP4ggzrU15j67wo5FlN1/72kgyX1zq9Uta4hpT7
szKMxjj756nWgJ1XNHrV3W459ZYMSh7haw4JxqCwjq/CoRNk0M6PGRyojkGv
myG8aZoMEy5a7+7uj0PhDR76jrNkWFbSOpf9NQ6p1sb/+TdHBoJTg4aXfTyK
qHhH1PvO2Q98fhV2uglI7THfvtc/yWD36o7Og9IE9Oah8qT/AhmMwytFopSu
I/XCQMvKZTIszS3VrNFORG/zC4Qt/nH0k39e+1BbIorK6eua56bAwAu/N3LW
Sehd2m59tbUUuFJ/2vL6rWR0LcX4T/86CizuG55uP3oDaSaTykkbKFC1PqZW
ZekGio5tkC8WokDNSt3NM/4pSOvazPsTIhS4qP+79KdxKpoIF8z4KEqB0Fm6
aK7kLaQd5CAsv5MC5SJEh+M/0tD7KxFdzyQosH+X9hbip3QU618S5iZJgW/2
ac3ff9xGk1SuP7myFJjZS1vjKZKF4khy5QbyFGC1OhhZFGWhQ96nieP7KZBc
X7jn0/FsFO+W9V5ChQJHvU2b+3NzkI5z++1aNQpMmglNCNjmoin7rxY2mpz6
HqXGL3flIV0r6ErVoUC8B8tWqyUfTZ/3CNNGFAg4XKvJffcOum4WDy+BAlwf
V394knwXzRx/VyZiyKknNHepLrUQJRrzER8bU0A4OOZjUsk9hI4qy5sdp4Dj
mdhht6H7KAkF3o47TYGV1X6B6WbFCOsUWCidpUBG8Mzc/L2HaFarT6j7PAXU
Tvso7LxWgkBldxi/NQUOifWbC20pRR8VjaHQlgJpmaXdBbOl6MY+0m8jBwqE
3xxW0et6jOakG3xCXSlAe/5XxLGiHN3cPSMn40GBWNYjYmJDBTIQF3zfRKBA
PzvhFP/oE5Qi6mDBRaJA2Fzy0RJUhQ5vjhDKpFBASuxb179r1eizQEmnnh8F
Xry/iF7O1aAj67jgkj8Fqskhhdqf69GXNXK/xa5w+HzQGd3S3oBu8Zwuq7zK
4e+hw9vFO43o659MuV8hFPgbGtJsE92M9rkWNbmHU4CiGeLCH9yCXHoqbUYi
KeAzp0yoC29Fw1n98TWxFHCYWCQ21j1Dwvxv9iklUCC7gS31+3s7OkGdbclM
5PBvVtuw6WAHaji6aomVQoGsiIqztv+60O9igcSftygwvf96oRCrB6lv26no
dpsCo+5N9V0b+5BPkNyzl5kUaPyhv7l8qg8VzKo7HsuhQMux0r2RXf1o4qz+
n6o8Tr25xE/iDWy0s9Y0WeEuB4+nP6bMmwZQXJzbc4EiCjyu/6/k+q8XqH2R
4hxUzPEHmaT8cN9LxON09e/3Eo7ehUkt+eRhpNt57abLYwp4OqbLlnWNIJp6
ispQOQV2r008qKT3CnEed51GlRz9et27e7XlNZrlfeT6tIoCuN4sW9HlDbIb
eZ6aXk8Baa1LVzOX3qEUgyG1TU0U8Eiicu36MY7Y9ye6r7ZQYOKA+13C8gTa
sOWL+7c2CrwdFvVLEp1EhgF/uJ2f/5+fPdxNBh9Q4PTa9MFOCty2nPyqyJpC
VadFNA17KIBcVa/JD00jJWlFgvwABeYuBFrGN84ij+iDq9NecPQ5IK+zy2YO
5cwfzdgwTAHx4f2HI4U+o9d2ZtoBoxSgr3mt8uD9FyTabsf+8poCErEpBMPZ
r+i0iqeX41sKED7oj+798Q1F3aLzDoxz4gJPl3I2/kArXvGHKqY4fBO+x/hd
nkfaQ+mDe/+jwIlLtmYJA78QBRf6pH7k4O2uqzCgv4iKCsr51n+mwEgGLp1o
X0JTQk05l79SYP2Pu2rhhD9o96Ue3c/fKfAP+ynfk/uLLkyODtnPU+AUF3n1
hTX/UHfFD/7DvymQv7i36lECN+bdzZVftkyB7h6nW0NlPBgiN2DZfxy/CApF
a8ytwv7ft43c5KaCif7Gv8cOrsFl1nuo61ZTIXGLo3PRbV78uUVl4yVeKvRn
9EaJ7ODDckro7hwfFZLErgvbPF6H07ksXvVupEK3ad3RQt2NeOiis5++IBWE
Ll0rlVEVwIIDRIHHwlRoRMyOynxBbKJ7uVBmCxVYxiUzma1COCQ/4vCNrVRQ
j1EOOvRbGNdtSh5bu50KbwVV3LcdFcGL9Gw6cycVbLkaumbubsFeJlX3bSSp
oPrs24GOmm14/ID2jlUyVOhTD+axT92OzbdURBXKcvpPnu1cSNuJu36r/T4l
TwU5D7GXDc8ksP67Rxd/7afC0P3zzqLxu3FF64GRdCUqLNb2el8ZlMQK9x8Y
H1ahgk6a07SEmjQWpRXujdekQu+zinUSxrL4mvXem5oHqdB0PprBWiWHufTz
ecd0qCBykaqm/V4e02SlacGICrrDooWWs/vxx/XZH+T1qcAXMQiHdyphh28S
5/sOUyHD1OflGaSMh4bSW2iGVGgtz/OpCVfBDdkpuc3HqbAv52fSHqI61ggX
3Uw4SYUrXxJ7RIU18T2vJJbgGSpYhC/Kqgxr4d1mwt8rzlIhLqFDKqTlIE7W
ine0NafC+ZdNHq6jOphffFP/Kisq3Hr4WpYujnAgTzTcs6aCVjk77KUxYEJ3
+K4FByo8CVfkSxc4jN+Wrom77UyFlRJJiQPZR/C5lOCVw25UOCAR/0LtvCHu
uMLtM+tBhZ0zIe4VSsYYO18di/ekwhfDCzHrVExwmfHfE1o+VLAKGvjYZX8C
71O6VDNG4vT7K0ToZ91JLLJES9tHo0L5YOUXXkEzHPnmJ38/gwryk09S/0s+
i1eaKf70S1SIt9qCRvXOY9/Cr/+JB1ChYEtb9SS/Bf4v1seqJZAKg0LirtZc
VtjOd66dEEwF1+5SozFJazxoRdAWCqPC+xP7/9hQbXGdjNtWu2tUeBFrbrNg
7YjV+CfDVsdSYVsZD8tt1AkXfHH8dS+eg88xy+ZCfxcs8eKt65lEKuyOVh5s
x244scr2xUIyFdryBOQEFT0wX9arIxkpVFDedvixqCEBB4RalR1Jo8L84bPC
LbFe2OP0+cSELCq8tHW5qPmOhMc0Bni0czl672d+CraiYLMdZyhv8qkgnli+
/cRPKm7n6h0PKeDgPeVfE/TYD+tNnTiz/z4VishDxea36Li0s6Oh/wEVnMrx
SShiYrlHxsqMEir8OSixbnnuEha+fESgtZwKh5RnfjwKDcQRjk0BnpVUSN0f
WrxpKQj/NYTPQtVUyPuiRpiKDsYUhTrbyloqLEx6TH8+HIpnhHS77RqokC5w
jCkgGY5tF57qrmmmAvMcne20NxKzX2sV3W+lwmft5UDtC9dw7V21a4sdnH7u
12a9ko/HTUvJo+Ruzn7QGEjRYSTgtuOL8h97qRBwLkAl4d113HH7AtOFTQXP
vzeWMl2ScM+XmvaxQY4fHVS2Id4bmK2/a5vFSyoUW/kMmj27iYcSg9z7Rqjw
URxlDBam4jdahrzNb6hw8cyp3RqvbuOJyILzuuNUeLBH5pTY1iw89Yo/v/w9
x3/n8vZePJ+NZxW9fypNcfygnpuRUJiDv1ztPVwwQwWvdTXcySJ5+Ge/SqLk
R47+UqanvG7m40XppIlbnzh4HXAz4FW7i7naLYNivlMhtnzl+csn9/Dq7dV9
vPOc/eKwZw8rpwjzeYnvDlzg6D+hSby9oBgLCU7UUZapkJMyl9cZ8giLOh3Z
NLdCBZv8rwT10lK8veyOrSu3L4SY3d1X/OkxlrL0XLbg9YVo9yzBbzEVWPZe
9/F+Pl94NJbes/TtCd63fCDNZL0vPBdd8yPO6SlWy/p5UE/QF3orRJvIbjX4
yMwVutR2X9DcOh5w06cRGx9615a20xdOqqfHXjzahE9EG4hu2eULB189FeGW
aMbnldeWr5XxheVz62zd+1uwGyP++5yiL2x0sjJ9va8dEzq+67sp+8LPtUae
c0vt2Gfn+YS3qr7AYHl9zmh5jmkNYspsLV/oUvmiY2/Sif2FL189fojTb8jC
RpPVXTjA5U1Pi64vJBpCZuKTLhzOl+v9RN8XUqIHhIr4enD0hTW1ykc459UU
nUbye3B8kfuGe4a+YL/x8VYpnV6ctPLcWvoYp99/bjZ27b045bTC/fTjvuDw
ev1QlWwfTs+J/b3lpC/cWPBcVHLtw1k/vx6LO+0L7+/X6cVk9uGClPKZoPO+
kJrOmFTg68dFs1u1/1j4wmjOzRcxmv24RNc/3PcCB297vw5Rx35cFvt66JON
L9B1zs6Ph/fjp++QrLu9L7zVPJO24X4/rlPN9nvn6As/cu1YFR39uClkVauV
iy+odg27c0/347YhV5EBN194+m9rkCAXG3fItTufuOgLV+YbePlE2fjGnN6h
p56+oJDqNf9Yjo2dSx4Lyvr4wmpL40sPtNlY2Vd++jrJF3bbXfTeasjGy1qZ
tf8ovsBVknVc5AwbP/8jkuTl5wunKz342qw49eqjCCN0X3jpHjdi6sDGTsFc
+ob+vuCz+59glwsbHzCibX182Rd0I5aX7d059fjnPu266gvx7vK9ez3YuL3H
sSU6yBdyW9IigRNPvv7y1lKwL/TEW39r5eQ7mZuS3cJ8wTIgM5TNqa+0vdlo
IMIX1NT2XbpqzcZ/xrQl4JovLBipVU+e49TLLv5ZFOMLrT1mH7aZsnGSq0yn
WDyH76/fzqocYWMH+VvZYdd9ASn2ShkcYmPFTwKMH0m+MJKlrGV3gI3bfP/I
dKf6wpk69y9/OXglapP/HEz3hc2zC3ez13Hyl6f672Rw7jeaMhX/px8vBbMD
AnN9wW3+5GDYGAd/I+Pzn/J9wemCb2Z+dz++vr5u/4UCX2jT1dSH2n6skFg4
rPbAF2DH9g2Caf3YLidQdbqCowd/7lwes368z+0X37mnvmDT0vrpM+rHC/Je
bxuqOfgJ3b6TuL8fxz+yiL7V4Av8tVKzYqv7cXOD0pRphy8k+FiFR5X2Ybm3
r1PLxnzBc+xSqcPaPvxtx0Fu1mo/SG3sNLpxoBsvWu9+IL3WD4a4vt9T/dOF
udLXWrWu84OFUrYNqa0LC+4cKuET8APjaSNqk3UXVt5JdYgT84PBmK+5VkGd
mLTzQX26kh+Ura78Qi17jhk2SZ5IxQ/6+mdXlBnPcWD6pa3v1PxgKUV27rDO
cxy/04QofdAPPrwtenCmvh2X7JyWuHfYD1yL9Q6b1j3DX3ZKBjyx9APlSSW1
LQmt+JcN3z4raz8QmDmlVmvYilfSv7z4besHq/aUDuj8acGbxOsUkbMfWJ0x
NL3h0IKVxK3HWrz9ICvkN/n+jmasaWsQ6UbyAy2BEL35tiaMbstr8FH9QN1k
a3YbqQmfFF+MPs7wg/VSdW9G6huxj3iyLpvFqX/UOaTTpAHTbC/PUEP9YHS2
vLmCXY8DbjsnbYnwA27B59keG+pxrLjqnGWMH0SPOgsS/GpxsXhv2tubfpAU
3SstJlGFP4mv+zNX5AciLW7b58ZLcUjHYJjjQz+gSGY8VeTh7Ft6lvDQIz+o
cDNaLSr1CBv3ae2rr/CD85HfecZai3Eey80qocEPUkz57Bk/72KdA6of1jT7
wYzIL2HGmTuY/eovyb+Vc34fySS4Mg9zaSRHOHf4QbD9gPja+9n45riDyHCX
H/i6aqUEH8zCSrEKWSd6/eDKM/k7fx/extbTzU80Bv1gU83OK4KJKfh7Ytzh
e0Mcfmxf7KvWvYEjwLpXYoTD3+Yz2GVjEt71SdY68ZUfBHAJBSetuY4rUr9P
rX3jB0+kjU+e3BOPTQ3rKJff+QHLaOWbzHA0nvweufJ1ghP/Oi/94lEkvpR5
Psr1gx/0n1t+83kwDAufkBQdnebUv9v1dA0KwYWLc9knZ/3ghNTsGtn/gjDk
Vyo2z/lByGpm9WLuVfzyTMhTrS9+IGv7YcfC9CXss3LqaNE3P+DTf7/8N4mB
19zf0b/7px9M3l+p6Mv2w+kW0zbJv/zgO8X7MXENFauufjyzbskPaBmX/tN7
QsLPSwJ8A/74wddjBXVadt7YwdaE68dfzjXZK/Z7x0X8a51otDsXDYIOqOHa
O244pmJ862seGhANlR++m3TGMs4Pck+vocGQ/IWxEaYjrhZgHmhdS4O0k2ev
366ww2Y1R6oP8tPgX0rKpeV/F/B/HoJGxRto4Lltw4hlvQUO3PKaLSVAA65r
s4U7ps7hrU137W4K0eCm11VdZ3czXOxDnV0vQgOxY4WEYa3T+OgOTAsUpUFP
aPnG9Wkn8Otn/Dzz22jgnMJPtsfHMNV3KObiDhq4zqT7uJkaYn7JHLE34jTI
MPJQbX1yGGd1e+eb7abB2Ki5P5uij7X8D6o8k6KBvGbgUtMMwj2ya2p19nDq
Hdoks8ddB7sM9BmX7KUBu1qKYXZGG/+5mj4os48GxY4P1XtSNfB1BQ+HVAXO
+W8J94bU1bD8iNrcxgM0KErT2K6wjfN9EPqPzlKhgaSuuW+tnxK2UO1ctaBG
A6UfwkqG+/bjz29uxHlq0qDzwex2S5DDodecdrzTpkHM5jOOm4v24J3aSnfP
6dAgMjeRR8xZGj+eXFJ9rkeDkxdIbEsbSWyS0FqnBzQIm5jj6dq1C4/rJZiU
GtBA7hW9IefTDsyYtRmSPUqD0eHPWkKiYnjTTTmnNCMaTE0OplJjRXH+4Z+f
BExoELj2boSfqQhmeKmcenqCBhUPxH8ZSAljk2SfEqdTNJj+3ZFhoSWId9bd
F9pgxplHaN/52HUb8eepGUr5ORr8x7ur23ItP24QkB20s6CBreOm8+tt1uLr
2s4afBdo0HH2FlXh72rs4ph145ENDY7UD/XdHOfBmlFjCxfsaaBc/qPvNDc3
5nu83Wq1Ew0Yv9fPVNxbQaOvLKoeuNCgUkhbUePhH1S0OnmHhTsNrBpmMl3X
LKGriuzLXASO/hTmYiZyfyEzc4E3hV4c/BId33iyfiKZqyfwWSINRJPD3BtT
v6NfdyOzlsk0kO3XPMV6/xW197Vx3/Hl6OPhqjDJss/o1tIq51N0GnSdvP/6
+9ePyEtKv2WRSYPygQPmNb7/IXQ8YE/OZRrU/3BfaNOaRkK+1WHHr9JAzVr5
Fah9QJPpi9M/g2jwSJ8lKen4HlW0ahzLCKHByuFDTIGacRTxmXLPKJyDj7LE
85P4HbqwtWT9t0gO/t63dpzvHkMK8MnrVjQNhnnHJbttXqEVj309h+No0J2i
eN5RdgT1Jbgf+JRAg22y7+PlZF6i3Kq8+BtJNFjSnvj35vQLRHs//g3fpMFl
Z8JX9t0BZLxh19n/UjnzzBv/G5Bho+0aNmXX02nQ+v6ZqUxLH5qzTd2im0mD
DyFL/4ZW96K6sCHah2wazLGrE82fdqH4h5uHY/NoUFWnUErI6kBOw6cPat+l
gcSQ5rsj5e1Igzv21nghJ15pLZb8ow3x7ev8E1VEgy0O975dsmhFo2Z8tuoP
OXyr6Z0NGGtGAXmsXeFlNPhKU1bOPNyITnfXByo/4ejj09QtR4kGJPVreXzk
KQ2y1ytVft5dh35KHDocXMPR74lv6zMO1KA2I3qeQj0NKLcDs0Vcq1AKqWzN
UCMNDGa3pn+rrUSE1G9uV1tosHv+n5Os1hMk8NFTnv2cBtIPetvarpahic2F
UZe6aKA9bWNz0eQxKtOd+ijTSwOjPfvWte4vRWGu0qY9/ZzrBhO8JPkIWcY6
FNMHaYAn1ATP7C9B+57cFpB8SQO30/p9V6KL0fLbUVLHCAffjEHao4kilKVy
Xk38LQ28pGJU1k8VIsqF60lt4zT4srFZoTS2AB0J7p0nTtJg7a+jlIKTd5Fo
0QYLsWkaCFF/EKVl7qD/Bo9VNv3HOX/DseTqxnxU8zdMzGuO4+9zIkhvXR6K
lW3x3/KFBuv95J2Wt+QiVQbS8/hJgz/LsfR422yUuNEhYPIXDfoC/wQv52Sh
nzlB9Q5LHL/LHEDsqUxU0d2ib7VCg5ymjl9NLrfRVucp1gsuOsQ917HWxemI
sbi25cwqOqyPatSg7UtDOtLHDU346MBszaB+VkpF6ZVe4W38dIgRMDfChilo
xTS23WAjHXr2B9pTCDdRA6PfREeYDuT8ayzroWQkuenHtScidLgVc3UsZ2cy
YuWKdKttpcOGZq/5Oa8kdKTH4pTCTk68fFuTsnwiyndmxhdI0MHKO7t/a9J1
xLt0q19Gkg5HQiy7R3mvo3bpN2fFZelgkuhmqcyTgOSf/ktKlaPDbATPvR+R
8SjqpOTQlv10KFnVcP7H1nhkynSx3KRMhwhtzTfZUbGoeFNYapQqnbNv+qak
2mOQYN7dUV4NOqxazPXOF4hB7J5Zm38HOfPfoinkVV1Dai4bMi7p0uGM3eb5
A+LXUNKS4tsFRIcal8ZDr8KjkLkM2fHrYTr01u/u+0eNRE+eXs/xMqTD9wsy
bQ0/I9C2U2XvZ4zpcCNEsvTA5Qg0ylxwHTelw6Fr0Z/e3w5HOgJid21P08H5
9GB2mlY4Ss87NDNiRocri+n+H4bCkH3vFQLbgg5NHrGsw3vCUINL5v2TF+jA
Xb1T4ONAKJL63TDXYUMHCd4JvuPhoSg4bkLRyJ4O9VWKsRo4FE3KrCY2O9Jh
+9Ldlqt/QtDRqj0l2IUOSo2ND7hrQtCdU0bfqt3ocJ7uuJIcGII8/KOoZZ50
MHuxZOq9JQQ9FygqU/ahw82RhXnyh2C0L797vohEh5WhXds3PA1G0Ye+aMpT
6RCsxftLMj4YfeoVZOT70eE+v2x9GiEYnXRVfSrJoMNAdHOMs3EwKvl99vdt
f858GfeMXOWDkVC8n872K3QQWLkfHbsxGFH23Lx84ypHXyl1eT0/WWigqrJW
mEUHRkIRUfQtC6mfHl2JDaFDcouGuWUXCyV/+IPXh9OBxkrUjahhoV/+4kHh
kXTo3nGclvaQhSwEcdOqaDqsiUHVEfksVJnvsCowlg6GB+bEjTNYaLsO68hy
PB2ujvTyDKSy0KW+3FBGIodPPLJNJoWF8l4Om84k02Gyp1p+Pyfe82ajqGUK
HUQDGo8PpbPQ4geDN89u0UH/3n+L0rksJPWJfkfrNh0Kdqzr2FzEQid+Fvnc
zaRDbdp53ztPWMjvz7jm1hw6fIivfTbWykIZPFv/heXRQXxkbXHNEAu1rzvx
7NcdOsx/qtxnNMtC3wWD4twKOXraVW3N4gpGO7ZVWAzd5+j/aru/r1gwOrLr
4y7DYjpYNyS/ldEIRj6yu2fKS+hQKF/Hk342GHEeGyV7HtNB7QQ56L1vMGpU
j2Ikl3PyV09K8qYGI5HDP/n8quhAwWt6Ns4GI2Qi3z9ZQ4f+cAG3TVtDkPsZ
u9Rz9XT4++qXoaRRCKqyb5dXb6FDVqn+36aSEDTp9vdbbhsdFHgf1NBnQ9BG
H9Wqzc85cbVjxVF7Q5HD5XSTH910iE7jfypbFIqigvuFnfvoIPnBljj+IxQ9
juJ9xWZz+KZeeGiLwxBvKsmz9CXHn09s5QQnwpByVr6a1Cgd7rAhNPRgOLK6
O/on4TVHX4mTI4eSw1FR+ZFo8jgdTlBM/i1aRaChGua58fd0uCY7O3G6OQL9
ay7eeWaKDpnqN7aEq0QiM/a2B8of6ZDN2zl/VDwKXR4x9cv6xNH/S1KjcloU
yn/H0hP8yonjxxZ1EtfQ4ue57i8/6fCe/K09Tyua83ySvGG/QIdq1Yk2Wnc0
Ov7X3K53iQ5Pa4f2vLkYgzLWN34uXqGDmLVHbsiTWHRELlnAh48BiQmvCi1e
xiOfAx0vx/gZ8ML08b4OSEA3Nf9lmm5kgL/dqrLB4gQ0e+SisqIwAzz3KrwI
Tb2ORE5kLKaLMGBUZyz+tmgi0js70LBhKwM+/6n+fCA1EcU76p2Z28GAzIK4
T88fJqEqD4qYjQQDdsMnGdsjyeg98e54524GmFAvJ7LeJiPNACHK/T0MsNBJ
/du27yZyCDU8tEOOAbeLtsdcf3UTRUVf4rm2jwFa8rZcJkkpaOzWh+uEAwwI
OqdI27DrFjKQiFYWUGVAgeZr7oOr09CdbNWex+oMSPCcyan+mYZIBVfX/T3I
gMbSXTsMft9GL/bL3s3WZcDrnQHrMgQz0aGHXUcMMQNOkUSaA7dnodUVYoFx
RxigcV11fej5bHTxYIO4uhEDDlZOKaj+y0Y9NW7Vw8cYEHpYXyL1UQ5KaX78
S/IUA37xNUylqOahv4YXktrOMKCipyvImCcfOXVwqXqeY8D39WYJ717no/39
pt5lVgzgztnrYVd+F8Wf+8lvZcOAlpqR9YVlBejny1sFf+04/Hj/Pne3sRDV
vZl+b+jCgGNOCdRNfEVI2ik26KMbA+QOBEzrH36AIj6o74q/yICUYyLKDXHF
yGwu6MKIDwNkT9s2kEpK0BOi3OIVMgPYAoqSs9RHaOePnmQpXwZclNn0zcqg
FE0t7ej3ZDKgxjLd6y1PGTp+pclH8DIDaGM/LH1/laESrosbygMYELGe8uXf
Qjlirq0wWglmwOyK4dt4uUr0JsrmQ04YA7Yk3S+MsHqKDDatCjaK5OjpffYp
u/QqtGHL6br4WAYwdc4InbapReSUX9YaCQxo/jW4ZuFVHRracXtpJJEB+UIT
p00ONqAsqVl16VQGHGl9zbw434jW3IlnP0tjgLbYO9/J6SZEkNcieWUwYOvV
D9tV/2tGvUVjG4WyOXg9l/M69bsFqSuH3C/PZcBNvw304zvbUOrjfccu3OHk
99mXGZ9+hlY0+6dWChiQLiBxNeBmO3qmJyFlXMwAkfx89fcunUihsaV+roQB
wR2r9yx+4rxvHvG0TXjMAMGOjJAt8T1o/pnQH40KBpDNVpr9ZfvQheOVKaOV
DNDBM6SDm/tRfY+d5tVqBjjpbcg9KsBGMmZrBqXrGDATliz4aMcA+mxpJuDd
zIBeia6HZwkv0NnXi0VCbQwocb1B2P5wCFXaZ5pUtDNgl4HBGud1w0j8/dGZ
C50MOK1hLVDhP4JYbnOh/7oZcOBiedPT1a/Q9H/XpfP6GCAUfspWvfA1OuF9
sNF4gMOv3tuiTYQ3aItv2HLCMMfP8+2p2TLjiM9FyH/dK45eTql1HZeeQMtn
0xcCxxjwpGhBXV/1Pfp6eK/f4lsG8P+54phpNokm1Uq/Eyc4evoYdDUl9AMa
ltYjTU8yYG9A60ffrinUtbn9k900xw8Ta94lyc2gsh9jM6ZzDOANsk3Lkf2I
Ct57uLV+ZkBltqrSSOccSh/48V73Gwfv3g6D/6I/o/jmAMeyHwzoL7M9Manx
FQU/Xvd2/y8GVEfvW3tM4xui5SbZ5C4ywFXjKWo5+h0REneNbv/DgCZhj/+i
PX4gM6rGi3VcTBDr1zGynJ1Hhs4NZkE8TBCIf2Zy5MQCOnT2eN/iaib0+64Q
z7UtIqXDQ6aktUxoC4wEowu/kaSaY+f0OiaEil8U/rtuGYlIzxnbb2CC94bH
Jf4v/yK+zfS2oU1MSFIo0Jlr+Ye+fo9ubN3MhEteb5NTV/PgyYmtWE+UCauK
Nzpmq67Cw+ycmrJtTIjYSBMf91uNu5oUDynsYMJ9nTrNj71rcENp5ZNccSZ4
Tgxrkw3W4rKcwxo7djOhKGLipGEvHy643lN6XYoJZnbPfjky+HEcZfJB0F4m
hPW72wrLbcIsJ+L+JXkm+Mus5DwWE8Q0s98FJAUmxCuvEj+qKoQJBqGyM0pM
GBuNf6RgL4ztVAXz7FWYUPvzAfFX9mZsJpUm+VKNCe8299aaLotgQ2HZzJOa
TKCXNv/3jyiKlb7r3NLTYcLm6dHLLvfFsNRE29ZyPSZ8adNT86PvwKLsM8kK
wISFhadqea7imL/ptXCeAROOKDz4eYOxC/995B6/4ygT0l0Gy5NGduOv2d83
JhoxYTruofHBDVJ4MuHKNX4TJpzf25o7eV4ad5ETw5ZOMiHT6rz7Aw1Z3OAo
sZp8hgmB706Hj/buxWVnCoNmzjIh4CmPi3qkPC7QV/9nb86ELT61b1Vd9uM0
lfrLLy05fAePxgY5K+JYSZPfJ62Z4PhIatPqqAOYJfSC3mbLBGuNJWvvT8qY
8G2WUu7EBB3zTQ73QtSw3bjfVwVXJngFEmxPLKhjs34unzx3Jvxq4j5bH6aJ
DRuvfdxBYIL5hDOYa2jjQ49ELyZ6MWFRsp+VvOYQVsrOnuInMmH5yW4erd86
WCpBwYVFZkL1k4eVSqIIryMb2JNpTDiQLRaQ4qGPtcdQqTiTCYKevlEmIwbY
45jOmo5LTGCJmFd0XzyCb5ZrWdICmNC8jadxYachbpNUvy8VxISuzZLh7+aN
8HyM8kpPMIfvYdOtMwvHsMxvhTOXwjj6vLHnXK3sCcxi71kYuMbhv67HKDvm
NH6EpEwCY5lwPZVFEpg/g9/dk7itkMAEuxqLarHLZ7Hg1h1fhxOZoMfdPpq6
5zzGwVsPh95gwpDf081FP82xz5fNN1RSmSBbE6RfPmeJM6wF/xtLY8Jx73nb
i0LWeFltXZxmNhOUmNuWLb/Z4/1ZayYmcjn6YIq4fbjgiC9s4NGIu8OEtADt
ytLXTjiSsRKuU8gEo7N/k78EuuDKyd+j0/eZQHV0a600ccPTpxcUk4qZ8GCy
8QRFzwOL1v4IhEcc/XT007ptCNgveU42tYIJo6l1Bi9ViDiP+z/m0adMcPCc
8T27SMKD3h+6vlUz4dBd3nx1OgWvGh3flVHHhA7NkUzbbb5Y1fANxaSR46f3
eTyjb/ywY+lo669mJnxXdxdZ6KbjeImX23LbmCDiq+Bp/B8Tf/7VW/enkwk5
szaJZmUBWNy5S6ighwmGEYttdhWB+ERvu8u5fib821rg56rCwpd0Wp9wDXL0
P2+l+6o7GN+728j/YIjjPzGVyLjYUDyyuc7WaoQJdQUDHqG0cMwXWFWy5jUT
2CPN1vMRkdjd8rG53ThnP0h5qh/UicU3Wh4W8k8y4eGAtbwJOR63KRctV0wx
4WVHrGDNeAKeTy845fwfEyzWF7WJkROxzLr8HIE5JmwcYEnnSybjs37Z89Wf
OfhevJJbOX8Ds8ZvG3t8Y4KlWOHXli8p+N3TG58bfjGBj+tR3aT9bSwgm6jv
vcSEKwWpn/a8ysToelyS2DITphr6mi0OZ2PvlWvTrStMmIyYSowpzcHphIhD
FG5/kFvmOuuvm4c7h0JiJFb7Q0p46geLiXz82yDoXQevP7zsL7xwMv8uttrh
Hya9wR++t4YO5YfdxxHhtJHeTf7wk35ao/HOA1z5g6JwWcgfVBv931+YfohF
uzzZg6L+EJESsuqhayk+qu2xJ0jMH4zs1RTdnzzGvnkuDMWd/vDln+cmO7Fy
zL5sKxEm6Q+3Vl9Os9lQiTsueC/ukfEHm4vhV8uTnuJG7SvsVll/mE69++Do
vmpc8jM9bI2CP/ConzrXzqjDsV6vP4do+oNDYKc6ua4Jh5nMtcsc9IfC3FTV
r3nN+Ircck6LDqe/KbM9q6JbsNfkDovV+v5wjbCnV9SyDR+3sa4PPu4PIwl7
E2a7n2ODQ56p0if9gbXt0GXlzA58aNslavNpfxAruLxJhNCJ9w3e2rvK3B9e
eCj/QbNdWKr0HneupT/oj028DMjoxmLxVa8MrDn9VZUHnTTpwXwnRuNYDv5w
4M0Rf1p4L+baN3tRytkf6ku6lbQ29OGFtb8PN7ly+tnz857Y6T78+cM6CScP
f9ioY1/jGNeHp5rFFrk9/SG7zYMq2tGH32TLs7O9/UHYznW7IVc/fnH1YJE+
yR9o4bcc16j24y7bY2HjFH/YjZgRPvb9uEXHyiHIzx+4vopGZkX04xqxi4ck
GZz5bDab1D3ox48XGCKN/v6gZ3189FNPP773IuKzwxV/cHT+Wmkx149zHqe0
cwX6ww3/8f2yvGx8K6EgJ4vlD7JDjPyQnWycQKy8DKEcvqe9DmUeYOMI03bz
d+H+sHTyw94czMaB+4eVA6M4+Ntfvvj0BBsz1s3w747xB9LjRDtBCzYmTi9M
1sf5gxqSCei3Y2O31rX19tf9oVeKd5usCxvb5W5N/ZfkD95m8VKa7mxsHrSX
mnnTH1r6HTbLebCxqb2WKb7lD4bE7U27OfEjekZ736b7wxr4738VnXc8V+/7
xxP5WIkioYzsEVoodd9XJSlFooxIShnpm0jK+5zz5m0XIiPZiYzMjDKykx2y
KmQlWSlEA7/378/zOOc6575er+frfpzrr9voCLP+gKgJCz3BHZKcMlTyrDrw
nt9XP4kluYM6Z/LPALMOrNRzu7A82R2qnjbfnTTswNsLfR9cSGXy5Prq0w/d
DiwSFmm/ku4OPrYmri9RB95489mR+Ex3+OhSN2e8uwNzGhRtQznuoH870HpI
tgMvcXW3kwXu0BIqbSPK3YFnx7883/aSmZcJhRvf/7bjr3ULPq+LmfmL3XN3
dbIddzME9y+Xu4MRWCTxN7bjwj/GSUSDO2QtVPXcoLfjA0ePW3xvcodi2Z1T
vxzbcfWDg5svtbrDlc0naLLm7bhVWvbesfdMHtVilaN2t+Nx/cWbG/vdwbiX
HmE60oa3Pn18KG3WHf7TO2fgsa8NJ00H/RWZcwdzPhubMKk2rKDJKAxacIdg
Q9VSr/VtWL3FQcHljzu85XufuVL1Dp9e1OJHbDS4riNn3s/zDnvrDQy+F6JB
G2NH8a7IFswV2RGtI0ID7bP6L8SutuDQwTrj4q00MI5/OPF6bwuOd82pj5ek
wfDE3kGezmb8KsEj116JBiYXNOlPeZrx1Nx2j1VEg8WYyqxJh0bsjIT2Ox+i
QWG1XOmzPY34tz/3/OgRGvyL1u4ZWG7A7GLzto26NNDiTo/PD27AErpvDCLO
0ICuoV5hk16PjWJtxZWu0iDEJapufXkdFrjckt1hR4PRXv7tkW51uFthN3K/
RgN3q3gJIbU6bP5yxaLBiQZGkcUXB+Le4EsdEdG2NBqod6343b5Wi6Uf/1XY
QNFAban3cIloLR6zsi4u8qDB4ddkY1pjDbafVu5d50uDRKdRFUvpGuzEUSuY
HEIDZY/2Jva6KrzrnUKKXhgNvpUGBPg4VOH5iAd75iJocKx15fHF9VXYTeq8
0eEYGozTNNh59CsxhX6GDKbQQEpWfU7G9TUOuiXBs62UBlldURFTjCKsr+Ub
U/uaBs/33uzY/6gQ862dUnSspAFveWavcXoBDn/w8njpGxqIal9bJetf4NgM
fT+zNhrUME4MDK/NxhduFmxmeU+DHLJY7590JpbQFHmW1kWDLsNipeiTGfjp
my+1ix9pwDDQ+jqU/wzbBOoZJ/TTQOjejSfui8lY1ihvRGeQBhSHuq617lOc
MUisjfxCA44PbR+6hBOxY+pw6MFxGrAcL/Ea04rDKv/TlfwyQYOHOwRYyx2j
8eye7NzAaRr8Fbb+FFv/COf93QR7Zmmwes01S88wAjtX33336ScN2L9WDw/9
F4b3BHy+4LXA1D/6qljFVAj+ZXB0RnGJBse1AjpEV4Pwq83PyY4/TN4Er9Lj
qXvYvZ9vvfsyDT47EPRPxn74QPLtWMk1BBxw1uLKIr3xikOfUsNaAoL31pQp
znviyp2HS53WMe+f7Fx4e4WOGUupJ7ZwEGBjryajZkfD2hXrP1ZwEXAke7ms
fcQNs/u62NuuJ+CpcUggd8st/PbkhyVePgK0bzopx25xxls8pOwCNhIw1lj7
b776BrbLv97DKkjAuyuXDDX6r+HisZc6lBAB200yFaed7DCXyNqiJWECslhW
4486XcHmp07KuGwlINynb/5F6yX83CMyfFqMgE+cifIjHhfxv/xBVjtJ5vod
5Vwu/7bAJ78qugxLMb/X4MSm6GyG40Rchy1kCdg4IzXIb3EOz5yqMOyRJ6BX
ypvnR5oRRp6cVYZKBLDzDDjrnzTEDwqM1Jp3EKAU7xRx7bY+Hvwal6CjRkBN
YbmraO8JrCY6zlu1i4A5pwOJQ5nHsKf+LkprLwFLHz4f3DSmjTs8ielCDQI2
D/FfGL19GEsV1lmo7ScgMj37zA5jwLfG+ZozDhDw63BbnOP4AVwrel5LBhPw
s7aghT9uHxY0SMlIOEQAh6fWYtBLdXyV8V1YRJsAZQcf1fVKe3BR4b6AcB0C
Lv6Ko2ymduL/vnkt8R4nwLP/9XjBiCo23dpqG6BHgFOwb8z0FWWcbrClh1Wf
gP09Z7NzTyvgP4xLOtRpAgLFj0ZIPJLFJ4oyC5fOEHDczHyJTUUax3z7Je1y
loDWLyw3w7i346mth8KnTQgIzdONwnIS+MDp+6x25gRcmdEc3T63FQd5dTkP
WzD7FflavnZJGA8UiQ9bWDF54f/6Ms9QCKtO2Bv2WBMw2Sr6VuWXAPbYVlBp
aEOA4pTTSGHfRtx2ekW1+SoBdpZKBx8t82FJb90EHXsCXohvK5VL5sXOLx/y
Vl0j4OHA9xEyjRtXT/SRWv8jIOy09JG6ZQ68SUxuutCJAFHG39ruaHZsY3jT
Qs2FgIQLhplxbmy40Lu0KcOVALyzMWAlcC1mf7VOS+YOkweD0df5nWvwuUmD
jAR3AlwO+XbZPlxBqWLRwiIkAfbndBL2Nv1FS4aj/uF0An5TB/Yo6v1Guj4q
S7wMAlL2H3wYx7WIHr+6YxvgTcDE7oGIt2sX0MRkdTerHwEis3xCKTvmkJb4
eh0qgIAe3xSbQZ8fKPCMSeHSfWY/6vezy9hnUZ/PE2mXYALWzJ/5+5/pNNpR
PBk2HULAI5ujjTMjE4ia2stqF0YA/xybLiNjHLWKezgPRxBwdRfHbFvKGBI3
ahyyiCJA7fz3zqC2UeTkK2DYE01Ax1POd8syI6iq+EKlYRwBDpYhU2NPhtDG
6TTV5gQCdp+3/uQJg+iSxFy8ThIBy8alIh//9aN8o4O8VcnM+i3mVYfzPiE2
Pz9SK5WA8YLzmm1RH5BxSftUYTqTN6kR5eTsHpQyLWqhlklAy8TQG6uZLvRL
4mpTRjYBboG3mwSNO9GGupqqLXkEfG74rHlmpAPJX5N85ZtPgHe4R1BGSDs6
xEfPni8kYP3AqRAHszZkXtiXfIn5C2V4nLbn8O1W5GK+P6athJm/n47Gu2yb
UeDqo1D0mgCTZJVbqZ6NqOK4ESVSTcDA5wI6q8xb1DuTe8u/lgDLaLvJzNQ3
6GcY77Vfdcz95dvCa4NjtYh7n6O1TQNz/TGKHu4sNUh6oMGko4mAZwZvWBbe
V6GDXnL60ErAate9spKySnRO3kc7u42ATY2KjyddKpC/M+y818Xkg+9Tn093
KXoiFC+31MPM70rstl7NElRS9nfb1Y8EaNTdcb386hV6b20m0NlHwH3pU3t7
z7xEU+wvuQ5/JkD8hGW/MHsRWpcpwJI7RMC6oETz/W0FSMzQeXHbKFOvQ8ll
rjn5yDBmx+jvcQLOt3LofHuWhxzg/kfbSQKua0ho65XlIu8v421d0wQIOh/O
UKrOQXH3dN4emSVg3nbb5ePy2ahINfl13k8Cujslx7rTMtG7TpYC8QUCvkVs
/Dl26Dkav2uVEbRIgKbRr9X8H+lIpFbkkf0/Zr6u+OyTfJCKdtvfCepZIWDk
es21z3efoZO83V5HWUjYy3YehbqmoCv5u93zWUk41NYwyumZjCjTUCdJdhIE
JiUadsc8RY+WZ64+4CDB1Px5NG9NEspNOmm5zEXCL1IzIGvxCRqZ+u/Ehw0k
WPK33e3zSkT/Qq/AsY0kbPqyQaYlPwFt1qhRLxQgYaN6fvNJl3ik60lJhQqT
sEtwe3CCXCyylu0TXhUl4YOF15/dIjHIvWkf33UxEuZ9Z368EI1GmYIL/3Sl
SBgSLtGoPxaF3pScmSuSIUFrc/L5fKdHaMAq95u0PAl5q0171FIiEX/Gte41
O0hg3669VUolAikaNDT/T5WEW8sqPGae4Uh7XrambycJTUecsuP7w9BtNJzz
Sp2En7zVJcdzHqIHI/iZ7D7m+5TG7F9LPURp/nGx4VokTNfz8lskhKKPHaYB
TkCCvtQb2XsZIWjOrYg+cJiEChWJOut9IYhnm8Dtk0dJcN/6PuNrzAOEbd9d
kj9BwgXlPBsl3mAU7h+v0nSShNSFmx9XdYLQePr1P9cNSLCY4m3LvBeIQqa4
H+Ybk3BKSC8Tqd1Ho+s/WZ4zIcEszfnLptB7aJ9qhsJvMxIqn+HuxD8BaPim
bhWyIuF+hqbK9jF/pB4mFDRkTUL0Xx+347b+6H7BmKm3DQknUjZqBH33Q4Nd
hdJytiQUTyZZPqL80J5F79kGexI8u9IyhQT8kP8W4zJHRxK+OGsY1+T4ov59
Uv4bbpDgVJESZWzoi3yJKvGzt5h6JT/0lE/xQR/jQiYXb5PAGUbo/Drng1Qr
rF5G3yXBoUXQumK9D/IeVPE6SJCQePOugFGDN+plWdEfpEjo2WS11TvAGylL
tYh4eZIg4cTrLq/vjTy1Y8dkvEnQZlw4KizkjRT99lPXAph+a6/Mnyn0QlQa
5wneQBICWNLWWdzzQu8begXzgpnXMpGROy97IfnJ1CGjUBKWZzO/FWMvRPC4
Zf0KI8Ga7ubVL+6F2nbo3H0cSYKsK4Pfj9ULyRgIHj3wmIRXi2uNnk4wkLvT
KN/nGBLmpJ6xSnYxUGtofp9nPAnq/nb1s9UMtD2fkSb9hAS/I6Zi6woYyK3T
8NbbpyR0gJzemTQGal6QAIdnJDzJcTVoTWAgCaFZ7vXpJOw0qvjoFM1AtzQr
enKek+AR2Au7oxiowSz46ZlsEg6rTjjxPWYgMZrljYVcEojd/dNscQzkHKus
FZXP5AUU6nmTGaju9V92rSIS8j/8idqRzUCinxs7+l+R4JqeSl0qZSCnNdHx
HqUk1K+3F8ltYqBaSXsHqXISskPPPRD5zEBbjmiq11WSUOodw0hdYKDrNv+t
ta8h4aPR6NYLG7xQtU93C3cdCZ05LOuPKXuhzakpj7PrSXD7Xnnf8aQXcqi/
dcWwiYTzd/5c/HjDC1V8O7JzvoWEOyd7v8VFeiEB7k3LkW0k+KibStRVeiE7
5eH6fe+ZflvyJl+e8UJlp/LC+7pI8LZVqfUX90b8Nzwu0ntJ+JMwfO+4sTcq
yRNbqu0nYUPxovxivTfifT9dYzvIzGN98B5BTh90eb7sAdcICd/bo27sPOWD
eDTOy50eZ/LGXlneN+SDLpoqzv2cICHLoPds1i5fVHj3d3nENAlcOQkGq36+
6ELZo3OffpLMeVGPqxb80OETemsNF0hge3QiqCjOD8n0rmTVLTL9f6elKrvq
h6bmrqx78Y+EmbYHW8Xa/NE7T+E8uVUSknR12v/hAPRiQ4tFHAsFkfNaOesK
A9BdpT0F/uwUcEq/97iQcw9ZFH+1WuGgICTRq0B4730Ex2K4b3FTkJSe39tV
eR+xX1572YqPAg4JMYnjk4EoPLqNX12EgunzsY/Swh6gO/Ler59vpWDDAq3v
pnwIOl+kYS8pToHFExEbzfshaHtHfCWPNAV2Ll/xsmUoYr94xpEhS8F9UROX
i62h6Nv0ui1L8hSEC2qnFB15iHI5r98Y2UGB25yDmgwKQ+GPJETN1CgYY+cU
LqkJQ24ynXWtuyjo2t1G0zIIR+iQlliJBgUzv7b/kLobgSTfzTSo7qcgb9lu
i8yWSMRmmeSacoCCNQqpZsfKI1HTHc6WkEMUcPcRx4wlo1A2++s77NoUhLqN
/VseiEIPw52kCR0KNjnwuR5LeYxMc3totnoU+I2KHXA9FYMOoPty/acoeLtb
lP2YWiwSb0bvz5ymYEtrwInwbXFo7GuKIjpLAf1RWWWDcAJqdDXrzjdh9tP4
nnVaIBFlsa5nKJhT4HViyPX800R0S/zWBwErCs7JYofazifINEvO5541BSL1
P/jv3ElCWlqf1NbYUMC25sdPNumnaK3JYf9JOwo+rA7+MQ9PRmOjC7utr1Fw
piXofzzmKajBOf1z93Wmvxv9vewUnqGQYD6NamcK2BsSw+FrKnLZWjus4UpB
lLfO6mB3GjqX4Rac5UbBj56GOdeOdLStbuBLFEHB8ebNY0qzz9Ea44ehvHQK
Hm9Yo12+KQuNDh096O1JwRvLwGMKOtkoYzkz/IYvBf3R3PJu13NR8P2L8MWf
gs5NJjhYPA/dFBaYMr9PQeKvO4VjH/OQ5l7aEZ0QChpYaY1eN/JRN+2w4row
pp5J02WbbQqQazUnf20Es1/PU4a7bP//POP2RUYUBb93Dws23i1CLwyiBg7F
UFBzz6ZzOPYlOh1p9WZNPAXO/Jf7w9pfoe99spkViRQwB5LrHMIlSNmh8O7B
ZxSYPbAbOvulDDXmEhf/pVHgWvGPc9GxHNkvHjlW+pyCsmXzX27slYgDcau4
ZzP5qAo6dmukEj3z7hDYl0fBHoHqJaPWKqTd9PjvYj4FJiw8+7nrq9EIv/Vw
URGT3/5K9cT2GiSR8D1nTxkF1dGL7gNb6lD5l6LIuXIKaCVhKn9N3yJLZYp8
UUUBIz9h4HNWPfrnfNTmZi0F+ULz3GzCjSi6mEdP7S0Fi7K5Xn9jmpDmms6d
3xsoODxSEH9HswX16MRsyW6mYPPwZK7+bCsS6FQYU+qgQH8hc4XVsh29EPnR
PNFJQVq2dLucXQcytH6Vn97D1ENUsdbK5z2aTaVH232kQDfhmtBKYScKntHx
lOunoPCAzKkbf7vQjr28dmOfmTxlXNA/YNKDmmld+inDTJ7M6l7zNPUiTk6b
rVLjFKg6vHFYZelDaQZKrMMTFBwc2Gi2vaEf6UT+/JY4TYFGseyJ07mf0Ze+
4jarWQoC2Zk7ct8g8pbyfCk2R8HgheyKc/NDaLuDbnz/AgWmJUpXn4kz54nc
DT6xSxSkcOWN37g4ilYOxp8RWWH6G5KRp6jwFcV6X9n3YQ0ddtwNs2kvGEda
TcoSUax08KzP6L5kOYE+8s+zm7DT4fdMsKSEzBS6Y1o6LchJh3PN2WV3eWfQ
5gRGZyc3HWqOLL3h5J1FhV+Ol4bx0qHiwckUG/kf6Kdzrz+/AB0CVbpYNsfP
oZDihBttm+lgKjL1cOLfPFJdY3vugTAd/rzN229w+xdq1VE5qL+VWa+QJHGV
Zwk5Bi1IrRenw+wjTkd61W/E1VnG1SxJh5xvn/S2Rf1F6SLeP+5J0yEpjMti
6eEyGkvdWMGhSIeUN0++laxhwd4zH1LeKtOh85ui+8jBtVhq75NAX1U6yLHr
nv0cxoqraXYuR3fRQdNRgl7Ktg5frFY1Z9tLhwsQpffiITte4ViEGg3m8x8i
HFWBA8cZlMsx9tPhww+hi50buPCBSB/eQwfpsPxyxzGSjQd/7Du5sIrpUB1Y
paojyYv/D9tyLL8=
       "]]},
     Annotation[#, "Charting`Private`Tag$55418875#1"]& ]}, {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"\"", TraditionalForm], None}, {
     FormBox[
      TagBox[
       TagBox["t", HoldForm], HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[FontFamily -> "Arial", 18],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 499.9999897959184}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.903099456685218*^9, 3.903099517714164*^9, 
  3.903099618353531*^9, 3.903100208091414*^9, 3.915152753957491*^9, 
  3.91515278619316*^9},
 CellLabel->
  "Out[210]=",ExpressionUUID->"2684a0b5-812c-4d80-8edf-759ca26ab29a"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.915153315145341*^9},ExpressionUUID->"a5db2680-d3a7-4275-93e1-\
00755d22b8db"],

Cell["Figure 4c", "Text",
 CellChangeTimes->{{3.903099634684742*^9, 
  3.903099642799465*^9}},ExpressionUUID->"49a5d3ca-0f42-486a-833b-\
448c803a79d5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A0", "=", "0.8`"}], ",", 
      RowBox[{"R", "=", ".14`"}], ",", 
      RowBox[{"g", "=", "2"}], ",", 
      RowBox[{"k", "=", "5"}], ",", 
      RowBox[{"m", "=", "0.03`"}], ",", 
      RowBox[{"a0", "=", "0.029`"}], ",", 
      RowBox[{"h0", "=", "0.434`"}], ",", 
      RowBox[{"r", "=", "8"}], ",", 
      RowBox[{"s", "=", "6"}], ",", 
      RowBox[{"\[Gamma]", "=", "0.8`"}], ",", 
      RowBox[{"rc", "=", "2"}], ",", 
      RowBox[{"tmax", "=", "500"}]}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"sol", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"A", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Gamma]", "*", 
            RowBox[{"A", "[", "t", "]"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"A", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"A0", "*", 
                 RowBox[{"E", "^", 
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"R", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "/", "rc"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}]}], ")"}]}]}]}], 
                ")"}]}]}], ")"}]}], "-", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g", "*", 
              RowBox[{"A", "[", "t", "]"}], "*", 
              RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"g", "*", "s", "*", 
               RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"H", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"r", "*", 
               RowBox[{"A", "[", "t", "]"}], "*", 
               RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"g", "*", "s", "*", 
                RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"H", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "A0"}], ")"}], "*", "k"}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{"(", 
            RowBox[{"m", "*", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"A", "[", "0", "]"}], "\[Equal]", "a0"}], ",", 
         RowBox[{
          RowBox[{"H", "[", "0", "]"}], "\[Equal]", "h0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A", "[", "t", "]"}], ",", 
         RowBox[{"H", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", "0.0001"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A0", "=", ".8"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A0", "-", 
          RowBox[{"A", "[", "t", "]"}]}], ",", 
         RowBox[{"H", "[", "t", "]"}], ",", 
         RowBox[{"A", "[", "t", "]"}]}], "}"}], "/.", "%"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "500"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"ColorData", "[", 
          RowBox[{"97", ",", "2"}], "]"}], "}"}], ",", 
        RowBox[{"{", "Black", "}"}], ",", 
        RowBox[{"ColorData", "[", 
         RowBox[{"97", ",", "3"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "->", "\"\<Arial\>\""}], ",", "18"}], "]"}]}], 
     ",", 
     RowBox[{"AspectRatio", "->", "1"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.903099939567787*^9, 3.9030999397763577`*^9}, {
  3.903100213400772*^9, 3.9031002404436827`*^9}, {3.9151528166220217`*^9, 
  3.915152817236246*^9}, {3.915153310083077*^9, 3.9151533105831137`*^9}},
 CellLabel->
  "In[213]:=",ExpressionUUID->"6184f4bb-bcc3-4262-ab92-31b9e11f5f30"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13c8lt//B3AkDUUZJSsjQkj2Pm+y97jtlRlSRlZCNIymrGxaVJ/MpJSQ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       "]]},
     Annotation[#, "Charting`Private`Tag$55858536#1"]& ], 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk8lN/3AHAhWUJC9j2ihJBScY+dsY0xhhkka5TKnrIU2dqkPlqEIqFQ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       "]]},
     Annotation[#, "Charting`Private`Tag$55858536#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1nk0Vd/7B3AkUqLBLHNmIfP8POZ5Hi+uMiSKzFIhSqYkKZQhQ0UpKimU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       "]]},
     Annotation[#, "Charting`Private`Tag$55858536#1"]& ]}, {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"\"", TraditionalForm], None}, {
     FormBox[
      TagBox[
       TagBox["t", HoldForm], HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[FontFamily -> "Arial", 18],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 499.9999897959184}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.915153322758645*^9},
 CellLabel->
  "Out[214]=",ExpressionUUID->"1c8dda66-c811-4d58-a736-409eff2da4c6"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.915153302010476*^9, 
  3.915153302155384*^9}},ExpressionUUID->"4b571fdb-59d0-4e58-b692-\
f0e581b6d039"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.915153305663872*^9},ExpressionUUID->"5b85407f-a1ca-4e95-8468-\
862df71595a5"],

Cell["Figure 4d", "Text",
 CellChangeTimes->{{3.903101593666542*^9, 
  3.903101595196553*^9}},ExpressionUUID->"78f73743-a840-4d2d-a1c2-\
1e3c7748e20b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Gamma]", " ", "A", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{" ", "A"}], 
          RowBox[{"A0", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "R"}], " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"A0", "-", "A"}], ")"}], "/", "rc"}]}]]}]]}], ")"}]}], 
      "-", 
      FractionBox[
       RowBox[{"g", " ", "A", "*", " ", "H"}], 
       RowBox[{"1", "+", 
        RowBox[{"g", " ", "s", " ", "A"}]}]]}], "==", "0"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"r", " ", "A", "*", " ", "H", " "}], 
        RowBox[{"1", "+", 
         RowBox[{"g", " ", "s", " ", "A"}]}]], 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["H", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "A0"}], ")"}], " ", "k"}]]}], ")"}]}], "-", 
      RowBox[{"m", " ", "H"}]}], "==", "0"}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A0", "->", "0.8"}], ",", 
    RowBox[{"g", "->", "2"}], ",", 
    RowBox[{"m", "->", "0.03"}], ",", 
    RowBox[{"r", "->", "8"}], ",", 
    RowBox[{"s", "->", "6"}], ",", 
    RowBox[{"\[Gamma]", "->", "0.8"}], ",", 
    RowBox[{"rc", "->", "2"}], ",", 
    RowBox[{"R", "->", ".5"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.889189216175036*^9, 3.889189327782156*^9}, {
   3.8891895562009583`*^9, 3.8891895812416363`*^9}, {3.889603426588776*^9, 
   3.88960343002586*^9}, {3.901751455975843*^9, 3.901751456792048*^9}, {
   3.901963434297947*^9, 3.901963469509304*^9}, {3.903124859407607*^9, 
   3.903124905632929*^9}, 3.9031249390666637`*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"38e37e64-5399-49c3-9e17-c10d5a653be4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"0.8`", " ", "A", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"1.25`", " ", "A", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"0.25`", " ", 
           RowBox[{"(", 
            RowBox[{"0.8`", "\[VeryThinSpace]", "-", "A"}], ")"}]}]]}]}], 
       ")"}]}], "-", 
     FractionBox[
      RowBox[{"2", " ", "A", " ", "H"}], 
      RowBox[{"1", "+", 
       RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.03`"}], " ", "H"}], "+", 
     FractionBox[
      RowBox[{"8", " ", "A", " ", "H", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"5.000000000000001`", " ", "H"}], "k"]}], ")"}]}], 
      RowBox[{"1", "+", 
       RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9031248318378887`*^9, {3.903124913167378*^9, 3.903124939691615*^9}},
 CellLabel->"Out[38]=",ExpressionUUID->"cf36e22d-4800-45a9-8866-38912b415af8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"A", "/.", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"0.8`", " ", "A", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"1.25`", " ", "A", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"0.25`", " ", 
                    RowBox[{"(", 
                    RowBox[{"0.8`", "\[VeryThinSpace]", "-", "A"}], 
                    ")"}]}]]}]}], ")"}]}], "-", 
                FractionBox[
                 RowBox[{"2", " ", "A", " ", "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "0.03`"}], " ", "H"}], "+", 
                FractionBox[
                 RowBox[{"8", " ", "A", " ", "H", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    FractionBox[
                    RowBox[{"5.000000000000001`", " ", "H"}], "k"]}], ")"}]}], 
                 RowBox[{"1", "+", 
                  RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", ",", "0.2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"H", ",", ".8"}], "}"}]}], "}"}]}], "]"}]}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "5.7", ",", "3.1", ",", 
         RowBox[{"-", ".1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"A", "/.", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"0.8`", " ", "A", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"1.25`", " ", "A", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"0.25`", " ", 
                    RowBox[{"(", 
                    RowBox[{"0.8`", "\[VeryThinSpace]", "-", "A"}], 
                    ")"}]}]]}]}], ")"}]}], "-", 
                FractionBox[
                 RowBox[{"2", " ", "A", " ", "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "0.03`"}], " ", "H"}], "+", 
                FractionBox[
                 RowBox[{"8", " ", "A", " ", "H", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    FractionBox[
                    RowBox[{"5.000000000000001`", " ", "H"}], "k"]}], ")"}]}], 
                 RowBox[{"1", "+", 
                  RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", ",", "0.01"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"H", ",", ".34"}], "}"}]}], "}"}]}], "]"}]}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "5.7", ",", "3.1", ",", 
         RowBox[{"-", ".1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"A", "/.", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"0.8`", " ", "A", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"1.25`", " ", "A", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"0.25`", " ", 
                    RowBox[{"(", 
                    RowBox[{"0.8`", "\[VeryThinSpace]", "-", "A"}], 
                    ")"}]}]]}]}], ")"}]}], "-", 
                FractionBox[
                 RowBox[{"2", " ", "A", " ", "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "0.03`"}], " ", "H"}], "+", 
                FractionBox[
                 RowBox[{"8", " ", "A", " ", "H", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    FractionBox[
                    RowBox[{"5.000000000000001`", " ", "H"}], "k"]}], ")"}]}], 
                 RowBox[{"1", "+", 
                  RowBox[{"12", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", ",", "0.45"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"H", ",", ".98"}], "}"}]}], "}"}]}], "]"}]}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "5.7", ",", "2.3", ",", 
         RowBox[{"-", ".1"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "2.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.01"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Black", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ColorData", "[", 
        RowBox[{"97", ",", "1"}], "]"}], "}"}], ",", 
      RowBox[{"ColorData", "[", 
       RowBox[{"97", ",", "14"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"FontFamily", "->", "\"\<Arial\>\""}], ",", "18"}], "]"}]}], 
   ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<k\>\"", ",", "\"\<Fraction Algae\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.901963482239113*^9, 3.901963565617077*^9}, {
   3.9019637310320587`*^9, 3.9019637456435413`*^9}, {3.9019637979731913`*^9, 
   3.901963864935278*^9}, {3.9019639036885777`*^9, 3.9019639146141443`*^9}, {
   3.901964370565571*^9, 3.9019643771549873`*^9}, {3.901964607398993*^9, 
   3.901964624307973*^9}, {3.901965087218165*^9, 3.90196509290975*^9}, {
   3.9019652073815517`*^9, 3.90196522422762*^9}, {3.9019653503938007`*^9, 
   3.901965394111006*^9}, {3.901965481271346*^9, 3.9019654815579233`*^9}, {
   3.9019655457940683`*^9, 3.90196555400799*^9}, {3.901965791219193*^9, 
   3.901965815558914*^9}, {3.901965921994048*^9, 3.9019659226488333`*^9}, 
   3.901966015110096*^9, 3.901966053373128*^9, 3.901966265363613*^9, 
   3.901966308725484*^9, {3.901966349389906*^9, 3.9019664345117693`*^9}, {
   3.903124947372012*^9, 3.9031250859338207`*^9}, {3.903125123004662*^9, 
   3.903125123186471*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"743d65c4-360d-44c2-9675-b08483c681e9"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 49, 38, 26988220897578206685, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.90312496030264*^9, {3.903125004630974*^9, 3.903125020632125*^9}, 
   3.9031250864176702`*^9, 3.903125123521793*^9},
 CellLabel->
  "During evaluation of \
In[49]:=",ExpressionUUID->"d5f7e51d-448a-4f73-a10b-cb74f7a3960a"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 49, 39, 26988220897578206685, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.90312496030264*^9, {3.903125004630974*^9, 3.903125020632125*^9}, 
   3.9031250864176702`*^9, 3.903125123555979*^9},
 CellLabel->
  "During evaluation of \
In[49]:=",ExpressionUUID->"738113f8-6001-4b3e-a64e-40e2df304090"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 49, 40, 26988220897578206685, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.90312496030264*^9, {3.903125004630974*^9, 3.903125020632125*^9}, 
   3.9031250864176702`*^9, 3.903125123571788*^9},
 CellLabel->
  "During evaluation of \
In[49]:=",ExpressionUUID->"8ffbd218-7a90-419a-827a-ebcedfaad8ef"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"FindRoot\\\", \
\\\"::\\\", \\\"lstol\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 49, 41, 26988220897578206685, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.90312496030264*^9, {3.903125004630974*^9, 3.903125020632125*^9}, 
   3.9031250864176702`*^9, 3.9031251235814238`*^9},
 CellLabel->
  "During evaluation of \
In[49]:=",ExpressionUUID->"86fc5afb-74bb-4f46-8b10-8d861427d87b"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 60], 0.016666666666666666`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQffYMCIg58CmHlou+vWKfngYCYg5bmML7F+66ZM8A
BmIOBj/ur9Odc8F+1kwQEHXYftHt7beKc/bGYCDqMFFvk26A+xl7iHkiDk6R
O967p52yBxuXJuKw8pZx/v9dJ6DmiTg8cT+557TZcah5wg6TMjZ3zb1wFGqe
sIPt7JZpSU1HoOYJOVRFG7mccj8MNU/I4W2RmeF82UNQ84QcOHi+TUhnPAg1
T9DBYOf1lSGP9kPNE3QoSqwqm3htL9Q8AYd9HpbOx+/shpon4DDlCJNH/6ed
UPMEHE44fp2+U3SHvQlYP7/D/AsVtXou26Dq+Rzmy6S7n6neArWP12HrHgU9
y12boObzOGz25+Ca+WcD1Dweh+uqM68w1K2DuofbgVmkKCn/2yqoeVwOsy+8
ml3vtRxqHqdD6/rwjK2Wi6HmcTjU7Jvy6iXXTHsAcNC5Sw==
      "]]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 60], 0.016666666666666666`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQffYMCIg58Lp/ifxZXGWfngYCYg7qxxIvuh6rsmcA
AzEHVQMfxfey1fazZoKAqIPTlWdLm6qr7Y3BQNRhDecny0X3q+0h5ok4qH0Q
U+XwrrEHG5cm4pB/4Pf/7n01UPNEHDg5qm9oWNdCzRN2YF188zfLoVqoecIO
pWcKv1SH1EHNE3K4XF/WpP2lDmqekMMxh5nrWBbXQ80TcrB6nu670bABap6g
g5Np0WGROQ1Q8wQdpssavqgQaoSaJ+CwxFCoRGl6I9Q8AYfgyHOMv3WaoOYJ
OHSb5k++fL3J3gSsn98hsryP58ycZqh6Pofjz9WLfje1QO3jdTh5ZsrXCVNa
oebzOPDNv3j+xYM2qHk8DiwCGT2HGzqg7uF2OLJeRod9QRfUPC6HDlu+91Uz
e6HmcTqwL/9eZ2o6EWoeh8PZ+9d+SQjMtAcAKcmxvQ==
      "]]}, 
    {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
      NCache[
       Rational[1, 60], 0.016666666666666666`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBmIQffYMCIg5eKaEnZF6e8U+PQ0ExBwEagu3PLC5bs8A
BmIOz0p2x2/OvGk/ayYIiDq4sK0MWXf9lr0xGIg6uDL+ub3x3217iHkiDiYh
85d4/b1jDzYuTcRhCuuKTU8e3IWaJ+JQmvNx4sUN96DmCTt0uPYFTCm8DzVP
2EFr1Y8ACeEHUPOEHG54HtJLyXgANU/IYTZTukX5zgdQ84Qcbnf80XrN9hBq
nqBD1MzrjRaBD6HmCTpcuftsz/4ZD6HmCTikKPBPOn/3IdQ8AYe6d1ImKxUe
Qc0TcDBacjGmOfGRvQlYP79DpG13c8+CR1D1fA7tfD1Nb+4+gtrH69Cia3bt
qORjqPk8Dne/nZlkFvIYah6Pg7xygUpk72Ooe7gd7H6zPXc5+hhqHpeDybv7
8/n+PIaax+kw+6HYgxOGT6DmcThcz/sa0pL2BGoeh8PrbbpcAbOeQM1jd9je
c3eB5dknUPPYHJ49mVbr+/8J1DxWh+vSGu+nGTyFmsfikBRS66+Q+BRqHouD
2fFV8p8nPIWax+ww4cF3eYkDT6HmMTmc+TI9Zfq7p/YA33T0sw==
      "]]}}, {{}, {}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.3000000000000047`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Fraction Algae\"", TraditionalForm], None}, {
     FormBox["\"k\"", TraditionalForm], None}},
  FrameStyle->Directive[FontFamily -> "Arial", 18],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{2.3, 6.}, {-0.01, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.903124960386382*^9, {3.90312500475135*^9, 3.903125020696972*^9}, 
   3.903125086494495*^9, 3.903125123630422*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"932bbd87-0192-4f7b-9c28-4bd9e1746b7b"]
}, Open  ]],

Cell["Figure 5c", "Text",
 CellChangeTimes->{{3.903124434250808*^9, 3.9031244399741507`*^9}, 
   3.915297397876773*^9},ExpressionUUID->"27873e55-9310-45cf-a775-\
a8db56dca5dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Gamma]", " ", "A", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{" ", "A"}], 
          RowBox[{"A0", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "R"}], " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"A0", "-", "A"}], ")"}], "/", "rc"}]}]]}]]}], ")"}]}], 
      "-", 
      FractionBox[
       RowBox[{"g", " ", "A", "*", " ", "H"}], 
       RowBox[{"1", "+", 
        RowBox[{"g", " ", "s", " ", "A"}]}]]}], "==", "0"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"r", " ", "A", "*", " ", "H", " "}], 
        RowBox[{"1", "+", 
         RowBox[{"g", " ", "s", " ", "A"}]}]], 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["H", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "A0"}], ")"}], " ", "k"}]]}], ")"}]}], "-", 
      RowBox[{"m", " ", "H"}]}], "==", "0"}]}], "}"}], "/.", 
  "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A0", "->", "0.9"}], ",", 
    RowBox[{"g", "->", "2"}], ",", 
    RowBox[{"k", "->", "4.8"}], ",", 
    RowBox[{"m", "->", "0.09"}], ",", 
    RowBox[{"r", "->", "8"}], ",", 
    RowBox[{"s", "->", "14"}], ",", 
    RowBox[{"\[Gamma]", "->", "0.15"}], ",", 
    RowBox[{"rc", "->", "2"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.903101631856227*^9, 3.903101652225507*^9}, {
   3.903101773962731*^9, 3.9031017768562603`*^9}, {3.9031019006188717`*^9, 
   3.903101900978478*^9}, {3.903101992985732*^9, 3.9031019973651*^9}, {
   3.903102032614222*^9, 3.903102039274385*^9}, {3.9031241498762693`*^9, 
   3.9031241947164993`*^9}, 3.903124336999399*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"849fe7c9-d31e-4cab-9603-a6c0803db7d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"0.15`", " ", "A", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"1.1111111111111112`", " ", "A", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"0.9`", "\[VeryThinSpace]", "-", "A"}], ")"}], " ", 
           "R"}]]}]}], ")"}]}], "-", 
     FractionBox[
      RowBox[{"2", " ", "A", " ", "H"}], 
      RowBox[{"1", "+", 
       RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.09`"}], " ", "H"}], "+", 
     FractionBox[
      RowBox[{"8", " ", "A", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2.083333333333334`", " ", "H"}]}], ")"}], " ", "H"}], 
      RowBox[{"1", "+", 
       RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{3.903124234576355*^9, 3.903124350756819*^9, 
  3.9034396147823553`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"60ed11a0-f627-4e1e-b99b-36db89f8d9a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"R", ",", 
         RowBox[{"A", "/.", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"0.15`", " ", "A", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"1.1111111111111112`", " ", "A", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"0.9`", "\[VeryThinSpace]", "-", "A"}], ")"}], 
                    " ", "R"}]]}]}], ")"}]}], "-", 
                FractionBox[
                 RowBox[{"2", " ", "A", " ", "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "0.09`"}], " ", "H"}], "+", 
                FractionBox[
                 RowBox[{"8", " ", "A", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"2.083333333333334`", " ", "H"}]}], ")"}], " ", 
                  "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", ",", "0.05"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"H", ",", ".1"}], "}"}]}], "}"}]}], "]"}]}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"R", ",", ".1", ",", "3", ",", ".01"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"R", ",", 
         RowBox[{"A", "/.", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"0.15`", " ", "A", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"1.1111111111111112`", " ", "A", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"0.9`", "\[VeryThinSpace]", "-", "A"}], ")"}], 
                    " ", "R"}]]}]}], ")"}]}], "-", 
                FractionBox[
                 RowBox[{"2", " ", "A", " ", "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "0.09`"}], " ", "H"}], "+", 
                FractionBox[
                 RowBox[{"8", " ", "A", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"2.083333333333334`", " ", "H"}]}], ")"}], " ", 
                  "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", ",", ".2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"H", ",", ".3"}], "}"}]}], "}"}]}], "]"}]}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"R", ",", ".1", ",", "1.72", ",", ".01"}], "}"}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"R", ",", 
         RowBox[{"A", "/.", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"0.15`", " ", "A", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"1.1111111111111112`", " ", "A", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"0.9`", "\[VeryThinSpace]", "-", "A"}], ")"}], 
                    " ", "R"}]]}]}], ")"}]}], "-", 
                FractionBox[
                 RowBox[{"2", " ", "A", " ", "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "0.09`"}], " ", "H"}], "+", 
                FractionBox[
                 RowBox[{"8", " ", "A", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"2.083333333333334`", " ", "H"}]}], ")"}], " ", 
                  "H"}], 
                 RowBox[{"1", "+", 
                  RowBox[{"28", " ", "A"}]}]]}], "\[Equal]", "0"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", ",", "0.6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"H", ",", ".3"}], "}"}]}], "}"}]}], "]"}]}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"R", ",", ".1", ",", "1.72", ",", ".01"}], "}"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.01"}], ",", ".9"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ColorData", "[", 
        RowBox[{"97", ",", "1"}], "]"}], "}"}], ",", 
      RowBox[{"{", "Black", "}"}], ",", 
      RowBox[{"ColorData", "[", 
       RowBox[{"97", ",", "14"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", 
      RowBox[{"FontFamily", "->", "\"\<Arial\>\""}], ",", "18"}], "]"}]}], 
   ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "3"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Clark-Evans R\>\"", ",", "\"\<Fraction Algae\>\""}], 
     "}"}]}], ",", 
   RowBox[{"FrameTicks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0.2", ",", ".4", ",", ".8", ",", ".8"}], "}"}], ",",
       "None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", ".05", ",", "1", ",", "1.5", ",", "2.", ",", "2.5", ",", 
        "3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.889189339302709*^9, 3.889189383953649*^9}, {
   3.8891895941042747`*^9, 3.889189603262547*^9}, {3.8891896345147943`*^9, 
   3.8891896347216578`*^9}, {3.889189856437202*^9, 3.889189858152586*^9}, {
   3.889189912726817*^9, 3.889190010812975*^9}, {3.889190055783535*^9, 
   3.889190076585575*^9}, {3.8891901462375727`*^9, 3.889190169095604*^9}, {
   3.88919033977691*^9, 3.889190340467835*^9}, {3.8896034395594053`*^9, 
   3.889603473863717*^9}, {3.9017514199993668`*^9, 3.901751425764875*^9}, {
   3.9019881747809477`*^9, 3.901988186719734*^9}, {3.901988735161271*^9, 
   3.9019887741179533`*^9}, {3.9019888224967413`*^9, 3.901988901060629*^9}, {
   3.901988953516418*^9, 3.901989011210009*^9}, {3.901989078383417*^9, 
   3.901989104226328*^9}, 3.901989145352932*^9, {3.901989197284252*^9, 
   3.9019892286338263`*^9}, {3.901989281888438*^9, 3.9019892830079517`*^9}, {
   3.901989349586658*^9, 3.9019893891405993`*^9}, {3.901993353721435*^9, 
   3.90199337900309*^9}, {3.9019934683855753`*^9, 3.901993531276623*^9}, {
   3.90312428590812*^9, 3.9031243157430477`*^9}, {3.903124367497035*^9, 
   3.903124388303306*^9}, {3.903124590445869*^9, 3.903124590862062*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"9f784c7d-1b51-4668-9a68-3fc3ec338368"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw11nlcTPsbB/DZmiEtUlGhFS034WZXPV/RJklZCkXUT3VLolwpXUs3EhEi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      "]]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw11HlUU2caBnB0mKHKSKsV6lI20ZbdTlFORekjZQYR56iggPTIUq0iRQWR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      "]]}, 
    {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw11AlQk2ceBnDUIqjrwgqirVdVtiDqekCwKPgoRUDtFMEVteAUaVEsyKGs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      "]]}}, {{}, {}}},
  AspectRatio->NCache[
    Rational[1, 3], 0.3333333333333333],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Fraction Algae\"", TraditionalForm], None}, {
     FormBox["\"Clark-Evans R\"", TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], FontFamily -> "Arial", 18],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 3.2}, {-0.01, 0.9}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.90312426610565*^9, 3.903124347071974*^9, 
  3.9031243911734962`*^9, 3.903124591790732*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"f3cc1075-a30d-4be5-be09-38cf450170bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A0", "=", "0.9"}], ",", 
      RowBox[{"R", "=", ".2"}], ",", 
      RowBox[{"g", "=", "2"}], ",", 
      RowBox[{"k", "=", "4.8"}], ",", 
      RowBox[{"m", "=", "0.09"}], ",", 
      RowBox[{"a0", "=", "0.02"}], ",", 
      RowBox[{"h0", "=", "0.12"}], ",", 
      RowBox[{"r", "=", "8"}], ",", 
      RowBox[{"s", "=", "14"}], ",", 
      RowBox[{"\[Gamma]", "=", "0.15"}], ",", 
      RowBox[{"tmax", "=", "1000"}], ",", 
      RowBox[{"rc", "=", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"sol", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"A", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Gamma]", "*", 
            RowBox[{"A", "[", "t", "]"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"A", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"A0", "*", 
                 RowBox[{"E", "^", 
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"R", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}], "/", "rc"}]}], 
                    ")"}]}]}]}], ")"}]}]}], ")"}]}], "-", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g", "*", 
              RowBox[{"A", "[", "t", "]"}], "*", 
              RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"g", "*", "s", "*", 
               RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"H", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"r", "*", 
               RowBox[{"A", "[", "t", "]"}], "*", 
               RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"g", "*", "s", "*", 
                RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"H", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "A0"}], ")"}], "*", "k"}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{"(", 
            RowBox[{"m", "*", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"A", "[", "0", "]"}], "\[Equal]", "a0"}], ",", 
         RowBox[{
          RowBox[{"H", "[", "0", "]"}], "\[Equal]", "h0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A", "[", "t", "]"}], ",", 
         RowBox[{"H", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", "0.0001"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A0", "=", ".8"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", "[", "t", "]"}], "}"}], "/.", "%"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"A\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"ColorData", "[", 
        RowBox[{"97", ",", "14"}], "]"}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", " ", 
        RowBox[{"FontFamily", "->", "\"\<Arial\>\""}], ",", "18"}], "]"}]}], 
     ",", 
     RowBox[{"AspectRatio", "->", 
      RowBox[{"1", "/", "4"}]}], ",", 
     RowBox[{"FrameTicks", "->", "None"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8891874333391857`*^9, 3.889187460869439*^9}, 
   3.8891874961270847`*^9, {3.889188838345305*^9, 3.889188838526822*^9}, {
   3.901890692786888*^9, 3.9018906932100143`*^9}, {3.9018908573697557`*^9, 
   3.901890867374848*^9}, {3.9018910215374317`*^9, 3.901891064271205*^9}, {
   3.901891112920808*^9, 3.901891154435718*^9}, {3.9018911883207293`*^9, 
   3.901891207012027*^9}, {3.903124666823481*^9, 3.903124668682273*^9}, {
   3.903124742982994*^9, 3.903124744484379*^9}, {3.903125368842155*^9, 
   3.903125453368372*^9}, {3.903125529453259*^9, 3.9031255310921593`*^9}, {
   3.903125684098865*^9, 3.903125720615137*^9}, {3.903125763644644*^9, 
   3.903125766529492*^9}, {3.90312614829351*^9, 3.903126156709798*^9}, {
   3.9031262517572813`*^9, 3.903126268219737*^9}, {3.9031264529224653`*^9, 
   3.903126454679119*^9}, {3.903126504881665*^9, 3.903126532244506*^9}, {
   3.9031267236594267`*^9, 3.9031267340004473`*^9}, {3.903126818493623*^9, 
   3.903126833446203*^9}, {3.903126866057481*^9, 3.9031268886821327`*^9}, {
   3.9031269500197697`*^9, 3.903126950948299*^9}, 3.903126997533896*^9},
 CellLabel->
  "In[119]:=",ExpressionUUID->"eb822c9f-0cd8-4e52-be27-722964576a2c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJxF13k8VN//B3BkyVISIknWopAQSZx3yL7vhLLvDLMYe0q2yjooW3alSEUi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       "]]},
     Annotation[#, "Charting`Private`Tag$93965#1"]& ]}, {}},
  AspectRatio->NCache[
    Rational[1, 4], 0.25],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"A\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
      TraditionalForm], None}, {
     FormBox["\"t\"", TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], FontFamily -> "Arial", 18],
  FrameTicks->{{{}, {}}, {{}, {}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 999.9999795918368}, {-0.1, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.903125730303441*^9, 3.903125773889017*^9, 3.903126164509906*^9, 
   3.903126276138706*^9, 3.903126462896723*^9, {3.903126518966158*^9, 
   3.9031265399521523`*^9}, {3.903126812495009*^9, 3.903126841161476*^9}, 
   3.9031268741295033`*^9, 3.903126904785008*^9, 3.903126965689822*^9, 
   3.903127014007285*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"65eb0c14-281b-41e3-8486-b9d9eb37ec1e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A0", "=", "0.9"}], ",", 
      RowBox[{"R", "=", "2"}], ",", 
      RowBox[{"g", "=", "2"}], ",", 
      RowBox[{"k", "=", "4.8"}], ",", 
      RowBox[{"m", "=", "0.09"}], ",", 
      RowBox[{"a0", "=", "0.02"}], ",", 
      RowBox[{"h0", "=", "0.12"}], ",", 
      RowBox[{"r", "=", "8"}], ",", 
      RowBox[{"s", "=", "14"}], ",", 
      RowBox[{"\[Gamma]", "=", "0.15"}], ",", 
      RowBox[{"tmax", "=", "1000"}], ",", 
      RowBox[{"rc", "=", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"sol", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"A", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Gamma]", "*", 
            RowBox[{"A", "[", "t", "]"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"A", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"A0", "*", 
                 RowBox[{"E", "^", 
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"R", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"A0", "-", 
                    RowBox[{"A", "[", "t", "]"}]}], ")"}], "/", "rc"}]}], 
                    ")"}]}]}]}], ")"}]}]}], ")"}]}], "-", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g", "*", 
              RowBox[{"A", "[", "t", "]"}], "*", 
              RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"g", "*", "s", "*", 
               RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"H", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"r", "*", 
               RowBox[{"A", "[", "t", "]"}], "*", 
               RowBox[{"H", "[", "t", "]"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"g", "*", "s", "*", 
                RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"H", "[", "t", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "A0"}], ")"}], "*", "k"}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{"(", 
            RowBox[{"m", "*", 
             RowBox[{"H", "[", "t", "]"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"A", "[", "0", "]"}], "\[Equal]", "a0"}], ",", 
         RowBox[{
          RowBox[{"H", "[", "0", "]"}], "\[Equal]", "h0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A", "[", "t", "]"}], ",", 
         RowBox[{"H", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", "0.0001"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A0", "=", ".8"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", "[", "t", "]"}], "}"}], "/.", "%"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"A\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"ColorData", "[", 
        RowBox[{"97", ",", "1"}], "]"}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", " ", 
        RowBox[{"FontFamily", "->", "\"\<Arial\>\""}], ",", "18"}], "]"}]}], 
     ",", 
     RowBox[{"AspectRatio", "->", 
      RowBox[{"1", "/", "4"}]}], ",", 
     RowBox[{"FrameTicks", "->", "None"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8891874333391857`*^9, 3.889187460869439*^9}, 
   3.8891874961270847`*^9, {3.889188838345305*^9, 3.889188838526822*^9}, {
   3.901890692786888*^9, 3.9018906932100143`*^9}, {3.9018908573697557`*^9, 
   3.901890867374848*^9}, {3.9018910215374317`*^9, 3.901891064271205*^9}, {
   3.901891112920808*^9, 3.901891154435718*^9}, {3.9018911883207293`*^9, 
   3.901891207012027*^9}, {3.903124666823481*^9, 3.903124668682273*^9}, {
   3.903124742982994*^9, 3.903124744484379*^9}, {3.903125368842155*^9, 
   3.903125453368372*^9}, {3.903125529453259*^9, 3.9031255310921593`*^9}, {
   3.903125684098865*^9, 3.903125720615137*^9}, {3.903125763644644*^9, 
   3.903125766529492*^9}, {3.90312614829351*^9, 3.903126156709798*^9}, {
   3.9031262517572813`*^9, 3.903126268219737*^9}, {3.9031264529224653`*^9, 
   3.903126454679119*^9}, {3.903126504881665*^9, 3.903126532244506*^9}, {
   3.9031267236594267`*^9, 3.9031267340004473`*^9}, {3.903126818493623*^9, 
   3.903126833446203*^9}, {3.903126866057481*^9, 3.9031268886821327`*^9}, {
   3.903126940351845*^9, 3.903126941336403*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"bff8189d-a740-4e62-aa61-0901ba2da1cc"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUV3c81f8XRigtLYWkQn0pKSMrnEMkO7LL3jLvdY1rXmRl7z0yk52y91aJ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       "]]},
     Annotation[#, "Charting`Private`Tag$93607#1"]& ]}, {}},
  AspectRatio->NCache[
    Rational[1, 4], 0.25],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"A\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
      TraditionalForm], None}, {
     FormBox["\"t\"", TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], FontFamily -> "Arial", 18],
  FrameTicks->{{{}, {}}, {{}, {}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 999.9999795918368}, {-0.1, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.903126994157218*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"cbb9f717-2f30-4e1b-a8f3-c5bc0a0dd325"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81f8XRigtLYWkQn0pKSMrnEMkO7LL3jLvdY1rXmRl7z0yk52y91aJ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         "]]},
       Annotation[#, "Charting`Private`Tag$93607#1"]& ]}, {}},
    AspectRatio->NCache[
      Rational[1, 4], 0.25],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"A\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], None}, {
       FormBox["\"t\"", TraditionalForm], None}},
    FrameStyle->Directive[
      GrayLevel[0], FontFamily -> "Arial", 18],
    FrameTicks->{{{}, {}}, {{}, {}}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0., 999.9999795918368}, {-0.1, 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
        AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJxF13k8VN//B3BkyVISIknWopAQSZx3yL7vhLLvDLMYe0q2yjooW3alSEUi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         "]]},
       Annotation[#, "Charting`Private`Tag$93965#1"]& ]}, {}},
    AspectRatio->NCache[
      Rational[1, 4], 0.25],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"A\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], None}, {
       FormBox["\"t\"", TraditionalForm], None}},
    FrameStyle->Directive[
      GrayLevel[0], FontFamily -> "Arial", 18],
    FrameTicks->{{{}, {}}, {{}, {}}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0., 999.9999795918368}, {-0.1, 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}]}], "]"}]], "Input",
 CellChangeTimes->{{3.903124682347815*^9, 3.9031246898271646`*^9}, {
  3.903124771598117*^9, 3.903124774428584*^9}, {3.903125650081828*^9, 
  3.903125652747011*^9}, {3.903127027741796*^9, 3.903127030376256*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"7fbf9670-0024-46fa-a002-d1d90fbd165e"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81f8XRigtLYWkQn0pKSMrnEMkO7LL3jLvdY1rXmRl7z0yk52y91aJ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        "]]},
      Annotation[#, "Charting`Private`Tag$93607#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJxF13k8VN//B3BkyVISIknWopAQSZx3yL7vhLLvDLMYe0q2yjooW3alSEUi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