% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{combat_gam}
\alias{combat_gam}
\title{ComBat-GAM harmonization}
\usage{
combat_gam(
  data,
  bat,
  covar = NULL,
  formula = NULL,
  eb = TRUE,
  robust.LS = FALSE,
  ref.batch = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{n x p} data frame or matrix of observations where
\emph{p} is the number of features and \emph{n} is the number of subjects}

\item{bat}{Factor indicating batch (often equivalent to site or scanner)}

\item{covar}{Data frame or matrix of covariates supplied to \link[mgcv]{gam}}

\item{formula}{Formula for \link[mgcv]{gam} starting with \verb{y ~} where \code{y} represents
each feature}

\item{eb}{If \code{TRUE}, uses ComBat model with empirical Bayes for mean
and variance harmonization}

\item{robust.LS}{If \code{TRUE}, uses robust location and scale estimators
for error variance and site effect parameters. Currently uses median and
biweight midvariance}

\item{ref.batch}{Reference batch, must take value in \code{levels(bat)}}

\item{...}{Additional arguments passed to \link[mgcv]{gam}}
}
\value{
\code{combat} returns a list containing the following components:
\item{dat.combat}{Harmonized data as a matrix with same dimensions as \code{data}}
\item{batch.info}{Batch information, including reference batch if specified}
\item{fits}{List of model fits from regression step, outputs of \link[mgcv]{gam} for each feature}
\item{estimates}{List of estimates from standardization and batch effect correction}
}
\description{
Implementation of ComBat-GAM (Pomponio et al., 2020) using \link[ComBatFamily]{comfam} with \code{model} as \link[mgcv]{gam}.
}
\examples{
combat_gam(iris[,1:2], iris$Species)
combat_gam(iris[,1:2], iris$Species, iris[3:4], y ~ s(Petal.Length) + Petal.Width)

}
\references{
Pomponio, R., Erus, G., Habes, M., Doshi, J., Srinivasan, D., Mamourian, E., Bashyam, V., Nasrallah, I. M., Satterthwaite, T. D., Fan, Y., Launer, L. J., Masters, C. L., Maruff, P., Zhuo, C., Völzke, H., Johnson, S. C., Fripp, J., Koutsouleris, N., Wolf, D. H., … Shou, H., Davatzikos, C. (2020). Harmonization of large MRI datasets for the analysis of brain imaging patterns throughout the lifespan. \emph{NeuroImage}, 208, 116450. https://doi.org/10.1016/j.neuroimage.2019.116450
}
\seealso{
\link[ComBatFamily]{plot.comfam} for assessing regression fit via
diagnostic plots associated with \link[mgcv]{gam}

\link[ComBatFamily]{predict.comfam} for applying ComBat parameters for
harmonization of new observations
}
