% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{combat}
\alias{combat}
\title{ComBat Harmonization}
\usage{
combat(
  data,
  bat,
  covar = NULL,
  formula = NULL,
  eb = TRUE,
  robust.LS = FALSE,
  ref.batch = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{n x p} data frame or matrix of observations where
\emph{p} is the number of features and \emph{n} is the number of subjects}

\item{bat}{Factor indicating batch (often equivalent to site or scanner)}

\item{covar}{Data frame or matrix of covariates supplied to \link[stats]{lm}}

\item{formula}{Formula for \link[stats]{lm} starting with \verb{y ~} where \code{y} represents
each feature}

\item{eb}{If \code{TRUE}, uses ComBat model with empirical Bayes for mean
and variance harmonization}

\item{robust.LS}{If \code{TRUE}, uses robust location and scale estimators
for error variance and site effect parameters. Currently uses median and
biweight midvariance}

\item{ref.batch}{Reference batch, must take value in \code{levels(bat)}}

\item{...}{Additional arguments passed to \link[stats]{lm}}
}
\value{
\code{combat} returns a list containing the following components:
\item{dat.combat}{Harmonized data as a matrix with same dimensions as \code{data}}
\item{batch.info}{Batch information, including reference batch if specified}
\item{fits}{List of model fits from regression step, outputs of \link[stats]{lm} for each feature}
\item{estimates}{List of estimates from standardization and batch effect correction}
}
\description{
Implementation of ComBat (Johnson et al., 2007) using \link[ComBatFamily]{comfam} with \code{model} as \link[stats]{lm}.
}
\examples{
combat(iris[,1:2], iris$Species)
combat(iris[,1:2], iris$Species, iris[3:4], y ~ Petal.Length + Petal.Width)

}
\references{
Fortin, J.-P., Cullen, N., Sheline, Y. I., Taylor, W. D., Aselcioglu, I., Cook, P. A., Adams, P., Cooper, C., Fava, M., McGrath, P. J., McInnis, M., Phillips, M. L., Trivedi, M. H., Weissman, M. M., & Shinohara, R. T. (2018). Harmonization of cortical thickness measurements across scanners and sites. \emph{NeuroImage}, 167, 104–120. https://doi.org/10.1016/j.neuroimage.2017.11.024

Fortin, J.-P., Parker, D., Tunç, B., Watanabe, T., Elliott, M. A., Ruparel, K., Roalf, D. R., Satterthwaite, T. D., Gur, R. C., Gur, R. E., Schultz, R. T., Verma, R., & Shinohara, R. T. (2017). Harmonization of multi-site diffusion tensor imaging data. \emph{NeuroImage}, 161, 149–170. https://doi.org/10.1016/j.neuroimage.2017.08.047

Johnson, W. E., Li, C., & Rabinovic, A. (2007). Adjusting batch effects in microarray expression data using empirical Bayes methods. \emph{Biostatistics}, 8(1), 118–127. https://doi.org/10.1093/biostatistics/kxj037
}
\seealso{
\link[ComBatFamily]{plot.comfam} for assessing regression fit via
diagnostic plots associated with \link[stats]{lm}

\link[ComBatFamily]{predict.comfam} for applying ComBat parameters for
harmonization of new observations
}
