# Data for publication ``The ZiCOS-M CO2 sensor network: measurement performance and CO2 variability across Zürich''

  - Author: Stuart K. Grange (stuart.grange@empa.ch)
  - Date: 2024-09-17

## Description

This repository contains the data files used for the data analysis presented and described in the *The ZiCOS-M CO2 sensor network: measurement performance and CO2 variability across Zürich* publication. Although a comprehensive dataset is publicly available on the [ICOS Cities data portal](https://citydata.icos-cp.eu/portal/) maintained by ICOS, for the analysis that is presented, some subtle changes to the hourly aggregation logic was applied to avoid data loss at some monitoring sites. 

Hourly CO2 observations are available for all sites and sensors included in the analysis, as are the observations of the sensors that underwent testing at the Dübendorf-Empa monitoring site, and a simple site table for basic monitoring site details such as classifications and coordinates. This dataset also includes observations from three CO2 monitoring sites Beromünster, Lägern Hochwacht, and Jungfraujoch that are maintained by complementary monitoring activities outside the ICOS Cites project. These three sites are equipped with high-precision gas analysers. Beromünster and Lägern Hochwacht are part of the CarboCount CH project and [Stephan Henne](stephan.henne@empa.ch) must be contacted before downstream use of these two time series and [Jungfraujoch](https://www.icos-cp.eu/jungfraujoch-station-switzerland) which forms part of the ICOS monitoring activities.

The data are always reported in UTC, but within the monitoring domain (Zürich, Switzerland), the local time zone is UTC + 1 for Swiss standard time and UTC + 2 for Swiss summer time. CO2 is always reported as a dry air mole fraction using the parts per million (ppm) unit. A full description of the data processing steps is contained within the publication. 

## Files

### `tree --charset=ascii` output

```
.
|-- co2_sensors_intercomparisions_observations.csv.bz2
|-- icos_cities_co2_hourly_observations.csv.bz2
|-- icos_cities_co2_sensors_sites.csv
|-- README.md
```

