'''
Parse the call graph generated by opt to obtain the dominator relationships.
'''
import networkx as nx
import numpy as np
import matplotlib.pyplot as plt

print('reading callgraph.dot ...')
g = nx.drawing.nx_pydot.read_dot("callgraph.dot")

nodes = g.nodes
node2label = {}
root_node = None
external_node = None

print('parsing callgraph.dot ...')
for node in nodes:
    try:
        # print(nodes[node]['label'][2:-2])
        if nodes[node]['label'][1:-1] == "{main}":
            print('Main node:',node)
            root_node = node
        elif nodes[node]['label'][1:-1] == "{external node}":
            external_node = node

        node2label[node] = nodes[node]['label'][2:-2]
    except:
        print('Node',node,'does not have a label.')
        node2label[node] = 'NULL'

if not root_node:
    # root_node = external_node
    print('Main node not found, stop.')
    exit()

imm_doms_extn = None
imm_doms_labels_extn = None
if not external_node:
    # root_node = external_node
    print('Externel node not found !')
    # exit()
else:
    imm_doms_extn = nx.immediate_dominators(g, external_node).items()
    imm_doms_labels_extn = {} # key:ee, value:er
    for ee,er in imm_doms_extn:
        # print(nodes[er]['label'],'dominates',nodes[ee]['label'])
        # print(node2label[er],'dominates',node2label[ee])
        imm_doms_labels_extn[node2label[ee]] = node2label[er]

# from graphviz import render
# render(engine='dot',format='png',filepath='./callgraph.dot')

print('calculating immediate dominators ...')
# print(nx.immediate_dominators(g, root_node).items())
imm_doms = nx.immediate_dominators(g, root_node).items()
imm_doms_labels = {} # key:ee, value:er
for ee,er in imm_doms:
    # print(nodes[er]['label'],'dominates',nodes[ee]['label'])
    print(node2label[er],'dominates',node2label[ee])
    imm_doms_labels[node2label[ee]] = node2label[er]





def getFuncDom(dict,target_func):
    curr_func = target_func
    doms = []
    while not(dict[curr_func] == curr_func):
        doms.append(dict[curr_func])
        curr_func = dict[curr_func]
    return doms

def getFuncDomExtn(dict,target_func):
    curr_func = target_func
    doms = []
    while not(dict[curr_func] == curr_func):
        doms.append(dict[curr_func])
        curr_func = dict[curr_func]
    return doms[:-1] # do not record external node

'''
Read the functions corresponding to the targets and obtain the dominator relationships of the targets.
'''
print('writing dominators of target functions ...')
with open('/root/instr-io/DominatorsOfTargetFunctions.txt','w') as out:
    with open('/root/instr-io/FunctionsOfTargets.txt','r') as f:
        for line in np.unique(f.readlines()):
            print(line)
            target_line,target_func = line.split(',')
            
            try:
                print(getFuncDom(imm_doms_labels,target_func.strip()))
                out.write(line.strip())
                for dom in getFuncDom(imm_doms_labels,target_func.strip()):
                    out.write(','+dom)
                out.write('\n')
            except:
                print('target function not found in the dominator tree. maybe indirect callee or dead code.')
                print('trying to perform dominance analysis starting from external node...')
                try:
                    if external_node:
                        print(getFuncDomExtn(imm_doms_labels_extn,target_func.strip()))
                        ## add this function as individual intra-procedural target
                        ## set root to external_node, perform dominance analysis
                        out.write(line.strip())
                        for dom in getFuncDomExtn(imm_doms_labels_extn,target_func.strip()):
                            out.write(','+dom)
                        out.write('\n')
                        # continue
                    else:
                        print('external node not found! skip dominance analysis.')
                except:
                    print('dominance analysis starting from external node failed. skip this target function.')
                    continue    



