# IDFuzz: Intelligent Directed Grey-box Fuzzing

This is a research prototype for the paper "IDFuzz: Intelligent Directed Grey-box Fuzzing." IDFuzz is an input mutation module that can theoretically be integrated into any AFL-based directed fuzzer. In this repository, we provide a patched version based on AFL.

### Pipeline

1. Compile the two llvm passes: `getFunctionName` and `getCSAdditionalTargets`. (detailed instructions can be found in `llvm-pass-getCSAdditionalTargets/README.md` and `llvm-pass-getFunctionName/README.md`).

2. Replace the files with the same names under the `AFL/` directory with the files of the same name from this repo, then compile.

3. Create the directory `/root/instr-io` and set up `BBtargets.txt`.

4. Compile the target using `gllvm` to extract `target.bc`.

5. Generate the function call graph `callgraph.dot`.

   ```shell
   opt -dot-callgraph target.bc
   ```

6. Generate `FunctionsOfTargets.txt`.

   ```shell
   opt -load /path/to/libgetFunctionName.so -getFunctionName target.bc
   ```

7. Use `parse_cg.py` to generate `DominatorsOfTargetFunctions.txt`.

   ```shell
   python3 /path/to/parse_cg.py
   ```

8. Generate `BBTargets-inter.txt`. 

   ```shell
   opt -load /path/to/libgetCSAdditionalTargets.so -getCSAdditionalTargets target.bc
   ```

9. Compile the target program using `afl-clang-fast` generated in step 2, setting `CFLAGS="-flto -fuse-ld=gold -Wl,-plugin-opt=save-temps"`, and generate `DominatorsOfTargets.txt`.

10. Use `gen_dom_graph.py` to generate an interprocedural dominator graph for each basic block (bb) target: list of (edge, level).

    ```shell
    python3 /path/to/gen_dom_graph.py
    ```

11. Perform fuzzing using the modified AFL, for example: 

    ```shell
    ~/AFL/afl-fuzz -G -K 25 -d -m none -z exp -c 10m -i in -o out ./objdump -SD @@
    ```

    The `-G` option enables the IDFuzz strategy, and the `-K 25` specifies the shared memory ID (25) used for communication with the neural network model.

12. After the fuzzer starts, run the neural network model in a new process.

    ```shell
    python3 /path/to/nn-dom.py [PUT] [fuzzing output folder] [shared memory id]
    ```

    For example:

    ```shell
    python3 /path/to/nn-dom.py objdump ./out/ 25
    ```

    

