This is the replication package for:

Heil, Sebastian, Schröder, Lucas and Gaedke, Martin. WNSWE: Web-based Network Simulator for Web Engineering Education. In Proceedings of the 25th International Web Information Systems Engineering Conference (WISE 2024). Springer, 2024.

The package contains two parts: In "implementation", there is a snapshot of the WSNWE implementation as of the submitted camera-ready version and in "scenarios", there are the 26 scenarios created for the feasibility study. 

The implementation directory contains the a snapshot of WSNWE representing the current implementation state at the time of submission (2024-09-05). It includes the main HTML, CSS and JavaScript files, in addition to some JavaScript libraries and some Python code. The current version of WSNWE can be found on Github: [https://github.com/LucasSchroeder99/WSNWE](https://github.com/LucasSchroeder99/WSNWE)

The scenarios directory contains the 26 scenarios listed in the publication as JSON files, usable with the above implementation. In order to use the scenarios, first host the implementation on a static webserver. For local testing, Python's built-in HTTP server (`python3 -m http.server`) works perfectly fine. Next, open the website in the browser and click on 'Import' in the header, selecting one of the files from the scenarios directory. This will load the scenario, and clicking on 'Start' will start the simulation.

The scenarios were created with educational use in mind, with several scenarios having already been used in tutorials or lectures.

The following scenarios are contained:

1. Switches & Hubs
2. Translating Bridge
3. Routers
4. ARP
5. ICMP
6. Traceroute
7. RIP
8. OSPF
9. TCP Reliability
10. TCP State Machine
11. Email Protocols
12. DNS Resolution - Recursive
13. DNS Resolution - Iterative
14. DNS Resolution - Mixed
15. Network Layering
16. NAT
17. TLS
18. Kerberos
19. Packet Switching - Cut-Through
20. Packet Switching - Store-and-Forward
21. Hypercube Routing
22. Distributed Lock
23. Causal Ordering
24. Weighted Reference Counting
25. Clock Synchronisation
26. Byzantine Agreement
