#!/bin/bash

# Extract barcodes and guides from sequencing
../barcode-assign/target/debug/bc-pbx --config NIJL009_v2_specs.toml --input ccs.bam

# Collapse barcodes
cut -f 4 pLJK06_v4-read-inserts-good.txt | ../barcode-assign/target/debug/bc-collapse -i 
- -o pLJK06_v4_bc1

cut -f 6 pLJK06_v4-read-inserts-good.txt | ../barcode-assign/target/debug/bc-collapse -i 
- -o pLJK06_v4_bc2

# Bowtie build guide reference
bowtie2-build guide_A_plus20.fa guide_A
bowtie2-build guide_B_plus20.fa guide_B

# Bowtie align guides to guide reference
bowtie2 -x guide_A -U pLJK06_v4-guide1.fq -S guide1_aligned -p 30
bowtie2 -x guide_B -U pLJK06_v4-guide2.fq -S guide2_aligned -p 30

# Create text file of just the name of the read and the name of the guide
cut -f 1,3 guide1_aligned | grep -v ^@ > ./guide1_read.txt
cut -f 1,3 guide2_aligned | grep -v ^@ > ./guide2_read.txt



